/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.annotation.impl;

import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.annotation.api.Annotation;
import org.opencastproject.annotation.api.AnnotationService;
import org.opencastproject.annotation.impl.AnnotationImpl;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.util.UrlSupport;
import org.opencastproject.util.doc.rest.RestParameter;
import org.opencastproject.util.doc.rest.RestQuery;
import org.opencastproject.util.doc.rest.RestResponse;
import org.opencastproject.util.doc.rest.RestService;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/annotation")
@RestService(name="annotation", title="Annotation Service", abstractText="This service is used for managing user generated annotations.", notes={"<strong>Deprecated:</strong> <em>This module is deprecated. It may be removed at any time. Planned removal is the Opencast release in December 2017. Please do not use it for new development.</em>", "All paths above are relative to the REST endpoint base (something like http://your.server/files)", "If the service is down or not working it will return a status 503, this means the the underlying service is not working and is either restarting or has failed", "A status code 500 means a general failure has occurred which is not recoverable and was not anticipated. In other words, there is a bug! You should file an error report with your server logs from the time when the error occurred: <a href=\"https://github.com/opencast/opencast/issues\">Opencast Issue Tracker</a>"})
@Component(immediate=true, service={AnnotationRestService.class}, property={"service.description=Annotation REST Endpoint", "opencast.service.type=org.opencastproject.annotation", "opencast.service.path=/annotation"})
@JaxrsResource
public class AnnotationRestService {
    private static final Logger logger = LoggerFactory.getLogger(AnnotationRestService.class);
    private AnnotationService annotationService;
    protected String serverUrl = "http://localhost:8080";
    protected String serviceUrl = "/annotation";

    @Reference
    public void setService(AnnotationService service) {
        this.annotationService = service;
    }

    @Activate
    public void activate(ComponentContext cc) {
        if (cc == null) {
            this.serverUrl = "http://localhost:8080";
        } else {
            String ccServerUrl = cc.getBundleContext().getProperty("org.opencastproject.server.url");
            logger.info("configured server url is {}", (Object)ccServerUrl);
            this.serverUrl = ccServerUrl == null ? "http://localhost:8080" : ccServerUrl;
            this.serviceUrl = (String)cc.getProperties().get("opencast.service.path");
        }
    }

    @GET
    @Produces(value={"text/xml"})
    @Path(value="annotations.xml")
    @RestQuery(name="annotationsasxml", description="Get annotations by key and day", returnDescription="The user annotations.", restParameters={@RestParameter(name="episode", description="The episode identifier", isRequired=false, type=RestParameter.Type.STRING), @RestParameter(name="type", description="The type of annotation", isRequired=false, type=RestParameter.Type.STRING), @RestParameter(name="day", description="The day of creation (format: YYYYMMDD)", isRequired=false, type=RestParameter.Type.STRING), @RestParameter(name="limit", description="The maximum number of items to return per page", isRequired=false, type=RestParameter.Type.INTEGER), @RestParameter(name="offset", description="The page number", isRequired=false, type=RestParameter.Type.INTEGER)}, responses={@RestResponse(responseCode=200, description="An XML representation of the user annotations")})
    public Response getAnnotationsAsXml(@QueryParam(value="episode") String id, @QueryParam(value="type") String type, @QueryParam(value="day") String day, @QueryParam(value="limit") int limit, @QueryParam(value="offset") int offset) {
        if (offset < 0 || limit < 0) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        if (limit == 0) {
            limit = 10;
        }
        if (!StringUtils.isEmpty((CharSequence)id) && !StringUtils.isEmpty((CharSequence)type)) {
            return Response.ok((Object)this.annotationService.getAnnotationsByTypeAndMediapackageId(type, id, offset, limit)).build();
        }
        if (!StringUtils.isEmpty((CharSequence)id)) {
            return Response.ok((Object)this.annotationService.getAnnotationsByMediapackageId(id, offset, limit)).build();
        }
        if (!StringUtils.isEmpty((CharSequence)type) && !StringUtils.isEmpty((CharSequence)day)) {
            return Response.ok((Object)this.annotationService.getAnnotationsByTypeAndDay(type, day, offset, limit)).build();
        }
        if (!StringUtils.isEmpty((CharSequence)type)) {
            return Response.ok((Object)this.annotationService.getAnnotationsByType(type, offset, limit)).build();
        }
        if (!StringUtils.isEmpty((CharSequence)day)) {
            return Response.ok((Object)this.annotationService.getAnnotationsByDay(day, offset, limit)).build();
        }
        return Response.ok((Object)this.annotationService.getAnnotations(offset, limit)).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="annotations.json")
    @RestQuery(name="annotationsasjson", description="Get annotations by key and day", returnDescription="The user annotations.", restParameters={@RestParameter(name="episode", description="The episode identifier", isRequired=false, type=RestParameter.Type.STRING), @RestParameter(name="type", description="The type of annotation", isRequired=false, type=RestParameter.Type.STRING), @RestParameter(name="day", description="The day of creation (format: YYYYMMDD)", isRequired=false, type=RestParameter.Type.STRING), @RestParameter(name="limit", description="The maximum number of items to return per page", isRequired=false, type=RestParameter.Type.INTEGER), @RestParameter(name="offset", description="The page number", isRequired=false, type=RestParameter.Type.INTEGER)}, responses={@RestResponse(responseCode=200, description="A JSON representation of the user annotations")})
    public Response getAnnotationsAsJson(@QueryParam(value="episode") String id, @QueryParam(value="type") String type, @QueryParam(value="day") String day, @QueryParam(value="limit") int limit, @QueryParam(value="offset") int offset) {
        return this.getAnnotationsAsXml(id, type, day, limit, offset);
    }

    @PUT
    @Path(value="")
    @Produces(value={"text/xml"})
    @RestQuery(name="add", description="Add an annotation on an episode", returnDescription="The user annotation.", restParameters={@RestParameter(name="episode", description="The episode identifier", isRequired=true, type=RestParameter.Type.STRING), @RestParameter(name="type", description="The type of annotation", isRequired=true, type=RestParameter.Type.STRING), @RestParameter(name="value", description="The value of the annotation", isRequired=true, type=RestParameter.Type.TEXT), @RestParameter(name="in", description="The time, or inpoint, of the annotation", isRequired=true, type=RestParameter.Type.STRING), @RestParameter(name="out", description="The optional outpoint of the annotation", isRequired=false, type=RestParameter.Type.STRING), @RestParameter(name="isPrivate", description="True if the annotation is private", isRequired=false, type=RestParameter.Type.BOOLEAN)}, responses={@RestResponse(responseCode=201, description="The URL to this annotation is returned in the Location header, and an XML representation of the annotation itelf is returned in the response body.")})
    public Response add(@FormParam(value="episode") String mediapackageId, @FormParam(value="in") int inpoint, @FormParam(value="out") int outpoint, @FormParam(value="type") String type, @FormParam(value="value") String value, @FormParam(value="isPrivate") boolean isPrivate, @Context HttpServletRequest request) {
        URI uri;
        String sessionId = request.getSession().getId();
        AnnotationImpl a = new AnnotationImpl();
        a.setMediapackageId(mediapackageId);
        a.setSessionId(sessionId);
        a.setInpoint(inpoint);
        a.setOutpoint(outpoint);
        a.setType(type);
        a.setValue(value);
        a.setPrivate(isPrivate);
        a = this.annotationService.addAnnotation((Annotation)a);
        try {
            uri = new URI(UrlSupport.concat((String[])new String[]{this.serverUrl, this.serviceUrl, Long.toString(a.getAnnotationId()), ".xml"}));
        }
        catch (URISyntaxException e) {
            throw new WebApplicationException((Throwable)e);
        }
        return Response.created((URI)uri).entity((Object)a).build();
    }

    @PUT
    @Path(value="{id}")
    @Produces(value={"text/xml"})
    @RestQuery(name="change", description="Changes the value of an annotation specified by its identifier ", returnDescription="The user annotation.", pathParameters={@RestParameter(name="id", description="The annotation identifier", isRequired=true, type=RestParameter.Type.STRING)}, restParameters={@RestParameter(name="value", description="The value of the annotation", isRequired=true, type=RestParameter.Type.TEXT)}, responses={@RestResponse(responseCode=201, description="The URL to this annotation is returned in the Location header, and an XML representation of the annotation itelf is returned in the response body.")})
    public Response change(@PathParam(value="id") String idAsString, @FormParam(value="value") String value, @Context HttpServletRequest request) throws NotFoundException {
        URI uri;
        Long id = null;
        try {
            id = Long.parseLong(idAsString);
        }
        catch (NumberFormatException e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        Annotation a = this.annotationService.getAnnotation(id.longValue());
        a.setValue(value);
        a = this.annotationService.changeAnnotation(a);
        try {
            uri = new URI(UrlSupport.concat((String[])new String[]{this.serverUrl, this.serviceUrl, Long.toString(a.getAnnotationId()), ".xml"}));
        }
        catch (URISyntaxException e) {
            throw new WebApplicationException((Throwable)e);
        }
        return Response.created((URI)uri).entity((Object)a).build();
    }

    @GET
    @Produces(value={"text/xml"})
    @Path(value="{id}.xml")
    @RestQuery(name="annotationasxml", description="Gets an annotation by its identifier", returnDescription="An XML representation of the user annotation.", pathParameters={@RestParameter(name="id", description="The episode identifier", isRequired=false, type=RestParameter.Type.STRING)}, responses={@RestResponse(responseCode=200, description="An XML representation of the user annotation")})
    public AnnotationImpl getAnnotationAsXml(@PathParam(value="id") String idAsString) throws NotFoundException {
        Long id = null;
        try {
            id = Long.parseLong(idAsString);
        }
        catch (NumberFormatException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.BAD_REQUEST);
        }
        return (AnnotationImpl)this.annotationService.getAnnotation(id.longValue());
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="{id}.json")
    @RestQuery(name="annotationasjson", description="Gets an annotation by its identifier", returnDescription="A JSON representation of the user annotation.", pathParameters={@RestParameter(name="id", description="The episode identifier", isRequired=false, type=RestParameter.Type.STRING)}, responses={@RestResponse(responseCode=200, description="A JSON representation of the user annotation")})
    public AnnotationImpl getAnnotationAsJson(@PathParam(value="id") String idAsString) throws NotFoundException {
        return this.getAnnotationAsXml(idAsString);
    }

    @DELETE
    @Path(value="{id}")
    @RestQuery(name="remove", description="Remove an annotation", returnDescription="Return status code", pathParameters={@RestParameter(name="id", description="The annotation identifier", isRequired=false, type=RestParameter.Type.STRING)}, responses={@RestResponse(responseCode=200, description="Annotation deleted."), @RestResponse(responseCode=204, description="Annotation not found.")})
    public Response removeAnnotation(@PathParam(value="id") String idAsString) throws NotFoundException {
        Long id = null;
        try {
            id = Long.parseLong(idAsString);
        }
        catch (NumberFormatException e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        AnnotationImpl a = (AnnotationImpl)this.annotationService.getAnnotation(id.longValue());
        boolean removed = this.annotationService.removeAnnotation((Annotation)a);
        if (removed) {
            return Response.status((Response.Status)Response.Status.OK).build();
        }
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }
}

