/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.adminui.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={AdminUIConfiguration.class}, property={"service.description=Admin UI - Configuration", "service.pid=org.opencastproject.adminui"})
public class AdminUIConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(AdminUIConfiguration.class);
    public static final String OPT_PREVIEW_SUBTYPE = "preview.subtype";
    private static final String OPT_RETRACT_WORKFLOW_ID = "retract.workflow.id";
    private static final String OPT_MATCH_MANAGED_ACL_ROLE_PREFIXES = "match.managed.acl.role.prefixes";
    private static final String DEFAULT_PREVIEW_SUBTYPE = "preview";
    private static final String DEFAULT_RETRACT_WORKFLOW_ID = "delete";
    private static final String DEFAULT_MATCH_MANAGED_ACL_ROLE_PREFIXES = "";
    private String previewSubtype = "preview";
    private String retractWorkflowId = "delete";
    private List<String> matchManagedAclRolePrefixes = new ArrayList<String>();

    public String getPreviewSubtype() {
        return this.previewSubtype;
    }

    public String getRetractWorkflowId() {
        return this.retractWorkflowId;
    }

    public List<String> getMatchManagedAclRolePrefixes() {
        return this.matchManagedAclRolePrefixes;
    }

    @Activate
    @Modified
    public void modified(Map<String, Object> properties) {
        if (properties == null) {
            properties = Map.of();
        }
        this.previewSubtype = Objects.toString(properties.get(OPT_PREVIEW_SUBTYPE), DEFAULT_PREVIEW_SUBTYPE);
        logger.debug("Preview subtype configuration set to '{}'", (Object)this.previewSubtype);
        this.retractWorkflowId = Objects.toString(properties.get(OPT_RETRACT_WORKFLOW_ID), DEFAULT_RETRACT_WORKFLOW_ID);
        logger.debug("Retract workflow ID set to {}", (Object)this.retractWorkflowId);
        String tmp = Objects.toString(properties.get(OPT_MATCH_MANAGED_ACL_ROLE_PREFIXES), DEFAULT_MATCH_MANAGED_ACL_ROLE_PREFIXES);
        this.matchManagedAclRolePrefixes = Arrays.asList(tmp.split(","));
        logger.debug("Match managed acl role prefixes set to {}", this.matchManagedAclRolePrefixes);
    }
}

