/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.adminui.endpoint;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.adminui.util.TextFilter;
import org.opencastproject.index.service.util.RestUtils;
import org.opencastproject.security.api.Organization;
import org.opencastproject.security.api.Role;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.security.api.UnauthorizedException;
import org.opencastproject.security.api.User;
import org.opencastproject.security.api.UserDirectoryService;
import org.opencastproject.security.impl.jpa.JpaOrganization;
import org.opencastproject.security.impl.jpa.JpaRole;
import org.opencastproject.security.impl.jpa.JpaUser;
import org.opencastproject.userdirectory.JpaUserAndRoleProvider;
import org.opencastproject.userdirectory.JpaUserReferenceProvider;
import org.opencastproject.userdirectory.UserIdRoleProvider;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.util.RestUtil;
import org.opencastproject.util.SmartIterator;
import org.opencastproject.util.UrlSupport;
import org.opencastproject.util.data.Tuple;
import org.opencastproject.util.doc.rest.RestParameter;
import org.opencastproject.util.doc.rest.RestQuery;
import org.opencastproject.util.doc.rest.RestResponse;
import org.opencastproject.util.doc.rest.RestService;
import org.opencastproject.util.requests.SortCriterion;
import org.opencastproject.workflow.api.WorkflowDatabaseException;
import org.opencastproject.workflow.api.WorkflowService;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/admin-ng/users")
@RestService(name="users", title="User service", abstractText="Provides operations for users", notes={"This service offers the default users CRUD Operations for the admin UI.", "<strong>Important:</strong> <em>This service is for exclusive use by the module admin-ui. Its API might change anytime without prior notice. Any dependencies other than the admin UI will be strictly ignored. DO NOT use this for integration of third-party applications.<em>"})
@Component(immediate=true, service={UsersEndpoint.class}, property={"service.description=Admin UI - Users facade Endpoint", "opencast.service.type=org.opencastproject.adminui.endpoint.UsersEndpoint", "opencast.service.path=/admin-ng/users"})
@JaxrsResource
public class UsersEndpoint {
    private static final Logger logger = LoggerFactory.getLogger(UsersEndpoint.class);
    protected UserDirectoryService userDirectoryService;
    private JpaUserAndRoleProvider jpaUserAndRoleProvider;
    private JpaUserReferenceProvider jpaUserReferenceProvider;
    private SecurityService securityService;
    private WorkflowService workflowService;
    private String endpointBaseUrl;
    private static final Type listType = new TypeToken<ArrayList<JsonRole>>(){}.getType();
    private static final Gson gson = new Gson();

    @Reference
    public void setUserDirectoryService(UserDirectoryService userDirectoryService) {
        this.userDirectoryService = userDirectoryService;
    }

    @Reference
    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    @Reference
    public void setJpaUserReferenceProvider(JpaUserReferenceProvider jpaUserReferenceProvider) {
        this.jpaUserReferenceProvider = jpaUserReferenceProvider;
    }

    @Reference
    public void setJpaUserAndRoleProvider(JpaUserAndRoleProvider jpaUserAndRoleProvider) {
        this.jpaUserAndRoleProvider = jpaUserAndRoleProvider;
    }

    @Reference
    public void setWorkflowService(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }

    @Activate
    protected void activate(ComponentContext cc) {
        logger.info("Activate the Admin ui - Users facade endpoint");
        Tuple endpointUrl = RestUtil.getEndpointUrl((ComponentContext)cc);
        this.endpointBaseUrl = UrlSupport.concat((String)((String)endpointUrl.getA()), (String)((String)endpointUrl.getB()));
    }

    @GET
    @Path(value="users.json")
    @Produces(value={"application/json"})
    @RestQuery(name="allusers", description="Returns a list of users", returnDescription="Returns a JSON representation of the list of user accounts", restParameters={@RestParameter(name="filter", isRequired=false, description="The filter used for the query. They should be formated like that: 'filter1:value1,filter2:value2'", type=RestParameter.Type.STRING), @RestParameter(name="sort", isRequired=false, description="The sort order. May include any of the following: STATUS, NAME OR LAST_UPDATED.  Add '_DESC' to reverse the sort order (e.g. STATUS_DESC).", type=RestParameter.Type.STRING), @RestParameter(defaultValue="100", description="The maximum number of items to return per page.", isRequired=false, name="limit", type=RestParameter.Type.STRING), @RestParameter(defaultValue="0", description="The page number.", isRequired=false, name="offset", type=RestParameter.Type.STRING)}, responses={@RestResponse(responseCode=200, description="The user accounts.")})
    public Response getUsers(@QueryParam(value="filter") String filter, @QueryParam(value="sort") String sort, @QueryParam(value="limit") int limit, @QueryParam(value="offset") int offset) throws IOException {
        if (limit < 1) {
            limit = 100;
        }
        sort = StringUtils.trimToNull((String)sort);
        String filterName = null;
        String filterRole = null;
        String filterProvider = null;
        String filterText = null;
        Map filters = RestUtils.parseFilter((String)filter);
        for (Object name : filters.keySet()) {
            String value = (String)filters.get(name);
            if ("Name".equals(name)) {
                filterName = value;
                continue;
            }
            if ("Role".equals(name)) {
                filterRole = value;
                continue;
            }
            if ("Provider".equals(name)) {
                filterProvider = value;
                continue;
            }
            if (!"textFilter".equals(name) || !StringUtils.isNotBlank((CharSequence)value)) continue;
            filterText = value;
        }
        List<User> filteredUsers = new ArrayList();
        for (User user : this.userDirectoryService.getUsers()) {
            String finalFilterRole = filterRole;
            if (filterName != null && !filterName.equals(user.getName()) || filterRole != null && user.getRoles().stream().noneMatch(r -> r.getName().equals(finalFilterRole)) || filterProvider != null && !filterProvider.equals(user.getProvider()) || filterText != null && !TextFilter.match(filterText, user.getUsername(), user.getName(), user.getEmail(), user.getProvider()) && !TextFilter.match(filterText, user.getRoles().stream().map(Role::getName).collect(Collectors.joining(" ")))) continue;
            filteredUsers.add(user);
        }
        int total = filteredUsers.size();
        if (sort != null) {
            ArrayList sortCriteria = RestUtils.parseSortQueryParameter((String)sort);
            filteredUsers.sort((user1, user2) -> {
                Iterator iterator = sortCriteria.iterator();
                if (iterator.hasNext()) {
                    SortCriterion criterion = (SortCriterion)iterator.next();
                    SortCriterion.Order order = criterion.getOrder();
                    switch (criterion.getFieldName()) {
                        case "name": {
                            if (order.equals((Object)SortCriterion.Order.Descending)) {
                                return String.CASE_INSENSITIVE_ORDER.compare(StringUtils.trimToEmpty((String)user2.getName()), StringUtils.trimToEmpty((String)user1.getName()));
                            }
                            return String.CASE_INSENSITIVE_ORDER.compare(StringUtils.trimToEmpty((String)user1.getName()), StringUtils.trimToEmpty((String)user2.getName()));
                        }
                        case "username": {
                            if (order.equals((Object)SortCriterion.Order.Descending)) {
                                return String.CASE_INSENSITIVE_ORDER.compare(StringUtils.trimToEmpty((String)user2.getUsername()), StringUtils.trimToEmpty((String)user1.getUsername()));
                            }
                            return String.CASE_INSENSITIVE_ORDER.compare(StringUtils.trimToEmpty((String)user1.getUsername()), StringUtils.trimToEmpty((String)user2.getUsername()));
                        }
                        case "email": {
                            if (order.equals((Object)SortCriterion.Order.Descending)) {
                                return String.CASE_INSENSITIVE_ORDER.compare(StringUtils.trimToEmpty((String)user2.getEmail()), StringUtils.trimToEmpty((String)user1.getEmail()));
                            }
                            return String.CASE_INSENSITIVE_ORDER.compare(StringUtils.trimToEmpty((String)user1.getEmail()), StringUtils.trimToEmpty((String)user2.getEmail()));
                        }
                        case "roles": {
                            String roles1 = user1.getRoles().stream().map(Role::getName).collect(Collectors.joining(","));
                            String roles2 = user1.getRoles().stream().map(Role::getName).collect(Collectors.joining(","));
                            if (order.equals((Object)SortCriterion.Order.Descending)) {
                                return String.CASE_INSENSITIVE_ORDER.compare(StringUtils.trimToEmpty((String)roles2), StringUtils.trimToEmpty((String)roles1));
                            }
                            return String.CASE_INSENSITIVE_ORDER.compare(StringUtils.trimToEmpty((String)roles1), StringUtils.trimToEmpty((String)roles2));
                        }
                        case "provider": {
                            if (order.equals((Object)SortCriterion.Order.Descending)) {
                                return String.CASE_INSENSITIVE_ORDER.compare(StringUtils.trimToEmpty((String)user2.getProvider()), StringUtils.trimToEmpty((String)user1.getProvider()));
                            }
                            return String.CASE_INSENSITIVE_ORDER.compare(StringUtils.trimToEmpty((String)user1.getProvider()), StringUtils.trimToEmpty((String)user2.getProvider()));
                        }
                    }
                    logger.info("Unknown sort type: {}", (Object)criterion.getFieldName());
                    return 0;
                }
                return 0;
            });
        }
        filteredUsers = new SmartIterator(limit, offset).applyLimitAndOffset(filteredUsers);
        ArrayList<Map<String, Object>> usersJSON = new ArrayList<Map<String, Object>>();
        for (User user : filteredUsers) {
            usersJSON.add(this.generateJsonUser(user));
        }
        Map<String, Integer> response = Map.of("results", usersJSON, "count", usersJSON.size(), "offset", offset, "limit", limit, "total", total);
        return Response.ok((Object)gson.toJson(response)).build();
    }

    @GET
    @Path(value="usersforroles.json")
    @Produces(value={"application/json"})
    @RestQuery(name="usersforroles", description="Returns a list of users", returnDescription="Returns a JSON representation of the list of user accounts", restParameters={@RestParameter(name="roles", isRequired=false, description="JSON Array", type=RestParameter.Type.STRING)}, responses={@RestResponse(responseCode=200, description="The user accounts.")})
    public Response getsUsersForRoles(@QueryParam(value="roles") String roles) {
        List rolesList = (List)gson.fromJson(roles, ArrayList.class);
        HashMap<String, Map<String, Object>> roleUserMap = new HashMap<String, Map<String, Object>>();
        for (String role : rolesList) {
            if (UserIdRoleProvider.isSanitize()) continue;
            User user = this.userDirectoryService.loadUser(role.replaceFirst(UserIdRoleProvider.getUserRolePrefix(), ""));
            if (user != null) {
                roleUserMap.put(role, this.generateJsonUser(user));
                continue;
            }
            roleUserMap.put(role, null);
        }
        return Response.ok((Object)gson.toJson(roleUserMap)).build();
    }

    @POST
    @Path(value="/")
    @RestQuery(name="createUser", description="Create a new  user", returnDescription="The location of the new ressource", restParameters={@RestParameter(description="The username.", isRequired=true, name="username", type=RestParameter.Type.STRING), @RestParameter(description="The password.", isRequired=true, name="password", type=RestParameter.Type.STRING), @RestParameter(description="The name.", isRequired=false, name="name", type=RestParameter.Type.STRING), @RestParameter(description="The email.", isRequired=false, name="email", type=RestParameter.Type.STRING), @RestParameter(name="roles", type=RestParameter.Type.STRING, isRequired=false, description="The user roles as a json array, e.g. <br>[{'name': 'ROLE_ADMIN', 'type': 'INTERNAL'}, {'name': 'ROLE_XY', 'type': 'INTERNAL'}]")}, responses={@RestResponse(responseCode=201, description="User has been created."), @RestResponse(responseCode=403, description="Not enough permissions to create a user with a admin role."), @RestResponse(responseCode=409, description="An user with this username already exist.")})
    public Response createUser(@FormParam(value="username") String username, @FormParam(value="password") String password, @FormParam(value="name") String name, @FormParam(value="email") String email, @FormParam(value="roles") String roles) {
        Set<JpaRole> rolesSet;
        if (StringUtils.isBlank((CharSequence)username)) {
            return Response.status((int)400).entity((Object)"Missing username").build();
        }
        if (StringUtils.isBlank((CharSequence)password)) {
            return Response.status((int)400).entity((Object)"Missing password").build();
        }
        User existingUser = this.jpaUserAndRoleProvider.loadUser(username);
        if (existingUser != null) {
            return Response.status((int)409).build();
        }
        JpaOrganization organization = (JpaOrganization)this.securityService.getOrganization();
        try {
            rolesSet = this.parseJsonRoles(roles);
        }
        catch (IllegalArgumentException e) {
            logger.debug("Received invalid JSON for roles", (Throwable)e);
            return Response.status((int)400).entity((Object)"Invalid JSON for roles").build();
        }
        if (rolesSet == null) {
            rolesSet = new HashSet<JpaRole>();
            rolesSet.add(new JpaRole(organization.getAnonymousRole(), organization));
        }
        JpaUser user = new JpaUser(username, password, organization, name, email, this.jpaUserAndRoleProvider.getName(), true, rolesSet);
        try {
            this.jpaUserAndRoleProvider.addUser(user);
            return Response.created((URI)UrlSupport.uri((Object[])new Object[]{this.endpointBaseUrl, user.getUsername() + ".json"})).build();
        }
        catch (UnauthorizedException e) {
            return Response.status((int)403).build();
        }
    }

    @GET
    @Path(value="{username}.json")
    @RestQuery(name="getUser", description="Get an user", returnDescription="Status ok", pathParameters={@RestParameter(name="username", type=RestParameter.Type.STRING, isRequired=true, description="The username")}, responses={@RestResponse(responseCode=200, description="User has been found."), @RestResponse(responseCode=404, description="User not found.")})
    public Response getUser(@PathParam(value="username") String username) {
        User user = this.userDirectoryService.loadUser(username);
        if (user == null) {
            return Response.status((int)404).build();
        }
        return Response.ok((Object)gson.toJson(this.generateJsonUser(user))).build();
    }

    @PUT
    @Path(value="{username}.json")
    @RestQuery(name="updateUser", description="Update an user", returnDescription="Status ok", restParameters={@RestParameter(description="The password.", isRequired=false, name="password", type=RestParameter.Type.STRING), @RestParameter(description="The name.", isRequired=false, name="name", type=RestParameter.Type.STRING), @RestParameter(description="The email.", isRequired=false, name="email", type=RestParameter.Type.STRING), @RestParameter(name="roles", type=RestParameter.Type.STRING, isRequired=false, description="The user roles as a json array")}, pathParameters={@RestParameter(name="username", type=RestParameter.Type.STRING, isRequired=true, description="The username")}, responses={@RestResponse(responseCode=200, description="User has been updated."), @RestResponse(responseCode=403, description="Not enough permissions to update a user with admin role."), @RestResponse(responseCode=400, description="Invalid data provided.")})
    public Response updateUser(@PathParam(value="username") String username, @FormParam(value="password") String password, @FormParam(value="name") String name, @FormParam(value="email") String email, @FormParam(value="roles") String roles) {
        Set<JpaRole> rolesSet;
        User user = this.jpaUserAndRoleProvider.loadUser(username);
        if (user == null) {
            return this.createUser(username, password, name, email, roles);
        }
        try {
            rolesSet = this.parseJsonRoles(roles);
        }
        catch (IllegalArgumentException e) {
            logger.debug("Received invalid JSON for roles", (Throwable)e);
            return Response.status((int)400).build();
        }
        JpaOrganization organization = (JpaOrganization)this.securityService.getOrganization();
        if (rolesSet == null) {
            rolesSet = new HashSet<JpaRole>();
            for (Role role : user.getRoles()) {
                rolesSet.add(new JpaRole(role.getName(), organization, role.getDescription(), role.getType()));
            }
        }
        try {
            this.jpaUserAndRoleProvider.updateUser(new JpaUser(username, password, organization, name, email, this.jpaUserAndRoleProvider.getName(), true, rolesSet));
            this.userDirectoryService.invalidate(username);
            return Response.status((int)200).build();
        }
        catch (UnauthorizedException ex) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        catch (NotFoundException e) {
            return Response.serverError().build();
        }
    }

    @DELETE
    @Path(value="{username}.json")
    @RestQuery(name="deleteUser", description="Deleter a new  user", returnDescription="Status ok", pathParameters={@RestParameter(name="username", type=RestParameter.Type.STRING, isRequired=true, description="The username")}, responses={@RestResponse(responseCode=200, description="User has been deleted."), @RestResponse(responseCode=403, description="Not enough permissions to delete a user with admin role."), @RestResponse(responseCode=404, description="User not found.")})
    public Response deleteUser(@PathParam(value="username") String username) throws NotFoundException {
        Organization organization = this.securityService.getOrganization();
        boolean userReferenceNotFound = false;
        boolean userNotFound = false;
        try {
            if (this.workflowService.userHasActiveWorkflows(username)) {
                logger.debug("Workflow still active for user {}:", (Object)username);
                return Response.status((int)409).build();
            }
        }
        catch (WorkflowDatabaseException e) {
            logger.error("Error during deletion of user {}", (Object)username, (Object)e);
            return Response.status((int)500).build();
        }
        try {
            try {
                this.jpaUserReferenceProvider.deleteUser(username, organization.getId());
            }
            catch (NotFoundException e) {
                userReferenceNotFound = true;
            }
            try {
                this.jpaUserAndRoleProvider.deleteUser(username, organization.getId());
            }
            catch (NotFoundException e) {
                userNotFound = true;
            }
            if (userNotFound && userReferenceNotFound) {
                throw new NotFoundException();
            }
            this.userDirectoryService.invalidate(username);
        }
        catch (NotFoundException e) {
            logger.debug("User {} not found.", (Object)username);
            return Response.status((int)404).build();
        }
        catch (UnauthorizedException e) {
            return Response.status((int)403).build();
        }
        catch (Exception e) {
            logger.error("Error during deletion of user {}", (Object)username, (Object)e);
            return Response.status((int)500).build();
        }
        logger.debug("User {} removed.", (Object)username);
        return Response.status((int)200).build();
    }

    private Set<JpaRole> parseJsonRoles(String roles) throws IllegalArgumentException {
        List rolesList;
        try {
            rolesList = (List)gson.fromJson(roles, listType);
        }
        catch (JsonSyntaxException e) {
            throw new IllegalArgumentException(e);
        }
        if (rolesList == null) {
            return null;
        }
        JpaOrganization organization = (JpaOrganization)this.securityService.getOrganization();
        HashSet<JpaRole> rolesSet = new HashSet<JpaRole>();
        for (JsonRole role : rolesList) {
            try {
                rolesSet.add(new JpaRole(role.getName(), organization, null, role.getType()));
            }
            catch (NullPointerException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return rolesSet;
    }

    private Map<String, Object> generateJsonUser(User user) {
        HashMap<String, Object> userData = new HashMap<String, Object>();
        userData.put("username", user.getUsername());
        userData.put("manageable", user.isManageable());
        userData.put("name", user.getName());
        userData.put("email", user.getEmail());
        userData.put("provider", user.getProvider());
        userData.put("roles", user.getRoles().stream().sorted(Comparator.comparing(Role::getName)).map(r -> new JsonRole(this, r.getName(), r.getType())).collect(Collectors.toList()));
        return userData;
    }

    class JsonRole {
        private String name;
        private String type;

        JsonRole(UsersEndpoint this$0, String name, Role.Type type) {
            this.name = name;
            this.type = type.toString();
        }

        public String getName() {
            return this.name;
        }

        public Role.Type getType() {
            return Role.Type.valueOf((String)this.type);
        }
    }
}

