/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.adminui.endpoint;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.opencastproject.adminui.exception.JsonCreationException;
import org.opencastproject.index.service.util.RestUtils;
import org.opencastproject.list.api.ResourceListFilter;
import org.opencastproject.list.impl.ResourceListQueryImpl;
import org.opencastproject.list.query.StringListFilter;
import org.opencastproject.security.api.AccessControlEntry;
import org.opencastproject.security.api.AccessControlList;
import org.opencastproject.security.api.User;
import org.opencastproject.security.api.UserDirectoryService;
import org.opencastproject.userdirectory.UserIdRoleProvider;

public final class EndpointUtil {
    private EndpointUtil() {
    }

    public static <T> JSONObject generateJSONObject(Map<String, T> list) throws JsonCreationException {
        if (list == null) {
            throw new JsonCreationException("List is null");
        }
        JSONObject jsonList = new JSONObject();
        for (Map.Entry<String, T> entry : list.entrySet()) {
            T value = entry.getValue();
            if (value instanceof String) {
                jsonList.put((Object)entry.getKey(), value);
                continue;
            }
            if (value instanceof JSONObject) {
                jsonList.put((Object)entry.getKey(), value);
                continue;
            }
            if (value instanceof List) {
                Collection collection = (Collection)value;
                JSONArray jsonArray = new JSONArray();
                jsonArray.addAll(collection);
                jsonList.put((Object)entry.getKey(), (Object)jsonArray);
                continue;
            }
            throw new JsonCreationException("Could not deal with " + String.valueOf(value));
        }
        return jsonList;
    }

    public static void addRequestFiltersToQuery(String filterString, ResourceListQueryImpl query) {
        for (Map.Entry filter : RestUtils.parseFilter((String)filterString).entrySet()) {
            query.addFilter((ResourceListFilter)new StringListFilter((String)filter.getKey(), (String)filter.getValue()));
        }
    }

    public static JSONArray transformAccessControList(AccessControlList acl, UserDirectoryService userDirectoryService) {
        class TransformedAcl {
            protected String role;
            protected boolean read = false;
            protected boolean write = false;
            protected List<String> actions = new ArrayList<String>();

            TransformedAcl() {
            }
        }
        HashMap<String, TransformedAcl> newPolicies = new HashMap<String, TransformedAcl>();
        JSONArray jsonEntryArray = new JSONArray();
        for (AccessControlEntry entry : acl.getEntries()) {
            if (!newPolicies.containsKey(entry.getRole())) {
                TransformedAcl transformedEntry = new TransformedAcl();
                transformedEntry.role = entry.getRole();
                newPolicies.put(entry.getRole(), transformedEntry);
            }
            if ("read".equals(entry.getAction())) {
                ((TransformedAcl)newPolicies.get((Object)entry.getRole())).read = entry.isAllow();
                continue;
            }
            if ("write".equals(entry.getAction())) {
                ((TransformedAcl)newPolicies.get((Object)entry.getRole())).write = entry.isAllow();
                continue;
            }
            if (!entry.isAllow()) continue;
            ((TransformedAcl)newPolicies.get((Object)entry.getRole())).actions.add(entry.getAction());
        }
        for (TransformedAcl policy : newPolicies.values()) {
            User user;
            JSONObject jsonEntry = new JSONObject();
            jsonEntry.put((Object)"role", (Object)policy.role);
            jsonEntry.put((Object)"read", (Object)policy.read);
            jsonEntry.put((Object)"write", (Object)policy.write);
            jsonEntry.put((Object)"actions", policy.actions);
            if (!UserIdRoleProvider.isSanitize() && (user = userDirectoryService.loadUser(policy.role.replaceFirst(UserIdRoleProvider.getUserRolePrefix(), ""))) != null) {
                HashMap<String, String> userData = new HashMap<String, String>();
                userData.put("username", user.getUsername());
                userData.put("name", user.getName());
                userData.put("email", user.getEmail());
                jsonEntry.put((Object)"user", userData);
            }
            jsonEntryArray.add((Object)jsonEntry);
        }
        return jsonEntryArray;
    }
}

