/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.adminui.endpoint;

import com.entwinemedia.fn.Fn;
import com.entwinemedia.fn.data.Opt;
import com.entwinemedia.fn.data.json.Field;
import com.entwinemedia.fn.data.json.JObject;
import com.entwinemedia.fn.data.json.JString;
import com.entwinemedia.fn.data.json.JValue;
import com.entwinemedia.fn.data.json.Jsons;
import java.net.URI;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TimeZone;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import net.fortuna.ical4j.model.property.RRule;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.json.simple.JSONArray;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.opencastproject.adminui.endpoint.EndpointUtil;
import org.opencastproject.adminui.endpoint.JobEndpoint;
import org.opencastproject.adminui.endpoint.SeriesEndpoint;
import org.opencastproject.adminui.exception.JobEndpointException;
import org.opencastproject.adminui.impl.AdminUIConfiguration;
import org.opencastproject.adminui.tobira.TobiraException;
import org.opencastproject.adminui.tobira.TobiraService;
import org.opencastproject.adminui.util.BulkUpdateUtil;
import org.opencastproject.assetmanager.api.AssetManager;
import org.opencastproject.authorization.xacml.manager.api.AclService;
import org.opencastproject.authorization.xacml.manager.api.ManagedAcl;
import org.opencastproject.authorization.xacml.manager.util.AccessInformationUtil;
import org.opencastproject.capture.admin.api.Agent;
import org.opencastproject.capture.admin.api.CaptureAgentStateService;
import org.opencastproject.elasticsearch.api.SearchIndexException;
import org.opencastproject.elasticsearch.api.SearchResult;
import org.opencastproject.elasticsearch.api.SearchResultItem;
import org.opencastproject.elasticsearch.index.ElasticsearchIndex;
import org.opencastproject.elasticsearch.index.objects.event.Event;
import org.opencastproject.elasticsearch.index.objects.event.EventSearchQuery;
import org.opencastproject.event.comment.EventComment;
import org.opencastproject.event.comment.EventCommentException;
import org.opencastproject.event.comment.EventCommentReply;
import org.opencastproject.event.comment.EventCommentService;
import org.opencastproject.index.service.api.IndexService;
import org.opencastproject.index.service.exception.IndexServiceException;
import org.opencastproject.index.service.exception.UnsupportedAssetException;
import org.opencastproject.index.service.impl.util.EventUtils;
import org.opencastproject.index.service.resources.list.provider.EventsListProvider;
import org.opencastproject.index.service.resources.list.query.SeriesListQuery;
import org.opencastproject.index.service.util.JSONUtils;
import org.opencastproject.index.service.util.RestUtils;
import org.opencastproject.mediapackage.Attachment;
import org.opencastproject.mediapackage.AudioStream;
import org.opencastproject.mediapackage.Catalog;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageException;
import org.opencastproject.mediapackage.Publication;
import org.opencastproject.mediapackage.Stream;
import org.opencastproject.mediapackage.Track;
import org.opencastproject.mediapackage.VideoStream;
import org.opencastproject.mediapackage.track.AudioStreamImpl;
import org.opencastproject.mediapackage.track.SubtitleStreamImpl;
import org.opencastproject.mediapackage.track.VideoStreamImpl;
import org.opencastproject.metadata.dublincore.DublinCore;
import org.opencastproject.metadata.dublincore.DublinCoreMetadataCollection;
import org.opencastproject.metadata.dublincore.EventCatalogUIAdapter;
import org.opencastproject.metadata.dublincore.MetadataField;
import org.opencastproject.metadata.dublincore.MetadataJson;
import org.opencastproject.metadata.dublincore.MetadataList;
import org.opencastproject.rest.BulkOperationResult;
import org.opencastproject.scheduler.api.Recording;
import org.opencastproject.scheduler.api.SchedulerException;
import org.opencastproject.scheduler.api.SchedulerService;
import org.opencastproject.scheduler.api.TechnicalMetadata;
import org.opencastproject.scheduler.api.Util;
import org.opencastproject.security.api.AccessControlList;
import org.opencastproject.security.api.AccessControlParser;
import org.opencastproject.security.api.AclScope;
import org.opencastproject.security.api.AuthorizationService;
import org.opencastproject.security.api.Organization;
import org.opencastproject.security.api.Permissions;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.security.api.UnauthorizedException;
import org.opencastproject.security.api.User;
import org.opencastproject.security.api.UserDirectoryService;
import org.opencastproject.security.urlsigning.exception.UrlSigningException;
import org.opencastproject.security.urlsigning.service.UrlSigningService;
import org.opencastproject.security.util.SecurityUtil;
import org.opencastproject.util.DateTimeSupport;
import org.opencastproject.util.Jsons;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.util.RestUtil;
import org.opencastproject.util.UrlSupport;
import org.opencastproject.util.data.Option;
import org.opencastproject.util.data.Tuple;
import org.opencastproject.util.data.Tuple3;
import org.opencastproject.util.doc.rest.RestParameter;
import org.opencastproject.util.doc.rest.RestQuery;
import org.opencastproject.util.doc.rest.RestResponse;
import org.opencastproject.util.requests.SortCriterion;
import org.opencastproject.workflow.api.RetryStrategy;
import org.opencastproject.workflow.api.WorkflowDatabaseException;
import org.opencastproject.workflow.api.WorkflowDefinition;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowOperationInstance;
import org.opencastproject.workflow.api.WorkflowService;
import org.opencastproject.workflow.api.WorkflowStateException;
import org.opencastproject.workflow.api.WorkflowUtil;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/admin-ng/event")
public abstract class AbstractEventEndpoint {
    public static final String SCHEDULING_AGENT_ID_KEY = "agentId";
    public static final String SCHEDULING_START_KEY = "start";
    public static final String SCHEDULING_END_KEY = "end";
    private static final String SCHEDULING_AGENT_CONFIGURATION_KEY = "agentConfiguration";
    public static final String SCHEDULING_PREVIOUS_AGENTID = "previousAgentId";
    public static final String SCHEDULING_PREVIOUS_PREVIOUSENTRIES = "previousEntries";
    private static final String WORKFLOW_ACTION_STOP = "STOP";
    static final Logger logger = LoggerFactory.getLogger(AbstractEventEndpoint.class);
    protected static final String WORKFLOW_DEFINITION_DEFAULT = "org.opencastproject.workflow.default.definition";
    private static final String WORKFLOW_STATUS_TRANSLATION_PREFIX = "EVENTS.EVENTS.DETAILS.WORKFLOWS.OPERATION_STATUS.";
    protected static final long DEFAULT_URL_SIGNING_EXPIRE_DURATION = 7200L;
    protected String serverUrl = "http://localhost:8080";
    protected String serviceUrl = null;
    protected String defaultWorkflowDefinionId = null;
    private String systemUserName = "opencast_system_account";
    private static final Fn<String, JValue> toStringJValue = new Fn<String, JValue>(){

        public JValue apply(String stringValue) {
            return com.entwinemedia.fn.data.json.Jsons.v((Object)stringValue, (JValue)com.entwinemedia.fn.data.json.Jsons.BLANK);
        }
    };
    private final Fn<Publication, JObject> publicationToJson = new Fn<Publication, JObject>(){

        public JObject apply(Publication publication) {
            Opt channel = Opt.nul((Object)((String)EventUtils.PUBLICATION_CHANNELS.get(publication.getChannel())));
            String url = publication.getURI() == null ? "" : AbstractEventEndpoint.this.signUrl(publication.getURI()).toString();
            return com.entwinemedia.fn.data.json.Jsons.obj((Field[])new Field[]{com.entwinemedia.fn.data.json.Jsons.f((String)"id", (JValue)com.entwinemedia.fn.data.json.Jsons.v((String)publication.getChannel())), com.entwinemedia.fn.data.json.Jsons.f((String)"name", (JValue)com.entwinemedia.fn.data.json.Jsons.v((String)((String)channel.getOr((Object)"EVENTS.EVENTS.DETAILS.PUBLICATIONS.CUSTOM")))), com.entwinemedia.fn.data.json.Jsons.f((String)"url", (JValue)com.entwinemedia.fn.data.json.Jsons.v((Object)url, (JValue)com.entwinemedia.fn.data.json.Jsons.NULL))});
        }
    };
    protected static final Fn<TechnicalMetadata, JObject> technicalMetadataToJson = new Fn<TechnicalMetadata, JObject>(){

        public JObject apply(TechnicalMetadata technicalMetadata) {
            JString agentConfig = technicalMetadata.getCaptureAgentConfiguration() == null ? com.entwinemedia.fn.data.json.Jsons.v((String)"") : JSONUtils.mapToJSON((Map)technicalMetadata.getCaptureAgentConfiguration());
            JString start = technicalMetadata.getStartDate() == null ? com.entwinemedia.fn.data.json.Jsons.v((String)"") : com.entwinemedia.fn.data.json.Jsons.v((String)DateTimeSupport.toUTC((long)technicalMetadata.getStartDate().getTime()));
            JString end = technicalMetadata.getEndDate() == null ? com.entwinemedia.fn.data.json.Jsons.v((String)"") : com.entwinemedia.fn.data.json.Jsons.v((String)DateTimeSupport.toUTC((long)technicalMetadata.getEndDate().getTime()));
            return com.entwinemedia.fn.data.json.Jsons.obj((Field[])new Field[]{com.entwinemedia.fn.data.json.Jsons.f((String)AbstractEventEndpoint.SCHEDULING_AGENT_ID_KEY, (JValue)com.entwinemedia.fn.data.json.Jsons.v((Object)technicalMetadata.getAgentId(), (JValue)com.entwinemedia.fn.data.json.Jsons.BLANK)), com.entwinemedia.fn.data.json.Jsons.f((String)AbstractEventEndpoint.SCHEDULING_AGENT_CONFIGURATION_KEY, (JValue)agentConfig), com.entwinemedia.fn.data.json.Jsons.f((String)AbstractEventEndpoint.SCHEDULING_START_KEY, (JValue)start), com.entwinemedia.fn.data.json.Jsons.f((String)AbstractEventEndpoint.SCHEDULING_END_KEY, (JValue)end), com.entwinemedia.fn.data.json.Jsons.f((String)"eventId", (JValue)com.entwinemedia.fn.data.json.Jsons.v((Object)technicalMetadata.getEventId(), (JValue)com.entwinemedia.fn.data.json.Jsons.BLANK)), com.entwinemedia.fn.data.json.Jsons.f((String)"presenters", (JValue)JSONUtils.setToJSON((Set)technicalMetadata.getPresenters())), com.entwinemedia.fn.data.json.Jsons.f((String)"recording", (JValue)((JValue)recordingToJson.apply((Object)technicalMetadata.getRecording())))});
        }
    };
    protected static final Fn<Optional<Recording>, JObject> recordingToJson = new Fn<Optional<Recording>, JObject>(){

        public JObject apply(Optional<Recording> recording) {
            if (recording.isEmpty()) {
                return com.entwinemedia.fn.data.json.Jsons.obj();
            }
            return com.entwinemedia.fn.data.json.Jsons.obj((Field[])new Field[]{com.entwinemedia.fn.data.json.Jsons.f((String)"id", (JValue)com.entwinemedia.fn.data.json.Jsons.v((Object)recording.get().getID(), (JValue)com.entwinemedia.fn.data.json.Jsons.BLANK)), com.entwinemedia.fn.data.json.Jsons.f((String)"lastCheckInTime", (JValue)com.entwinemedia.fn.data.json.Jsons.v((Object)recording.get().getLastCheckinTime(), (JValue)com.entwinemedia.fn.data.json.Jsons.BLANK)), com.entwinemedia.fn.data.json.Jsons.f((String)"lastCheckInTimeUTC", (JValue)com.entwinemedia.fn.data.json.Jsons.v((Object)DateTimeSupport.toUTC((long)recording.get().getLastCheckinTime()), (JValue)com.entwinemedia.fn.data.json.Jsons.BLANK)), com.entwinemedia.fn.data.json.Jsons.f((String)"state", (JValue)com.entwinemedia.fn.data.json.Jsons.v((Object)recording.get().getState(), (JValue)com.entwinemedia.fn.data.json.Jsons.BLANK))});
        }
    };

    public abstract AssetManager getAssetManager();

    public abstract WorkflowService getWorkflowService();

    public abstract ElasticsearchIndex getIndex();

    public abstract JobEndpoint getJobService();

    public abstract SeriesEndpoint getSeriesEndpoint();

    public abstract AclService getAclService();

    public abstract EventCommentService getEventCommentService();

    public abstract SecurityService getSecurityService();

    public abstract IndexService getIndexService();

    public abstract AuthorizationService getAuthorizationService();

    public abstract SchedulerService getSchedulerService();

    public abstract CaptureAgentStateService getCaptureAgentStateService();

    public abstract AdminUIConfiguration getAdminUIConfiguration();

    public abstract long getUrlSigningExpireDuration();

    public abstract UrlSigningService getUrlSigningService();

    public abstract Boolean signWithClientIP();

    public abstract Boolean getOnlySeriesWithWriteAccessEventModal();

    public abstract Boolean getOnlyEventsWithWriteAccessEventsTab();

    public abstract UserDirectoryService getUserDirectoryService();

    @Activate
    public void activate(ComponentContext cc) {
        if (cc != null) {
            String ccServerUrl = cc.getBundleContext().getProperty("org.opencastproject.server.url");
            if (StringUtils.isNotBlank((CharSequence)ccServerUrl)) {
                this.serverUrl = ccServerUrl;
            }
            this.serviceUrl = (String)cc.getProperties().get("opencast.service.path");
            String ccDefaultWorkflowDefinionId = StringUtils.trimToNull((String)cc.getBundleContext().getProperty(WORKFLOW_DEFINITION_DEFAULT));
            if (StringUtils.isNotBlank((CharSequence)ccDefaultWorkflowDefinionId)) {
                this.defaultWorkflowDefinionId = ccDefaultWorkflowDefinionId;
            }
            this.systemUserName = SecurityUtil.getSystemUserName((ComponentContext)cc);
        }
    }

    @POST
    @Path(value="workflowProperties")
    @Produces(value={"application/json"})
    @RestQuery(name="workflowProperties", description="Returns workflow properties for the specified events", returnDescription="The workflow properties for every event as JSON", restParameters={@RestParameter(name="eventIds", description="A JSON array of ids of the events", isRequired=true, type=RestParameter.Type.STRING)}, responses={@RestResponse(description="Returns the workflow properties for the events as JSON", responseCode=200), @RestResponse(description="The list of ids could not be parsed into a json list.", responseCode=400)})
    public Response getEventWorkflowProperties(@FormParam(value="eventIds") String eventIds) throws UnauthorizedException {
        List ids;
        if (StringUtils.isBlank((CharSequence)eventIds)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        JSONParser parser = new JSONParser();
        try {
            ids = (List)parser.parse(eventIds);
        }
        catch (ParseException e) {
            logger.error("Unable to parse '{}'", (Object)eventIds, (Object)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        catch (ClassCastException e) {
            logger.error("Unable to cast '{}'", (Object)eventIds, (Object)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        Map eventWithProperties = this.getIndexService().getEventWorkflowProperties(ids);
        HashMap<String, Field> jsonEvents = new HashMap<String, Field>();
        for (Map.Entry event : eventWithProperties.entrySet()) {
            ArrayList<Field> jsonProperties = new ArrayList<Field>();
            for (Map.Entry property : ((Map)event.getValue()).entrySet()) {
                jsonProperties.add(com.entwinemedia.fn.data.json.Jsons.f((String)((String)property.getKey()), (String)((String)property.getValue())));
            }
            jsonEvents.put((String)event.getKey(), com.entwinemedia.fn.data.json.Jsons.f((String)((String)event.getKey()), (JValue)com.entwinemedia.fn.data.json.Jsons.obj(jsonProperties)));
        }
        return RestUtils.okJson((JValue)com.entwinemedia.fn.data.json.Jsons.obj(jsonEvents));
    }

    @GET
    @Path(value="catalogAdapters")
    @Produces(value={"application/json"})
    @RestQuery(name="getcataloguiadapters", description="Returns the available catalog UI adapters as JSON", returnDescription="The catalog UI adapters as JSON", responses={@RestResponse(description="Returns the available catalog UI adapters as JSON", responseCode=200)})
    public Response getCatalogAdapters() {
        ArrayList<JObject> adapters = new ArrayList<JObject>();
        for (EventCatalogUIAdapter adapter : this.getIndexService().getEventCatalogUIAdapters()) {
            ArrayList<Field> fields = new ArrayList<Field>();
            fields.add(com.entwinemedia.fn.data.json.Jsons.f((String)"flavor", (JValue)com.entwinemedia.fn.data.json.Jsons.v((String)adapter.getFlavor().toString())));
            fields.add(com.entwinemedia.fn.data.json.Jsons.f((String)"title", (JValue)com.entwinemedia.fn.data.json.Jsons.v((String)adapter.getUITitle())));
            adapters.add(com.entwinemedia.fn.data.json.Jsons.obj(fields));
        }
        return RestUtils.okJson((JValue)com.entwinemedia.fn.data.json.Jsons.arr(adapters));
    }

    @GET
    @Path(value="{eventId}")
    @Produces(value={"application/json"})
    @RestQuery(name="getevent", description="Returns the event by the given id as JSON", returnDescription="The event as JSON", pathParameters={@RestParameter(name="eventId", description="The event id", isRequired=true, type=RestParameter.Type.STRING)}, responses={@RestResponse(description="Returns the event as JSON", responseCode=200), @RestResponse(description="No event with this identifier was found.", responseCode=404)})
    public Response getEventResponse(@PathParam(value="eventId") String id) throws Exception {
        Iterator iterator = this.getIndexService().getEvent(id, this.getIndex()).iterator();
        if (iterator.hasNext()) {
            Event event = (Event)iterator.next();
            event.updatePreview(this.getAdminUIConfiguration().getPreviewSubtype());
            return RestUtils.okJson((JValue)this.eventToJSON(event, Optional.empty()));
        }
        return RestUtils.notFound((String)"Cannot find an event with id '%s'.", (Object[])new Object[]{id});
    }

    @DELETE
    @Path(value="{eventId}")
    @Produces(value={"application/json"})
    @RestQuery(name="deleteevent", description="Delete a single event.", returnDescription="Ok if the event has been deleted.", pathParameters={@RestParameter(name="eventId", isRequired=true, description="The id of the event to delete.", type=RestParameter.Type.STRING)}, responses={@RestResponse(responseCode=200, description="The event has been deleted."), @RestResponse(responseCode=202, description="The event will be retracted and deleted afterwards."), @RestResponse(responseCode=401, description="If the current user is not authorized to perform this action")})
    public Response deleteEvent(@PathParam(value="eventId") String id) throws UnauthorizedException, SearchIndexException {
        IndexService.EventRemovalResult result;
        Opt<Event> event = this.checkAgentAccessForEvent(id);
        if (event.isNone()) {
            return RestUtil.R.notFound((Object)id);
        }
        try {
            result = this.getIndexService().removeEvent((Event)event.get(), this.getAdminUIConfiguration().getRetractWorkflowId());
        }
        catch (WorkflowDatabaseException e) {
            logger.error("Workflow database is not reachable. This may be a temporary problem.");
            return RestUtil.R.serverError();
        }
        catch (NotFoundException e) {
            logger.error("Configured retract workflow not found. Check your configuration.");
            return RestUtil.R.serverError();
        }
        switch (result) {
            case SUCCESS: {
                return Response.ok().build();
            }
            case RETRACTING: {
                return Response.accepted().build();
            }
            case GENERAL_FAILURE: {
                return Response.serverError().build();
            }
            case NOT_FOUND: {
                return RestUtil.R.notFound((Object)id);
            }
        }
        throw new RuntimeException("Unknown EventRemovalResult type: " + result.name());
    }

    @POST
    @Path(value="deleteEvents")
    @Produces(value={"application/json"})
    @RestQuery(name="deleteevents", description="Deletes a json list of events by their given ids e.g. [\"1dbe7255-e17d-4279-811d-a5c7ced689bf\", \"04fae22b-0717-4f59-8b72-5f824f76d529\"]", returnDescription="Returns a JSON object containing a list of event ids that were deleted, not found or if there was a server error.", responses={@RestResponse(description="Events have been deleted", responseCode=200), @RestResponse(description="The list of ids could not be parsed into a json list.", responseCode=400), @RestResponse(description="If the current user is not authorized to perform this action", responseCode=401)})
    public Response deleteEvents(String eventIdsContent) throws UnauthorizedException, SearchIndexException {
        JSONArray eventIdsJsonArray;
        if (StringUtils.isBlank((CharSequence)eventIdsContent)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        JSONParser parser = new JSONParser();
        try {
            eventIdsJsonArray = (JSONArray)parser.parse(eventIdsContent);
        }
        catch (ParseException e) {
            logger.error("Unable to parse '{}'", (Object)eventIdsContent, (Object)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        catch (ClassCastException e) {
            logger.error("Unable to cast '{}'", (Object)eventIdsContent, (Object)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        BulkOperationResult result = new BulkOperationResult();
        for (Object eventIdObject : eventIdsJsonArray) {
            String eventId = eventIdObject.toString();
            try {
                Opt<Event> event = this.checkAgentAccessForEvent(eventId);
                if (event.isSome()) {
                    IndexService.EventRemovalResult currentResult = this.getIndexService().removeEvent((Event)event.get(), this.getAdminUIConfiguration().getRetractWorkflowId());
                    switch (currentResult) {
                        case SUCCESS: {
                            result.addOk(eventId);
                            break;
                        }
                        case RETRACTING: {
                            result.addAccepted(eventId);
                            break;
                        }
                        case GENERAL_FAILURE: {
                            result.addServerError(eventId);
                            break;
                        }
                        case NOT_FOUND: {
                            result.addNotFound(eventId);
                            break;
                        }
                        default: {
                            throw new RuntimeException("Unknown EventRemovalResult type: " + currentResult.name());
                        }
                    }
                    continue;
                }
                result.addNotFound(eventId);
            }
            catch (UnauthorizedException e) {
                result.addUnauthorized(eventId);
            }
            catch (WorkflowDatabaseException e) {
                logger.error("Workflow database is not reachable. This may be a temporary problem.");
                return RestUtil.R.serverError();
            }
            catch (NotFoundException e) {
                logger.error("Configured retract workflow not found. Check your configuration.");
                return RestUtil.R.serverError();
            }
        }
        return Response.ok((Object)result.toJson()).build();
    }

    @GET
    @Path(value="{eventId}/publications.json")
    @Produces(value={"application/json"})
    @RestQuery(name="geteventpublications", description="Returns all the data related to the publications tab in the event details modal as JSON", returnDescription="All the data related to the event publications tab as JSON", pathParameters={@RestParameter(name="eventId", description="The event id (mediapackage id).", isRequired=true, type=RestParameter.Type.STRING)}, responses={@RestResponse(description="Returns all the data related to the event publications tab as JSON", responseCode=200), @RestResponse(description="No event with this identifier was found.", responseCode=404)})
    public Response getEventPublicationsTab(@PathParam(value="eventId") String id) throws Exception {
        Opt optEvent = this.getIndexService().getEvent(id, this.getIndex());
        if (optEvent.isNone()) {
            return RestUtils.notFound((String)"Cannot find an event with id '%s'.", (Object[])new Object[]{id});
        }
        Event event = (Event)optEvent.get();
        List<JValue> pubJSON = this.eventPublicationsToJson(event);
        return RestUtils.okJson((JValue)com.entwinemedia.fn.data.json.Jsons.obj((Field[])new Field[]{com.entwinemedia.fn.data.json.Jsons.f((String)"publications", (JValue)com.entwinemedia.fn.data.json.Jsons.arr(pubJSON)), com.entwinemedia.fn.data.json.Jsons.f((String)"start-date", (JValue)com.entwinemedia.fn.data.json.Jsons.v((Object)event.getRecordingStartDate(), (JValue)com.entwinemedia.fn.data.json.Jsons.BLANK)), com.entwinemedia.fn.data.json.Jsons.f((String)"end-date", (JValue)com.entwinemedia.fn.data.json.Jsons.v((Object)event.getRecordingEndDate(), (JValue)com.entwinemedia.fn.data.json.Jsons.BLANK))}));
    }

    private List<JValue> eventPublicationsToJson(Event event) {
        ArrayList<JValue> pubJSON = new ArrayList<JValue>();
        for (JObject json : com.entwinemedia.fn.Stream.$((Iterable)event.getPublications()).filter(EventUtils.internalChannelFilter).map(this.publicationToJson)) {
            pubJSON.add((JValue)json);
        }
        return pubJSON;
    }

    private List<JObject> eventCommentsToJson(List<EventComment> comments) {
        ArrayList<JObject> commentArr = new ArrayList<JObject>();
        for (EventComment c : comments) {
            JObject thing = com.entwinemedia.fn.data.json.Jsons.obj((Field[])new Field[]{com.entwinemedia.fn.data.json.Jsons.f((String)"reason", (JValue)com.entwinemedia.fn.data.json.Jsons.v((String)c.getReason())), com.entwinemedia.fn.data.json.Jsons.f((String)"resolvedStatus", (JValue)com.entwinemedia.fn.data.json.Jsons.v((Boolean)c.isResolvedStatus())), com.entwinemedia.fn.data.json.Jsons.f((String)"modificationDate", (JValue)com.entwinemedia.fn.data.json.Jsons.v((String)c.getModificationDate().toInstant().toString())), com.entwinemedia.fn.data.json.Jsons.f((String)"replies", (JValue)com.entwinemedia.fn.data.json.Jsons.arr(this.eventCommentRepliesToJson(c.getReplies()))), com.entwinemedia.fn.data.json.Jsons.f((String)"author", (JValue)com.entwinemedia.fn.data.json.Jsons.obj((Field[])new Field[]{com.entwinemedia.fn.data.json.Jsons.f((String)"name", (String)c.getAuthor().getName()), com.entwinemedia.fn.data.json.Jsons.f((String)"email", (JValue)com.entwinemedia.fn.data.json.Jsons.v((Object)c.getAuthor().getEmail(), (JValue)com.entwinemedia.fn.data.json.Jsons.NULL)), com.entwinemedia.fn.data.json.Jsons.f((String)"username", (String)c.getAuthor().getUsername())})), com.entwinemedia.fn.data.json.Jsons.f((String)"id", (JValue)com.entwinemedia.fn.data.json.Jsons.v((Number)((Number)c.getId().get()))), com.entwinemedia.fn.data.json.Jsons.f((String)"text", (JValue)com.entwinemedia.fn.data.json.Jsons.v((String)c.getText())), com.entwinemedia.fn.data.json.Jsons.f((String)"creationDate", (JValue)com.entwinemedia.fn.data.json.Jsons.v((String)c.getCreationDate().toInstant().toString()))});
            commentArr.add(thing);
        }
        return commentArr;
    }

    private List<JObject> eventCommentRepliesToJson(List<EventCommentReply> replies) {
        ArrayList<JObject> repliesArr = new ArrayList<JObject>();
        for (EventCommentReply r : replies) {
            JObject thing = com.entwinemedia.fn.data.json.Jsons.obj((Field[])new Field[]{com.entwinemedia.fn.data.json.Jsons.f((String)"id", (JValue)com.entwinemedia.fn.data.json.Jsons.v((Number)((Number)r.getId().get()))), com.entwinemedia.fn.data.json.Jsons.f((String)"text", (JValue)com.entwinemedia.fn.data.json.Jsons.v((String)r.getText())), com.entwinemedia.fn.data.json.Jsons.f((String)"creationDate", (JValue)com.entwinemedia.fn.data.json.Jsons.v((String)r.getCreationDate().toInstant().toString())), com.entwinemedia.fn.data.json.Jsons.f((String)"modificationDate", (JValue)com.entwinemedia.fn.data.json.Jsons.v((String)r.getModificationDate().toInstant().toString())), com.entwinemedia.fn.data.json.Jsons.f((String)"author", (JValue)com.entwinemedia.fn.data.json.Jsons.obj((Field[])new Field[]{com.entwinemedia.fn.data.json.Jsons.f((String)"name", (String)r.getAuthor().getName()), com.entwinemedia.fn.data.json.Jsons.f((String)"email", (JValue)com.entwinemedia.fn.data.json.Jsons.v((Object)r.getAuthor().getEmail(), (JValue)com.entwinemedia.fn.data.json.Jsons.NULL)), com.entwinemedia.fn.data.json.Jsons.f((String)"username", (String)r.getAuthor().getUsername())}))});
            repliesArr.add(thing);
        }
        return repliesArr;
    }

    @GET
    @Path(value="{eventId}/scheduling.json")
    @Produces(value={"application/json"})
    @RestQuery(name="getEventSchedulingMetadata", description="Returns all of the scheduling metadata for an event", returnDescription="All the technical metadata related to scheduling as JSON", pathParameters={@RestParameter(name="eventId", description="The event id (mediapackage id).", isRequired=true, type=RestParameter.Type.STRING)}, responses={@RestResponse(description="Returns all the data related to the event scheduling tab as JSON", responseCode=200), @RestResponse(description="No event with this identifier was found.", responseCode=404)})
    public Response getEventScheduling(@PathParam(value="eventId") String eventId) throws NotFoundException, UnauthorizedException, SearchIndexException {
        Opt optEvent = this.getIndexService().getEvent(eventId, this.getIndex());
        if (optEvent.isNone()) {
            return RestUtils.notFound((String)"Cannot find an event with id '%s'.", (Object[])new Object[]{eventId});
        }
        try {
            TechnicalMetadata technicalMetadata = this.getSchedulerService().getTechnicalMetadata(eventId);
            return RestUtils.okJson((JValue)((JValue)technicalMetadataToJson.apply((Object)technicalMetadata)));
        }
        catch (SchedulerException e) {
            logger.error("Unable to get technical metadata for event with id {}", (Object)eventId);
            throw new WebApplicationException((Throwable)e, 500);
        }
    }

    @POST
    @Path(value="scheduling.json")
    @Produces(value={"application/json"})
    @RestQuery(name="getEventsScheduling", description="Returns all of the scheduling metadata for a list of events", returnDescription="All the technical metadata related to scheduling as JSON", restParameters={@RestParameter(name="eventIds", description="An array of event IDs (mediapackage id)", isRequired=true, type=RestParameter.Type.STRING), @RestParameter(name="ignoreNonScheduled", description="Whether events that are not really scheduled events should be ignored or produce an error", isRequired=true, type=RestParameter.Type.BOOLEAN)}, responses={@RestResponse(description="Returns all the data related to the event scheduling tab as JSON", responseCode=200), @RestResponse(description="No event with this identifier was found.", responseCode=404)})
    public Response getEventsScheduling(@FormParam(value="eventIds") List<String> eventIds, @FormParam(value="ignoreNonScheduled") boolean ignoreNonScheduled) {
        ArrayList<JValue> fields = new ArrayList<JValue>(eventIds.size());
        for (String eventId : eventIds) {
            try {
                fields.add((JValue)technicalMetadataToJson.apply((Object)this.getSchedulerService().getTechnicalMetadata(eventId)));
            }
            catch (NotFoundException e) {
                if (ignoreNonScheduled) continue;
                logger.warn("Unable to find id {}", (Object)eventId, (Object)e);
                return RestUtils.notFound((String)"Cannot find an event with id '%s'.", (Object[])new Object[]{eventId});
            }
            catch (UnauthorizedException e) {
                logger.warn("Unauthorized access to event ID {}", (Object)eventId, (Object)e);
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            catch (SchedulerException e) {
                logger.warn("Scheduler exception accessing event ID {}", (Object)eventId, (Object)e);
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
        }
        return RestUtils.okJson((JValue)com.entwinemedia.fn.data.json.Jsons.arr(fields));
    }

    @PUT
    @Path(value="{eventId}/scheduling")
    @RestQuery(name="updateEventScheduling", description="Updates the scheduling information of an event", returnDescription="The method doesn't return any content", pathParameters={@RestParameter(name="eventId", isRequired=true, description="The event identifier", type=RestParameter.Type.STRING)}, restParameters={@RestParameter(name="scheduling", isRequired=true, description="The updated scheduling (JSON object)", type=RestParameter.Type.TEXT)}, responses={@RestResponse(responseCode=400, description="The required params were missing in the request."), @RestResponse(responseCode=404, description="If the event has not been found."), @RestResponse(responseCode=204, description="The method doesn't return any content")})
    public Response updateEventScheduling(@PathParam(value="eventId") String eventId, @FormParam(value="scheduling") String scheduling) throws NotFoundException, UnauthorizedException, SearchIndexException, IndexServiceException {
        if (StringUtils.isBlank((CharSequence)scheduling)) {
            return RestUtil.R.badRequest((String)"Missing parameters");
        }
        try {
            Event event = this.getEventOrThrowNotFoundException(eventId);
            this.updateEventScheduling(scheduling, event);
            return Response.noContent().build();
        }
        catch (JSONException e) {
            return RestUtil.R.badRequest((String)"The scheduling object is not valid");
        }
        catch (java.text.ParseException e) {
            return RestUtil.R.badRequest((String)"The UTC dates in the scheduling object is not valid");
        }
        catch (SchedulerException e) {
            logger.error("Unable to update scheduling technical metadata of event {}", (Object)eventId, (Object)e);
            throw new WebApplicationException((Throwable)e, 500);
        }
        catch (IllegalStateException e) {
            return RestUtil.R.badRequest((String)e.getMessage());
        }
    }

    private void updateEventScheduling(String scheduling, Event event) throws NotFoundException, UnauthorizedException, SchedulerException, JSONException, java.text.ParseException, SearchIndexException, IndexServiceException {
        TechnicalMetadata technicalMetadata = this.getSchedulerService().getTechnicalMetadata(event.getIdentifier());
        JSONObject schedulingJson = new JSONObject(scheduling);
        Optional<Object> agentId = Optional.empty();
        if (schedulingJson.has(SCHEDULING_AGENT_ID_KEY)) {
            agentId = Optional.of(schedulingJson.getString(SCHEDULING_AGENT_ID_KEY));
            logger.trace("Updating agent id of event '{}' from '{}' to '{}'", new Object[]{event.getIdentifier(), technicalMetadata.getAgentId(), agentId});
        }
        Opt previousAgentId = Opt.none();
        if (schedulingJson.has(SCHEDULING_PREVIOUS_AGENTID)) {
            previousAgentId = Opt.some((Object)schedulingJson.getString(SCHEDULING_PREVIOUS_AGENTID));
        }
        Optional<Object> previousAgentInputs = Optional.empty();
        Optional<Object> agentInputs = Optional.empty();
        if (agentId.isPresent() && previousAgentId.isSome()) {
            Agent previousAgent = this.getCaptureAgentStateService().getAgent((String)previousAgentId.get());
            Agent agent = this.getCaptureAgentStateService().getAgent((String)agentId.get());
            previousAgentInputs = Optional.ofNullable(previousAgent.getCapabilities().getProperty("capture.device.names"));
            agentInputs = Optional.ofNullable(agent.getCapabilities().getProperty("capture.device.names"));
        }
        this.checkAgentAccessForAgent(technicalMetadata.getAgentId());
        if (agentId.isPresent()) {
            this.checkAgentAccessForAgent((String)agentId.get());
        }
        Optional<Object> start = Optional.empty();
        if (schedulingJson.has(SCHEDULING_START_KEY)) {
            start = Optional.of(new Date(DateTimeSupport.fromUTC((String)schedulingJson.getString(SCHEDULING_START_KEY))));
            logger.trace("Updating start time of event '{}' id from '{}' to '{}'", new Object[]{event.getIdentifier(), DateTimeSupport.toUTC((long)technicalMetadata.getStartDate().getTime()), DateTimeSupport.toUTC((long)((Date)start.get()).getTime())});
        }
        Optional<Object> end = Optional.empty();
        if (schedulingJson.has(SCHEDULING_END_KEY)) {
            end = Optional.of(new Date(DateTimeSupport.fromUTC((String)schedulingJson.getString(SCHEDULING_END_KEY))));
            logger.trace("Updating end time of event '{}' id from '{}' to '{}'", new Object[]{event.getIdentifier(), DateTimeSupport.toUTC((long)technicalMetadata.getEndDate().getTime()), DateTimeSupport.toUTC((long)((Date)end.get()).getTime())});
        }
        Optional<Object> agentConfiguration = Optional.empty();
        if (schedulingJson.has(SCHEDULING_AGENT_CONFIGURATION_KEY)) {
            agentConfiguration = Optional.of(JSONUtils.toMap((JSONObject)schedulingJson.getJSONObject(SCHEDULING_AGENT_CONFIGURATION_KEY)));
            logger.trace("Updating agent configuration of event '{}' id from '{}' to '{}'", new Object[]{event.getIdentifier(), technicalMetadata.getCaptureAgentConfiguration(), agentConfiguration});
        }
        Opt previousAgentInputMethods = Opt.none();
        if (schedulingJson.has(SCHEDULING_PREVIOUS_PREVIOUSENTRIES)) {
            previousAgentInputMethods = Opt.some((Object)JSONUtils.toMap((JSONObject)schedulingJson.getJSONObject(SCHEDULING_PREVIOUS_PREVIOUSENTRIES)));
        }
        if (previousAgentInputs.isPresent() && previousAgentInputs.isPresent() && agentInputs.isPresent()) {
            String mapAsString;
            Map map = (Map)previousAgentInputMethods.get();
            String previousInputs = mapAsString = map.keySet().stream().collect(Collectors.joining(","));
            if (previousAgentInputs.equals(agentInputs)) {
                HashMap<String, String> configMap = new HashMap<String, String>((Map)agentConfiguration.get());
                configMap.put("capture.device.names", previousInputs);
                agentConfiguration = Optional.of(configMap);
            }
        }
        if ((start.isPresent() || end.isPresent()) && ((Date)end.orElse(technicalMetadata.getEndDate())).before((Date)start.orElse(technicalMetadata.getStartDate()))) {
            throw new IllegalStateException("The end date is before the start date");
        }
        if (!(start.isEmpty() && end.isEmpty() && agentId.isEmpty() && agentConfiguration.isEmpty())) {
            this.getSchedulerService().updateEvent(event.getIdentifier(), start, end, agentId, Optional.empty(), Optional.empty(), Optional.empty(), agentConfiguration);
        }
    }

    private Event getEventOrThrowNotFoundException(String eventId) throws NotFoundException, SearchIndexException {
        Opt optEvent = this.getIndexService().getEvent(eventId, this.getIndex());
        if (optEvent.isSome()) {
            return (Event)optEvent.get();
        }
        throw new NotFoundException(String.format("Cannot find an event with id '%s'.", eventId));
    }

    @GET
    @Path(value="{eventId}/comments")
    @Produces(value={"application/json"})
    @RestQuery(name="geteventcomments", description="Returns all the data related to the comments tab in the event details modal as JSON", returnDescription="All the data related to the event comments tab as JSON", pathParameters={@RestParameter(name="eventId", description="The event id", isRequired=true, type=RestParameter.Type.STRING)}, responses={@RestResponse(description="Returns all the data related to the event comments tab as JSON", responseCode=200), @RestResponse(description="No event with this identifier was found.", responseCode=404)})
    public Response getEventComments(@PathParam(value="eventId") String eventId) throws Exception {
        Opt optEvent = this.getIndexService().getEvent(eventId, this.getIndex());
        if (optEvent.isNone()) {
            return RestUtils.notFound((String)"Cannot find an event with id '%s'.", (Object[])new Object[]{eventId});
        }
        try {
            List comments = this.getEventCommentService().getComments(eventId);
            ArrayList<Jsons.Obj> commentArr = new ArrayList<Jsons.Obj>();
            for (EventComment c : comments) {
                commentArr.add(c.toJson());
            }
            return Response.ok((Object)Jsons.arr(commentArr).toJson(), (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
        }
        catch (EventCommentException e) {
            logger.error("Unable to get comments from event {}", (Object)eventId, (Object)e);
            throw new WebApplicationException((Throwable)e);
        }
    }

    @GET
    @Path(value="{eventId}/hasActiveTransaction")
    @Produces(value={"text/plain"})
    @RestQuery(name="hasactivetransaction", description="Returns whether there is currently a transaction in progress for the given event", returnDescription="Whether there is currently a transaction in progress for the given event", pathParameters={@RestParameter(name="eventId", description="The event id", isRequired=true, type=RestParameter.Type.STRING)}, responses={@RestResponse(description="Returns whether there is currently a transaction in progress for the given event", responseCode=200), @RestResponse(description="No event with this identifier was found.", responseCode=404)})
    public Response hasActiveTransaction(@PathParam(value="eventId") String eventId) throws Exception {
        Opt optEvent = this.getIndexService().getEvent(eventId, this.getIndex());
        if (optEvent.isNone()) {
            return RestUtils.notFound((String)"Cannot find an event with id '%s'.", (Object[])new Object[]{eventId});
        }
        org.json.simple.JSONObject json = new org.json.simple.JSONObject();
        if (WorkflowUtil.isActive((String)((Event)optEvent.get()).getWorkflowState())) {
            json.put((Object)"active", (Object)true);
        } else {
            json.put((Object)"active", (Object)false);
        }
        return Response.ok((Object)json.toJSONString()).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="{eventId}/comment/{commentId}")
    @RestQuery(name="geteventcomment", description="Returns the comment with the given identifier", returnDescription="Returns the comment as JSON", pathParameters={@RestParameter(name="eventId", description="The event id", isRequired=true, type=RestParameter.Type.STRING), @RestParameter(name="commentId", isRequired=true, description="The comment identifier", type=RestParameter.Type.STRING)}, responses={@RestResponse(responseCode=200, description="The comment as JSON."), @RestResponse(responseCode=404, description="No event or comment with this identifier was found.")})
    public Response getEventComment(@PathParam(value="eventId") String eventId, @PathParam(value="commentId") long commentId) throws NotFoundException, Exception {
        Opt optEvent = this.getIndexService().getEvent(eventId, this.getIndex());
        if (optEvent.isNone()) {
            return RestUtils.notFound((String)"Cannot find an event with id '%s'.", (Object[])new Object[]{eventId});
        }
        try {
            EventComment comment = this.getEventCommentService().getComment(commentId);
            return Response.ok((Object)comment.toJson().toJson()).build();
        }
        catch (NotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error("Could not retrieve comment {}", (Object)commentId, (Object)e);
            throw new WebApplicationException((Throwable)e);
        }
    }

    @PUT
    @Path(value="{eventId}/comment/{commentId}")
    @RestQuery(name="updateeventcomment", description="Updates an event comment", returnDescription="The updated comment as JSON.", pathParameters={@RestParameter(name="eventId", description="The event id", isRequired=true, type=RestParameter.Type.STRING), @RestParameter(name="commentId", isRequired=true, description="The comment identifier", type=RestParameter.Type.STRING)}, restParameters={@RestParameter(name="text", isRequired=false, description="The comment text", type=RestParameter.Type.TEXT), @RestParameter(name="reason", isRequired=false, description="The comment reason", type=RestParameter.Type.STRING), @RestParameter(name="resolved", isRequired=false, description="The comment resolved status", type=RestParameter.Type.BOOLEAN)}, responses={@RestResponse(responseCode=404, description="The event or comment to update has not been found."), @RestResponse(responseCode=200, description="The updated comment as JSON.")})
    public Response updateEventComment(@PathParam(value="eventId") String eventId, @PathParam(value="commentId") long commentId, @FormParam(value="text") String text, @FormParam(value="reason") String reason, @FormParam(value="resolved") Boolean resolved) throws Exception {
        Opt optEvent = this.getIndexService().getEvent(eventId, this.getIndex());
        if (optEvent.isNone()) {
            return RestUtils.notFound((String)"Cannot find an event with id '%s'.", (Object[])new Object[]{eventId});
        }
        try {
            EventComment dto = this.getEventCommentService().getComment(commentId);
            text = StringUtils.isNotBlank((CharSequence)text) ? text.trim() : dto.getText();
            reason = StringUtils.isNotBlank((CharSequence)reason) ? reason.trim() : dto.getReason();
            if (resolved == null) {
                resolved = dto.isResolvedStatus();
            }
            EventComment updatedComment = EventComment.create((Option)dto.getId(), (String)eventId, (String)this.getSecurityService().getOrganization().getId(), (String)text, (User)dto.getAuthor(), (String)reason, (boolean)resolved, (Date)dto.getCreationDate(), (Date)new Date(), (List)dto.getReplies());
            updatedComment = this.getEventCommentService().updateComment(updatedComment);
            List comments = this.getEventCommentService().getComments(eventId);
            this.getIndexService().updateCommentCatalog((Event)optEvent.get(), comments);
            return Response.ok((Object)updatedComment.toJson().toJson()).build();
        }
        catch (NotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error("Unable to update the comments catalog on event {}", (Object)eventId, (Object)e);
            throw new WebApplicationException((Throwable)e);
        }
    }

    @POST
    @Path(value="{eventId}/access")
    @RestQuery(name="applyAclToEvent", description="Immediate application of an ACL to an event", returnDescription="Status code", pathParameters={@RestParameter(name="eventId", isRequired=true, description="The event ID", type=RestParameter.Type.STRING)}, restParameters={@RestParameter(name="acl", isRequired=true, description="The ACL to apply", type=RestParameter.Type.STRING)}, responses={@RestResponse(responseCode=200, description="The ACL has been successfully applied"), @RestResponse(responseCode=400, description="Unable to parse the given ACL"), @RestResponse(responseCode=404, description="The the event has not been found"), @RestResponse(responseCode=401, description="Not authorized to perform this action"), @RestResponse(responseCode=500, description="Internal error")})
    public Response applyAclToEvent(@PathParam(value="eventId") String eventId, @FormParam(value="acl") String acl) throws NotFoundException, UnauthorizedException, SearchIndexException, IndexServiceException {
        AccessControlList accessControlList;
        try {
            accessControlList = AccessControlParser.parseAcl((String)acl);
        }
        catch (Exception e) {
            logger.warn("Unable to parse ACL '{}'", (Object)acl);
            return RestUtil.R.badRequest();
        }
        try {
            Opt optEvent = this.getIndexService().getEvent(eventId, this.getIndex());
            if (optEvent.isNone()) {
                logger.warn("Unable to find the event '{}'", (Object)eventId);
                return RestUtil.R.notFound();
            }
            IndexService.Source eventSource = this.getIndexService().getEventSource((Event)optEvent.get());
            if (eventSource == IndexService.Source.ARCHIVE) {
                Optional mediaPackage = this.getAssetManager().getMediaPackage(eventId);
                Option aclOpt = Option.option((Object)accessControlList);
                if (mediaPackage.isPresent()) {
                    final MediaPackage episodeSvcMp = (MediaPackage)mediaPackage.get();
                    aclOpt.fold((Option.Match)new Option.EMatch<AccessControlList>(){

                        public void esome(AccessControlList acl) {
                            try {
                                MediaPackage mp = (MediaPackage)AbstractEventEndpoint.this.getAuthorizationService().setAcl(episodeSvcMp, AclScope.Episode, acl).getA();
                                AbstractEventEndpoint.this.getAssetManager().takeSnapshot(mp);
                            }
                            catch (MediaPackageException e) {
                                logger.error("Error getting ACL from media package", (Throwable)e);
                            }
                        }

                        public void enone() {
                            MediaPackage mp = AbstractEventEndpoint.this.getAuthorizationService().removeAcl(episodeSvcMp, AclScope.Episode);
                            AbstractEventEndpoint.this.getAssetManager().takeSnapshot(mp);
                        }
                    });
                    return RestUtil.R.ok();
                }
                logger.warn("Unable to find the event '{}'", (Object)eventId);
                return RestUtil.R.notFound();
            }
            if (eventSource == IndexService.Source.WORKFLOW) {
                logger.warn("An ACL cannot be edited while an event is part of a current workflow because it might lead to inconsistent ACLs i.e. changed after distribution so that the old ACL is still being used by the distribution channel.");
                org.json.simple.JSONObject json = new org.json.simple.JSONObject();
                json.put((Object)"Error", (Object)"Unable to edit an ACL for a current workflow.");
                return RestUtil.R.conflict((String)json.toJSONString());
            }
            MediaPackage mediaPackage = this.getIndexService().getEventMediapackage((Event)optEvent.get());
            mediaPackage = (MediaPackage)this.getAuthorizationService().setAcl(mediaPackage, AclScope.Episode, accessControlList).getA();
            this.getSchedulerService().updateEvent(eventId, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(mediaPackage), Optional.empty(), Optional.empty());
            return RestUtil.R.ok();
        }
        catch (MediaPackageException e) {
            if (e.getCause() instanceof UnauthorizedException) {
                return RestUtil.R.forbidden();
            }
            logger.error("Error applying acl '{}' to event '{}'", new Object[]{accessControlList, eventId, e});
            return RestUtil.R.serverError();
        }
        catch (SchedulerException e) {
            logger.error("Error applying ACL to scheduled event {}", (Object)eventId, (Object)e);
            return RestUtil.R.serverError();
        }
    }

    @POST
    @Path(value="{eventId}/comment")
    @Produces(value={"application/json"})
    @RestQuery(name="createeventcomment", description="Creates a comment related to the event given by the identifier", returnDescription="The comment related to the event as JSON", pathParameters={@RestParameter(name="eventId", description="The event id", isRequired=true, type=RestParameter.Type.STRING)}, restParameters={@RestParameter(name="text", isRequired=true, description="The comment text", type=RestParameter.Type.TEXT), @RestParameter(name="resolved", isRequired=false, description="The comment resolved status", type=RestParameter.Type.BOOLEAN), @RestParameter(name="reason", isRequired=false, description="The comment reason", type=RestParameter.Type.STRING)}, responses={@RestResponse(description="The comment has been created.", responseCode=201), @RestResponse(description="If no text ist set.", responseCode=400), @RestResponse(description="No event with this identifier was found.", responseCode=404)})
    public Response createEventComment(@PathParam(value="eventId") String eventId, @FormParam(value="text") String text, @FormParam(value="reason") String reason, @FormParam(value="resolved") Boolean resolved) throws Exception {
        Opt optEvent = this.getIndexService().getEvent(eventId, this.getIndex());
        if (optEvent.isNone()) {
            return RestUtils.notFound((String)"Cannot find an event with id '%s'.", (Object[])new Object[]{eventId});
        }
        if (StringUtils.isBlank((CharSequence)text)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        User author = this.getSecurityService().getUser();
        try {
            EventComment createdComment = EventComment.create((Option)Option.none(), (String)eventId, (String)this.getSecurityService().getOrganization().getId(), (String)text, (User)author, (String)reason, (boolean)BooleanUtils.toBoolean((String)reason));
            createdComment = this.getEventCommentService().updateComment(createdComment);
            List comments = this.getEventCommentService().getComments(eventId);
            this.getIndexService().updateCommentCatalog((Event)optEvent.get(), comments);
            return Response.created((URI)this.getCommentUrl(eventId, (Long)createdComment.getId().get())).entity((Object)createdComment.toJson().toJson()).build();
        }
        catch (Exception e) {
            logger.error("Unable to create a comment on the event {}", (Object)eventId, (Object)e);
            throw new WebApplicationException((Throwable)e);
        }
    }

    @POST
    @Path(value="{eventId}/comment/{commentId}")
    @RestQuery(name="resolveeventcomment", description="Resolves an event comment", returnDescription="The resolved comment.", pathParameters={@RestParameter(name="eventId", description="The event id", isRequired=true, type=RestParameter.Type.STRING), @RestParameter(name="commentId", isRequired=true, description="The comment identifier", type=RestParameter.Type.STRING)}, responses={@RestResponse(responseCode=404, description="The event or comment to resolve has not been found."), @RestResponse(responseCode=200, description="The resolved comment as JSON.")})
    public Response resolveEventComment(@PathParam(value="eventId") String eventId, @PathParam(value="commentId") long commentId) throws Exception {
        Opt optEvent = this.getIndexService().getEvent(eventId, this.getIndex());
        if (optEvent.isNone()) {
            return RestUtils.notFound((String)"Cannot find an event with id '%s'.", (Object[])new Object[]{eventId});
        }
        try {
            EventComment dto = this.getEventCommentService().getComment(commentId);
            EventComment updatedComment = EventComment.create((Option)dto.getId(), (String)dto.getEventId(), (String)dto.getOrganization(), (String)dto.getText(), (User)dto.getAuthor(), (String)dto.getReason(), (boolean)true, (Date)dto.getCreationDate(), (Date)new Date(), (List)dto.getReplies());
            updatedComment = this.getEventCommentService().updateComment(updatedComment);
            List comments = this.getEventCommentService().getComments(eventId);
            this.getIndexService().updateCommentCatalog((Event)optEvent.get(), comments);
            return Response.ok((Object)updatedComment.toJson().toJson()).build();
        }
        catch (NotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error("Could not resolve comment {}", (Object)commentId, (Object)e);
            throw new WebApplicationException((Throwable)e);
        }
    }

    @DELETE
    @Path(value="{eventId}/comment/{commentId}")
    @Produces(value={"application/json"})
    @RestQuery(name="deleteeventcomment", description="Deletes a event related comment by its identifier", returnDescription="No content", pathParameters={@RestParameter(name="eventId", description="The event id", isRequired=true, type=RestParameter.Type.STRING), @RestParameter(name="commentId", description="The comment id", isRequired=true, type=RestParameter.Type.STRING)}, responses={@RestResponse(description="The event related comment has been deleted.", responseCode=204), @RestResponse(description="No event or comment with this identifier was found.", responseCode=404)})
    public Response deleteEventComment(@PathParam(value="eventId") String eventId, @PathParam(value="commentId") long commentId) throws Exception {
        Opt optEvent = this.getIndexService().getEvent(eventId, this.getIndex());
        if (optEvent.isNone()) {
            return RestUtils.notFound((String)"Cannot find an event with id '%s'.", (Object[])new Object[]{eventId});
        }
        try {
            this.getEventCommentService().deleteComment(commentId);
            List comments = this.getEventCommentService().getComments(eventId);
            this.getIndexService().updateCommentCatalog((Event)optEvent.get(), comments);
            return Response.noContent().build();
        }
        catch (NotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error("Unable to delete comment {} on event {}", new Object[]{commentId, eventId, e});
            throw new WebApplicationException((Throwable)e);
        }
    }

    @DELETE
    @Path(value="{eventId}/comment/{commentId}/{replyId}")
    @RestQuery(name="deleteeventreply", description="Delete an event comment reply", returnDescription="The updated comment as JSON.", pathParameters={@RestParameter(name="eventId", description="The event id", isRequired=true, type=RestParameter.Type.STRING), @RestParameter(name="commentId", isRequired=true, description="The comment identifier", type=RestParameter.Type.STRING), @RestParameter(name="replyId", isRequired=true, description="The comment reply identifier", type=RestParameter.Type.STRING)}, responses={@RestResponse(responseCode=404, description="No event comment or reply with this identifier was found."), @RestResponse(responseCode=200, description="The updated comment as JSON.")})
    public Response deleteEventCommentReply(@PathParam(value="eventId") String eventId, @PathParam(value="commentId") long commentId, @PathParam(value="replyId") long replyId) throws Exception {
        Opt optEvent = this.getIndexService().getEvent(eventId, this.getIndex());
        if (optEvent.isNone()) {
            return RestUtils.notFound((String)"Cannot find an event with id '%s'.", (Object[])new Object[]{eventId});
        }
        EventComment comment = null;
        EventCommentReply reply = null;
        try {
            comment = this.getEventCommentService().getComment(commentId);
            for (EventCommentReply r : comment.getReplies()) {
                if (r.getId().isNone() || replyId != (Long)r.getId().get()) continue;
                reply = r;
                break;
            }
            if (reply == null) {
                throw new NotFoundException("Reply with id " + replyId + " not found!");
            }
            comment.removeReply(reply);
            EventComment updatedComment = this.getEventCommentService().updateComment(comment);
            List comments = this.getEventCommentService().getComments(eventId);
            this.getIndexService().updateCommentCatalog((Event)optEvent.get(), comments);
            return Response.ok((Object)updatedComment.toJson().toJson()).build();
        }
        catch (NotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            logger.warn("Could not remove event comment reply {} from comment {}", new Object[]{replyId, commentId, e});
            throw new WebApplicationException((Throwable)e);
        }
    }

    @PUT
    @Path(value="{eventId}/comment/{commentId}/{replyId}")
    @RestQuery(name="updateeventcommentreply", description="Updates an event comment reply", returnDescription="The updated comment as JSON.", pathParameters={@RestParameter(name="eventId", description="The event id", isRequired=true, type=RestParameter.Type.STRING), @RestParameter(name="commentId", isRequired=true, description="The comment identifier", type=RestParameter.Type.STRING), @RestParameter(name="replyId", isRequired=true, description="The comment reply identifier", type=RestParameter.Type.STRING)}, restParameters={@RestParameter(name="text", isRequired=true, description="The comment reply text", type=RestParameter.Type.TEXT)}, responses={@RestResponse(responseCode=404, description="The event or comment to extend with a reply or the reply has not been found."), @RestResponse(responseCode=400, description="If no text is set."), @RestResponse(responseCode=200, description="The updated comment as JSON.")})
    public Response updateEventCommentReply(@PathParam(value="eventId") String eventId, @PathParam(value="commentId") long commentId, @PathParam(value="replyId") long replyId, @FormParam(value="text") String text) throws Exception {
        if (StringUtils.isBlank((CharSequence)text)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        Opt optEvent = this.getIndexService().getEvent(eventId, this.getIndex());
        if (optEvent.isNone()) {
            return RestUtils.notFound((String)"Cannot find an event with id '%s'.", (Object[])new Object[]{eventId});
        }
        EventComment comment = null;
        EventCommentReply reply = null;
        try {
            comment = this.getEventCommentService().getComment(commentId);
            for (EventCommentReply r : comment.getReplies()) {
                if (r.getId().isNone() || replyId != (Long)r.getId().get()) continue;
                reply = r;
                break;
            }
            if (reply == null) {
                throw new NotFoundException("Reply with id " + replyId + " not found!");
            }
            EventCommentReply updatedReply = EventCommentReply.create((Option)reply.getId(), (String)text.trim(), (User)reply.getAuthor(), (Date)reply.getCreationDate(), (Date)new Date());
            comment.removeReply(reply);
            comment.addReply(updatedReply);
            EventComment updatedComment = this.getEventCommentService().updateComment(comment);
            List comments = this.getEventCommentService().getComments(eventId);
            this.getIndexService().updateCommentCatalog((Event)optEvent.get(), comments);
            return Response.ok((Object)updatedComment.toJson().toJson()).build();
        }
        catch (NotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            logger.warn("Could not update event comment reply {} from comment {}", new Object[]{replyId, commentId, e});
            throw new WebApplicationException((Throwable)e);
        }
    }

    @POST
    @Path(value="{eventId}/comment/{commentId}/reply")
    @RestQuery(name="createeventcommentreply", description="Creates an event comment reply", returnDescription="The updated comment as JSON.", pathParameters={@RestParameter(name="eventId", description="The event id", isRequired=true, type=RestParameter.Type.STRING), @RestParameter(name="commentId", isRequired=true, description="The comment identifier", type=RestParameter.Type.STRING)}, restParameters={@RestParameter(name="text", isRequired=true, description="The comment reply text", type=RestParameter.Type.TEXT), @RestParameter(name="resolved", isRequired=false, description="Flag defining if this reply solve or not the comment.", type=RestParameter.Type.BOOLEAN)}, responses={@RestResponse(responseCode=404, description="The event or comment to extend with a reply has not been found."), @RestResponse(responseCode=400, description="If no text is set."), @RestResponse(responseCode=200, description="The updated comment as JSON.")})
    public Response createEventCommentReply(@PathParam(value="eventId") String eventId, @PathParam(value="commentId") long commentId, @FormParam(value="text") String text, @FormParam(value="resolved") Boolean resolved) throws Exception {
        if (StringUtils.isBlank((CharSequence)text)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        Opt optEvent = this.getIndexService().getEvent(eventId, this.getIndex());
        if (optEvent.isNone()) {
            return RestUtils.notFound((String)"Cannot find an event with id '%s'.", (Object[])new Object[]{eventId});
        }
        EventComment comment = null;
        try {
            comment = this.getEventCommentService().getComment(commentId);
            EventComment updatedComment = resolved != null && resolved != false ? EventComment.create((Option)comment.getId(), (String)comment.getEventId(), (String)comment.getOrganization(), (String)comment.getText(), (User)comment.getAuthor(), (String)comment.getReason(), (boolean)true, (Date)comment.getCreationDate(), (Date)new Date(), (List)comment.getReplies()) : comment;
            User author = this.getSecurityService().getUser();
            EventCommentReply reply = EventCommentReply.create((Option)Option.none(), (String)text, (User)author);
            updatedComment.addReply(reply);
            updatedComment = this.getEventCommentService().updateComment(updatedComment);
            List comments = this.getEventCommentService().getComments(eventId);
            this.getIndexService().updateCommentCatalog((Event)optEvent.get(), comments);
            return Response.ok((Object)updatedComment.toJson().toJson()).build();
        }
        catch (Exception e) {
            logger.warn("Could not create event comment reply on comment {}", (Object)comment, (Object)e);
            throw new WebApplicationException((Throwable)e);
        }
    }

    private void removeSeriesWithNullTitlesFromFieldCollection(MetadataList ml) {
        MetadataField seriesField = Optional.ofNullable((MetadataList.TitledMetadataCollection)ml.getMetadataList().get("dublincore/episode")).flatMap(titledMetadataCollection -> Optional.ofNullable(titledMetadataCollection.getCollection())).flatMap(dcMetadataCollection -> Optional.ofNullable(dcMetadataCollection.getOutputFields())).flatMap(metadataFields -> Optional.ofNullable((MetadataField)metadataFields.get("isPartOf"))).orElse(null);
        if (seriesField == null || seriesField.getCollection() == null) {
            return;
        }
        Map seriesCollection = seriesField.getCollection();
        seriesCollection.remove(null);
        seriesField.setCollection(seriesCollection);
    }

    @GET
    @Path(value="{eventId}/metadata.json")
    @Produces(value={"application/json"})
    @RestQuery(name="geteventmetadata", description="Returns all the data related to the metadata tab in the event details modal as JSON", returnDescription="All the data related to the event metadata tab as JSON", pathParameters={@RestParameter(name="eventId", description="The event id", isRequired=true, type=RestParameter.Type.STRING)}, responses={@RestResponse(description="Returns all the data related to the event metadata tab as JSON", responseCode=200), @RestResponse(description="No event with this identifier was found.", responseCode=404)})
    public Response getEventMetadata(@PathParam(value="eventId") String eventId) throws Exception {
        Opt optEvent = this.getIndexService().getEvent(eventId, this.getIndex());
        if (optEvent.isNone()) {
            return RestUtils.notFound((String)"Cannot find an event with id '%s'.", (Object[])new Object[]{eventId});
        }
        Event event = (Event)optEvent.get();
        MetadataList metadataList = new MetadataList();
        List extendedCatalogUIAdapters = this.getIndexService().getExtendedEventCatalogUIAdapters();
        if (!extendedCatalogUIAdapters.isEmpty()) {
            MediaPackage mediaPackage;
            try {
                mediaPackage = this.getIndexService().getEventMediapackage(event);
            }
            catch (IndexServiceException e) {
                if (e.getCause() instanceof NotFoundException) {
                    return RestUtils.notFound((String)"Cannot find data for event %s", (Object[])new Object[]{eventId});
                }
                if (e.getCause() instanceof UnauthorizedException) {
                    return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)("Not authorized to access " + eventId)).build();
                }
                logger.error("Internal error when trying to access metadata for " + eventId, (Throwable)e);
                return RestUtil.R.serverError();
            }
            for (EventCatalogUIAdapter extendedCatalogUIAdapter : extendedCatalogUIAdapters) {
                metadataList.add(extendedCatalogUIAdapter, extendedCatalogUIAdapter.getFields(mediaPackage));
            }
        }
        EventCatalogUIAdapter eventCatalogUiAdapter = this.getIndexService().getCommonEventCatalogUIAdapter();
        DublinCoreMetadataCollection metadataCollection = eventCatalogUiAdapter.getRawFields(this.getCollectionQueryDisable());
        EventUtils.setEventMetadataValues((Event)event, (DublinCoreMetadataCollection)metadataCollection);
        metadataList.add(eventCatalogUiAdapter, metadataCollection);
        this.removeSeriesWithNullTitlesFromFieldCollection(metadataList);
        String wfState = event.getWorkflowState();
        if (wfState != null && WorkflowUtil.isActive((WorkflowInstance.WorkflowState)WorkflowInstance.WorkflowState.valueOf((String)wfState))) {
            metadataList.setLocked(MetadataList.Locked.WORKFLOW_RUNNING);
        }
        return RestUtils.okJson((JValue)MetadataJson.listToJson((MetadataList)metadataList, (boolean)true));
    }

    private Map getCollectionQueryDisable() {
        HashMap<String, SeriesListQuery> collectionQueryOverrides = new HashMap<String, SeriesListQuery>();
        SeriesListQuery seriesListQuery = new SeriesListQuery();
        seriesListQuery.setLimit(Integer.valueOf(0));
        collectionQueryOverrides.put(DublinCore.PROPERTY_IS_PART_OF.getLocalName(), seriesListQuery);
        return collectionQueryOverrides;
    }

    @POST
    @Path(value="events/metadata.json")
    @Produces(value={"application/json"})
    @RestQuery(name="geteventsmetadata", description="Returns all the data related to the edit events metadata modal as JSON", returnDescription="All the data related to the edit events metadata modal as JSON", restParameters={@RestParameter(name="eventIds", description="The event ids", isRequired=true, type=RestParameter.Type.STRING)}, responses={@RestResponse(description="Returns all the data related to the edit events metadata modal as JSON", responseCode=200), @RestResponse(description="No events to update, either not found or with running workflow, details in response body.", responseCode=404)})
    public Response getEventsMetadata(@FormParam(value="eventIds") String eventIds) throws Exception {
        DublinCoreMetadataCollection mergedMetadata;
        List ids;
        if (StringUtils.isBlank((CharSequence)eventIds)) {
            return RestUtil.R.badRequest((String)"Event ids can't be empty");
        }
        JSONParser parser = new JSONParser();
        try {
            ids = (List)parser.parse(eventIds);
        }
        catch (ParseException e) {
            logger.error("Unable to parse '{}'", (Object)eventIds, (Object)e);
            return RestUtil.R.badRequest((String)"Unable to parse event ids");
        }
        catch (ClassCastException e) {
            logger.error("Unable to cast '{}'", (Object)eventIds, (Object)e);
            return RestUtil.R.badRequest((String)"Unable to parse event ids");
        }
        HashSet<String> eventsNotFound = new HashSet<String>();
        HashSet<String> eventsWithRunningWorkflow = new HashSet<String>();
        HashSet<String> eventsMerged = new HashSet<String>();
        ArrayList<DublinCoreMetadataCollection> collectedMetadata = new ArrayList<DublinCoreMetadataCollection>();
        for (String eventId : ids) {
            Opt optEvent = this.getIndexService().getEvent(eventId, this.getIndex());
            if (optEvent.isNone()) {
                eventsNotFound.add(eventId);
                continue;
            }
            Event event = (Event)optEvent.get();
            String wfState = event.getWorkflowState();
            if (wfState != null && WorkflowUtil.isActive((WorkflowInstance.WorkflowState)WorkflowInstance.WorkflowState.valueOf((String)wfState))) {
                eventsWithRunningWorkflow.add(eventId);
                continue;
            }
            EventCatalogUIAdapter eventCatalogUiAdapter = this.getIndexService().getCommonEventCatalogUIAdapter();
            DublinCoreMetadataCollection metadataCollection = eventCatalogUiAdapter.getRawFields(this.getCollectionQueryDisable());
            EventUtils.setEventMetadataValues((Event)event, (DublinCoreMetadataCollection)metadataCollection);
            collectedMetadata.add(metadataCollection);
            eventsMerged.add(eventId);
        }
        if (collectedMetadata.isEmpty()) {
            return RestUtils.notFoundJson((JValue)com.entwinemedia.fn.data.json.Jsons.obj((Field[])new Field[]{com.entwinemedia.fn.data.json.Jsons.f((String)"notFound", (JValue)JSONUtils.setToJSON(eventsNotFound)), com.entwinemedia.fn.data.json.Jsons.f((String)"runningWorkflow", (JValue)JSONUtils.setToJSON(eventsWithRunningWorkflow))}));
        }
        if (collectedMetadata.size() == 1) {
            mergedMetadata = (DublinCoreMetadataCollection)collectedMetadata.get(0);
        } else {
            mergedMetadata = new DublinCoreMetadataCollection((DublinCoreMetadataCollection)collectedMetadata.get(0));
            collectedMetadata.remove(0);
            block4: for (MetadataField field : mergedMetadata.getFields()) {
                for (DublinCoreMetadataCollection otherMetadataCollection : collectedMetadata) {
                    MetadataField matchingField = (MetadataField)otherMetadataCollection.getOutputFields().get(field.getOutputID());
                    if (Objects.equals(field.getValue(), matchingField.getValue())) continue;
                    field.setDifferentValues();
                    continue block4;
                }
            }
        }
        return RestUtils.okJson((JValue)com.entwinemedia.fn.data.json.Jsons.obj((Field[])new Field[]{com.entwinemedia.fn.data.json.Jsons.f((String)"metadata", (JValue)MetadataJson.collectionToJson((DublinCoreMetadataCollection)mergedMetadata, (boolean)true)), com.entwinemedia.fn.data.json.Jsons.f((String)"notFound", (JValue)JSONUtils.setToJSON(eventsNotFound)), com.entwinemedia.fn.data.json.Jsons.f((String)"runningWorkflow", (JValue)JSONUtils.setToJSON(eventsWithRunningWorkflow)), com.entwinemedia.fn.data.json.Jsons.f((String)"merged", (JValue)JSONUtils.setToJSON(eventsMerged))}));
    }

    @PUT
    @Path(value="bulk/update")
    @RestQuery(name="bulkupdate", description="Update all of the given events at once", restParameters={@RestParameter(name="update", isRequired=true, type=RestParameter.Type.TEXT, description="The list of groups with events and fields to update.")}, responses={@RestResponse(description="All events have been updated successfully.", responseCode=200), @RestResponse(description="Could not parse update instructions.", responseCode=400), @RestResponse(description="Field updating metadata or scheduling information. Some events may have been updated. Details are available in the response body.", responseCode=500), @RestResponse(description="The events in the response body were not found. No events were updated.", responseCode=404)}, returnDescription="In case of success, no content is returned. In case of errors while updating the metadata or scheduling information, the errors are returned. In case events were not found, their ids are returned")
    public Response bulkUpdate(@FormParam(value="update") String updateJson) {
        BulkUpdateUtil.BulkUpdateInstructions instructions;
        try {
            instructions = new BulkUpdateUtil.BulkUpdateInstructions(updateJson);
        }
        catch (IllegalArgumentException e2) {
            return RestUtil.R.badRequest((String)"Cannot parse bulk update instructions");
        }
        HashMap metadataUpdateFailures = new HashMap();
        HashMap schedulingUpdateFailures = new HashMap();
        for (BulkUpdateUtil.BulkUpdateInstructionGroup groupInstructions : instructions.getGroups()) {
            Map<String, Optional> events = groupInstructions.getEventIds().stream().collect(Collectors.toMap(id -> id, id -> BulkUpdateUtil.getEvent(this.getIndexService(), this.getIndex(), id)));
            Set notFoundIds = events.entrySet().stream().filter(e -> !((Optional)e.getValue()).isPresent()).map(Map.Entry::getKey).collect(Collectors.toSet());
            if (!notFoundIds.isEmpty()) {
                return RestUtils.notFoundJson((JValue)JSONUtils.setToJSON(notFoundIds));
            }
            events.values().forEach(e -> e.ifPresent(event -> {
                org.json.simple.JSONObject metadata = null;
                try {
                    if (groupInstructions.getScheduling() != null) {
                        org.json.simple.JSONObject scheduling = BulkUpdateUtil.addSchedulingDates(event, groupInstructions.getScheduling());
                        this.updateEventScheduling(scheduling.toJSONString(), (Event)event);
                        metadata = BulkUpdateUtil.toNonTechnicalMetadataJson(scheduling);
                    }
                }
                catch (Exception exception) {
                    schedulingUpdateFailures.put(event.getIdentifier(), exception.getMessage());
                }
                try {
                    if (groupInstructions.getMetadata() != null || metadata != null) {
                        metadata = BulkUpdateUtil.mergeMetadataFields(metadata, groupInstructions.getMetadata());
                        this.getIndexService().updateAllEventMetadata(event.getIdentifier(), JSONArray.toJSONString(Collections.singletonList(metadata)), this.getIndex());
                    }
                }
                catch (Exception exception) {
                    metadataUpdateFailures.put(event.getIdentifier(), exception.getMessage());
                }
            }));
        }
        if (!metadataUpdateFailures.isEmpty() || !schedulingUpdateFailures.isEmpty()) {
            return RestUtils.serverErrorJson((JValue)com.entwinemedia.fn.data.json.Jsons.obj((Field[])new Field[]{com.entwinemedia.fn.data.json.Jsons.f((String)"metadataFailures", (JValue)JSONUtils.mapToJSON(metadataUpdateFailures)), com.entwinemedia.fn.data.json.Jsons.f((String)"schedulingFailures", (JValue)JSONUtils.mapToJSON(schedulingUpdateFailures))}));
        }
        return RestUtil.R.ok();
    }

    @POST
    @Path(value="bulk/conflicts")
    @RestQuery(name="getBulkConflicts", description="Checks if the current bulk update scheduling settings are in a conflict with another event", returnDescription="Returns NO CONTENT if no event are in conflict within specified period or list of conflicting recordings in JSON", restParameters={@RestParameter(name="update", isRequired=true, type=RestParameter.Type.TEXT, description="The list of events and fields to update.")}, responses={@RestResponse(responseCode=204, description="No conflicting events found"), @RestResponse(responseCode=404, description="The events in the response body were not found. No events were updated."), @RestResponse(responseCode=409, description="There is a conflict"), @RestResponse(responseCode=400, description="Missing or invalid parameters")})
    public Response getBulkConflicts(@FormParam(value="update") String updateJson) throws NotFoundException {
        BulkUpdateUtil.BulkUpdateInstructions instructions;
        try {
            instructions = new BulkUpdateUtil.BulkUpdateInstructions(updateJson);
        }
        catch (IllegalArgumentException e2) {
            return RestUtil.R.badRequest((String)"Cannot parse bulk update instructions");
        }
        HashMap<String, List> conflicts = new HashMap<String, List>();
        List eventsWithSchedulingOpt = instructions.getGroups().stream().flatMap(group -> group.getEventIds().stream().map(eventId -> Tuple3.tuple3((Object)eventId, BulkUpdateUtil.getEvent(this.getIndexService(), this.getIndex(), eventId), (Object)group.getScheduling()))).collect(Collectors.toList());
        Set notFoundIds = eventsWithSchedulingOpt.stream().filter(e -> !((Optional)e.getB()).isPresent()).map(Tuple3::getA).collect(Collectors.toSet());
        if (!notFoundIds.isEmpty()) {
            return RestUtils.notFoundJson((JValue)JSONUtils.setToJSON(notFoundIds));
        }
        List eventsWithScheduling = eventsWithSchedulingOpt.stream().map(e -> Tuple.tuple((Object)((Event)((Optional)e.getB()).get()), (Object)((org.json.simple.JSONObject)e.getC()))).collect(Collectors.toList());
        Set changedIds = eventsWithScheduling.stream().map(e -> ((Event)e.getA()).getIdentifier()).collect(Collectors.toSet());
        for (Tuple eventWithGroup : eventsWithScheduling) {
            Event event = (Event)eventWithGroup.getA();
            org.json.simple.JSONObject groupScheduling = (org.json.simple.JSONObject)eventWithGroup.getB();
            try {
                if (groupScheduling == null) continue;
                org.json.simple.JSONObject scheduling = BulkUpdateUtil.addSchedulingDates(event, groupScheduling);
                Date start = Date.from(Instant.parse((String)scheduling.get((Object)SCHEDULING_START_KEY)));
                Date end = Date.from(Instant.parse((String)scheduling.get((Object)SCHEDULING_END_KEY)));
                String agentId = Optional.ofNullable((String)scheduling.get((Object)SCHEDULING_AGENT_ID_KEY)).orElse(event.getAgentId());
                ArrayList<JValue> currentConflicts = new ArrayList<JValue>();
                eventsWithScheduling.stream().filter(otherEvent -> !((Event)otherEvent.getA()).getIdentifier().equals(event.getIdentifier())).forEach(otherEvent -> {
                    org.json.simple.JSONObject otherScheduling = BulkUpdateUtil.addSchedulingDates((Event)otherEvent.getA(), (org.json.simple.JSONObject)otherEvent.getB());
                    Date otherStart = Date.from(Instant.parse((String)otherScheduling.get((Object)SCHEDULING_START_KEY)));
                    Date otherEnd = Date.from(Instant.parse((String)otherScheduling.get((Object)SCHEDULING_END_KEY)));
                    String otherAgentId = Optional.ofNullable((String)otherScheduling.get((Object)SCHEDULING_AGENT_ID_KEY)).orElse(((Event)otherEvent.getA()).getAgentId());
                    if (!otherAgentId.equals(agentId)) {
                        return;
                    }
                    if (Util.schedulingIntervalsOverlap((Date)start, (Date)end, (Date)otherStart, (Date)otherEnd)) {
                        currentConflicts.add(this.convertEventToConflictingObject(DateTimeSupport.toUTC((long)otherStart.getTime()), DateTimeSupport.toUTC((long)otherEnd.getTime()), ((Event)otherEvent.getA()).getTitle()));
                    }
                });
                List<MediaPackage> conflicting = this.getSchedulerService().findConflictingEvents(agentId, start, end).stream().filter(mp -> !changedIds.contains(mp.getIdentifier().toString())).collect(Collectors.toList());
                if (!conflicting.isEmpty()) {
                    currentConflicts.addAll(this.convertToConflictObjects(event.getIdentifier(), conflicting));
                }
                conflicts.put(event.getIdentifier(), currentConflicts);
            }
            catch (SearchIndexException | SchedulerException | UnauthorizedException exception) {
                throw new RuntimeException(exception);
            }
        }
        if (!conflicts.isEmpty()) {
            ArrayList responseJson = new ArrayList();
            conflicts.forEach((eventId, conflictingEvents) -> {
                if (!conflictingEvents.isEmpty()) {
                    responseJson.add(com.entwinemedia.fn.data.json.Jsons.obj((Field[])new Field[]{com.entwinemedia.fn.data.json.Jsons.f((String)"eventId", (String)eventId), com.entwinemedia.fn.data.json.Jsons.f((String)"conflicts", (JValue)com.entwinemedia.fn.data.json.Jsons.arr((Iterable)conflictingEvents))}));
                }
            });
            if (!responseJson.isEmpty()) {
                return RestUtils.conflictJson((JValue)com.entwinemedia.fn.data.json.Jsons.arr(responseJson));
            }
        }
        return RestUtil.R.noContent();
    }

    @PUT
    @Path(value="{eventId}/metadata")
    @RestQuery(name="updateeventmetadata", description="Update the passed metadata for the event with the given Id", pathParameters={@RestParameter(name="eventId", description="The event id", isRequired=true, type=RestParameter.Type.STRING)}, restParameters={@RestParameter(name="metadata", isRequired=true, type=RestParameter.Type.TEXT, description="The list of metadata to update")}, responses={@RestResponse(description="The metadata have been updated.", responseCode=200), @RestResponse(description="Could not parse metadata.", responseCode=400), @RestResponse(description="No event with this identifier was found.", responseCode=404)}, returnDescription="No content is returned.")
    public Response updateEventMetadata(@PathParam(value="eventId") String id, @FormParam(value="metadata") String metadataJSON) throws Exception {
        Opt optEvent = this.getIndexService().getEvent(id, this.getIndex());
        if (optEvent.isNone()) {
            return RestUtils.notFound((String)"Cannot find an event with id '%s'.", (Object[])new Object[]{id});
        }
        try {
            MetadataList metadataList = this.getIndexService().updateAllEventMetadata(id, metadataJSON, this.getIndex());
            return RestUtils.okJson((JValue)MetadataJson.listToJson((MetadataList)metadataList, (boolean)true));
        }
        catch (IllegalArgumentException e) {
            return RestUtil.R.badRequest((String)String.format("Event %s metadata can't be updated.: %s", id, e.getMessage()));
        }
    }

    @PUT
    @Path(value="events/metadata")
    @RestQuery(name="updateeventsmetadata", description="Update the passed metadata for the events with the given ids", restParameters={@RestParameter(name="eventIds", isRequired=true, type=RestParameter.Type.STRING, description="The ids of the events to update"), @RestParameter(name="metadata", isRequired=true, type=RestParameter.Type.TEXT, description="The metadata fields to update")}, responses={@RestResponse(description="All events have been updated successfully.", responseCode=204), @RestResponse(description="One or multiple errors occured while updating event metadata. Some events may have been updated successfully. Details are available in the response body.", responseCode=500)}, returnDescription="In case of complete success, no content is returned. Otherwise, the response content contains the ids of events that couldn't be found and the ids and errors of events where the update failed as well as the ids of the events that were updated successfully.")
    public Response updateEventsMetadata(@FormParam(value="eventIds") String eventIds, @FormParam(value="metadata") String metadata) throws Exception {
        List ids;
        if (StringUtils.isBlank((CharSequence)eventIds)) {
            return RestUtil.R.badRequest((String)"Event ids can't be empty");
        }
        JSONParser parser = new JSONParser();
        try {
            ids = (List)parser.parse(eventIds);
        }
        catch (ParseException e) {
            logger.error("Unable to parse '{}'", (Object)eventIds, (Object)e);
            return RestUtil.R.badRequest((String)"Unable to parse event ids");
        }
        catch (ClassCastException e) {
            logger.error("Unable to cast '{}'", (Object)eventIds, (Object)e);
            return RestUtil.R.badRequest((String)"Unable to parse event ids");
        }
        HashSet<String> eventsNotFound = new HashSet<String>();
        HashSet<String> eventsUpdated = new HashSet<String>();
        HashSet<String> eventsUpdateFailure = new HashSet<String>();
        for (String eventId : ids) {
            Opt optEvent = this.getIndexService().getEvent(eventId, this.getIndex());
            if (optEvent.isNone()) {
                eventsNotFound.add(eventId);
                continue;
            }
            try {
                this.getIndexService().updateAllEventMetadata(eventId, metadata, this.getIndex());
                eventsUpdated.add(eventId);
            }
            catch (IllegalArgumentException e) {
                eventsUpdateFailure.add(eventId);
            }
        }
        if (!eventsNotFound.isEmpty() || !eventsUpdateFailure.isEmpty()) {
            return RestUtils.serverErrorJson((JValue)com.entwinemedia.fn.data.json.Jsons.obj((Field[])new Field[]{com.entwinemedia.fn.data.json.Jsons.f((String)"updateFailures", (JValue)JSONUtils.setToJSON(eventsUpdateFailure)), com.entwinemedia.fn.data.json.Jsons.f((String)"notFound", (JValue)JSONUtils.setToJSON(eventsNotFound)), com.entwinemedia.fn.data.json.Jsons.f((String)"updated", (JValue)JSONUtils.setToJSON(eventsUpdated))}));
        }
        return RestUtil.R.noContent();
    }

    @GET
    @Path(value="{eventId}/asset/assets.json")
    @Produces(value={"application/json"})
    @RestQuery(name="getAssetList", description="Returns the number of assets from each types as JSON", returnDescription="The number of assets from each types as JSON", pathParameters={@RestParameter(name="eventId", description="The event id", isRequired=true, type=RestParameter.Type.STRING)}, responses={@RestResponse(description="Returns the number of assets from each types as JSON", responseCode=200), @RestResponse(description="No event with this identifier was found.", responseCode=404)})
    public Response getAssetList(@PathParam(value="eventId") String id) throws Exception {
        MediaPackage mp;
        Opt optEvent = this.getIndexService().getEvent(id, this.getIndex());
        if (optEvent.isNone()) {
            return RestUtils.notFound((String)"Cannot find an event with id '%s'.", (Object[])new Object[]{id});
        }
        try {
            mp = this.getIndexService().getEventMediapackage((Event)optEvent.get());
        }
        catch (IndexServiceException e) {
            if (e.getCause() instanceof NotFoundException) {
                return RestUtils.notFound((String)"Cannot find data for event %s", (Object[])new Object[]{id});
            }
            if (e.getCause() instanceof UnauthorizedException) {
                return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)("Not authorized to access " + id)).build();
            }
            logger.error("Internal error when trying to access metadata for " + id, (Throwable)e);
            return RestUtil.R.serverError();
        }
        int attachments = mp.getAttachments().length;
        int catalogs = mp.getCatalogs().length;
        int media = mp.getTracks().length;
        int publications = mp.getPublications().length;
        return RestUtils.okJson((JValue)com.entwinemedia.fn.data.json.Jsons.obj((Field[])new Field[]{com.entwinemedia.fn.data.json.Jsons.f((String)"attachments", (JValue)com.entwinemedia.fn.data.json.Jsons.v((Number)attachments)), com.entwinemedia.fn.data.json.Jsons.f((String)"catalogs", (JValue)com.entwinemedia.fn.data.json.Jsons.v((Number)catalogs)), com.entwinemedia.fn.data.json.Jsons.f((String)"media", (JValue)com.entwinemedia.fn.data.json.Jsons.v((Number)media)), com.entwinemedia.fn.data.json.Jsons.f((String)"publications", (JValue)com.entwinemedia.fn.data.json.Jsons.v((Number)publications))}));
    }

    @GET
    @Path(value="{eventId}/asset/attachment/attachments.json")
    @Produces(value={"application/json"})
    @RestQuery(name="getAttachmentsList", description="Returns a list of attachments from the given event as JSON", returnDescription="The list of attachments from the given event as JSON", pathParameters={@RestParameter(name="eventId", description="The event id", isRequired=true, type=RestParameter.Type.STRING)}, responses={@RestResponse(description="Returns a list of attachments from the given event as JSON", responseCode=200), @RestResponse(description="No event with this identifier was found.", responseCode=404)})
    public Response getAttachmentsList(@PathParam(value="eventId") String id) throws Exception {
        Opt optEvent = this.getIndexService().getEvent(id, this.getIndex());
        if (optEvent.isNone()) {
            return RestUtils.notFound((String)"Cannot find an event with id '%s'.", (Object[])new Object[]{id});
        }
        MediaPackage mp = this.getIndexService().getEventMediapackage((Event)optEvent.get());
        return RestUtils.okJson((JValue)com.entwinemedia.fn.data.json.Jsons.arr(this.getEventMediaPackageElements((MediaPackageElement[])mp.getAttachments())));
    }

    @GET
    @Path(value="{eventId}/asset/attachment/{id}.json")
    @Produces(value={"application/json"})
    @RestQuery(name="getAttachment", description="Returns the details of an attachment from the given event and attachment id as JSON", returnDescription="The details of an attachment from the given event and attachment id as JSON", pathParameters={@RestParameter(name="eventId", description="The event id", isRequired=true, type=RestParameter.Type.STRING), @RestParameter(name="id", description="The attachment id", isRequired=true, type=RestParameter.Type.STRING)}, responses={@RestResponse(description="Returns the details of an attachment from the given event and attachment id as JSON", responseCode=200), @RestResponse(description="No event or attachment with this identifier was found.", responseCode=404)})
    public Response getAttachment(@PathParam(value="eventId") String eventId, @PathParam(value="id") String id) throws NotFoundException, SearchIndexException, IndexServiceException {
        MediaPackage mp = this.getMediaPackageByEventId(eventId);
        Attachment attachment = mp.getAttachment(id);
        if (attachment == null) {
            return RestUtils.notFound((String)"Cannot find an attachment with id '%s'.", (Object[])new Object[]{id});
        }
        return RestUtils.okJson((JValue)this.attachmentToJSON(attachment));
    }

    @GET
    @Path(value="{eventId}/asset/catalog/catalogs.json")
    @Produces(value={"application/json"})
    @RestQuery(name="getCatalogList", description="Returns a list of catalogs from the given event as JSON", returnDescription="The list of catalogs from the given event as JSON", pathParameters={@RestParameter(name="eventId", description="The event id", isRequired=true, type=RestParameter.Type.STRING)}, responses={@RestResponse(description="Returns a list of catalogs from the given event as JSON", responseCode=200), @RestResponse(description="No event with this identifier was found.", responseCode=404)})
    public Response getCatalogList(@PathParam(value="eventId") String id) throws Exception {
        Opt optEvent = this.getIndexService().getEvent(id, this.getIndex());
        if (optEvent.isNone()) {
            return RestUtils.notFound((String)"Cannot find an event with id '%s'.", (Object[])new Object[]{id});
        }
        MediaPackage mp = this.getIndexService().getEventMediapackage((Event)optEvent.get());
        return RestUtils.okJson((JValue)com.entwinemedia.fn.data.json.Jsons.arr(this.getEventMediaPackageElements((MediaPackageElement[])mp.getCatalogs())));
    }

    @GET
    @Path(value="{eventId}/asset/catalog/{id}.json")
    @Produces(value={"application/json"})
    @RestQuery(name="getCatalog", description="Returns the details of a catalog from the given event and catalog id as JSON", returnDescription="The details of a catalog from the given event and catalog id as JSON", pathParameters={@RestParameter(name="eventId", description="The event id", isRequired=true, type=RestParameter.Type.STRING), @RestParameter(name="id", description="The catalog id", isRequired=true, type=RestParameter.Type.STRING)}, responses={@RestResponse(description="Returns the details of a catalog from the given event and catalog id as JSON", responseCode=200), @RestResponse(description="No event or catalog with this identifier was found.", responseCode=404)})
    public Response getCatalog(@PathParam(value="eventId") String eventId, @PathParam(value="id") String id) throws NotFoundException, SearchIndexException, IndexServiceException {
        MediaPackage mp = this.getMediaPackageByEventId(eventId);
        Catalog catalog = mp.getCatalog(id);
        if (catalog == null) {
            return RestUtils.notFound((String)"Cannot find a catalog with id '%s'.", (Object[])new Object[]{id});
        }
        return RestUtils.okJson((JValue)this.catalogToJSON(catalog));
    }

    @GET
    @Path(value="{eventId}/asset/media/media.json")
    @Produces(value={"application/json"})
    @RestQuery(name="getMediaList", description="Returns a list of media from the given event as JSON", returnDescription="The list of media from the given event as JSON", pathParameters={@RestParameter(name="eventId", description="The event id", isRequired=true, type=RestParameter.Type.STRING)}, responses={@RestResponse(description="Returns a list of media from the given event as JSON", responseCode=200), @RestResponse(description="No event with this identifier was found.", responseCode=404)})
    public Response getMediaList(@PathParam(value="eventId") String id) throws Exception {
        Opt optEvent = this.getIndexService().getEvent(id, this.getIndex());
        if (optEvent.isNone()) {
            return RestUtils.notFound((String)"Cannot find an event with id '%s'.", (Object[])new Object[]{id});
        }
        MediaPackage mp = this.getIndexService().getEventMediapackage((Event)optEvent.get());
        return RestUtils.okJson((JValue)com.entwinemedia.fn.data.json.Jsons.arr(this.getEventMediaPackageElements((MediaPackageElement[])mp.getTracks())));
    }

    @GET
    @Path(value="{eventId}/asset/media/{id}.json")
    @Produces(value={"application/json"})
    @RestQuery(name="getMedia", description="Returns the details of a media from the given event and media id as JSON", returnDescription="The details of a media from the given event and media id as JSON", pathParameters={@RestParameter(name="eventId", description="The event id", isRequired=true, type=RestParameter.Type.STRING), @RestParameter(name="id", description="The media id", isRequired=true, type=RestParameter.Type.STRING)}, responses={@RestResponse(description="Returns the media of a catalog from the given event and media id as JSON", responseCode=200), @RestResponse(description="No event or media with this identifier was found.", responseCode=404)})
    public Response getMedia(@PathParam(value="eventId") String eventId, @PathParam(value="id") String id) throws NotFoundException, SearchIndexException, IndexServiceException {
        MediaPackage mp = this.getMediaPackageByEventId(eventId);
        Track track = mp.getTrack(id);
        if (track == null) {
            return RestUtils.notFound((String)"Cannot find media with id '%s'.", (Object[])new Object[]{id});
        }
        return RestUtils.okJson((JValue)this.trackToJSON(track));
    }

    @GET
    @Path(value="{eventId}/asset/publication/publications.json")
    @Produces(value={"application/json"})
    @RestQuery(name="getPublicationList", description="Returns a list of publications from the given event as JSON", returnDescription="The list of publications from the given event as JSON", pathParameters={@RestParameter(name="eventId", description="The event id", isRequired=true, type=RestParameter.Type.STRING)}, responses={@RestResponse(description="Returns a list of publications from the given event as JSON", responseCode=200), @RestResponse(description="No event with this identifier was found.", responseCode=404)})
    public Response getPublicationList(@PathParam(value="eventId") String id) throws Exception {
        Opt optEvent = this.getIndexService().getEvent(id, this.getIndex());
        if (optEvent.isNone()) {
            return RestUtils.notFound((String)"Cannot find an event with id '%s'.", (Object[])new Object[]{id});
        }
        MediaPackage mp = this.getIndexService().getEventMediapackage((Event)optEvent.get());
        return RestUtils.okJson((JValue)com.entwinemedia.fn.data.json.Jsons.arr(this.getEventPublications(mp.getPublications())));
    }

    @GET
    @Path(value="{eventId}/asset/publication/{id}.json")
    @Produces(value={"application/json"})
    @RestQuery(name="getPublication", description="Returns the details of a publication from the given event and publication id as JSON", returnDescription="The details of a publication from the given event and publication id as JSON", pathParameters={@RestParameter(name="eventId", description="The event id", isRequired=true, type=RestParameter.Type.STRING), @RestParameter(name="id", description="The publication id", isRequired=true, type=RestParameter.Type.STRING)}, responses={@RestResponse(description="Returns the publication of a catalog from the given event and publication id as JSON", responseCode=200), @RestResponse(description="No event or publication with this identifier was found.", responseCode=404)})
    public Response getPublication(@PathParam(value="eventId") String eventId, @PathParam(value="id") String id) throws NotFoundException, SearchIndexException, IndexServiceException {
        MediaPackage mp = this.getMediaPackageByEventId(eventId);
        Publication publication = null;
        for (Publication p : mp.getPublications()) {
            if (!id.equals(p.getIdentifier())) continue;
            publication = p;
            break;
        }
        if (publication == null) {
            return RestUtils.notFound((String)"Cannot find publication with id '%s'.", (Object[])new Object[]{id});
        }
        return RestUtils.okJson((JValue)this.publicationToJSON(publication));
    }

    @GET
    @Path(value="{eventId}/tobira/pages")
    @RestQuery(name="getEventHostPages", description="Returns the pages of a connected Tobira instance that contain the given event", returnDescription="The Tobira pages that contain the given event", pathParameters={@RestParameter(name="eventId", isRequired=true, description="The event identifier", type=RestParameter.Type.STRING)}, responses={@RestResponse(responseCode=200, description="The Tobira pages containing the given event"), @RestResponse(responseCode=404, description="Tobira doesn't know about the given event"), @RestResponse(responseCode=503, description="Tobira is not configured (correctly)")})
    public Response getEventHostPages(@PathParam(value="eventId") String eventId) {
        TobiraService tobira = TobiraService.getTobira(this.getSecurityService().getOrganization().getId());
        if (!tobira.ready()) {
            return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).entity((Object)"Tobira is not configured (correctly)").build();
        }
        try {
            org.json.simple.JSONObject eventData = tobira.getEventHostPages(eventId);
            if (eventData == null) {
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            eventData.put((Object)"baseURL", (Object)tobira.getOrigin());
            return Response.ok((Object)eventData.toJSONString()).build();
        }
        catch (TobiraException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Path(value="{eventId}/workflows.json")
    @Produces(value={"application/json"})
    @RestQuery(name="geteventworkflows", description="Returns all the data related to the workflows tab in the event details modal as JSON", returnDescription="All the data related to the event workflows tab as JSON", pathParameters={@RestParameter(name="eventId", description="The event id", isRequired=true, type=RestParameter.Type.STRING)}, responses={@RestResponse(description="Returns all the data related to the event workflows tab as JSON", responseCode=200), @RestResponse(description="No event with this identifier was found.", responseCode=404)})
    public Response getEventWorkflows(@PathParam(value="eventId") String id) throws UnauthorizedException, SearchIndexException, JobEndpointException {
        Opt optEvent = this.getIndexService().getEvent(id, this.getIndex());
        if (optEvent.isNone()) {
            return RestUtils.notFound((String)"Cannot find an event with id '%s'.", (Object[])new Object[]{id});
        }
        try {
            if (((Event)optEvent.get()).getEventStatus().equals("EVENTS.EVENTS.STATUS.SCHEDULED")) {
                ArrayList<Field> fields = new ArrayList<Field>();
                Map workflowConfig = this.getSchedulerService().getWorkflowConfig(id);
                for (Map.Entry entry : workflowConfig.entrySet()) {
                    fields.add(com.entwinemedia.fn.data.json.Jsons.f((String)((String)entry.getKey()), (JValue)com.entwinemedia.fn.data.json.Jsons.v(entry.getValue(), (JValue)com.entwinemedia.fn.data.json.Jsons.BLANK)));
                }
                Map agentConfiguration = this.getSchedulerService().getCaptureAgentConfiguration(id);
                return RestUtils.okJson((JValue)com.entwinemedia.fn.data.json.Jsons.obj((Field[])new Field[]{com.entwinemedia.fn.data.json.Jsons.f((String)"workflowId", (JValue)com.entwinemedia.fn.data.json.Jsons.v(agentConfiguration.get("org.opencastproject.workflow.definition"), (JValue)com.entwinemedia.fn.data.json.Jsons.BLANK)), com.entwinemedia.fn.data.json.Jsons.f((String)"configuration", (JValue)com.entwinemedia.fn.data.json.Jsons.obj(fields))}));
            }
            List workflowInstances = this.getWorkflowService().getWorkflowInstancesByMediaPackage(id);
            ArrayList<JObject> jsonList = new ArrayList<JObject>();
            for (WorkflowInstance instance : workflowInstances) {
                long instanceId = instance.getId();
                Date created = instance.getDateCreated();
                String submitter = instance.getCreatorName();
                User user = submitter == null ? null : this.getUserDirectoryService().loadUser(submitter);
                String submitterName = null;
                String submitterEmail = null;
                if (user != null) {
                    submitterName = user.getName();
                    submitterEmail = user.getEmail();
                }
                jsonList.add(com.entwinemedia.fn.data.json.Jsons.obj((Field[])new Field[]{com.entwinemedia.fn.data.json.Jsons.f((String)"id", (JValue)com.entwinemedia.fn.data.json.Jsons.v((Number)instanceId)), com.entwinemedia.fn.data.json.Jsons.f((String)"title", (JValue)com.entwinemedia.fn.data.json.Jsons.v((Object)instance.getTitle(), (JValue)com.entwinemedia.fn.data.json.Jsons.BLANK)), com.entwinemedia.fn.data.json.Jsons.f((String)"status", (JValue)com.entwinemedia.fn.data.json.Jsons.v((String)(WORKFLOW_STATUS_TRANSLATION_PREFIX + instance.getState().toString()))), com.entwinemedia.fn.data.json.Jsons.f((String)"submitted", (JValue)com.entwinemedia.fn.data.json.Jsons.v((Object)(created != null ? DateTimeSupport.toUTC((long)created.getTime()) : ""), (JValue)com.entwinemedia.fn.data.json.Jsons.BLANK)), com.entwinemedia.fn.data.json.Jsons.f((String)"submitter", (JValue)com.entwinemedia.fn.data.json.Jsons.v((Object)submitter, (JValue)com.entwinemedia.fn.data.json.Jsons.BLANK)), com.entwinemedia.fn.data.json.Jsons.f((String)"submitterName", (JValue)com.entwinemedia.fn.data.json.Jsons.v((Object)submitterName, (JValue)com.entwinemedia.fn.data.json.Jsons.BLANK)), com.entwinemedia.fn.data.json.Jsons.f((String)"submitterEmail", (JValue)com.entwinemedia.fn.data.json.Jsons.v((Object)submitterEmail, (JValue)com.entwinemedia.fn.data.json.Jsons.BLANK))}));
            }
            JObject json = com.entwinemedia.fn.data.json.Jsons.obj((Field[])new Field[]{com.entwinemedia.fn.data.json.Jsons.f((String)"results", (JValue)com.entwinemedia.fn.data.json.Jsons.arr(jsonList)), com.entwinemedia.fn.data.json.Jsons.f((String)"count", (JValue)com.entwinemedia.fn.data.json.Jsons.v((Number)workflowInstances.size()))});
            return RestUtils.okJson((JValue)json);
        }
        catch (NotFoundException e) {
            return RestUtils.notFound((String)"Cannot find workflows for event %s", (Object[])new Object[]{id});
        }
        catch (SchedulerException e) {
            logger.error("Unable to get workflow data for event with id {}", (Object)id);
            throw new WebApplicationException((Throwable)e, 500);
        }
        catch (WorkflowDatabaseException e) {
            throw new JobEndpointException(String.format("Not able to get the list of job from the database: %s", new Object[]{e}), e.getCause());
        }
    }

    @PUT
    @Path(value="{eventId}/workflows")
    @RestQuery(name="updateEventWorkflow", description="Update the workflow configuration for the scheduled event with the given id", pathParameters={@RestParameter(name="eventId", description="The event id", isRequired=true, type=RestParameter.Type.STRING)}, restParameters={@RestParameter(name="configuration", isRequired=true, description="The workflow configuration as JSON", type=RestParameter.Type.TEXT)}, responses={@RestResponse(description="Request executed succesfully", responseCode=204), @RestResponse(description="No event with this identifier was found.", responseCode=404)}, returnDescription="The method does not retrun any content.")
    public Response updateEventWorkflow(@PathParam(value="eventId") String id, @FormParam(value="configuration") String configuration) throws SearchIndexException, UnauthorizedException {
        Opt optEvent = this.getIndexService().getEvent(id, this.getIndex());
        if (optEvent.isNone()) {
            return RestUtils.notFound((String)"Cannot find an event with id '%s'.", (Object[])new Object[]{id});
        }
        if (((Event)optEvent.get()).isScheduledEvent() && !((Event)optEvent.get()).hasRecordingStarted()) {
            try {
                org.json.simple.JSONObject configJSON;
                try {
                    configJSON = (org.json.simple.JSONObject)new JSONParser().parse(configuration);
                }
                catch (Exception e) {
                    logger.warn("Unable to parse the workflow configuration {}", (Object)configuration);
                    return RestUtil.R.badRequest();
                }
                Optional<Object> caMetadataOpt = Optional.empty();
                Optional<Object> workflowConfigOpt = Optional.empty();
                String workflowId = (String)configJSON.get((Object)"id");
                HashMap<String, String> caMetadata = new HashMap<String, String>(this.getSchedulerService().getCaptureAgentConfiguration(id));
                if (!workflowId.equals(caMetadata.get("org.opencastproject.workflow.definition"))) {
                    caMetadata.put("org.opencastproject.workflow.definition", workflowId);
                    caMetadataOpt = Optional.of(caMetadata);
                }
                HashMap workflowConfig = new HashMap((org.json.simple.JSONObject)configJSON.get((Object)"configuration"));
                HashMap oldWorkflowConfig = new HashMap(this.getSchedulerService().getWorkflowConfig(id));
                if (!oldWorkflowConfig.equals(workflowConfig)) {
                    workflowConfigOpt = Optional.of(workflowConfig);
                }
                if (caMetadataOpt.isEmpty() && workflowConfigOpt.isEmpty()) {
                    return Response.noContent().build();
                }
                this.checkAgentAccessForAgent(((Event)optEvent.get()).getAgentId());
                this.getSchedulerService().updateEvent(id, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), workflowConfigOpt, caMetadataOpt);
                return Response.noContent().build();
            }
            catch (NotFoundException e) {
                return RestUtils.notFound((String)"Cannot find event %s in scheduler service", (Object[])new Object[]{id});
            }
            catch (SchedulerException e) {
                logger.error("Unable to update scheduling workflow data for event with id {}", (Object)id);
                throw new WebApplicationException((Throwable)e, 500);
            }
        }
        return RestUtil.R.badRequest((String)String.format("Event %s workflow can not be updated as the recording already started.", id));
    }

    @GET
    @Path(value="{eventId}/workflows/{workflowId}")
    @Produces(value={"application/json"})
    @RestQuery(name="geteventworkflow", description="Returns all the data related to the single workflow tab in the event details modal as JSON", returnDescription="All the data related to the event singe workflow tab as JSON", pathParameters={@RestParameter(name="eventId", description="The event id", isRequired=true, type=RestParameter.Type.STRING), @RestParameter(name="workflowId", description="The workflow id", isRequired=true, type=RestParameter.Type.STRING)}, responses={@RestResponse(description="Returns all the data related to the event single workflow tab as JSON", responseCode=200), @RestResponse(description="Unable to parse workflowId", responseCode=400), @RestResponse(description="No event with this identifier was found.", responseCode=404)})
    public Response getEventWorkflow(@PathParam(value="eventId") String eventId, @PathParam(value="workflowId") String workflowId) throws SearchIndexException {
        long workflowInstanceId;
        Opt optEvent = this.getIndexService().getEvent(eventId, this.getIndex());
        if (optEvent.isNone()) {
            return RestUtils.notFound((String)"Cannot find an event with id '%s'.", (Object[])new Object[]{eventId});
        }
        try {
            workflowId = StringUtils.remove((String)workflowId, (String)".json");
            workflowInstanceId = Long.parseLong(workflowId);
        }
        catch (Exception e2) {
            logger.warn("Unable to parse workflow id {}", (Object)workflowId);
            return RestUtil.R.badRequest();
        }
        try {
            WorkflowInstance instance = this.getWorkflowService().getWorkflowById(workflowInstanceId);
            Date created = instance.getDateCreated();
            Date completed = instance.getDateCompleted();
            if (completed == null) {
                completed = new Date();
            }
            long executionTime = completed.getTime() - created.getTime();
            List fields = instance.getConfigurations().entrySet().stream().map(e -> com.entwinemedia.fn.data.json.Jsons.f((String)((String)e.getKey()), (JValue)com.entwinemedia.fn.data.json.Jsons.v(e.getValue(), (JValue)com.entwinemedia.fn.data.json.Jsons.BLANK))).collect(Collectors.toList());
            return RestUtils.okJson((JValue)com.entwinemedia.fn.data.json.Jsons.obj((Field[])new Field[]{com.entwinemedia.fn.data.json.Jsons.f((String)"status", (JValue)com.entwinemedia.fn.data.json.Jsons.v((Object)(WORKFLOW_STATUS_TRANSLATION_PREFIX + String.valueOf(instance.getState())), (JValue)com.entwinemedia.fn.data.json.Jsons.BLANK)), com.entwinemedia.fn.data.json.Jsons.f((String)"description", (JValue)com.entwinemedia.fn.data.json.Jsons.v((Object)instance.getDescription(), (JValue)com.entwinemedia.fn.data.json.Jsons.BLANK)), com.entwinemedia.fn.data.json.Jsons.f((String)"executionTime", (JValue)com.entwinemedia.fn.data.json.Jsons.v((Object)executionTime, (JValue)com.entwinemedia.fn.data.json.Jsons.BLANK)), com.entwinemedia.fn.data.json.Jsons.f((String)"wiid", (JValue)com.entwinemedia.fn.data.json.Jsons.v((Object)instance.getId(), (JValue)com.entwinemedia.fn.data.json.Jsons.BLANK)), com.entwinemedia.fn.data.json.Jsons.f((String)"title", (JValue)com.entwinemedia.fn.data.json.Jsons.v((Object)instance.getTitle(), (JValue)com.entwinemedia.fn.data.json.Jsons.BLANK)), com.entwinemedia.fn.data.json.Jsons.f((String)"wdid", (JValue)com.entwinemedia.fn.data.json.Jsons.v((Object)instance.getTemplate(), (JValue)com.entwinemedia.fn.data.json.Jsons.BLANK)), com.entwinemedia.fn.data.json.Jsons.f((String)"configuration", (JValue)com.entwinemedia.fn.data.json.Jsons.obj(fields)), com.entwinemedia.fn.data.json.Jsons.f((String)"submittedAt", (JValue)com.entwinemedia.fn.data.json.Jsons.v((Object)DateTimeSupport.toUTC((long)created.getTime()), (JValue)com.entwinemedia.fn.data.json.Jsons.BLANK)), com.entwinemedia.fn.data.json.Jsons.f((String)"creator", (JValue)com.entwinemedia.fn.data.json.Jsons.v((Object)instance.getCreatorName(), (JValue)com.entwinemedia.fn.data.json.Jsons.BLANK))}));
        }
        catch (NotFoundException e3) {
            return RestUtils.notFound((String)"Cannot find workflow  %s", (Object[])new Object[]{workflowId});
        }
        catch (WorkflowDatabaseException e4) {
            logger.error("Unable to get workflow {} of event {}", new Object[]{workflowId, eventId, e4});
            return RestUtil.R.serverError();
        }
        catch (UnauthorizedException e5) {
            return RestUtil.R.forbidden();
        }
    }

    @GET
    @Path(value="{eventId}/workflows/{workflowId}/operations.json")
    @Produces(value={"application/json"})
    @RestQuery(name="geteventoperations", description="Returns all the data related to the workflow/operations tab in the event details modal as JSON", returnDescription="All the data related to the event workflow/opertations tab as JSON", pathParameters={@RestParameter(name="eventId", description="The event id", isRequired=true, type=RestParameter.Type.STRING), @RestParameter(name="workflowId", description="The workflow id", isRequired=true, type=RestParameter.Type.STRING)}, responses={@RestResponse(description="Returns all the data related to the event workflow/operations tab as JSON", responseCode=200), @RestResponse(description="Unable to parse workflowId", responseCode=400), @RestResponse(description="No event with this identifier was found.", responseCode=404)})
    public Response getEventOperations(@PathParam(value="eventId") String eventId, @PathParam(value="workflowId") String workflowId) throws SearchIndexException {
        long workflowInstanceId;
        Opt optEvent = this.getIndexService().getEvent(eventId, this.getIndex());
        if (optEvent.isNone()) {
            return RestUtils.notFound((String)"Cannot find an event with id '%s'.", (Object[])new Object[]{eventId});
        }
        try {
            workflowInstanceId = Long.parseLong(workflowId);
        }
        catch (Exception e) {
            logger.warn("Unable to parse workflow id {}", (Object)workflowId);
            return RestUtil.R.badRequest();
        }
        try {
            WorkflowInstance instance = this.getWorkflowService().getWorkflowById(workflowInstanceId);
            List operations = instance.getOperations();
            ArrayList<JObject> operationsJSON = new ArrayList<JObject>();
            for (WorkflowOperationInstance wflOp : operations) {
                ArrayList<Field> fields = new ArrayList<Field>();
                for (String key : wflOp.getConfigurationKeys()) {
                    fields.add(com.entwinemedia.fn.data.json.Jsons.f((String)key, (JValue)com.entwinemedia.fn.data.json.Jsons.v((Object)wflOp.getConfiguration(key), (JValue)com.entwinemedia.fn.data.json.Jsons.BLANK)));
                }
                operationsJSON.add(com.entwinemedia.fn.data.json.Jsons.obj((Field[])new Field[]{com.entwinemedia.fn.data.json.Jsons.f((String)"status", (JValue)com.entwinemedia.fn.data.json.Jsons.v((Object)(WORKFLOW_STATUS_TRANSLATION_PREFIX + String.valueOf(wflOp.getState())), (JValue)com.entwinemedia.fn.data.json.Jsons.BLANK)), com.entwinemedia.fn.data.json.Jsons.f((String)"title", (JValue)com.entwinemedia.fn.data.json.Jsons.v((Object)wflOp.getTemplate(), (JValue)com.entwinemedia.fn.data.json.Jsons.BLANK)), com.entwinemedia.fn.data.json.Jsons.f((String)"description", (JValue)com.entwinemedia.fn.data.json.Jsons.v((Object)wflOp.getDescription(), (JValue)com.entwinemedia.fn.data.json.Jsons.BLANK)), com.entwinemedia.fn.data.json.Jsons.f((String)"id", (JValue)com.entwinemedia.fn.data.json.Jsons.v((Object)wflOp.getId(), (JValue)com.entwinemedia.fn.data.json.Jsons.BLANK)), com.entwinemedia.fn.data.json.Jsons.f((String)"configuration", (JValue)com.entwinemedia.fn.data.json.Jsons.obj(fields))}));
            }
            return RestUtils.okJson((JValue)com.entwinemedia.fn.data.json.Jsons.arr(operationsJSON));
        }
        catch (NotFoundException e) {
            return RestUtils.notFound((String)"Cannot find workflow %s", (Object[])new Object[]{workflowId});
        }
        catch (WorkflowDatabaseException e) {
            logger.error("Unable to get workflow operations of event {} and workflow {}", new Object[]{eventId, workflowId, e});
            return RestUtil.R.serverError();
        }
        catch (UnauthorizedException e) {
            return RestUtil.R.forbidden();
        }
    }

    @GET
    @Path(value="{eventId}/workflows/{workflowId}/operations/{operationPosition}")
    @Produces(value={"application/json"})
    @RestQuery(name="geteventoperation", description="Returns all the data related to the workflow/operation tab in the event details modal as JSON", returnDescription="All the data related to the event workflow/opertation tab as JSON", pathParameters={@RestParameter(name="eventId", description="The event id", isRequired=true, type=RestParameter.Type.STRING), @RestParameter(name="workflowId", description="The workflow id", isRequired=true, type=RestParameter.Type.STRING), @RestParameter(name="operationPosition", description="The operation position", isRequired=true, type=RestParameter.Type.INTEGER)}, responses={@RestResponse(description="Returns all the data related to the event workflow/operation tab as JSON", responseCode=200), @RestResponse(description="Unable to parse workflowId or operationPosition", responseCode=400), @RestResponse(description="No operation with these identifiers was found.", responseCode=404)})
    public Response getEventOperation(@PathParam(value="eventId") String eventId, @PathParam(value="workflowId") String workflowId, @PathParam(value="operationPosition") Integer operationPosition) throws SearchIndexException {
        WorkflowInstance instance;
        long workflowInstanceId;
        Opt optEvent = this.getIndexService().getEvent(eventId, this.getIndex());
        if (optEvent.isNone()) {
            return RestUtils.notFound((String)"Cannot find an event with id '%s'.", (Object[])new Object[]{eventId});
        }
        try {
            workflowInstanceId = Long.parseLong(workflowId);
        }
        catch (Exception e) {
            logger.warn("Unable to parse workflow id {}", (Object)workflowId);
            return RestUtil.R.badRequest();
        }
        try {
            instance = this.getWorkflowService().getWorkflowById(workflowInstanceId);
        }
        catch (NotFoundException e) {
            return RestUtils.notFound((String)"Cannot find workflow %s", (Object[])new Object[]{workflowId});
        }
        catch (WorkflowDatabaseException e) {
            logger.error("Unable to get workflow operation of event {} and workflow {} at position {}", new Object[]{eventId, workflowId, operationPosition, e});
            return RestUtil.R.serverError();
        }
        catch (UnauthorizedException e) {
            return RestUtil.R.forbidden();
        }
        List operations = instance.getOperations();
        if (operations.size() > operationPosition) {
            WorkflowOperationInstance wflOp = (WorkflowOperationInstance)operations.get(operationPosition);
            return RestUtils.okJson((JValue)com.entwinemedia.fn.data.json.Jsons.obj((Field[])new Field[]{com.entwinemedia.fn.data.json.Jsons.f((String)"retry_strategy", (JValue)com.entwinemedia.fn.data.json.Jsons.v((Object)wflOp.getRetryStrategy(), (JValue)com.entwinemedia.fn.data.json.Jsons.BLANK)), com.entwinemedia.fn.data.json.Jsons.f((String)"execution_host", (JValue)com.entwinemedia.fn.data.json.Jsons.v((Object)wflOp.getExecutionHost(), (JValue)com.entwinemedia.fn.data.json.Jsons.BLANK)), com.entwinemedia.fn.data.json.Jsons.f((String)"failed_attempts", (JValue)com.entwinemedia.fn.data.json.Jsons.v((Number)wflOp.getFailedAttempts())), com.entwinemedia.fn.data.json.Jsons.f((String)"max_attempts", (JValue)com.entwinemedia.fn.data.json.Jsons.v((Number)wflOp.getMaxAttempts())), com.entwinemedia.fn.data.json.Jsons.f((String)"exception_handler_workflow", (JValue)com.entwinemedia.fn.data.json.Jsons.v((Object)wflOp.getExceptionHandlingWorkflow(), (JValue)com.entwinemedia.fn.data.json.Jsons.BLANK)), com.entwinemedia.fn.data.json.Jsons.f((String)"fail_on_error", (JValue)com.entwinemedia.fn.data.json.Jsons.v((Boolean)wflOp.isFailOnError())), com.entwinemedia.fn.data.json.Jsons.f((String)"description", (JValue)com.entwinemedia.fn.data.json.Jsons.v((Object)wflOp.getDescription(), (JValue)com.entwinemedia.fn.data.json.Jsons.BLANK)), com.entwinemedia.fn.data.json.Jsons.f((String)"state", (JValue)com.entwinemedia.fn.data.json.Jsons.v((Object)(WORKFLOW_STATUS_TRANSLATION_PREFIX + String.valueOf(wflOp.getState())), (JValue)com.entwinemedia.fn.data.json.Jsons.BLANK)), com.entwinemedia.fn.data.json.Jsons.f((String)"job", (JValue)com.entwinemedia.fn.data.json.Jsons.v((Object)wflOp.getId(), (JValue)com.entwinemedia.fn.data.json.Jsons.BLANK)), com.entwinemedia.fn.data.json.Jsons.f((String)"name", (JValue)com.entwinemedia.fn.data.json.Jsons.v((Object)wflOp.getTemplate(), (JValue)com.entwinemedia.fn.data.json.Jsons.BLANK)), com.entwinemedia.fn.data.json.Jsons.f((String)"time_in_queue", (JValue)com.entwinemedia.fn.data.json.Jsons.v((Object)wflOp.getTimeInQueue(), (JValue)com.entwinemedia.fn.data.json.Jsons.v((Number)0))), com.entwinemedia.fn.data.json.Jsons.f((String)"started", (JValue)(wflOp.getDateStarted() != null ? com.entwinemedia.fn.data.json.Jsons.v((String)DateTimeSupport.toUTC((long)wflOp.getDateStarted().getTime())) : com.entwinemedia.fn.data.json.Jsons.BLANK)), com.entwinemedia.fn.data.json.Jsons.f((String)"completed", (JValue)(wflOp.getDateCompleted() != null ? com.entwinemedia.fn.data.json.Jsons.v((String)DateTimeSupport.toUTC((long)wflOp.getDateCompleted().getTime())) : com.entwinemedia.fn.data.json.Jsons.BLANK))}));
        }
        return RestUtils.notFound((String)"Cannot find workflow operation of workflow %s at position %s", (Object[])new Object[]{workflowId, operationPosition});
    }

    @GET
    @Path(value="{eventId}/workflows/{workflowId}/errors.json")
    @Produces(value={"application/json"})
    @RestQuery(name="geteventerrors", description="Returns all the data related to the workflow/errors tab in the event details modal as JSON", returnDescription="All the data related to the event workflow/errors tab as JSON", pathParameters={@RestParameter(name="eventId", description="The event id", isRequired=true, type=RestParameter.Type.STRING), @RestParameter(name="workflowId", description="The workflow id", isRequired=true, type=RestParameter.Type.STRING)}, responses={@RestResponse(description="Returns all the data related to the event workflow/errors tab as JSON", responseCode=200), @RestResponse(description="Unable to parse workflowId", responseCode=400), @RestResponse(description="No event with this identifier was found.", responseCode=404)})
    public Response getEventErrors(@PathParam(value="eventId") String eventId, @PathParam(value="workflowId") String workflowId, @Context HttpServletRequest req) throws JobEndpointException, SearchIndexException {
        Iterator iterator = this.getIndexService().getEvent(eventId, this.getIndex()).iterator();
        if (iterator.hasNext()) {
            long workflowIdLong;
            Event ignore = (Event)iterator.next();
            try {
                workflowIdLong = Long.parseLong(workflowId);
            }
            catch (Exception e) {
                logger.warn("Unable to parse workflow id {}", (Object)workflowId);
                return RestUtil.R.badRequest();
            }
            try {
                return RestUtils.okJson((JValue)this.getJobService().getIncidentsAsJSON(workflowIdLong, req.getLocale(), true));
            }
            catch (NotFoundException e) {
                return RestUtils.notFound((String)"Cannot find the incident for the workflow %s", (Object[])new Object[]{workflowId});
            }
        }
        return RestUtils.notFound((String)"Cannot find an event with id '%s'.", (Object[])new Object[]{eventId});
    }

    @GET
    @Path(value="{eventId}/workflows/{workflowId}/errors/{errorId}.json")
    @Produces(value={"application/json"})
    @RestQuery(name="geteventerror", description="Returns all the data related to the workflow/error tab in the event details modal as JSON", returnDescription="All the data related to the event workflow/error tab as JSON", pathParameters={@RestParameter(name="eventId", description="The event id", isRequired=true, type=RestParameter.Type.STRING), @RestParameter(name="workflowId", description="The workflow id", isRequired=true, type=RestParameter.Type.STRING), @RestParameter(name="errorId", description="The error id", isRequired=true, type=RestParameter.Type.STRING)}, responses={@RestResponse(description="Returns all the data related to the event workflow/error tab as JSON", responseCode=200), @RestResponse(description="Unable to parse workflowId", responseCode=400), @RestResponse(description="No event with this identifier was found.", responseCode=404)})
    public Response getEventError(@PathParam(value="eventId") String eventId, @PathParam(value="workflowId") String workflowId, @PathParam(value="errorId") String errorId, @Context HttpServletRequest req) throws JobEndpointException, SearchIndexException {
        Iterator iterator = this.getIndexService().getEvent(eventId, this.getIndex()).iterator();
        if (iterator.hasNext()) {
            long errorIdLong;
            Event ignore = (Event)iterator.next();
            try {
                errorIdLong = Long.parseLong(errorId);
            }
            catch (Exception e) {
                logger.warn("Unable to parse error id {}", (Object)errorId);
                return RestUtil.R.badRequest();
            }
            try {
                return RestUtils.okJson((JValue)this.getJobService().getIncidentAsJSON(errorIdLong, req.getLocale()));
            }
            catch (NotFoundException e) {
                return RestUtils.notFound((String)"Cannot find the incident %s", (Object[])new Object[]{errorId});
            }
        }
        return RestUtils.notFound((String)"Cannot find an event with id '%s'.", (Object[])new Object[]{eventId});
    }

    @GET
    @Path(value="{eventId}/access.json")
    @Produces(value={"application/json"})
    @RestQuery(name="getEventAccessInformation", description="Get the access information of an event", returnDescription="The access information", pathParameters={@RestParameter(name="eventId", isRequired=true, description="The event identifier", type=RestParameter.Type.STRING)}, responses={@RestResponse(responseCode=400, description="The required form params were missing in the request."), @RestResponse(responseCode=404, description="If the event has not been found."), @RestResponse(responseCode=200, description="The access information ")})
    public Response getEventAccessInformation(@PathParam(value="eventId") String eventId) throws Exception {
        Opt optEvent = this.getIndexService().getEvent(eventId, this.getIndex());
        if (optEvent.isNone()) {
            return RestUtils.notFound((String)"Cannot find an event with id '%s'.", (Object[])new Object[]{eventId});
        }
        JSONArray systemAclsJson = new JSONArray();
        List acls = this.getAclService().getAcls();
        for (ManagedAcl acl : acls) {
            systemAclsJson.add((Object)AccessInformationUtil.serializeManagedAcl((ManagedAcl)acl));
        }
        AccessControlList activeAcl = new AccessControlList();
        try {
            if (((Event)optEvent.get()).getAccessPolicy() != null) {
                activeAcl = AccessControlParser.parseAcl((String)((Event)optEvent.get()).getAccessPolicy());
            }
        }
        catch (Exception e) {
            logger.error("Unable to parse access policy", (Throwable)e);
        }
        Option currentAcl = AccessInformationUtil.matchAclsLenient((List)acls, (AccessControlList)activeAcl, this.getAdminUIConfiguration().getMatchManagedAclRolePrefixes());
        org.json.simple.JSONObject episodeAccessJson = new org.json.simple.JSONObject();
        episodeAccessJson.put((Object)"current_acl", (Object)(currentAcl.isSome() ? ((ManagedAcl)currentAcl.get()).getId() : 0L));
        episodeAccessJson.put((Object)"acl", (Object)EndpointUtil.transformAccessControList(activeAcl, this.getUserDirectoryService()));
        episodeAccessJson.put((Object)"privileges", (Object)AccessInformationUtil.serializePrivilegesByRole((AccessControlList)activeAcl));
        if (StringUtils.isNotBlank((CharSequence)((Event)optEvent.get()).getWorkflowState()) && WorkflowUtil.isActive((WorkflowInstance.WorkflowState)WorkflowInstance.WorkflowState.valueOf((String)((Event)optEvent.get()).getWorkflowState()))) {
            episodeAccessJson.put((Object)"locked", (Object)true);
        }
        org.json.simple.JSONObject jsonReturnObj = new org.json.simple.JSONObject();
        jsonReturnObj.put((Object)"episode_access", (Object)episodeAccessJson);
        jsonReturnObj.put((Object)"system_acls", (Object)systemAclsJson);
        return Response.ok((Object)jsonReturnObj.toString()).build();
    }

    @POST
    @Path(value="{eventId}/assets")
    @Consumes(value={"multipart/form-data"})
    @RestQuery(name="updateAssets", description="Update or create an asset for the eventId by the given metadata as JSON and files in the body", pathParameters={@RestParameter(name="eventId", description="The event id", isRequired=true, type=RestParameter.Type.STRING)}, restParameters={@RestParameter(name="metadata", isRequired=true, type=RestParameter.Type.TEXT, description="The list of asset metadata")}, responses={@RestResponse(description="The asset has been added.", responseCode=200), @RestResponse(description="Could not add asset, problem with the metadata or files.", responseCode=400), @RestResponse(description="No event with this identifier was found.", responseCode=404)}, returnDescription="The workflow identifier")
    public Response updateAssets(@PathParam(value="eventId") String eventId, @Context HttpServletRequest request) throws Exception {
        try {
            MediaPackage mp = this.getMediaPackageByEventId(eventId);
            String result = this.getIndexService().updateEventAssets(mp, request);
            return Response.status((Response.Status)Response.Status.CREATED).entity((Object)result).build();
        }
        catch (NotFoundException e) {
            return RestUtils.notFound((String)"Cannot find an event with id '%s'.", (Object[])new Object[]{eventId});
        }
        catch (IllegalArgumentException | UnsupportedAssetException e) {
            return RestUtil.R.badRequest((String)e.getMessage());
        }
        catch (Exception e) {
            return RestUtil.R.serverError();
        }
    }

    @GET
    @Path(value="new/metadata")
    @RestQuery(name="getNewMetadata", description="Returns all the data related to the metadata tab in the new event modal as JSON", returnDescription="All the data related to the event metadata tab as JSON", responses={@RestResponse(responseCode=200, description="Returns all the data related to the event metadata tab as JSON")})
    public Response getNewMetadata() {
        MetadataList metadataList = new MetadataList();
        List extendedCatalogUIAdapters = this.getIndexService().getExtendedEventCatalogUIAdapters();
        for (EventCatalogUIAdapter extendedCatalogUIAdapter : extendedCatalogUIAdapters) {
            metadataList.add(extendedCatalogUIAdapter, extendedCatalogUIAdapter.getRawFields());
        }
        EventCatalogUIAdapter commonCatalogUiAdapter = this.getIndexService().getCommonEventCatalogUIAdapter();
        DublinCoreMetadataCollection commonMetadata = commonCatalogUiAdapter.getRawFields(this.getCollectionQueryDisable());
        if (commonMetadata.getOutputFields().containsKey(DublinCore.PROPERTY_CREATED.getLocalName())) {
            commonMetadata.removeField((MetadataField)commonMetadata.getOutputFields().get(DublinCore.PROPERTY_CREATED.getLocalName()));
        }
        if (commonMetadata.getOutputFields().containsKey("duration")) {
            commonMetadata.removeField((MetadataField)commonMetadata.getOutputFields().get("duration"));
        }
        if (commonMetadata.getOutputFields().containsKey(DublinCore.PROPERTY_IDENTIFIER.getLocalName())) {
            commonMetadata.removeField((MetadataField)commonMetadata.getOutputFields().get(DublinCore.PROPERTY_IDENTIFIER.getLocalName()));
        }
        if (commonMetadata.getOutputFields().containsKey(DublinCore.PROPERTY_SOURCE.getLocalName())) {
            commonMetadata.removeField((MetadataField)commonMetadata.getOutputFields().get(DublinCore.PROPERTY_SOURCE.getLocalName()));
        }
        if (commonMetadata.getOutputFields().containsKey("startDate")) {
            commonMetadata.removeField((MetadataField)commonMetadata.getOutputFields().get("startDate"));
        }
        if (commonMetadata.getOutputFields().containsKey("startTime")) {
            commonMetadata.removeField((MetadataField)commonMetadata.getOutputFields().get("startTime"));
        }
        if (commonMetadata.getOutputFields().containsKey("location")) {
            commonMetadata.removeField((MetadataField)commonMetadata.getOutputFields().get("location"));
        }
        if (commonMetadata.getOutputFields().containsKey(DublinCore.PROPERTY_PUBLISHER.getLocalName())) {
            String loggedInUser;
            MetadataField publisher = (MetadataField)commonMetadata.getOutputFields().get(DublinCore.PROPERTY_PUBLISHER.getLocalName());
            Map<String, String> users = new HashMap();
            if (publisher.getCollection() != null) {
                users = publisher.getCollection();
            }
            if (!users.containsKey(loggedInUser = this.getSecurityService().getUser().getName())) {
                users.put(loggedInUser, loggedInUser);
            }
            publisher.setValue((Object)loggedInUser);
        }
        metadataList.add(commonCatalogUiAdapter, commonMetadata);
        this.removeSeriesWithNullTitlesFromFieldCollection(metadataList);
        return RestUtils.okJson((JValue)MetadataJson.listToJson((MetadataList)metadataList, (boolean)true));
    }

    @GET
    @Path(value="new/processing")
    @RestQuery(name="getNewProcessing", description="Returns all the data related to the processing tab in the new event modal as JSON", returnDescription="All the data related to the event processing tab as JSON", restParameters={@RestParameter(name="tags", isRequired=false, description="A comma separated list of tags to filter the workflow definitions", type=RestParameter.Type.STRING)}, responses={@RestResponse(responseCode=200, description="Returns all the data related to the event processing tab as JSON")})
    public Response getNewProcessing(@QueryParam(value="tags") String tagsString) {
        List tags = RestUtil.splitCommaSeparatedParam((Option)Option.option((Object)tagsString)).value();
        ArrayList<JObject> workflows = new ArrayList<JObject>();
        try {
            List workflowsDefinitions = this.getWorkflowService().listAvailableWorkflowDefinitions();
            for (WorkflowDefinition wflDef : workflowsDefinitions) {
                if (!wflDef.containsTag((Collection)tags)) continue;
                workflows.add(com.entwinemedia.fn.data.json.Jsons.obj((Field[])new Field[]{com.entwinemedia.fn.data.json.Jsons.f((String)"id", (JValue)com.entwinemedia.fn.data.json.Jsons.v((String)wflDef.getId())), com.entwinemedia.fn.data.json.Jsons.f((String)"tags", (JValue)com.entwinemedia.fn.data.json.Jsons.arr((String[])wflDef.getTags())), com.entwinemedia.fn.data.json.Jsons.f((String)"title", (JValue)com.entwinemedia.fn.data.json.Jsons.v((String)((String)Opt.nul((Object)wflDef.getTitle()).getOr((Object)"")))), com.entwinemedia.fn.data.json.Jsons.f((String)"description", (JValue)com.entwinemedia.fn.data.json.Jsons.v((String)((String)Opt.nul((Object)wflDef.getDescription()).getOr((Object)"")))), com.entwinemedia.fn.data.json.Jsons.f((String)"displayOrder", (JValue)com.entwinemedia.fn.data.json.Jsons.v((Number)wflDef.getDisplayOrder())), com.entwinemedia.fn.data.json.Jsons.f((String)"configuration_panel", (JValue)com.entwinemedia.fn.data.json.Jsons.v((String)((String)Opt.nul((Object)wflDef.getConfigurationPanel()).getOr((Object)"")))), com.entwinemedia.fn.data.json.Jsons.f((String)"configuration_panel_json", (JValue)com.entwinemedia.fn.data.json.Jsons.v((String)((String)Opt.nul((Object)wflDef.getConfigurationPanelJson()).getOr((Object)""))))}));
            }
        }
        catch (WorkflowDatabaseException e) {
            logger.error("Unable to get available workflow definitions", (Throwable)e);
            return RestUtil.R.serverError();
        }
        JObject data = com.entwinemedia.fn.data.json.Jsons.obj((Field[])new Field[]{com.entwinemedia.fn.data.json.Jsons.f((String)"workflows", (JValue)com.entwinemedia.fn.data.json.Jsons.arr(workflows)), com.entwinemedia.fn.data.json.Jsons.f((String)"default_workflow_id", (JValue)com.entwinemedia.fn.data.json.Jsons.v((Object)this.defaultWorkflowDefinionId, (JValue)com.entwinemedia.fn.data.json.Jsons.NULL))});
        return RestUtils.okJson((JValue)data);
    }

    @POST
    @Path(value="new/conflicts")
    @RestQuery(name="checkNewConflicts", description="Checks if the current scheduler parameters are in a conflict with another event", returnDescription="Returns NO CONTENT if no event are in conflict within specified period or list of conflicting recordings in JSON", restParameters={@RestParameter(name="metadata", isRequired=true, description="The metadata as JSON", type=RestParameter.Type.TEXT)}, responses={@RestResponse(responseCode=204, description="No conflicting events found"), @RestResponse(responseCode=409, description="There is a conflict"), @RestResponse(responseCode=400, description="Missing or invalid parameters")})
    public Response getNewConflicts(@FormParam(value="metadata") String metadata) throws NotFoundException {
        Date end;
        Date start;
        String endDate;
        String startDate;
        String device;
        org.json.simple.JSONObject metadataJson;
        if (StringUtils.isBlank((CharSequence)metadata)) {
            logger.warn("Metadata is not specified");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        JSONParser parser = new JSONParser();
        try {
            metadataJson = (org.json.simple.JSONObject)parser.parse(metadata);
        }
        catch (Exception e) {
            logger.warn("Unable to parse metadata {}", (Object)metadata);
            return RestUtil.R.badRequest((String)"Unable to parse metadata");
        }
        try {
            device = (String)metadataJson.get((Object)"device");
            startDate = (String)metadataJson.get((Object)SCHEDULING_START_KEY);
            endDate = (String)metadataJson.get((Object)SCHEDULING_END_KEY);
        }
        catch (Exception e) {
            logger.warn("Unable to parse metadata {}", (Object)metadata);
            return RestUtil.R.badRequest((String)"Unable to parse metadata");
        }
        if (StringUtils.isBlank((CharSequence)device) || StringUtils.isBlank((CharSequence)startDate) || StringUtils.isBlank((CharSequence)endDate)) {
            logger.warn("Either device, start date or end date were not specified");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        try {
            start = new Date(DateTimeSupport.fromUTC((String)startDate));
        }
        catch (Exception e) {
            logger.warn("Unable to parse start date {}", (Object)startDate);
            return RestUtil.R.badRequest((String)"Unable to parse start date");
        }
        try {
            end = new Date(DateTimeSupport.fromUTC((String)endDate));
        }
        catch (Exception e) {
            logger.warn("Unable to parse end date {}", (Object)endDate);
            return RestUtil.R.badRequest((String)"Unable to parse end date");
        }
        String rruleString = (String)metadataJson.get((Object)"rrule");
        RRule rrule = null;
        TimeZone timeZone = TimeZone.getDefault();
        String durationString = null;
        if (StringUtils.isNotEmpty((CharSequence)rruleString)) {
            try {
                rrule = new RRule(rruleString);
                rrule.validate();
            }
            catch (Exception e) {
                logger.warn("Unable to parse rrule {}: {}", (Object)rruleString, (Object)e.getMessage());
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            durationString = (String)metadataJson.get((Object)"duration");
            if (StringUtils.isBlank((CharSequence)durationString)) {
                logger.warn("If checking recurrence, must include duration.");
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            Agent agent = this.getCaptureAgentStateService().getAgent(device);
            String timezone = agent.getConfiguration().getProperty("capture.device.timezone");
            if (StringUtils.isBlank((CharSequence)timezone)) {
                timezone = TimeZone.getDefault().getID();
                logger.warn("No 'capture.device.timezone' set on agent {}. The default server timezone {} will be used.", (Object)device, (Object)timezone);
            }
            timeZone = TimeZone.getTimeZone(timezone);
        }
        String eventId = (String)metadataJson.get((Object)"id");
        try {
            List<JValue> eventsJSON;
            List events = null;
            events = StringUtils.isNotEmpty((CharSequence)rruleString) ? this.getSchedulerService().findConflictingEvents(device, rrule, start, end, Long.parseLong(durationString), timeZone) : this.getSchedulerService().findConflictingEvents(device, start, end);
            if (!events.isEmpty() && !(eventsJSON = this.convertToConflictObjects(eventId, events)).isEmpty()) {
                return RestUtils.conflictJson((JValue)com.entwinemedia.fn.data.json.Jsons.arr(eventsJSON));
            }
            return Response.noContent().build();
        }
        catch (Exception e) {
            logger.error("Unable to find conflicting events for {}, {}, {}", new Object[]{device, startDate, endDate, e});
            return RestUtil.R.serverError();
        }
    }

    private List<JValue> convertToConflictObjects(String eventId, List<MediaPackage> events) throws SearchIndexException {
        ArrayList<JValue> eventsJSON = new ArrayList<JValue>();
        Organization organization = this.getSecurityService().getOrganization();
        User user = SecurityUtil.createSystemUser((String)this.systemUserName, (Organization)organization);
        SecurityUtil.runAs((SecurityService)this.getSecurityService(), (Organization)organization, (User)user, () -> {
            try {
                for (MediaPackage event : events) {
                    Opt eventOpt = this.getIndexService().getEvent(event.getIdentifier().toString(), this.getIndex());
                    if (eventOpt.isSome()) {
                        Event e = (Event)eventOpt.get();
                        if (StringUtils.isNotEmpty((CharSequence)eventId) && eventId.equals(e.getIdentifier())) continue;
                        eventsJSON.add(this.convertEventToConflictingObject(e.getTechnicalStartTime(), e.getTechnicalEndTime(), e.getTitle()));
                        continue;
                    }
                    logger.warn("Index out of sync! Conflicting event catalog {} not found on event index!", (Object)event.getIdentifier().toString());
                }
            }
            catch (Exception e) {
                logger.error("Failed to get conflicting events", (Throwable)e);
            }
        });
        return eventsJSON;
    }

    private JValue convertEventToConflictingObject(String start, String end, String title) {
        return com.entwinemedia.fn.data.json.Jsons.obj((Field[])new Field[]{com.entwinemedia.fn.data.json.Jsons.f((String)SCHEDULING_START_KEY, (JValue)com.entwinemedia.fn.data.json.Jsons.v((String)start)), com.entwinemedia.fn.data.json.Jsons.f((String)SCHEDULING_END_KEY, (JValue)com.entwinemedia.fn.data.json.Jsons.v((String)end)), com.entwinemedia.fn.data.json.Jsons.f((String)"title", (JValue)com.entwinemedia.fn.data.json.Jsons.v((String)title))});
    }

    @POST
    @Path(value="/new")
    @Consumes(value={"multipart/form-data"})
    @RestQuery(name="createNewEvent", description="Creates a new event by the given metadata as JSON and the files in the body", returnDescription="The workflow identifier", restParameters={@RestParameter(name="metadata", isRequired=true, description="The metadata as JSON", type=RestParameter.Type.TEXT)}, responses={@RestResponse(responseCode=201, description="Event sucessfully added"), @RestResponse(responseCode=400, description="If the metadata is not set or couldn't be parsed")})
    public Response createNewEvent(@Context HttpServletRequest request) {
        try {
            String result = this.getIndexService().createEvent(request);
            if (StringUtils.isEmpty((CharSequence)result)) {
                return RestUtil.R.badRequest((String)"The date range provided did not include any events");
            }
            return Response.status((Response.Status)Response.Status.CREATED).entity((Object)result).build();
        }
        catch (IllegalArgumentException | UnsupportedAssetException e) {
            return RestUtil.R.badRequest((String)e.getMessage());
        }
        catch (Exception e) {
            return RestUtil.R.serverError();
        }
    }

    @GET
    @Path(value="events.json")
    @Produces(value={"application/json"})
    @RestQuery(name="getevents", description="Returns all the events as JSON", returnDescription="All the events as JSON", restParameters={@RestParameter(name="filter", isRequired=false, description="The filter used for the query. They should be formated like that: 'filter1:value1,filter2:value2'", type=RestParameter.Type.STRING), @RestParameter(name="sort", description="The order instructions used to sort the query result. Must be in the form '<field name>:(ASC|DESC)'", isRequired=false, type=RestParameter.Type.STRING), @RestParameter(name="limit", description="The maximum number of items to return per page.", isRequired=false, type=RestParameter.Type.INTEGER), @RestParameter(name="offset", description="The page number.", isRequired=false, type=RestParameter.Type.INTEGER), @RestParameter(name="getComments", description="If comments should be fetched", isRequired=false, type=RestParameter.Type.BOOLEAN)}, responses={@RestResponse(description="Returns all events as JSON", responseCode=200)})
    public Response getEvents(@QueryParam(value="id") String id, @QueryParam(value="commentReason") String reasonFilter, @QueryParam(value="commentResolution") String resolutionFilter, @QueryParam(value="filter") String filter, @QueryParam(value="sort") String sort, @QueryParam(value="offset") Integer offset, @QueryParam(value="limit") Integer limit, @QueryParam(value="getComments") Boolean getComments) {
        Option optLimit = Option.option((Object)limit);
        Option optOffset = Option.option((Object)offset);
        Option optSort = Option.option((Object)StringUtils.trimToNull((String)sort));
        Option optGetComments = Option.option((Object)getComments);
        ArrayList<JValue> eventsList = new ArrayList<JValue>();
        Organization organization = this.getSecurityService().getOrganization();
        User user = this.getSecurityService().getUser();
        if (organization == null || user == null) {
            return Response.status((int)503).build();
        }
        EventSearchQuery query = new EventSearchQuery(organization.getId(), user);
        if (optLimit.isSome() && limit == 0) {
            optLimit = Option.none();
        }
        Map filters = RestUtils.parseFilter((String)filter);
        for (Object name : filters.keySet()) {
            if ("presentersBibliographic".equals(name)) {
                query.withPresenter((String)filters.get(name));
            }
            if ("presentersTechnical".equals(name)) {
                query.withTechnicalPresenters((String)filters.get(name));
            }
            if ("contributors".equals(name)) {
                query.withContributor((String)filters.get(name));
            }
            if ("location".equals(name)) {
                query.withLocation((String)filters.get(name));
            }
            if ("agent".equals(name)) {
                query.withAgentId((String)filters.get(name));
            }
            if ("textFilter".equals(name)) {
                query.withText((String)filters.get(name));
            }
            if ("series".equals(name)) {
                query.withSeriesId((String)filters.get(name));
            }
            if ("status".equals(name)) {
                query.withEventStatus((String)filters.get(name));
            }
            if ("publisher".equals(name)) {
                query.withPublisher((String)filters.get(name));
            }
            if ("comments".equals(name)) {
                switch (EventsListProvider.Comments.valueOf((String)((String)filters.get(name)))) {
                    case NONE: {
                        query.withComments(false);
                        break;
                    }
                    case OPEN: {
                        query.withOpenComments(true);
                        break;
                    }
                    case RESOLVED: {
                        query.withComments(true);
                        query.withOpenComments(false);
                        break;
                    }
                    default: {
                        logger.info("Unknown comment {}", filters.get(name));
                        return Response.status((int)400).build();
                    }
                }
            }
            if ("isPublished".equals(name)) {
                if (filters.containsKey(name)) {
                    switch (EventsListProvider.IsPublished.valueOf((String)((String)filters.get(name)))) {
                        case YES: {
                            query.withIsPublished(true);
                            break;
                        }
                        case NO: {
                            query.withIsPublished(false);
                            break;
                        }
                    }
                } else {
                    logger.info("Query for invalid published status: {}", filters.get(name));
                    return Response.status((int)400).build();
                }
            }
            if (!"startDate".equals(name)) continue;
            try {
                Tuple fromAndToCreationRange = RestUtils.getFromAndToDateRange((String)((String)filters.get(name)));
                query.withStartFrom((Date)fromAndToCreationRange.getA());
                query.withStartTo((Date)fromAndToCreationRange.getB());
            }
            catch (IllegalArgumentException e) {
                return RestUtil.R.badRequest((String)e.getMessage());
            }
        }
        if (optSort.isSome()) {
            ArrayList sortCriteria = RestUtils.parseSortQueryParameter((String)((String)optSort.get()));
            block44: for (SortCriterion criterion : sortCriteria) {
                switch (criterion.getFieldName()) {
                    case "uid": {
                        query.sortByUID(criterion.getOrder());
                        continue block44;
                    }
                    case "title": {
                        query.sortByTitle(criterion.getOrder());
                        continue block44;
                    }
                    case "presenter": {
                        query.sortByPresenter(criterion.getOrder());
                        continue block44;
                    }
                    case "technical_start": 
                    case "technical_date": {
                        query.sortByTechnicalStartDate(criterion.getOrder());
                        continue block44;
                    }
                    case "technical_end": {
                        query.sortByTechnicalEndDate(criterion.getOrder());
                        continue block44;
                    }
                    case "publication": {
                        query.sortByPublicationIgnoringInternal(criterion.getOrder());
                        continue block44;
                    }
                    case "start_date": 
                    case "date": {
                        query.sortByStartDate(criterion.getOrder());
                        continue block44;
                    }
                    case "end_date": {
                        query.sortByEndDate(criterion.getOrder());
                        continue block44;
                    }
                    case "series_name": {
                        query.sortBySeriesName(criterion.getOrder());
                        continue block44;
                    }
                    case "location": {
                        query.sortByLocation(criterion.getOrder());
                        continue block44;
                    }
                    case "event_status": {
                        query.sortByEventStatus(criterion.getOrder());
                        continue block44;
                    }
                }
                String msg = String.format("Unknown sort criteria field %s", criterion.getFieldName());
                logger.debug(msg);
                return RestUtil.R.badRequest((String)msg);
            }
        }
        if (this.getOnlyEventsWithWriteAccessEventsTab().booleanValue()) {
            query.withoutActions();
            query.withAction(Permissions.Action.WRITE);
            query.withAction(Permissions.Action.READ);
        }
        if (optLimit.isSome()) {
            query.withLimit(((Integer)optLimit.get()).intValue());
        }
        if (optOffset.isSome()) {
            query.withOffset(offset.intValue());
        }
        SearchResult results = null;
        try {
            results = this.getIndex().getByQuery(query);
        }
        catch (SearchIndexException e) {
            logger.error("The admin UI Search Index was not able to get the events list:", (Throwable)e);
            return RestUtil.R.serverError();
        }
        if (results.getPageSize() == 0L) {
            logger.debug("No events match the given filters.");
            return RestUtils.okJsonList(eventsList, (int)((Integer)Opt.nul((Object)offset).getOr((Object)0)), (int)((Integer)Opt.nul((Object)limit).getOr((Object)0)), (long)0L);
        }
        for (SearchResultItem item : results.getItems()) {
            Event source = (Event)item.getSource();
            source.updatePreview(this.getAdminUIConfiguration().getPreviewSubtype());
            List comments = null;
            if (optGetComments.isSome() && ((Boolean)optGetComments.get()).booleanValue()) {
                try {
                    comments = this.getEventCommentService().getComments(source.getIdentifier());
                }
                catch (EventCommentException e) {
                    logger.error("Unable to get comments from event {}", (Object)source.getIdentifier(), (Object)e);
                    throw new WebApplicationException((Throwable)e);
                }
            }
            eventsList.add(this.eventToJSON(source, Optional.ofNullable(comments)));
        }
        return RestUtils.okJsonList(eventsList, (int)((Integer)Opt.nul((Object)offset).getOr((Object)0)), (int)((Integer)Opt.nul((Object)limit).getOr((Object)0)), (long)results.getHitCount());
    }

    private MediaPackage getMediaPackageByEventId(String eventId) throws SearchIndexException, NotFoundException, IndexServiceException {
        Opt optEvent = this.getIndexService().getEvent(eventId, this.getIndex());
        if (optEvent.isNone()) {
            throw new NotFoundException(String.format("Cannot find an event with id '%s'.", eventId));
        }
        return this.getIndexService().getEventMediapackage((Event)optEvent.get());
    }

    private URI getCommentUrl(String eventId, long commentId) {
        return UrlSupport.uri((Object[])new Object[]{this.serverUrl, eventId, "comment", Long.toString(commentId)});
    }

    private JValue eventToJSON(Event event, Optional<List<EventComment>> comments) {
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.add(com.entwinemedia.fn.data.json.Jsons.f((String)"id", (JValue)com.entwinemedia.fn.data.json.Jsons.v((String)event.getIdentifier())));
        fields.add(com.entwinemedia.fn.data.json.Jsons.f((String)"title", (JValue)com.entwinemedia.fn.data.json.Jsons.v((Object)event.getTitle(), (JValue)com.entwinemedia.fn.data.json.Jsons.BLANK)));
        fields.add(com.entwinemedia.fn.data.json.Jsons.f((String)"source", (JValue)com.entwinemedia.fn.data.json.Jsons.v((Object)event.getSource(), (JValue)com.entwinemedia.fn.data.json.Jsons.BLANK)));
        fields.add(com.entwinemedia.fn.data.json.Jsons.f((String)"presenters", (JValue)com.entwinemedia.fn.data.json.Jsons.arr((Iterable)com.entwinemedia.fn.Stream.$((Iterable)event.getPresenters()).map(Jsons.Functions.stringToJValue))));
        if (StringUtils.isNotBlank((CharSequence)event.getSeriesId())) {
            String seriesTitle = event.getSeriesName();
            String seriesID = event.getSeriesId();
            fields.add(com.entwinemedia.fn.data.json.Jsons.f((String)"series", (JValue)com.entwinemedia.fn.data.json.Jsons.obj((Field[])new Field[]{com.entwinemedia.fn.data.json.Jsons.f((String)"id", (JValue)com.entwinemedia.fn.data.json.Jsons.v((Object)seriesID, (JValue)com.entwinemedia.fn.data.json.Jsons.BLANK)), com.entwinemedia.fn.data.json.Jsons.f((String)"title", (JValue)com.entwinemedia.fn.data.json.Jsons.v((Object)seriesTitle, (JValue)com.entwinemedia.fn.data.json.Jsons.BLANK))})));
        }
        fields.add(com.entwinemedia.fn.data.json.Jsons.f((String)"location", (JValue)com.entwinemedia.fn.data.json.Jsons.v((Object)event.getLocation(), (JValue)com.entwinemedia.fn.data.json.Jsons.BLANK)));
        fields.add(com.entwinemedia.fn.data.json.Jsons.f((String)"start_date", (JValue)com.entwinemedia.fn.data.json.Jsons.v((Object)event.getRecordingStartDate(), (JValue)com.entwinemedia.fn.data.json.Jsons.BLANK)));
        fields.add(com.entwinemedia.fn.data.json.Jsons.f((String)"end_date", (JValue)com.entwinemedia.fn.data.json.Jsons.v((Object)event.getRecordingEndDate(), (JValue)com.entwinemedia.fn.data.json.Jsons.BLANK)));
        fields.add(com.entwinemedia.fn.data.json.Jsons.f((String)"managedAcl", (JValue)com.entwinemedia.fn.data.json.Jsons.v((Object)event.getManagedAcl(), (JValue)com.entwinemedia.fn.data.json.Jsons.BLANK)));
        fields.add(com.entwinemedia.fn.data.json.Jsons.f((String)"workflow_state", (JValue)com.entwinemedia.fn.data.json.Jsons.v((Object)event.getWorkflowState(), (JValue)com.entwinemedia.fn.data.json.Jsons.BLANK)));
        fields.add(com.entwinemedia.fn.data.json.Jsons.f((String)"event_status", (JValue)com.entwinemedia.fn.data.json.Jsons.v((String)event.getEventStatus())));
        fields.add(com.entwinemedia.fn.data.json.Jsons.f((String)"displayable_status", (JValue)com.entwinemedia.fn.data.json.Jsons.v((String)event.getDisplayableStatus(this.getWorkflowService().getWorkflowStateMappings()))));
        fields.add(com.entwinemedia.fn.data.json.Jsons.f((String)"source", (JValue)com.entwinemedia.fn.data.json.Jsons.v((String)this.getIndexService().getEventSource(event).toString())));
        fields.add(com.entwinemedia.fn.data.json.Jsons.f((String)"has_comments", (JValue)com.entwinemedia.fn.data.json.Jsons.v((Boolean)event.hasComments())));
        fields.add(com.entwinemedia.fn.data.json.Jsons.f((String)"has_open_comments", (JValue)com.entwinemedia.fn.data.json.Jsons.v((Boolean)event.hasOpenComments())));
        fields.add(com.entwinemedia.fn.data.json.Jsons.f((String)"needs_cutting", (JValue)com.entwinemedia.fn.data.json.Jsons.v((Boolean)event.needsCutting())));
        fields.add(com.entwinemedia.fn.data.json.Jsons.f((String)"has_preview", (JValue)com.entwinemedia.fn.data.json.Jsons.v((Boolean)event.hasPreview())));
        fields.add(com.entwinemedia.fn.data.json.Jsons.f((String)"agent_id", (JValue)com.entwinemedia.fn.data.json.Jsons.v((Object)event.getAgentId(), (JValue)com.entwinemedia.fn.data.json.Jsons.BLANK)));
        fields.add(com.entwinemedia.fn.data.json.Jsons.f((String)"technical_start", (JValue)com.entwinemedia.fn.data.json.Jsons.v((Object)event.getTechnicalStartTime(), (JValue)com.entwinemedia.fn.data.json.Jsons.BLANK)));
        fields.add(com.entwinemedia.fn.data.json.Jsons.f((String)"technical_end", (JValue)com.entwinemedia.fn.data.json.Jsons.v((Object)event.getTechnicalEndTime(), (JValue)com.entwinemedia.fn.data.json.Jsons.BLANK)));
        fields.add(com.entwinemedia.fn.data.json.Jsons.f((String)"technical_presenters", (JValue)com.entwinemedia.fn.data.json.Jsons.arr((Iterable)com.entwinemedia.fn.Stream.$((Iterable)event.getTechnicalPresenters()).map(Jsons.Functions.stringToJValue))));
        fields.add(com.entwinemedia.fn.data.json.Jsons.f((String)"publications", (JValue)com.entwinemedia.fn.data.json.Jsons.arr(this.eventPublicationsToJson(event))));
        if (comments.isPresent()) {
            fields.add(com.entwinemedia.fn.data.json.Jsons.f((String)"comments", (JValue)com.entwinemedia.fn.data.json.Jsons.arr(this.eventCommentsToJson(comments.get()))));
        }
        return com.entwinemedia.fn.data.json.Jsons.obj(fields);
    }

    private JValue attachmentToJSON(Attachment attachment) {
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.addAll(this.getEventMediaPackageElementFields((MediaPackageElement)attachment));
        fields.addAll(this.getCommonElementFields((MediaPackageElement)attachment));
        return com.entwinemedia.fn.data.json.Jsons.obj(fields);
    }

    private JValue catalogToJSON(Catalog catalog) {
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.addAll(this.getEventMediaPackageElementFields((MediaPackageElement)catalog));
        fields.addAll(this.getCommonElementFields((MediaPackageElement)catalog));
        return com.entwinemedia.fn.data.json.Jsons.obj(fields);
    }

    private JValue trackToJSON(Track track) {
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.addAll(this.getEventMediaPackageElementFields((MediaPackageElement)track));
        fields.addAll(this.getCommonElementFields((MediaPackageElement)track));
        fields.add(com.entwinemedia.fn.data.json.Jsons.f((String)"duration", (JValue)com.entwinemedia.fn.data.json.Jsons.v((Object)track.getDuration(), (JValue)com.entwinemedia.fn.data.json.Jsons.BLANK)));
        fields.add(com.entwinemedia.fn.data.json.Jsons.f((String)"has_audio", (JValue)com.entwinemedia.fn.data.json.Jsons.v((Boolean)track.hasAudio())));
        fields.add(com.entwinemedia.fn.data.json.Jsons.f((String)"has_video", (JValue)com.entwinemedia.fn.data.json.Jsons.v((Boolean)track.hasVideo())));
        fields.add(com.entwinemedia.fn.data.json.Jsons.f((String)"has_subtitle", (JValue)com.entwinemedia.fn.data.json.Jsons.v((Boolean)track.hasSubtitle())));
        fields.add(com.entwinemedia.fn.data.json.Jsons.f((String)"streams", (JValue)com.entwinemedia.fn.data.json.Jsons.obj(this.streamsToJSON(track.getStreams()))));
        return com.entwinemedia.fn.data.json.Jsons.obj(fields);
    }

    private List<Field> streamsToJSON(Stream[] streams) {
        ArrayList<Field> fields = new ArrayList<Field>();
        ArrayList<JObject> audioList = new ArrayList<JObject>();
        ArrayList<JObject> videoList = new ArrayList<JObject>();
        ArrayList<JObject> subtitleList = new ArrayList<JObject>();
        for (Stream stream : streams) {
            if (stream instanceof AudioStreamImpl) {
                ArrayList<Field> audio = new ArrayList<Field>();
                AudioStream audioStream = (AudioStream)stream;
                audio.add(com.entwinemedia.fn.data.json.Jsons.f((String)"id", (JValue)com.entwinemedia.fn.data.json.Jsons.v((Object)audioStream.getIdentifier(), (JValue)com.entwinemedia.fn.data.json.Jsons.BLANK)));
                audio.add(com.entwinemedia.fn.data.json.Jsons.f((String)"type", (JValue)com.entwinemedia.fn.data.json.Jsons.v((Object)audioStream.getFormat(), (JValue)com.entwinemedia.fn.data.json.Jsons.BLANK)));
                audio.add(com.entwinemedia.fn.data.json.Jsons.f((String)"channels", (JValue)com.entwinemedia.fn.data.json.Jsons.v((Object)audioStream.getChannels(), (JValue)com.entwinemedia.fn.data.json.Jsons.BLANK)));
                audio.add(com.entwinemedia.fn.data.json.Jsons.f((String)"bitrate", (JValue)com.entwinemedia.fn.data.json.Jsons.v((Object)audioStream.getBitRate(), (JValue)com.entwinemedia.fn.data.json.Jsons.BLANK)));
                audio.add(com.entwinemedia.fn.data.json.Jsons.f((String)"bitdepth", (JValue)com.entwinemedia.fn.data.json.Jsons.v((Object)audioStream.getBitDepth(), (JValue)com.entwinemedia.fn.data.json.Jsons.BLANK)));
                audio.add(com.entwinemedia.fn.data.json.Jsons.f((String)"samplingrate", (JValue)com.entwinemedia.fn.data.json.Jsons.v((Object)audioStream.getSamplingRate(), (JValue)com.entwinemedia.fn.data.json.Jsons.BLANK)));
                audio.add(com.entwinemedia.fn.data.json.Jsons.f((String)"framecount", (JValue)com.entwinemedia.fn.data.json.Jsons.v((Object)audioStream.getFrameCount(), (JValue)com.entwinemedia.fn.data.json.Jsons.BLANK)));
                audio.add(com.entwinemedia.fn.data.json.Jsons.f((String)"peakleveldb", (JValue)com.entwinemedia.fn.data.json.Jsons.v((Object)audioStream.getPkLevDb(), (JValue)com.entwinemedia.fn.data.json.Jsons.BLANK)));
                audio.add(com.entwinemedia.fn.data.json.Jsons.f((String)"rmsleveldb", (JValue)com.entwinemedia.fn.data.json.Jsons.v((Object)audioStream.getRmsLevDb(), (JValue)com.entwinemedia.fn.data.json.Jsons.BLANK)));
                audio.add(com.entwinemedia.fn.data.json.Jsons.f((String)"rmspeakdb", (JValue)com.entwinemedia.fn.data.json.Jsons.v((Object)audioStream.getRmsPkDb(), (JValue)com.entwinemedia.fn.data.json.Jsons.BLANK)));
                audioList.add(com.entwinemedia.fn.data.json.Jsons.obj(audio));
                continue;
            }
            if (stream instanceof VideoStreamImpl) {
                ArrayList<Field> video = new ArrayList<Field>();
                VideoStream videoStream = (VideoStream)stream;
                video.add(com.entwinemedia.fn.data.json.Jsons.f((String)"id", (JValue)com.entwinemedia.fn.data.json.Jsons.v((Object)videoStream.getIdentifier(), (JValue)com.entwinemedia.fn.data.json.Jsons.BLANK)));
                video.add(com.entwinemedia.fn.data.json.Jsons.f((String)"type", (JValue)com.entwinemedia.fn.data.json.Jsons.v((Object)videoStream.getFormat(), (JValue)com.entwinemedia.fn.data.json.Jsons.BLANK)));
                video.add(com.entwinemedia.fn.data.json.Jsons.f((String)"bitrate", (JValue)com.entwinemedia.fn.data.json.Jsons.v((Object)videoStream.getBitRate(), (JValue)com.entwinemedia.fn.data.json.Jsons.BLANK)));
                video.add(com.entwinemedia.fn.data.json.Jsons.f((String)"framerate", (JValue)com.entwinemedia.fn.data.json.Jsons.v((Object)videoStream.getFrameRate(), (JValue)com.entwinemedia.fn.data.json.Jsons.BLANK)));
                video.add(com.entwinemedia.fn.data.json.Jsons.f((String)"resolution", (JValue)com.entwinemedia.fn.data.json.Jsons.v((Object)(videoStream.getFrameWidth() + "x" + videoStream.getFrameHeight()), (JValue)com.entwinemedia.fn.data.json.Jsons.BLANK)));
                video.add(com.entwinemedia.fn.data.json.Jsons.f((String)"framecount", (JValue)com.entwinemedia.fn.data.json.Jsons.v((Object)videoStream.getFrameCount(), (JValue)com.entwinemedia.fn.data.json.Jsons.BLANK)));
                video.add(com.entwinemedia.fn.data.json.Jsons.f((String)"scantype", (JValue)com.entwinemedia.fn.data.json.Jsons.v((Object)videoStream.getScanType(), (JValue)com.entwinemedia.fn.data.json.Jsons.BLANK)));
                video.add(com.entwinemedia.fn.data.json.Jsons.f((String)"scanorder", (JValue)com.entwinemedia.fn.data.json.Jsons.v((Object)videoStream.getScanOrder(), (JValue)com.entwinemedia.fn.data.json.Jsons.BLANK)));
                videoList.add(com.entwinemedia.fn.data.json.Jsons.obj(video));
                continue;
            }
            if (stream instanceof SubtitleStreamImpl) {
                ArrayList<Field> subtitle = new ArrayList<Field>();
                SubtitleStreamImpl subtitleStream = (SubtitleStreamImpl)stream;
                subtitle.add(com.entwinemedia.fn.data.json.Jsons.f((String)"id", (JValue)com.entwinemedia.fn.data.json.Jsons.v((Object)subtitleStream.getIdentifier(), (JValue)com.entwinemedia.fn.data.json.Jsons.BLANK)));
                subtitle.add(com.entwinemedia.fn.data.json.Jsons.f((String)"type", (JValue)com.entwinemedia.fn.data.json.Jsons.v((Object)subtitleStream.getFormat(), (JValue)com.entwinemedia.fn.data.json.Jsons.BLANK)));
                subtitleList.add(com.entwinemedia.fn.data.json.Jsons.obj(subtitle));
                continue;
            }
            throw new IllegalArgumentException("Stream must be either audio, video or subtitle");
        }
        fields.add(com.entwinemedia.fn.data.json.Jsons.f((String)"audio", (JValue)com.entwinemedia.fn.data.json.Jsons.arr(audioList)));
        fields.add(com.entwinemedia.fn.data.json.Jsons.f((String)"video", (JValue)com.entwinemedia.fn.data.json.Jsons.arr(videoList)));
        fields.add(com.entwinemedia.fn.data.json.Jsons.f((String)"subtitle", (JValue)com.entwinemedia.fn.data.json.Jsons.arr(subtitleList)));
        return fields;
    }

    private JValue publicationToJSON(Publication publication) {
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.add(com.entwinemedia.fn.data.json.Jsons.f((String)"id", (JValue)com.entwinemedia.fn.data.json.Jsons.v((Object)publication.getIdentifier(), (JValue)com.entwinemedia.fn.data.json.Jsons.BLANK)));
        fields.add(com.entwinemedia.fn.data.json.Jsons.f((String)"channel", (JValue)com.entwinemedia.fn.data.json.Jsons.v((Object)publication.getChannel(), (JValue)com.entwinemedia.fn.data.json.Jsons.BLANK)));
        fields.add(com.entwinemedia.fn.data.json.Jsons.f((String)"mimetype", (JValue)com.entwinemedia.fn.data.json.Jsons.v((Object)publication.getMimeType(), (JValue)com.entwinemedia.fn.data.json.Jsons.BLANK)));
        fields.add(com.entwinemedia.fn.data.json.Jsons.f((String)"tags", (JValue)com.entwinemedia.fn.data.json.Jsons.arr((Iterable)com.entwinemedia.fn.Stream.$((Object[])publication.getTags()).map(toStringJValue))));
        fields.add(com.entwinemedia.fn.data.json.Jsons.f((String)"url", (JValue)com.entwinemedia.fn.data.json.Jsons.v((Object)this.signUrl(publication.getURI()), (JValue)com.entwinemedia.fn.data.json.Jsons.BLANK)));
        fields.addAll(this.getCommonElementFields((MediaPackageElement)publication));
        return com.entwinemedia.fn.data.json.Jsons.obj(fields);
    }

    private List<Field> getCommonElementFields(MediaPackageElement element) {
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.add(com.entwinemedia.fn.data.json.Jsons.f((String)"size", (JValue)com.entwinemedia.fn.data.json.Jsons.v((Object)element.getSize(), (JValue)com.entwinemedia.fn.data.json.Jsons.BLANK)));
        fields.add(com.entwinemedia.fn.data.json.Jsons.f((String)"checksum", (JValue)com.entwinemedia.fn.data.json.Jsons.v((Object)(element.getChecksum() != null ? element.getChecksum().getValue() : null), (JValue)com.entwinemedia.fn.data.json.Jsons.BLANK)));
        fields.add(com.entwinemedia.fn.data.json.Jsons.f((String)"reference", (JValue)com.entwinemedia.fn.data.json.Jsons.v((Object)(element.getReference() != null ? element.getReference().getIdentifier() : null), (JValue)com.entwinemedia.fn.data.json.Jsons.BLANK)));
        return fields;
    }

    private List<JValue> getEventPublications(Publication[] publications) {
        ArrayList<JValue> publicationJSON = new ArrayList<JValue>();
        for (Publication publication : publications) {
            publicationJSON.add((JValue)com.entwinemedia.fn.data.json.Jsons.obj((Field[])new Field[]{com.entwinemedia.fn.data.json.Jsons.f((String)"id", (JValue)com.entwinemedia.fn.data.json.Jsons.v((Object)publication.getIdentifier(), (JValue)com.entwinemedia.fn.data.json.Jsons.BLANK)), com.entwinemedia.fn.data.json.Jsons.f((String)"channel", (JValue)com.entwinemedia.fn.data.json.Jsons.v((Object)publication.getChannel(), (JValue)com.entwinemedia.fn.data.json.Jsons.BLANK)), com.entwinemedia.fn.data.json.Jsons.f((String)"mimetype", (JValue)com.entwinemedia.fn.data.json.Jsons.v((Object)publication.getMimeType(), (JValue)com.entwinemedia.fn.data.json.Jsons.BLANK)), com.entwinemedia.fn.data.json.Jsons.f((String)"tags", (JValue)com.entwinemedia.fn.data.json.Jsons.arr((Iterable)com.entwinemedia.fn.Stream.$((Object[])publication.getTags()).map(toStringJValue))), com.entwinemedia.fn.data.json.Jsons.f((String)"url", (JValue)com.entwinemedia.fn.data.json.Jsons.v((Object)this.signUrl(publication.getURI()), (JValue)com.entwinemedia.fn.data.json.Jsons.BLANK))}));
        }
        return publicationJSON;
    }

    private URI signUrl(URI url) {
        if (url == null) {
            return null;
        }
        if (this.getUrlSigningService().accepts(url.toString())) {
            try {
                String clientIP = null;
                if (this.signWithClientIP().booleanValue()) {
                    clientIP = this.getSecurityService().getUserIP();
                }
                return URI.create(this.getUrlSigningService().sign(url.toString(), Long.valueOf(this.getUrlSigningExpireDuration()), null, clientIP));
            }
            catch (UrlSigningException e) {
                logger.warn("Unable to sign url '{}'", (Object)url, (Object)e);
            }
        }
        return url;
    }

    private List<JValue> getEventMediaPackageElements(MediaPackageElement[] elements) {
        ArrayList<JValue> elementJSON = new ArrayList<JValue>();
        for (MediaPackageElement element : elements) {
            elementJSON.add((JValue)com.entwinemedia.fn.data.json.Jsons.obj(this.getEventMediaPackageElementFields(element)));
        }
        return elementJSON;
    }

    private List<Field> getEventMediaPackageElementFields(MediaPackageElement element) {
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.add(com.entwinemedia.fn.data.json.Jsons.f((String)"id", (JValue)com.entwinemedia.fn.data.json.Jsons.v((Object)element.getIdentifier(), (JValue)com.entwinemedia.fn.data.json.Jsons.BLANK)));
        fields.add(com.entwinemedia.fn.data.json.Jsons.f((String)"type", (JValue)com.entwinemedia.fn.data.json.Jsons.v((Object)element.getFlavor(), (JValue)com.entwinemedia.fn.data.json.Jsons.BLANK)));
        fields.add(com.entwinemedia.fn.data.json.Jsons.f((String)"mimetype", (JValue)com.entwinemedia.fn.data.json.Jsons.v((Object)element.getMimeType(), (JValue)com.entwinemedia.fn.data.json.Jsons.BLANK)));
        List tags = com.entwinemedia.fn.Stream.$((Object[])element.getTags()).map(toStringJValue).toList();
        fields.add(com.entwinemedia.fn.data.json.Jsons.f((String)"tags", (JValue)com.entwinemedia.fn.data.json.Jsons.arr((Iterable)tags)));
        fields.add(com.entwinemedia.fn.data.json.Jsons.f((String)"url", (JValue)com.entwinemedia.fn.data.json.Jsons.v((Object)this.signUrl(element.getURI()), (JValue)com.entwinemedia.fn.data.json.Jsons.BLANK)));
        return fields;
    }

    @PUT
    @Path(value="{eventId}/workflows/{workflowId}/action/{action}")
    @RestQuery(name="workflowAction", description="Performs the given action for the given workflow.", returnDescription="", pathParameters={@RestParameter(name="eventId", description="The id of the media package", isRequired=true, type=RestParameter.Type.STRING), @RestParameter(name="workflowId", description="The id of the workflow", isRequired=true, type=RestParameter.Type.STRING), @RestParameter(name="action", description="The action to take: STOP, RETRY or NONE (abort processing)", isRequired=true, type=RestParameter.Type.STRING)}, responses={@RestResponse(responseCode=200, description="Workflow resumed."), @RestResponse(responseCode=404, description="Event or workflow instance not found."), @RestResponse(responseCode=400, description="Invalid action entered."), @RestResponse(responseCode=401, description="You do not have permission to perform the action. Maybe you need to authenticate."), @RestResponse(responseCode=500, description="An exception occurred.")})
    public Response workflowAction(@PathParam(value="eventId") String id, @PathParam(value="workflowId") long wfId, @PathParam(value="action") String action) {
        if (StringUtils.isEmpty((CharSequence)id) || StringUtils.isEmpty((CharSequence)action)) {
            return RestUtil.R.badRequest();
        }
        try {
            Opt optEvent = this.getIndexService().getEvent(id, this.getIndex());
            if (optEvent.isNone()) {
                return RestUtils.notFound((String)"Cannot find an event with id '%s'.", (Object[])new Object[]{id});
            }
            WorkflowInstance wfInstance = this.getWorkflowService().getWorkflowById(wfId);
            if (!wfInstance.getMediaPackage().getIdentifier().toString().equals(id)) {
                return RestUtil.R.badRequest((String)String.format("Workflow %s is not associated to event %s", wfId, id));
            }
            if (RetryStrategy.NONE.toString().equalsIgnoreCase(action) || RetryStrategy.RETRY.toString().equalsIgnoreCase(action)) {
                this.getWorkflowService().resume(wfId, Collections.singletonMap("retryStrategy", action));
                return RestUtil.R.ok();
            }
            if (WORKFLOW_ACTION_STOP.equalsIgnoreCase(action)) {
                this.getWorkflowService().stop(wfId);
                return RestUtil.R.ok();
            }
            return RestUtil.R.badRequest((String)("Action not supported: " + action));
        }
        catch (NotFoundException e) {
            return RestUtils.notFound((String)"Workflow not found: '%d'.", (Object[])new Object[]{wfId});
        }
        catch (IllegalStateException e) {
            return RestUtil.R.badRequest((String)String.format("Action %s not allowed for current workflow state. EventId: %s", action, id));
        }
        catch (UnauthorizedException e) {
            return RestUtil.R.forbidden();
        }
        catch (Exception e) {
            return RestUtil.R.serverError();
        }
    }

    @DELETE
    @Path(value="{eventId}/workflows/{workflowId}")
    @RestQuery(name="deleteWorkflow", description="Deletes a workflow", returnDescription="The method doesn't return any content", pathParameters={@RestParameter(name="eventId", isRequired=true, description="The event identifier", type=RestParameter.Type.STRING), @RestParameter(name="workflowId", isRequired=true, description="The workflow identifier", type=RestParameter.Type.INTEGER)}, responses={@RestResponse(responseCode=400, description="When trying to delete the latest workflow of the event."), @RestResponse(responseCode=404, description="If the event or the workflow has not been found."), @RestResponse(responseCode=204, description="The method does not return any content")})
    public Response deleteWorkflow(@PathParam(value="eventId") String id, @PathParam(value="workflowId") long wfId) throws SearchIndexException {
        Opt optEvent = this.getIndexService().getEvent(id, this.getIndex());
        try {
            if (optEvent.isNone()) {
                return RestUtils.notFound((String)"Cannot find an event with id '%s'.", (Object[])new Object[]{id});
            }
            WorkflowInstance wfInstance = this.getWorkflowService().getWorkflowById(wfId);
            if (!wfInstance.getMediaPackage().getIdentifier().toString().equals(id)) {
                return RestUtil.R.badRequest((String)String.format("Workflow %s is not associated to event %s", wfId, id));
            }
            if (wfId == ((Event)optEvent.get()).getWorkflowId()) {
                return RestUtil.R.badRequest((String)String.format("Cannot delete current workflow %s from event %s. Only older workflows can be deleted.", wfId, id));
            }
            this.getWorkflowService().remove(wfId);
            return Response.noContent().build();
        }
        catch (WorkflowStateException e) {
            return RestUtil.R.badRequest((String)("Deleting is not allowed for current workflow state. EventId: " + id));
        }
        catch (NotFoundException e) {
            return RestUtils.notFound((String)"Workflow not found: '%d'.", (Object[])new Object[]{wfId});
        }
        catch (UnauthorizedException e) {
            return RestUtil.R.forbidden();
        }
        catch (Exception e) {
            return RestUtil.R.serverError();
        }
    }

    private Opt<Event> checkAgentAccessForEvent(String eventId) throws UnauthorizedException, SearchIndexException {
        Opt event = this.getIndexService().getEvent(eventId, this.getIndex());
        if (event.isNone() || !((Event)event.get()).getEventStatus().contains("SCHEDULE")) {
            return event;
        }
        SecurityUtil.checkAgentAccess((SecurityService)this.getSecurityService(), (String)((Event)event.get()).getAgentId());
        return event;
    }

    private void checkAgentAccessForAgent(String agentId) throws UnauthorizedException {
        SecurityUtil.checkAgentAccess((SecurityService)this.getSecurityService(), (String)agentId);
    }
}

