/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.adminui.endpoint;

import com.entwinemedia.fn.Fn;
import com.entwinemedia.fn.Stream;
import com.entwinemedia.fn.data.json.Field;
import com.entwinemedia.fn.data.json.JObject;
import com.entwinemedia.fn.data.json.JValue;
import com.entwinemedia.fn.data.json.Jsons;
import com.entwinemedia.fn.data.json.SimpleSerializer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.adminui.endpoint.EndpointUtil;
import org.opencastproject.adminui.exception.JobEndpointException;
import org.opencastproject.index.service.resources.list.query.JobsListQuery;
import org.opencastproject.index.service.util.RestUtils;
import org.opencastproject.job.api.Incident;
import org.opencastproject.job.api.IncidentTree;
import org.opencastproject.job.api.Job;
import org.opencastproject.list.impl.ResourceListQueryImpl;
import org.opencastproject.security.api.UserDirectoryService;
import org.opencastproject.serviceregistry.api.HostRegistration;
import org.opencastproject.serviceregistry.api.IncidentL10n;
import org.opencastproject.serviceregistry.api.IncidentService;
import org.opencastproject.serviceregistry.api.IncidentServiceException;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.serviceregistry.api.ServiceRegistryException;
import org.opencastproject.util.DateTimeSupport;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.util.RestUtil;
import org.opencastproject.util.SmartIterator;
import org.opencastproject.util.data.Tuple;
import org.opencastproject.util.doc.rest.RestParameter;
import org.opencastproject.util.doc.rest.RestQuery;
import org.opencastproject.util.doc.rest.RestResponse;
import org.opencastproject.util.doc.rest.RestService;
import org.opencastproject.util.requests.SortCriterion;
import org.opencastproject.workflow.api.WorkflowService;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
@RestService(name="JobProxyService", title="UI Jobs", abstractText="This service provides the job data for the UI.", notes={"These Endpoints deliver informations about the job required for the UI.", "<strong>Important:</strong> <em>This service is for exclusive use by the module admin-ui. Its API might change anytime without prior notice. Any dependencies other than the admin UI will be strictly ignored. DO NOT use this for integration of third-party applications.<em>"})
@Component(immediate=true, service={JobEndpoint.class}, property={"service.description=Admin UI - Job facade Endpoint", "opencast.service.type=org.opencastproject.adminui.endpoint.JobEndpoint", "opencast.service.path=/admin-ng/job"})
public class JobEndpoint {
    private static final Logger logger = LoggerFactory.getLogger(JobEndpoint.class);
    private static final SimpleSerializer serializer = new SimpleSerializer();
    public static final Response NOT_FOUND = Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    private static final String NEGATE_PREFIX = "-";
    private static final String WORKFLOW_STATUS_TRANSLATION_PREFIX = "EVENTS.EVENTS.DETAILS.WORKFLOWS.OPERATION_STATUS.";
    private static final String JOB_STATUS_TRANSLATION_PREFIX = "SYSTEMS.JOBS.STATUS.";
    private WorkflowService workflowService;
    private ServiceRegistry serviceRegistry;
    private IncidentService incidentService;
    private UserDirectoryService userDirectoryService;
    private final Fn<Tuple<String, String>, JObject> errorDetailToJson = new Fn<Tuple<String, String>, JObject>(){

        public JObject apply(Tuple<String, String> detail) {
            return Jsons.obj((Field[])new Field[]{Jsons.f((String)"name", (JValue)Jsons.v((Object)detail.getA(), (JValue)Jsons.BLANK)), Jsons.f((String)"value", (JValue)Jsons.v((Object)detail.getB(), (JValue)Jsons.BLANK))});
        }
    };

    @Reference
    public void setWorkflowService(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }

    @Reference
    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    @Reference
    public void setIncidentService(IncidentService incidentService) {
        this.incidentService = incidentService;
    }

    @Reference
    public void setUserDirectoryService(UserDirectoryService userDirectoryService) {
        this.userDirectoryService = userDirectoryService;
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        logger.info("Activate job endpoint");
    }

    @GET
    @Path(value="jobs.json")
    @Produces(value={"application/json"})
    @RestQuery(description="Returns the list of active jobs", name="jobs", restParameters={@RestParameter(name="limit", description="The maximum number of items to return per page", isRequired=false, type=RestParameter.Type.INTEGER), @RestParameter(name="offset", description="The offset", isRequired=false, type=RestParameter.Type.INTEGER), @RestParameter(name="filter", description="Filter results by hostname, status or free text query", isRequired=false, type=RestParameter.Type.STRING), @RestParameter(name="sort", description="The sort order. May include any of the following: CREATOR, OPERATION, PROCESSINGHOST, STATUS, STARTED, SUBMITTED or TYPE. The suffix must be :ASC for ascending or :DESC for descending sort order (e.g. OPERATION:DESC)", isRequired=false, type=RestParameter.Type.STRING)}, responses={@RestResponse(description="Returns the list of active jobs from Opencast", responseCode=200)}, returnDescription="The list of jobs as JSON")
    public Response getJobs(@QueryParam(value="limit") int limit, @QueryParam(value="offset") int offset, @QueryParam(value="filter") String filter, @QueryParam(value="sort") String sort) {
        JobsListQuery query = new JobsListQuery();
        EndpointUtil.addRequestFiltersToQuery(filter, (ResourceListQueryImpl)query);
        query.setLimit(Integer.valueOf(limit));
        query.setOffset(Integer.valueOf(offset));
        String fHostname = null;
        if (query.getHostname().isSome()) {
            fHostname = StringUtils.trimToNull((String)((String)query.getHostname().get()));
        }
        String fNodeName = null;
        if (query.getNodeName().isSome()) {
            fNodeName = StringUtils.trimToNull((String)((String)query.getNodeName().get()));
        }
        String fStatus = null;
        if (query.getStatus().isSome()) {
            fStatus = StringUtils.trimToNull((String)((String)query.getStatus().get()));
        }
        String fFreeText = null;
        if (query.getFreeText().isSome()) {
            fFreeText = StringUtils.trimToNull((String)((String)query.getFreeText().get()));
        }
        ArrayList<JobExtended> jobs = new ArrayList<JobExtended>();
        try {
            List servers = this.serviceRegistry.getHostRegistrations();
            for (Job job : this.serviceRegistry.getActiveJobs()) {
                String vNodeName;
                if (StringUtils.equals((CharSequence)"org.opencastproject.workflow", (CharSequence)job.getJobType()) && StringUtils.equals((CharSequence)"START_WORKFLOW", (CharSequence)job.getOperation()) || fHostname != null && !StringUtils.equalsIgnoreCase((CharSequence)job.getProcessingHost(), (CharSequence)fHostname)) continue;
                Optional<HostRegistration> server = this.findServerByHost(job.getProcessingHost(), servers);
                String string = vNodeName = server.isPresent() ? server.get().getNodeName() : "";
                if (fNodeName != null && server.isPresent() && !StringUtils.equalsIgnoreCase((CharSequence)vNodeName, (CharSequence)fNodeName) || fStatus != null && !StringUtils.equalsIgnoreCase((CharSequence)job.getStatus().toString(), (CharSequence)fStatus) || fFreeText != null && !StringUtils.equalsIgnoreCase((CharSequence)job.getProcessingHost(), (CharSequence)fFreeText) && !StringUtils.equalsIgnoreCase((CharSequence)vNodeName, (CharSequence)fFreeText) && !StringUtils.equalsIgnoreCase((CharSequence)job.getJobType(), (CharSequence)fFreeText) && !StringUtils.equalsIgnoreCase((CharSequence)job.getOperation(), (CharSequence)fFreeText) && !StringUtils.equalsIgnoreCase((CharSequence)job.getCreator(), (CharSequence)fFreeText) && !StringUtils.equalsIgnoreCase((CharSequence)job.getStatus().toString(), (CharSequence)fFreeText) && !StringUtils.equalsIgnoreCase((CharSequence)Long.toString(job.getId()), (CharSequence)fFreeText) && job.getRootJobId() != null && !StringUtils.equalsIgnoreCase((CharSequence)Long.toString(job.getRootJobId()), (CharSequence)fFreeText)) continue;
                jobs.add(new JobExtended(job, vNodeName));
            }
        }
        catch (ServiceRegistryException ex) {
            logger.error("Failed to retrieve jobs list from service registry.", (Throwable)ex);
            return RestUtil.R.serverError();
        }
        JobSort sortKey = JobSort.SUBMITTED;
        boolean ascending = true;
        if (StringUtils.isNotBlank((CharSequence)sort)) {
            try {
                SortCriterion sortCriterion = (SortCriterion)RestUtils.parseSortQueryParameter((String)sort).iterator().next();
                sortKey = JobSort.valueOf(sortCriterion.getFieldName().toUpperCase());
                ascending = SortCriterion.Order.Ascending == sortCriterion.getOrder() || SortCriterion.Order.None == sortCriterion.getOrder();
            }
            catch (WebApplicationException ex) {
                logger.warn("Failed to parse sort criterion \"{}\", invalid format.", (Object)sort);
            }
            catch (IllegalArgumentException ex) {
                logger.warn("Can not apply sort criterion \"{}\", no field with this name.", (Object)sort);
            }
        }
        JobComparator comparator = new JobComparator(sortKey, ascending);
        Collections.sort(jobs, comparator);
        List<JValue> json = this.getJobsAsJSON(new SmartIterator(((Integer)query.getLimit().getOrElse((Object)0)).intValue(), ((Integer)query.getOffset().getOrElse((Object)0)).intValue()).applyLimitAndOffset(jobs));
        return RestUtils.okJsonList(json, (int)offset, (int)limit, (long)jobs.size());
    }

    public List<JValue> getJobsAsJSON(List<JobExtended> jobs) {
        ArrayList<JValue> jsonList = new ArrayList<JValue>();
        for (JobExtended jobEx : jobs) {
            Job job = jobEx.getJob();
            long id = job.getId();
            String jobType = job.getJobType();
            String operation = job.getOperation();
            Job.Status status = job.getStatus();
            Date dateCreated = job.getDateCreated();
            String created = null;
            if (dateCreated != null) {
                created = DateTimeSupport.toUTC((long)dateCreated.getTime());
            }
            Date dateStarted = job.getDateStarted();
            String started = null;
            if (dateStarted != null) {
                started = DateTimeSupport.toUTC((long)dateStarted.getTime());
            }
            String creator = job.getCreator();
            String processingHost = job.getProcessingHost();
            String processingNode = jobEx.getNodeName();
            jsonList.add((JValue)Jsons.obj((Field[])new Field[]{Jsons.f((String)"id", (JValue)Jsons.v((Number)id)), Jsons.f((String)"type", (JValue)Jsons.v((String)jobType)), Jsons.f((String)"operation", (JValue)Jsons.v((String)operation)), Jsons.f((String)"status", (JValue)Jsons.v((String)(JOB_STATUS_TRANSLATION_PREFIX + status.toString()))), Jsons.f((String)"submitted", (JValue)Jsons.v((Object)created, (JValue)Jsons.BLANK)), Jsons.f((String)"started", (JValue)Jsons.v((Object)started, (JValue)Jsons.BLANK)), Jsons.f((String)"creator", (JValue)Jsons.v((Object)creator, (JValue)Jsons.BLANK)), Jsons.f((String)"processingHost", (JValue)Jsons.v((Object)processingHost, (JValue)Jsons.BLANK)), Jsons.f((String)"processingNode", (JValue)Jsons.v((Object)processingNode, (JValue)Jsons.BLANK))}));
        }
        return jsonList;
    }

    public JValue getIncidentsAsJSON(long jobId, final Locale locale, boolean cascade) throws JobEndpointException, NotFoundException {
        List<Incident> incidents;
        try {
            IncidentTree it = this.incidentService.getIncidentsOfJob(jobId, cascade);
            incidents = cascade ? this.flatten(it) : it.getIncidents();
        }
        catch (IncidentServiceException e) {
            throw new JobEndpointException(String.format("Not able to get the incidents for the job %d from the incident service : %s", new Object[]{jobId, e}), e.getCause());
        }
        Stream json = Stream.$(incidents).map((Fn)new Fn<Incident, JValue>(){

            public JValue apply(Incident i) {
                return Jsons.obj((Field[])new Field[]{Jsons.f((String)"id", (JValue)Jsons.v((Number)i.getId())), Jsons.f((String)"severity", (JValue)Jsons.v((Object)i.getSeverity(), (JValue)Jsons.BLANK)), Jsons.f((String)"timestamp", (JValue)Jsons.v((Object)DateTimeSupport.toUTC((long)i.getTimestamp().getTime()), (JValue)Jsons.BLANK))}).merge((Iterable)JobEndpoint.this.localizeIncident(i, locale));
            }
        });
        return Jsons.arr((Iterable)json);
    }

    private List<Incident> flatten(IncidentTree incidentsTree) {
        ArrayList<Incident> incidents = new ArrayList<Incident>();
        incidents.addAll(incidentsTree.getIncidents());
        for (IncidentTree descendantTree : incidentsTree.getDescendants()) {
            incidents.addAll(this.flatten(descendantTree));
        }
        return incidents;
    }

    private JObject localizeIncident(Incident incident, Locale locale) {
        try {
            IncidentL10n loc = this.incidentService.getLocalization(incident.getId(), locale);
            return Jsons.obj((Field[])new Field[]{Jsons.f((String)"title", (JValue)Jsons.v((Object)loc.getTitle(), (JValue)Jsons.BLANK)), Jsons.f((String)"description", (JValue)Jsons.v((Object)loc.getDescription(), (JValue)Jsons.BLANK))});
        }
        catch (Exception e) {
            return Jsons.obj((Field[])new Field[]{Jsons.f((String)"title", (JValue)Jsons.v((String)"")), Jsons.f((String)"description", (JValue)Jsons.v((String)""))});
        }
    }

    public JValue getIncidentAsJSON(long id, Locale locale) throws JobEndpointException, NotFoundException {
        Incident incident;
        try {
            incident = this.incidentService.getIncident(id);
        }
        catch (IncidentServiceException e) {
            throw new JobEndpointException(String.format("Not able to get the incident %d: %s", new Object[]{id, e}), e.getCause());
        }
        return Jsons.obj((Field[])new Field[]{Jsons.f((String)"id", (JValue)Jsons.v((Object)incident.getId(), (JValue)Jsons.BLANK)), Jsons.f((String)"job_id", (JValue)Jsons.v((Object)incident.getJobId(), (JValue)Jsons.BLANK)), Jsons.f((String)"severity", (JValue)Jsons.v((Object)incident.getSeverity(), (JValue)Jsons.BLANK)), Jsons.f((String)"timestamp", (JValue)Jsons.v((Object)DateTimeSupport.toUTC((long)incident.getTimestamp().getTime()), (JValue)Jsons.BLANK)), Jsons.f((String)"processing_host", (JValue)Jsons.v((Object)incident.getProcessingHost(), (JValue)Jsons.BLANK)), Jsons.f((String)"service_type", (JValue)Jsons.v((Object)incident.getServiceType(), (JValue)Jsons.BLANK)), Jsons.f((String)"technical_details", (JValue)Jsons.v((Object)incident.getDescriptionParameters(), (JValue)Jsons.BLANK)), Jsons.f((String)"details", (JValue)Jsons.arr((Iterable)Stream.$((Iterable)incident.getDetails()).map(this.errorDetailToJson)))}).merge((Iterable)this.localizeIncident(incident, locale));
    }

    private Optional<HostRegistration> findServerByHost(String hostname, List<HostRegistration> servers) {
        return servers.stream().filter(o -> o.getBaseUrl().equals(hostname)).findFirst();
    }

    private class JobComparator
    implements Comparator<JobExtended> {
        private JobSort sortType;
        private boolean ascending;

        JobComparator(JobSort sortType, boolean ascending) {
            this.sortType = sortType;
            this.ascending = ascending;
        }

        @Override
        public int compare(JobExtended jobEx1, JobExtended jobEx2) {
            int result = 0;
            Object value1 = null;
            Object value2 = null;
            Job job1 = jobEx1.getJob();
            Job job2 = jobEx2.getJob();
            switch (this.sortType) {
                case CREATOR: {
                    value1 = job1.getCreator();
                    value2 = job2.getCreator();
                    break;
                }
                case OPERATION: {
                    value1 = job1.getOperation();
                    value2 = job2.getOperation();
                    break;
                }
                case PROCESSINGHOST: {
                    value1 = job1.getProcessingHost();
                    value2 = job2.getProcessingHost();
                    break;
                }
                case PROCESSINGNODE: {
                    value1 = jobEx1.getNodeName();
                    value2 = jobEx2.getNodeName();
                    break;
                }
                case STARTED: {
                    value1 = job1.getDateStarted();
                    value2 = job2.getDateStarted();
                    break;
                }
                case STATUS: {
                    value1 = job1.getStatus();
                    value2 = job2.getStatus();
                    break;
                }
                case SUBMITTED: {
                    value1 = job1.getDateCreated();
                    value2 = job2.getDateCreated();
                    break;
                }
                case TYPE: {
                    value1 = job1.getJobType();
                    value2 = job2.getJobType();
                    break;
                }
                case ID: {
                    value1 = job1.getId();
                    value2 = job2.getId();
                    break;
                }
            }
            if (value1 == null) {
                return value2 == null ? 0 : 1;
            }
            if (value2 == null) {
                return -1;
            }
            try {
                result = ((Comparable)value1).compareTo(value2);
            }
            catch (ClassCastException ex) {
                logger.debug("Can not compare \"{}\" with \"{}\": {}", new Object[]{value1, value2, ex});
            }
            return this.ascending ? result : -1 * result;
        }
    }

    class JobExtended {
        private final Job job;
        private final String nodeName;

        JobExtended(Job job, String nodeName) {
            this.job = job;
            this.nodeName = nodeName;
        }

        public Job getJob() {
            return this.job;
        }

        public String getNodeName() {
            return this.nodeName;
        }
    }

    private static enum JobSort {
        CREATOR,
        OPERATION,
        PROCESSINGHOST,
        PROCESSINGNODE,
        STATUS,
        STARTED,
        SUBMITTED,
        TYPE,
        ID;

    }
}

