/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.jul.processing;

import javax.vecmath.Quat4d;
import javax.vecmath.Vector3d;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuaternionEulerTransform {
    protected static final Logger logger = LoggerFactory.getLogger(QuaternionEulerTransform.class);

    public static Quat4d transform(double roll, double pitch, double yaw) {
        return QuaternionEulerTransform.transform(new Vector3d(roll, pitch, yaw));
    }

    public static Quat4d transform(Vector3d vector3d) {
        logger.info("QuaternionEulerTransform roll: " + vector3d.x);
        logger.info("QuaternionEulerTransform pitch: " + vector3d.y);
        logger.info("QuaternionEulerTransform yaw: " + vector3d.z);
        double cosYawHalf = Math.cos(vector3d.z / 2.0);
        double sinYawHalf = Math.sin(vector3d.z / 2.0);
        double cosPitchHalf = Math.cos(vector3d.y / 2.0);
        double sinPitchHalf = Math.sin(vector3d.y / 2.0);
        double cosRollHalf = Math.cos(vector3d.x / 2.0);
        double sinRollHalf = Math.sin(vector3d.x / 2.0);
        double cosYawPitchHalf = cosYawHalf * cosPitchHalf;
        double sinYawPitchHalf = sinYawHalf * sinPitchHalf;
        Quat4d quat4d = new Quat4d();
        quat4d.w = cosYawPitchHalf * cosRollHalf - sinYawPitchHalf * sinRollHalf;
        quat4d.x = cosYawPitchHalf * sinRollHalf + sinYawPitchHalf * cosRollHalf;
        quat4d.y = cosYawHalf * sinPitchHalf * cosRollHalf - sinYawHalf * cosPitchHalf * sinRollHalf;
        quat4d.z = sinYawHalf * cosPitchHalf * cosRollHalf + cosYawHalf * sinPitchHalf * sinRollHalf;
        return quat4d;
    }

    public static Vector3d transform(Quat4d quat4d) {
        double[] euler = new double[3];
        Vector3d result = new Vector3d();
        double test = quat4d.x * quat4d.z + quat4d.y * quat4d.w;
        if (test >= 0.5) {
            result.x = 0.0;
            result.y = 1.5707963267948966;
            result.z = 2.0 * Math.atan2(quat4d.x, quat4d.w);
            return result;
        }
        if (test <= -0.5) {
            result.x = 0.0;
            result.y = -1.5707963267948966;
            result.z = -2.0 * Math.atan2(quat4d.x, quat4d.w);
            return result;
        }
        double sqx = quat4d.x * quat4d.x;
        double sqz = quat4d.y * quat4d.y;
        double sqy = quat4d.z * quat4d.z;
        result.x = Math.atan2(2.0 * quat4d.x * quat4d.w - 2.0 * quat4d.z * quat4d.y, 1.0 - 2.0 * sqx - 2.0 * sqz);
        result.y = Math.asin(2.0 * test);
        result.z = Math.atan2(2.0 * quat4d.z * quat4d.w - 2.0 * quat4d.x * quat4d.y, 1.0 - 2.0 * sqy - 2.0 * sqz);
        return result;
    }
}

