/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.jul.exception.printer;

import org.openbase.jps.core.JPService;
import org.openbase.jps.exception.JPServiceException;
import org.openbase.jps.preset.JPVerbose;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.exception.printer.LogLevel;
import org.openbase.jul.exception.printer.Printer;
import org.slf4j.Logger;

public class LogPrinter
implements Printer {
    private final Logger logger;
    private final LogLevel logLevel;

    public LogPrinter(Logger logger, LogLevel logLevel) {
        this.logger = logger;
        this.logLevel = logLevel;
    }

    @Override
    public void print(String message) {
        switch (this.logLevel) {
            case TRACE: {
                this.logger.trace(message);
                break;
            }
            case DEBUG: {
                this.logger.debug(message);
                break;
            }
            case INFO: {
                this.logger.info(message);
                break;
            }
            case WARN: {
                this.logger.warn(message);
                break;
            }
            case ERROR: {
                this.logger.error(message);
            }
        }
    }

    @Override
    public void print(String message, Throwable throwable) {
        switch (this.logLevel) {
            case TRACE: {
                this.logger.trace(message, throwable);
                break;
            }
            case DEBUG: {
                this.logger.debug(message, throwable);
                break;
            }
            case INFO: {
                this.logger.info(message, throwable);
                break;
            }
            case WARN: {
                this.logger.warn(message, throwable);
                break;
            }
            case ERROR: {
                this.logger.error(message, throwable);
            }
        }
    }

    @Override
    public boolean isDebugEnabled() {
        try {
            return this.logger.isDebugEnabled() || (Boolean)((JPVerbose)JPService.getProperty(JPVerbose.class)).getValue() != false && this.logLevel == LogLevel.ERROR;
        }
        catch (JPServiceException ex) {
            ExceptionPrinter.printHistory(new CouldNotPerformException("Could not access java property!", ex), this.logger);
            return true;
        }
    }

    public LogLevel getLogLevel() {
        return this.logLevel;
    }
}

