/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.jps.preset;

import java.io.File;
import org.openbase.jps.core.JPService;
import org.openbase.jps.exception.JPNotAvailableException;
import org.openbase.jps.preset.AbstractJPDirectory;
import org.openbase.jps.preset.JPLocalUserPrefix;
import org.openbase.jps.preset.JPTmpDirectory;
import org.openbase.jps.tools.FileHandler;

public class JPPrefix
extends AbstractJPDirectory {
    public static final String[] COMMAND_IDENTIFIERS = new String[]{"-p", "--prefix"};

    public JPPrefix() {
        super(COMMAND_IDENTIFIERS, FileHandler.ExistenceHandling.Must, FileHandler.AutoMode.Off);
    }

    @Override
    protected File getPropertyDefaultValue() throws JPNotAvailableException {
        if (JPService.testMode()) {
            return (File)JPService.getProperty(JPTmpDirectory.class).getValue();
        }
        String globalPrefix = System.getenv("prefix");
        if (globalPrefix == null) {
            File localUserPrefix = (File)JPService.getProperty(JPLocalUserPrefix.class).getValue();
            this.logger.warn("Could not load global prefix! Use local user Prefix[" + localUserPrefix.getAbsolutePath() + "] instead.");
            return localUserPrefix;
        }
        return new File(globalPrefix);
    }

    @Override
    public String getDescription() {
        return "Set the application prefix, which is used for accessing configurations and storing temporally data.";
    }
}

