/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.registry.lib.com;

import com.google.protobuf.GeneratedMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.openbase.bco.registry.lib.com.SynchronizedRemoteRegistry;
import org.openbase.jps.core.JPService;
import org.openbase.jps.exception.JPServiceException;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InitializationException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.extension.rsb.com.RPCHelper;
import org.openbase.jul.extension.rsb.com.RSBRemote;
import org.openbase.jul.extension.rsb.com.RSBRemoteService;
import org.openbase.jul.extension.rsb.scope.jp.JPScope;
import org.openbase.jul.schedule.FutureProcessor;
import org.openbase.jul.storage.registry.RegistryRemote;
import org.openbase.jul.storage.registry.RemoteRegistry;
import org.slf4j.Logger;
import rsb.Scope;

public abstract class AbstractRegistryRemote<M extends GeneratedMessage>
extends RSBRemoteService<M>
implements RegistryRemote<M> {
    private final Class<? extends JPScope> jpScopePropery;
    private final List<RemoteRegistry> remoteRegistries;

    public AbstractRegistryRemote(Class<? extends JPScope> jpScopePropery, Class<M> dataClass) {
        super(dataClass);
        this.jpScopePropery = jpScopePropery;
        this.remoteRegistries = new ArrayList<RemoteRegistry>();
    }

    public void init() throws InitializationException, InterruptedException {
        try {
            super.init((Scope)((JPScope)JPService.getProperty(this.jpScopePropery)).getValue());
        }
        catch (JPServiceException | CouldNotPerformException ex) {
            throw new InitializationException((Object)this, ex);
        }
    }

    protected void postInit() throws InitializationException, InterruptedException {
        super.postInit();
        try {
            try {
                this.remoteRegistries.clear();
                this.registerRemoteRegistries();
            }
            catch (CouldNotPerformException ex) {
                throw new CouldNotPerformException("Could not activate version control for all internal registries!", (Throwable)ex);
            }
        }
        catch (CouldNotPerformException ex) {
            throw new InitializationException((Object)this, (Throwable)ex);
        }
    }

    public void activate() throws InterruptedException, CouldNotPerformException {
        super.activate();
        for (RemoteRegistry remoteRegistry : this.remoteRegistries) {
            if (!(remoteRegistry instanceof SynchronizedRemoteRegistry)) continue;
            ((SynchronizedRemoteRegistry)remoteRegistry).activate();
        }
    }

    public void deactivate() throws InterruptedException, CouldNotPerformException {
        super.deactivate();
        for (RemoteRegistry remoteRegistry : this.remoteRegistries) {
            if (!(remoteRegistry instanceof SynchronizedRemoteRegistry)) continue;
            ((SynchronizedRemoteRegistry)remoteRegistry).deactivate();
        }
    }

    public void shutdown() {
        super.shutdown();
        this.remoteRegistries.stream().forEach(remoteRegistry -> remoteRegistry.shutdown());
    }

    public Boolean isReady() throws InterruptedException {
        try {
            if (!this.isConnected()) {
                return false;
            }
            this.ping().get();
            return (Boolean)RPCHelper.callRemoteMethod((RSBRemote)this, Boolean.class).get(30000L, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException | TimeoutException | CouldNotPerformException ex) {
            ExceptionPrinter.printHistory((String)"Could not check if registry is ready!", (Throwable)ex, (Logger)this.logger);
            return false;
        }
    }

    public void waitUntilReady() throws InterruptedException, CouldNotPerformException {
        try {
            this.waitForData();
            RPCHelper.callRemoteMethod((RSBRemote)this, Void.class).get();
        }
        catch (CancellationException | ExecutionException | CouldNotPerformException ex) {
            throw new CouldNotPerformException("Could not wait until " + (Object)((Object)this) + " is ready!", ex);
        }
    }

    public Future<Void> waitUntilReadyFuture() {
        try {
            return RPCHelper.callRemoteMethod((RSBRemote)this, Void.class);
        }
        catch (CouldNotPerformException ex) {
            return FutureProcessor.canceledFuture(null, (Exception)((Object)ex));
        }
    }

    protected void registerRemoteRegistry(RemoteRegistry<?, ?, ?> registry) {
        this.remoteRegistries.add(registry);
        registry.setRegistryRemote((RegistryRemote)this);
    }

    protected abstract void registerRemoteRegistries() throws CouldNotPerformException;

    protected List<RemoteRegistry> getRemoteRegistries() {
        return this.remoteRegistries;
    }
}

