/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.registry.lib.com;

import com.google.protobuf.GeneratedMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Future;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.openbase.bco.registry.lib.com.SynchronizedRemoteRegistry;
import org.openbase.jps.core.JPService;
import org.openbase.jps.exception.JPNotAvailableException;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.CouldNotTransformException;
import org.openbase.jul.exception.FatalImplementationErrorException;
import org.openbase.jul.exception.InitializationException;
import org.openbase.jul.exception.InstantiationException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.exception.RejectedException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.exception.printer.LogLevel;
import org.openbase.jul.extension.rsb.com.RPCHelper;
import org.openbase.jul.extension.rsb.com.RSBCommunicationService;
import org.openbase.jul.extension.rsb.iface.RSBLocalServer;
import org.openbase.jul.extension.rsb.scope.ScopeTransformer;
import org.openbase.jul.extension.rsb.scope.jp.JPScope;
import org.openbase.jul.iface.Launchable;
import org.openbase.jul.schedule.GlobalCachedExecutorService;
import org.openbase.jul.schedule.SyncObject;
import org.openbase.jul.storage.file.ProtoBufJSonFileProvider;
import org.openbase.jul.storage.registry.ConsistencyHandler;
import org.openbase.jul.storage.registry.ProtoBufFileSynchronizedRegistry;
import org.openbase.jul.storage.registry.Registry;
import org.openbase.jul.storage.registry.RegistryController;
import org.openbase.jul.storage.registry.RemoteRegistry;
import org.slf4j.Logger;
import rsb.Scope;
import rst.rsb.ScopeType;

public abstract class AbstractRegistryController<M extends GeneratedMessage, MB extends GeneratedMessage.Builder<MB>>
extends RSBCommunicationService<M, MB>
implements RegistryController<M>,
Launchable<ScopeType.Scope> {
    public static final boolean SPARSELY_REGISTRY_DATA_FILTERED = true;
    public static final boolean SPARSELY_REGISTRY_DATA_NOTIFIED = false;
    protected ProtoBufJSonFileProvider protoBufJSonFileProvider = new ProtoBufJSonFileProvider();
    private final SyncObject CHANGE_NOTIFIER = new SyncObject("WaitUntilReadySync");
    private final List<RemoteRegistry> remoteRegistryList;
    private final List<ProtoBufFileSynchronizedRegistry> registryList;
    private final Class<? extends JPScope> jpScopePropery;
    private final boolean filterSparselyRegistryData;
    private final List<Registry> lockedRegistries;
    private final Random randomJitter;
    private final ReentrantReadWriteLock lock;
    private Future notifyChangeFuture;

    public AbstractRegistryController(Class<? extends JPScope> jpScopePropery, MB builder) throws InstantiationException {
        this(jpScopePropery, builder, true);
    }

    public AbstractRegistryController(Class<? extends JPScope> jpScopePropery, MB builder, boolean filterSparselyRegistryData) throws InstantiationException {
        super(builder);
        this.filterSparselyRegistryData = filterSparselyRegistryData;
        this.jpScopePropery = jpScopePropery;
        this.registryList = new ArrayList<ProtoBufFileSynchronizedRegistry>();
        this.remoteRegistryList = new ArrayList<RemoteRegistry>();
        this.protoBufJSonFileProvider = new ProtoBufJSonFileProvider();
        this.randomJitter = new Random();
        this.lockedRegistries = new ArrayList<Registry>();
        this.lock = new ReentrantReadWriteLock();
    }

    public ScopeType.Scope getDefaultConfig() throws NotAvailableException {
        try {
            return ScopeTransformer.transform((Scope)((Scope)((JPScope)JPService.getProperty(this.jpScopePropery)).getValue()));
        }
        catch (JPNotAvailableException | CouldNotTransformException ex) {
            throw new NotAvailableException("DefaultConfig", ex);
        }
    }

    protected void postInit() throws InitializationException, InterruptedException {
        super.postInit();
        try {
            try {
                this.registerRegistries();
            }
            catch (CouldNotPerformException ex) {
                throw new CouldNotPerformException("Could not register all internal registries!", (Throwable)ex);
            }
            try {
                this.registerRemoteRegistries();
            }
            catch (CouldNotPerformException ex) {
                throw new CouldNotPerformException("Could register all remote registries!", (Throwable)ex);
            }
            try {
                this.activateVersionControl();
            }
            catch (CouldNotPerformException ex) {
                throw new CouldNotPerformException("Could not activate version control for all internal registries!", (Throwable)ex);
            }
            try {
                this.loadRegistries();
            }
            catch (CouldNotPerformException ex) {
                throw new CouldNotPerformException("Could not load all internal registries!", (Throwable)ex);
            }
            try {
                this.registerConsistencyHandler();
            }
            catch (CouldNotPerformException ex) {
                throw new CouldNotPerformException("Could not register consistency handler for all internal registries!", (Throwable)ex);
            }
            try {
                this.registerPlugins();
            }
            catch (CouldNotPerformException ex) {
                throw new CouldNotPerformException("Could not register plugins for all internal registries!", (Throwable)ex);
            }
            try {
                this.registerObserver();
            }
            catch (CouldNotPerformException ex) {
                throw new CouldNotPerformException("Could not register observer for all internal registries!", (Throwable)ex);
            }
        }
        catch (CouldNotPerformException ex) {
            throw new InitializationException((Object)this, (Throwable)ex);
        }
    }

    public void activate() throws InterruptedException, CouldNotPerformException {
        try {
            super.activate();
            this.activateRemoteRegistries();
            this.registerDependencies();
            this.performInitialConsistencyCheck();
        }
        catch (CouldNotPerformException ex) {
            throw new CouldNotPerformException("Could not activate location registry!", (Throwable)ex);
        }
    }

    public void deactivate() throws InterruptedException, CouldNotPerformException {
        super.deactivate();
        this.deactivateRemoteRegistries();
        this.removeDependencies();
    }

    public void shutdown() {
        super.shutdown();
        this.remoteRegistryList.stream().forEach(remoteRegistry -> remoteRegistry.shutdown());
        this.registryList.stream().forEach(registry -> registry.shutdown());
    }

    public void registerMethods(RSBLocalServer server) throws CouldNotPerformException {
        RPCHelper.registerInterface(RegistryController.class, (Object)((Object)this), (RSBLocalServer)server);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyChange() throws CouldNotPerformException, InterruptedException {
        try {
            this.syncRegistryFlags();
            if (this.filterSparselyRegistryData) {
                for (ProtoBufFileSynchronizedRegistry registry : this.getRegistries()) {
                    if (!registry.isBusy()) continue;
                    this.scheduleNotifyChangeTask();
                    return;
                }
            }
            if (this.notifyChangeFuture != null && !this.notifyChangeFuture.isDone()) {
                this.notifyChangeFuture.cancel(true);
            }
            this.lockInternalRegistries();
            super.notifyChange();
        }
        finally {
            if (this.lock.isWriteLockedByCurrentThread()) {
                this.unlockInternalRegistries();
            }
            SyncObject syncObject = this.CHANGE_NOTIFIER;
            synchronized (syncObject) {
                this.CHANGE_NOTIFIER.notifyAll();
            }
        }
    }

    private void scheduleNotifyChangeTask() {
        if (this.notifyChangeFuture == null || this.notifyChangeFuture.isDone()) {
            this.notifyChangeFuture = GlobalCachedExecutorService.submit(() -> {
                try {
                    this.waitUntilReady();
                    this.syncRegistryFlags();
                    try {
                        this.lockInternalRegistries();
                        super.notifyChange();
                    }
                    finally {
                        if (this.lock.isWriteLockedByCurrentThread()) {
                            this.unlockInternalRegistries();
                        }
                    }
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
                catch (CouldNotPerformException ex) {
                    this.logger.warn("Could not notify change", (Throwable)ex);
                }
            });
        }
    }

    private void lockInternalRegistries() throws InterruptedException {
        while (!Thread.currentThread().isInterrupted()) {
            boolean success = true;
            if (this.lock.writeLock().tryLock()) {
                for (Registry registry : this.getRegistries()) {
                    try {
                        if (registry.tryLockRegistry()) {
                            this.lockedRegistries.add(registry);
                            continue;
                        }
                        success = false;
                        break;
                    }
                    catch (RejectedException ex) {
                        ExceptionPrinter.printHistory((Throwable)new FatalImplementationErrorException("Internal registry[" + registry + "] not lockable", (Object)this), (Logger)this.logger);
                    }
                }
                if (success) {
                    return;
                }
                this.unlockInternalRegistries();
            }
            Thread.sleep(20 + this.randomJitter.nextInt(30));
        }
    }

    private void unlockInternalRegistries() {
        assert (this.lock.isWriteLockedByCurrentThread());
        this.lockedRegistries.forEach(registry -> registry.unlockRegistry());
        this.lockedRegistries.clear();
        this.lock.writeLock().unlock();
    }

    protected void activateRemoteRegistries() throws CouldNotPerformException, InterruptedException {
        for (RemoteRegistry remoteRegistry : this.remoteRegistryList) {
            if (!(remoteRegistry instanceof SynchronizedRemoteRegistry)) continue;
            ((SynchronizedRemoteRegistry)remoteRegistry).activate();
        }
    }

    protected void deactivateRemoteRegistries() throws CouldNotPerformException, InterruptedException {
        for (RemoteRegistry remoteRegistry : this.remoteRegistryList) {
            if (!(remoteRegistry instanceof SynchronizedRemoteRegistry)) continue;
            ((SynchronizedRemoteRegistry)remoteRegistry).deactivate();
        }
    }

    private void removeDependencies() throws CouldNotPerformException {
        this.registryList.stream().forEach(registry -> registry.removeAllDependencies());
    }

    private void registerObserver() throws CouldNotPerformException {
        this.registryList.stream().forEach(registry -> registry.addObserver((source, data) -> this.notifyChange()));
    }

    private void loadRegistries() throws CouldNotPerformException {
        for (ProtoBufFileSynchronizedRegistry registry : this.registryList) {
            registry.loadRegistry();
        }
    }

    private void activateVersionControl() throws CouldNotPerformException {
        for (ProtoBufFileSynchronizedRegistry registry : this.registryList) {
            Package versionConverterPackage;
            try {
                versionConverterPackage = this.detectVersionConverterPackage();
            }
            catch (NotAvailableException ex) {
                ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Skip version control activation for " + registry + "!", (Throwable)ex), (Logger)this.logger, (LogLevel)LogLevel.WARN);
                continue;
            }
            registry.activateVersionControl(versionConverterPackage);
        }
    }

    private void performInitialConsistencyCheck() throws CouldNotPerformException, InterruptedException {
        for (ProtoBufFileSynchronizedRegistry registry : this.registryList) {
            try {
                this.logger.debug("Trigger inital consistency check of " + registry + " with " + registry.getEntries().size() + " entries.");
                registry.checkConsistency();
            }
            catch (CouldNotPerformException ex) {
                ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Initial consistency check failed!", (Throwable)ex), (Logger)this.logger);
                this.notifyChange();
            }
        }
    }

    protected void registerDependency(Registry dependency, Class messageClass) throws CouldNotPerformException {
        for (ProtoBufFileSynchronizedRegistry registry : this.registryList) {
            registry.registerDependency(dependency);
        }
    }

    protected void registerRegistry(ProtoBufFileSynchronizedRegistry registry) {
        this.registryList.add(registry);
    }

    protected void registerRemoteRegistry(RemoteRegistry registry) {
        this.remoteRegistryList.add(registry);
    }

    protected void registerConsistencyHandler(ConsistencyHandler consistencyHandler, Class messageClass) throws CouldNotPerformException {
        for (ProtoBufFileSynchronizedRegistry registry : this.registryList) {
            if (messageClass.equals(registry.getMessageClass())) {
                registry.registerConsistencyHandler(consistencyHandler);
                continue;
            }
            this.logger.debug("Registration of " + consistencyHandler + " skipped for " + registry + " because " + messageClass.getSimpleName() + " is not compatible.");
        }
    }

    public List<RemoteRegistry> getRemoteRegistries() {
        return this.remoteRegistryList;
    }

    protected List<ProtoBufFileSynchronizedRegistry> getRegistries() {
        return this.registryList;
    }

    private Package detectVersionConverterPackage() throws CouldNotPerformException {
        Package converterPackage;
        try {
            converterPackage = Class.forName(((Object)((Object)this)).getClass().getPackage().getName() + "." + "dbconvert" + ".ConverterPackageIdentifier").getPackage();
        }
        catch (ClassNotFoundException ex) {
            throw new NotAvailableException("ConverterPackage[" + ((Object)((Object)this)).getClass().getPackage().getName() + "." + "dbconvert" + ".ConverterPackageIdentifier]", (Throwable)ex);
        }
        return converterPackage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilReady() throws InterruptedException {
        while (true) {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            SyncObject syncObject = this.CHANGE_NOTIFIER;
            synchronized (syncObject) {
                if (this.isReady().booleanValue()) {
                    return;
                }
                this.CHANGE_NOTIFIER.wait(500L);
            }
        }
    }

    public Future<Void> waitUntilReadyFuture() {
        return GlobalCachedExecutorService.submit(() -> {
            this.waitUntilReady();
            return null;
        });
    }

    public Boolean isReady() {
        return this.registryList.stream().noneMatch(registry -> !registry.isReady());
    }

    protected abstract void registerConsistencyHandler() throws CouldNotPerformException;

    protected abstract void registerPlugins() throws CouldNotPerformException, InterruptedException;

    protected abstract void registerRegistries() throws CouldNotPerformException;

    protected abstract void registerDependencies() throws CouldNotPerformException;

    protected abstract void syncRegistryFlags() throws CouldNotPerformException, InterruptedException;

    protected abstract void registerRemoteRegistries() throws CouldNotPerformException;
}

