/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.registry.lib.com;

import com.google.protobuf.Descriptors;
import com.google.protobuf.GeneratedMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openbase.bco.registry.lib.com.AbstractRegistryRemote;
import org.openbase.bco.registry.lib.com.SynchronizedRemoteRegistry;
import org.openbase.jps.core.JPService;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InitializationException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.extension.protobuf.IdentifiableMessage;
import org.openbase.jul.extension.protobuf.processing.ProtoBufFieldProcessor;
import org.openbase.jul.extension.rsb.scope.jp.JPScope;
import org.openbase.jul.pattern.Observer;
import org.openbase.jul.schedule.SyncObject;
import org.openbase.jul.storage.registry.RegistryRemote;
import org.slf4j.Logger;

public abstract class AbstractVirtualRegistryRemote<M extends GeneratedMessage>
extends AbstractRegistryRemote<M> {
    private final Map<SynchronizedRemoteRegistry, Descriptors.FieldDescriptor> remoteRegistryFieldDescriptorMap;
    private final Map<SynchronizedRemoteRegistry, RegistryRemote<? extends GeneratedMessage>> remoteRegistrySyncMap;
    private final List<RegistryRemote<? extends GeneratedMessage>> registryRemotes;
    private final SyncObject virtualRegistrySyncLock = new SyncObject("RegistryRemoteVirtualSyncLock");
    private final Observer synchronisationObserver;

    public AbstractVirtualRegistryRemote(Class<? extends JPScope> jpScopePropery, Class<M> dataClass) {
        super(jpScopePropery, dataClass);
        this.remoteRegistryFieldDescriptorMap = new HashMap<SynchronizedRemoteRegistry, Descriptors.FieldDescriptor>();
        this.remoteRegistrySyncMap = new HashMap<SynchronizedRemoteRegistry, RegistryRemote<? extends GeneratedMessage>>();
        this.registryRemotes = new ArrayList<RegistryRemote<? extends GeneratedMessage>>();
        this.synchronisationObserver = (source, data1) -> {
            SyncObject syncObject = this.virtualRegistrySyncLock;
            synchronized (syncObject) {
                this.virtualRegistrySyncLock.notifyAll();
            }
        };
    }

    @Override
    protected void postInit() throws InitializationException, InterruptedException {
        super.postInit();
        this.registryRemotes.clear();
        this.registerRegistryRemotes();
        this.bindRegistryRemoteToRemoteRegistries();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void activate() throws InterruptedException, CouldNotPerformException {
        super.activate();
        this.getRemoteRegistries().forEach(remoteRegistry -> remoteRegistry.addObserver(this.synchronisationObserver));
        SyncObject syncObject = this.virtualRegistrySyncLock;
        synchronized (syncObject) {
            this.virtualRegistrySyncLock.notifyAll();
        }
    }

    @Override
    public void deactivate() throws InterruptedException, CouldNotPerformException {
        this.getRemoteRegistries().forEach(remoteRegistry -> remoteRegistry.removeObserver(this.synchronisationObserver));
        super.deactivate();
    }

    protected void registerRegistryRemote(RegistryRemote<? extends GeneratedMessage> registryRemote) {
        this.registryRemotes.add(registryRemote);
    }

    protected abstract void registerRegistryRemotes() throws InitializationException, InterruptedException;

    protected void bindRegistryRemoteToRemoteRegistry(SynchronizedRemoteRegistry remoteRegistry, RegistryRemote<? extends GeneratedMessage> registryRemote, Integer fieldNumber) throws CouldNotPerformException {
        try {
            Descriptors.FieldDescriptor fieldDescriptor = null;
            try {
                fieldDescriptor = ProtoBufFieldProcessor.getFieldDescriptors((Class)registryRemote.getDataClass(), (int[])new int[]{fieldNumber})[0];
            }
            catch (CouldNotPerformException ex) {
                throw new CouldNotPerformException("Invalid field descriptor for [" + registryRemote.getDataClass().getSimpleName() + "]", (Throwable)ex);
            }
            if (!this.registryRemotes.contains(registryRemote)) {
                throw new CouldNotPerformException("Trying to bind to unregistered registryRemote");
            }
            this.remoteRegistryFieldDescriptorMap.put(remoteRegistry, fieldDescriptor);
            this.remoteRegistrySyncMap.put(remoteRegistry, registryRemote);
        }
        catch (CouldNotPerformException ex) {
            throw new CouldNotPerformException("Could not bind fieldNumber[" + fieldNumber + "] of [" + registryRemote.getDataClass().getSimpleName() + "] to remoteRegistry[" + (Object)((Object)remoteRegistry) + "]", (Throwable)ex);
        }
    }

    protected abstract void bindRegistryRemoteToRemoteRegistries();

    public void waitForData() throws CouldNotPerformException, InterruptedException {
        for (RegistryRemote<? extends GeneratedMessage> registryRemote : this.registryRemotes) {
            registryRemote.waitForData();
        }
        super.waitForData();
        this.waitForVirtualRegistrySync();
    }

    @Override
    public Boolean isReady() throws InterruptedException {
        return this.isDataAvailable() && super.isReady() != false;
    }

    public boolean isDataAvailable() {
        for (RegistryRemote<? extends GeneratedMessage> registryRemote : this.registryRemotes) {
            if (registryRemote.isDataAvailable()) continue;
            return false;
        }
        return super.isDataAvailable() && this.isVirtualRegistrySynchronized();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForVirtualRegistrySync() throws InterruptedException {
        SyncObject syncObject = this.virtualRegistrySyncLock;
        synchronized (syncObject) {
            while (!this.isVirtualRegistrySynchronized()) {
                this.virtualRegistrySyncLock.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isVirtualRegistrySynchronized() {
        SyncObject syncObject = this.virtualRegistrySyncLock;
        synchronized (syncObject) {
            for (SynchronizedRemoteRegistry remoteRegistry : this.remoteRegistrySyncMap.keySet()) {
                try {
                    int remoteRegistryMessageCount;
                    ArrayList registryRemoteMessageList = new ArrayList((List)((GeneratedMessage)this.remoteRegistrySyncMap.get((Object)remoteRegistry).getData()).getField(this.remoteRegistryFieldDescriptorMap.get((Object)remoteRegistry)));
                    List registryRemoteFilteredMessageList = remoteRegistry.getFilter().filter(registryRemoteMessageList);
                    int registryRemoteMessageCount = registryRemoteMessageList.size();
                    int registryRemoteFilteredMessageCount = registryRemoteFilteredMessageList.size();
                    if (JPService.testMode() && registryRemoteMessageCount != registryRemoteFilteredMessageCount) {
                        this.logger.info((Object)((Object)this) + " has a been filtered for Field[" + this.remoteRegistryFieldDescriptorMap.get((Object)remoteRegistry).getName() + "] from " + registryRemoteMessageCount + " to " + registryRemoteFilteredMessageCount);
                        for (Object message : registryRemoteMessageList) {
                            if (registryRemoteFilteredMessageList.contains(message)) continue;
                            this.logger.info("Filtered Message[" + new IdentifiableMessage((GeneratedMessage)message).generateMessageDescription() + "] because permission was denied.");
                        }
                    }
                    if (registryRemoteFilteredMessageCount == (remoteRegistryMessageCount = remoteRegistry.getMessages().size())) continue;
                    if (JPService.testMode()) {
                        this.logger.info("MessageCount for [" + (Object)((Object)remoteRegistry) + "] is not correct. Expected " + registryRemoteFilteredMessageCount + " but is " + remoteRegistryMessageCount);
                        for (Object message : registryRemoteFilteredMessageList) {
                            if (remoteRegistry.getMessages().contains(message)) continue;
                            this.logger.info("Message[" + new IdentifiableMessage((GeneratedMessage)message).generateMessageDescription() + "] was not synchronized from the registry remote into the internal remote registry!");
                        }
                        for (Object message : remoteRegistry.getMessages()) {
                            if (registryRemoteFilteredMessageList.contains(message)) continue;
                            this.logger.info("Message[" + new IdentifiableMessage((GeneratedMessage)message).generateMessageDescription() + "] was not removed form the internal remote registry!");
                        }
                    }
                    return false;
                }
                catch (CouldNotPerformException ex) {
                    ExceptionPrinter.printHistory((String)"Could not check if registries contains the same amount of entries!", (Throwable)ex, (Logger)this.logger);
                    return false;
                }
            }
            return true;
        }
    }
}

