/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.registry.lib.com;

import com.google.protobuf.GeneratedMessage;
import java.util.ArrayList;
import java.util.List;
import org.openbase.bco.registry.lib.com.AbstractRegistryController;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InitializationException;
import org.openbase.jul.exception.InstantiationException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.extension.protobuf.ClosableDataBuilder;
import org.openbase.jul.extension.rsb.scope.jp.JPScope;
import org.openbase.jul.pattern.Observable;
import org.openbase.jul.pattern.Observer;
import org.openbase.jul.storage.registry.RegistryRemote;
import org.slf4j.Logger;

public abstract class AbstractVirtualRegistryController<M extends GeneratedMessage, MB extends GeneratedMessage.Builder<MB>, RM>
extends AbstractRegistryController<M, MB> {
    private final VirtualRegistrySynchronizer virtualRegistrySynchronizer = new VirtualRegistrySynchronizer();
    private final List<RegistryRemote> registryRemoteList = new ArrayList<RegistryRemote>();

    public AbstractVirtualRegistryController(Class<? extends JPScope> jpScopePropery, MB builder) throws InstantiationException {
        super(jpScopePropery, builder);
    }

    public AbstractVirtualRegistryController(Class<? extends JPScope> jpScopePropery, MB builder, boolean filterSparselyRegistryData) throws InstantiationException {
        super(jpScopePropery, builder, filterSparselyRegistryData);
    }

    @Override
    protected void postInit() throws InitializationException, InterruptedException {
        super.postInit();
        try {
            try {
                this.registerRegistryRemotes();
            }
            catch (CouldNotPerformException ex) {
                throw new CouldNotPerformException("Could not register all registry remotes!", (Throwable)ex);
            }
        }
        catch (CouldNotPerformException ex) {
            throw new InitializationException((Object)this, (Throwable)ex);
        }
    }

    @Override
    protected void registerConsistencyHandler() throws CouldNotPerformException {
    }

    @Override
    protected void registerDependencies() throws CouldNotPerformException {
    }

    @Override
    protected void syncRegistryFlags() throws CouldNotPerformException, InterruptedException {
    }

    @Override
    protected void registerRegistries() throws CouldNotPerformException {
    }

    @Override
    protected void registerPlugins() throws CouldNotPerformException, InterruptedException {
    }

    @Override
    protected void activateRemoteRegistries() throws CouldNotPerformException, InterruptedException {
        super.activateRemoteRegistries();
        this.getRegistryRemotes().forEach(registryRemote -> registryRemote.addDataObserver((Observer)this.virtualRegistrySynchronizer));
    }

    @Override
    protected void deactivateRemoteRegistries() throws CouldNotPerformException, InterruptedException {
        this.getRegistryRemotes().forEach(registryRemote -> registryRemote.removeDataObserver((Observer)this.virtualRegistrySynchronizer));
        super.deactivateRemoteRegistries();
    }

    protected void registerRegistryRemote(RegistryRemote registry) {
        this.registryRemoteList.add(registry);
    }

    protected List<RegistryRemote> getRegistryRemotes() {
        return this.registryRemoteList;
    }

    protected abstract void registerRegistryRemotes() throws CouldNotPerformException;

    protected abstract void syncVirtualRegistryFields(MB var1, RM var2) throws CouldNotPerformException;

    class VirtualRegistrySynchronizer
    implements Observer<RM> {
        VirtualRegistrySynchronizer() {
        }

        public void update(Observable<RM> source, RM realData) throws Exception {
            try {
                try (ClosableDataBuilder dataBuilder = AbstractVirtualRegistryController.this.getDataBuilder(this);){
                    AbstractVirtualRegistryController.this.syncVirtualRegistryFields(dataBuilder.getInternalBuilder(), realData);
                }
                catch (Exception ex) {
                    throw new CouldNotPerformException("Could not apply data change!", (Throwable)ex);
                }
            }
            catch (CouldNotPerformException ex) {
                ExceptionPrinter.printHistory((String)"Could not sync virtual registry!", (Throwable)ex, (Logger)AbstractVirtualRegistryController.this.logger);
            }
        }
    }
}

