/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.registry.lib.com;

import com.google.protobuf.GeneratedMessage;
import java.util.ArrayList;
import java.util.List;
import org.openbase.bco.registry.lib.com.SynchronizedRemoteRegistry;
import org.openbase.jps.core.JPService;
import org.openbase.jps.exception.JPNotAvailableException;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.CouldNotTransformException;
import org.openbase.jul.exception.InitializationException;
import org.openbase.jul.exception.InstantiationException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.exception.printer.LogLevel;
import org.openbase.jul.extension.rsb.com.RSBCommunicationService;
import org.openbase.jul.extension.rsb.scope.ScopeTransformer;
import org.openbase.jul.extension.rsb.scope.jp.JPScope;
import org.openbase.jul.iface.Launchable;
import org.openbase.jul.schedule.SyncObject;
import org.openbase.jul.storage.file.ProtoBufJSonFileProvider;
import org.openbase.jul.storage.registry.ConsistencyHandler;
import org.openbase.jul.storage.registry.ProtoBufFileSynchronizedRegistry;
import org.openbase.jul.storage.registry.Registry;
import org.openbase.jul.storage.registry.RegistryController;
import org.openbase.jul.storage.registry.RegistryRemote;
import org.openbase.jul.storage.registry.RemoteRegistry;
import org.slf4j.Logger;
import rsb.Scope;
import rst.rsb.ScopeType;

public abstract class AbstractRegistryController<M extends GeneratedMessage, MB extends GeneratedMessage.Builder<MB>>
extends RSBCommunicationService<M, MB>
implements RegistryController<M>,
Launchable<ScopeType.Scope> {
    public static final boolean SPARSELY_REGISTRY_DATA_FILTERED = true;
    public static final boolean SPARSELY_REGISTRY_DATA_NOTIFIED = false;
    protected ProtoBufJSonFileProvider protoBufJSonFileProvider = new ProtoBufJSonFileProvider();
    private final SyncObject CHANGE_NOTIFIER = new SyncObject("WaitUntilReadySync");
    private final List<RegistryRemote> registryRemoteList;
    private final List<RemoteRegistry> remoteRegistryList;
    private final List<ProtoBufFileSynchronizedRegistry> registryList;
    private final Class<? extends JPScope> jpScopePropery;
    private final boolean filterSparselyRegistryData;

    public AbstractRegistryController(Class<? extends JPScope> jpScopePropery, MB builder) throws InstantiationException {
        this(jpScopePropery, builder, true);
    }

    public AbstractRegistryController(Class<? extends JPScope> jpScopePropery, MB builder, boolean filterSparselyRegistryData) throws InstantiationException {
        super(builder);
        this.filterSparselyRegistryData = filterSparselyRegistryData;
        this.jpScopePropery = jpScopePropery;
        this.registryRemoteList = new ArrayList<RegistryRemote>();
        this.registryList = new ArrayList<ProtoBufFileSynchronizedRegistry>();
        this.remoteRegistryList = new ArrayList<RemoteRegistry>();
        this.protoBufJSonFileProvider = new ProtoBufJSonFileProvider();
    }

    public ScopeType.Scope getDefaultConfig() throws NotAvailableException {
        try {
            return ScopeTransformer.transform((Scope)((Scope)((JPScope)JPService.getProperty(this.jpScopePropery)).getValue()));
        }
        catch (JPNotAvailableException | CouldNotTransformException ex) {
            throw new NotAvailableException("DefaultConfig", ex);
        }
    }

    protected void postInit() throws InitializationException, InterruptedException {
        super.postInit();
        try {
            try {
                this.registerRegistries();
            }
            catch (CouldNotPerformException ex) {
                throw new CouldNotPerformException("Could not register all internal registries!", (Throwable)ex);
            }
            try {
                this.registerRegistryRemotes();
            }
            catch (CouldNotPerformException ex) {
                throw new CouldNotPerformException("Could not register all registry remotes!", (Throwable)ex);
            }
            try {
                this.registerRemoteRegistries();
            }
            catch (CouldNotPerformException ex) {
                throw new CouldNotPerformException("Could register all remote registries!", (Throwable)ex);
            }
            try {
                this.initRemoteRegistries();
            }
            catch (CouldNotPerformException ex) {
                throw new CouldNotPerformException("Could not init all remote registries!", (Throwable)ex);
            }
            try {
                this.activateVersionControl();
            }
            catch (CouldNotPerformException ex) {
                throw new CouldNotPerformException("Could not activate version control for all internal registries!", (Throwable)ex);
            }
            try {
                this.loadRegistries();
            }
            catch (CouldNotPerformException ex) {
                throw new CouldNotPerformException("Could not load all internal registries!", (Throwable)ex);
            }
            try {
                this.registerConsistencyHandler();
            }
            catch (CouldNotPerformException ex) {
                throw new CouldNotPerformException("Could not register consistency handler for all internal registries!", (Throwable)ex);
            }
            try {
                this.registerPlugins();
            }
            catch (CouldNotPerformException ex) {
                throw new CouldNotPerformException("Could not register plugins for all internal registries!", (Throwable)ex);
            }
            try {
                this.registerObserver();
            }
            catch (CouldNotPerformException ex) {
                throw new CouldNotPerformException("Could not register observer for all internal registries!", (Throwable)ex);
            }
        }
        catch (CouldNotPerformException ex) {
            throw new InitializationException((Object)this, (Throwable)ex);
        }
    }

    public void activate() throws InterruptedException, CouldNotPerformException {
        try {
            super.activate();
            this.activateRemoteRegistries();
            this.activateRegistryRemotes();
            this.registerDependencies();
            this.performInitialConsistencyCheck();
        }
        catch (CouldNotPerformException ex) {
            throw new CouldNotPerformException("Could not activate location registry!", (Throwable)ex);
        }
    }

    public void deactivate() throws InterruptedException, CouldNotPerformException {
        super.deactivate();
        this.deactivateRemoteRegistries();
        this.deactivateRegistryRemotes();
        this.removeDependencies();
    }

    public void shutdown() {
        super.shutdown();
        this.registryRemoteList.stream().forEach(remote -> remote.shutdown());
        this.remoteRegistryList.stream().forEach(remoteRegistry -> remoteRegistry.shutdown());
        this.registryList.stream().forEach(registry -> registry.shutdown());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyChange() throws CouldNotPerformException, InterruptedException {
        if (this.filterSparselyRegistryData) {
            for (ProtoBufFileSynchronizedRegistry registry : this.getRegistries()) {
                if (!registry.isBusy()) continue;
                return;
            }
        }
        this.syncRegistryFlags();
        super.notifyChange();
        SyncObject syncObject = this.CHANGE_NOTIFIER;
        synchronized (syncObject) {
            this.CHANGE_NOTIFIER.notify();
        }
    }

    private void initRemoteRegistries() throws CouldNotPerformException, InterruptedException {
        for (RegistryRemote remote : this.registryRemoteList) {
            remote.init();
        }
    }

    protected void activateRemoteRegistries() throws CouldNotPerformException, InterruptedException {
        for (RemoteRegistry remoteRegistry : this.remoteRegistryList) {
            if (!(remoteRegistry instanceof SynchronizedRemoteRegistry)) continue;
            ((SynchronizedRemoteRegistry)remoteRegistry).activate();
        }
    }

    private void activateRegistryRemotes() throws CouldNotPerformException, InterruptedException {
        for (RegistryRemote remote : this.registryRemoteList) {
            remote.activate();
        }
        for (RegistryRemote remote : this.registryRemoteList) {
            remote.waitForData();
        }
    }

    private void deactivateRemoteRegistries() throws CouldNotPerformException, InterruptedException {
        for (RemoteRegistry remoteRegistry : this.remoteRegistryList) {
            if (!(remoteRegistry instanceof SynchronizedRemoteRegistry)) continue;
            ((SynchronizedRemoteRegistry)remoteRegistry).deactivate();
        }
    }

    protected void deactivateRegistryRemotes() throws CouldNotPerformException, InterruptedException {
        for (RegistryRemote remote : this.registryRemoteList) {
            remote.deactivate();
        }
    }

    private void removeDependencies() throws CouldNotPerformException {
        this.registryList.stream().forEach(registry -> registry.removeAllDependencies());
    }

    private void registerObserver() throws CouldNotPerformException {
        this.registryList.stream().forEach(registry -> registry.addObserver((source, data) -> this.notifyChange()));
    }

    private void loadRegistries() throws CouldNotPerformException {
        for (ProtoBufFileSynchronizedRegistry registry : this.registryList) {
            registry.loadRegistry();
        }
    }

    private void activateVersionControl() throws CouldNotPerformException {
        for (ProtoBufFileSynchronizedRegistry registry : this.registryList) {
            Package versionConverterPackage;
            try {
                versionConverterPackage = this.detectVersionConverterPackage();
            }
            catch (NotAvailableException ex) {
                ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Skip version control activation for " + registry + "!", (Throwable)ex), (Logger)this.logger, (LogLevel)LogLevel.WARN);
                continue;
            }
            registry.activateVersionControl(versionConverterPackage);
        }
    }

    private void performInitialConsistencyCheck() throws CouldNotPerformException, InterruptedException {
        for (ProtoBufFileSynchronizedRegistry registry : this.registryList) {
            try {
                this.logger.debug("Trigger inital consistency check of " + registry + " with " + registry.getEntries().size() + " entries.");
                registry.checkConsistency();
            }
            catch (CouldNotPerformException ex) {
                ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Initial consistency check failed!", (Throwable)ex), (Logger)this.logger);
                this.notifyChange();
            }
        }
    }

    protected void registerDependency(Registry dependency, Class messageClass) throws CouldNotPerformException {
        for (ProtoBufFileSynchronizedRegistry registry : this.registryList) {
            registry.registerDependency(dependency);
        }
    }

    protected void registerRegistryRemote(RegistryRemote registry) {
        this.registryRemoteList.add(registry);
    }

    protected void registerRegistry(ProtoBufFileSynchronizedRegistry registry) {
        this.registryList.add(registry);
    }

    protected void registerRemoteRegistry(RemoteRegistry registry) {
        this.remoteRegistryList.add(registry);
    }

    protected void registerConsistencyHandler(ConsistencyHandler consistencyHandler, Class messageClass) throws CouldNotPerformException {
        for (ProtoBufFileSynchronizedRegistry registry : this.registryList) {
            if (messageClass.equals(registry.getMessageClass())) {
                registry.registerConsistencyHandler(consistencyHandler);
                continue;
            }
            this.logger.debug("Register of " + consistencyHandler + " skipped for " + registry + " because " + messageClass.getSimpleName() + " is not compatible.");
        }
    }

    protected List<RegistryRemote> getRegistryRemotes() {
        return this.registryRemoteList;
    }

    public List<RemoteRegistry> getRemoteRegistries() {
        return this.remoteRegistryList;
    }

    protected List<ProtoBufFileSynchronizedRegistry> getRegistries() {
        return this.registryList;
    }

    private Package detectVersionConverterPackage() throws CouldNotPerformException {
        Package converterPackage;
        try {
            converterPackage = Class.forName(((Object)((Object)this)).getClass().getPackage().getName() + "." + "dbconvert" + ".ConverterPackageIdentifier").getPackage();
        }
        catch (ClassNotFoundException ex) {
            throw new NotAvailableException("ConverterPackage[" + ((Object)((Object)this)).getClass().getPackage().getName() + "." + "dbconvert" + ".ConverterPackageIdentifier" + "]", (Throwable)ex);
        }
        return converterPackage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilReady() throws InterruptedException {
        while (true) {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            SyncObject syncObject = this.CHANGE_NOTIFIER;
            synchronized (syncObject) {
                if (this.isReady().booleanValue()) {
                    return;
                }
                this.CHANGE_NOTIFIER.wait();
            }
        }
    }

    public Boolean isReady() throws InterruptedException {
        for (ProtoBufFileSynchronizedRegistry protoBufFileSynchronizedRegistry : this.registryList) {
            if (protoBufFileSynchronizedRegistry.isReady()) continue;
            return false;
        }
        for (RegistryRemote registryRemote : this.registryRemoteList) {
            if (registryRemote.isReady().booleanValue()) continue;
            return false;
        }
        return true;
    }

    protected abstract void registerConsistencyHandler() throws CouldNotPerformException;

    protected abstract void registerPlugins() throws CouldNotPerformException, InterruptedException;

    protected abstract void registerRegistryRemotes() throws CouldNotPerformException;

    protected abstract void registerRegistries() throws CouldNotPerformException;

    protected abstract void registerDependencies() throws CouldNotPerformException;

    protected abstract void syncRegistryFlags() throws CouldNotPerformException, InterruptedException;

    protected abstract void registerRemoteRegistries() throws CouldNotPerformException;
}

