/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.registry.lib.launch;

import java.util.List;
import org.openbase.bco.registry.lib.com.AbstractRegistryController;
import org.openbase.bco.registry.lib.launch.AbstractLauncher;
import org.openbase.jps.core.JPService;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InstantiationException;
import org.openbase.jul.exception.InvalidStateException;
import org.openbase.jul.exception.MultiException;
import org.openbase.jul.exception.VerificationFailedException;
import org.openbase.jul.storage.registry.RemoteRegistry;

public abstract class AbstractRegistryLauncher<L extends AbstractRegistryController>
extends AbstractLauncher<L> {
    public AbstractRegistryLauncher(Class applicationClass, Class<L> launchableClass) throws InstantiationException {
        super(applicationClass, launchableClass);
    }

    @Override
    public void verify() throws VerificationFailedException, InterruptedException {
        MultiException.ExceptionStack exceptionStack = null;
        List<RemoteRegistry> remoteRegistries = ((AbstractRegistryController)((Object)this.getLaunchable())).getRemoteRegistries();
        for (RemoteRegistry registry : remoteRegistries) {
            if (registry.isConsistent()) continue;
            exceptionStack = MultiException.push(this.getLaunchable(), (Exception)new VerificationFailedException(registry.getName() + " started in read only mode!", (Throwable)new InvalidStateException("Registry not consistent!")), exceptionStack);
        }
        try {
            MultiException.checkAndThrow((String)(JPService.getApplicationName() + " started in fallback mode!"), exceptionStack);
        }
        catch (CouldNotPerformException ex) {
            throw new VerificationFailedException((Throwable)ex);
        }
    }
}

