/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.registry.lib.launch;

import com.google.protobuf.GeneratedMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.openbase.bco.registry.lib.launch.jp.JPExcludeLauncher;
import org.openbase.bco.registry.lib.launch.jp.JPPrintLauncher;
import org.openbase.jps.core.JPService;
import org.openbase.jps.exception.JPNotAvailableException;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InitializationException;
import org.openbase.jul.exception.InstantiationException;
import org.openbase.jul.exception.MultiException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.exception.VerificationFailedException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.exception.printer.LogLevel;
import org.openbase.jul.extension.rsb.com.AbstractIdentifiableController;
import org.openbase.jul.extension.rsb.com.RPCHelper;
import org.openbase.jul.extension.rsb.iface.RSBLocalServer;
import org.openbase.jul.extension.rsb.scope.ScopeGenerator;
import org.openbase.jul.iface.Launchable;
import org.openbase.jul.iface.Shutdownable;
import org.openbase.jul.iface.VoidInitializable;
import org.openbase.jul.iface.provider.NameProvider;
import org.openbase.jul.pattern.Launcher;
import org.openbase.jul.processing.StringProcessor;
import org.openbase.jul.schedule.GlobalCachedExecutorService;
import org.openbase.jul.schedule.SyncObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rst.domotic.state.ActivationStateType;

public abstract class AbstractLauncher<L extends Launchable>
extends AbstractIdentifiableController<ActivationStateType.ActivationState, ActivationStateType.ActivationState.Builder>
implements Launcher,
VoidInitializable,
NameProvider {
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    public static final long LAUNCHER_TIMEOUT = 60000L;
    public static final String SCOPE_PREFIX_LAUNCHER = "/launcher";
    private final Class<L> launchableClass;
    private final Class applicationClass;
    private L launchable;
    private long launchTime = -1L;
    private LauncherState state;
    private boolean verified;
    private VerificationFailedException verificationFailedException;
    private final SyncObject LAUNCHER_LOCK = new SyncObject((Object)this);

    public AbstractLauncher(Class applicationClass, Class<L> launchableClass) throws InstantiationException {
        super((GeneratedMessage.Builder)ActivationStateType.ActivationState.newBuilder());
        this.launchableClass = launchableClass;
        this.applicationClass = applicationClass;
        Shutdownable.registerShutdownHook((Shutdownable)this);
    }

    public void init() throws InitializationException, InterruptedException {
        try {
            super.init("/launcher/" + ScopeGenerator.convertIntoValidScopeComponent((String)this.getName()));
        }
        catch (NotAvailableException ex) {
            throw new InitializationException((Object)this, (Throwable)ex);
        }
    }

    public void registerMethods(RSBLocalServer server) throws CouldNotPerformException {
        RPCHelper.registerInterface(Launcher.class, (Object)((Object)this), (RSBLocalServer)server);
    }

    public L getLaunchable() {
        return this.launchable;
    }

    public String getName() throws NotAvailableException {
        return this.applicationClass.getSimpleName();
    }

    protected L instantiateLaunchable() throws CouldNotPerformException {
        try {
            return (L)((Launchable)this.launchableClass.newInstance());
        }
        catch (IllegalAccessException | java.lang.InstantiationException ex) {
            throw new CouldNotPerformException("Could not load launchable class!", (Throwable)ex);
        }
    }

    protected abstract void loadProperties();

    protected void verify() throws VerificationFailedException, InterruptedException {
    }

    private void setState(LauncherState state) {
        this.state = state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void launch() throws CouldNotPerformException, InterruptedException {
        SyncObject syncObject = this.LAUNCHER_LOCK;
        synchronized (syncObject) {
            this.setState(LauncherState.INITALIZING);
            this.launchable = this.instantiateLaunchable();
            try {
                this.launchable.init();
                this.setState(LauncherState.LAUNCHING);
                this.launchable.activate();
                this.launchTime = System.currentTimeMillis();
                this.setState(LauncherState.RUNNING);
                try {
                    this.verify();
                    this.verified = true;
                }
                catch (VerificationFailedException ex) {
                    this.verified = false;
                    this.verificationFailedException = ex;
                }
            }
            catch (CouldNotPerformException ex) {
                this.setState(LauncherState.ERROR);
                this.launchable.shutdown();
                throw new CouldNotPerformException("Could not launch " + this.getName(), (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void relaunch() throws CouldNotPerformException, InterruptedException {
        SyncObject syncObject = this.LAUNCHER_LOCK;
        synchronized (syncObject) {
            this.stop();
            this.launch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        SyncObject syncObject = this.LAUNCHER_LOCK;
        synchronized (syncObject) {
            this.setState(LauncherState.STOPPING);
            if (this.launchable != null) {
                this.launchable.shutdown();
            }
            this.setState(LauncherState.STOPPED);
        }
    }

    public void shutdown() {
        this.stop();
        super.shutdown();
    }

    public long getUpTime() {
        if (this.launchTime < 0L) {
            return 0L;
        }
        return System.currentTimeMillis() - this.launchTime;
    }

    public long getLaunchTime() {
        return this.launchTime;
    }

    public boolean isVerified() {
        return this.verified;
    }

    public VerificationFailedException getVerificationFailedCause() {
        return this.verificationFailedException;
    }

    public static void main(String[] args, Class application, Class<? extends AbstractLauncher> ... launchers) {
        Logger logger = LoggerFactory.getLogger(Launcher.class);
        JPService.setApplicationName((Class)application);
        MultiException.ExceptionStack errorExceptionStack = null;
        MultiException.ExceptionStack verificationExceptionStack = null;
        HashMap<Class<? extends AbstractLauncher>, AbstractLauncher> launcherMap = new HashMap<Class<? extends AbstractLauncher>, AbstractLauncher>();
        for (Class<? extends AbstractLauncher> launcherClass : launchers) {
            try {
                launcherMap.put(launcherClass, launcherClass.newInstance());
            }
            catch (IllegalAccessException | java.lang.InstantiationException ex) {
                errorExceptionStack = MultiException.push((Object)application, (Exception)((Object)new CouldNotPerformException("Could not load launcher class!", (Throwable)ex)), errorExceptionStack);
            }
        }
        for (AbstractLauncher launcher : launcherMap.values()) {
            launcher.loadProperties();
        }
        JPService.registerProperty(JPPrintLauncher.class);
        JPService.registerProperty(JPExcludeLauncher.class);
        JPService.parseAndExitOnError((String[])args);
        try {
            if (((Boolean)((JPPrintLauncher)JPService.getProperty(JPPrintLauncher.class)).getValue()).booleanValue()) {
                if (launcherMap.isEmpty()) {
                    System.out.println(JPService.getApplicationName() + " does not provide any launcher!");
                    System.exit(255);
                }
                System.out.println("Available launcher:");
                System.out.println("");
                int maxLauncherNameSize = 0;
                for (Map.Entry launcherEntry : launcherMap.entrySet()) {
                    maxLauncherNameSize = Math.max(maxLauncherNameSize, ((Class)launcherEntry.getKey()).getSimpleName().length());
                }
                for (Map.Entry launcherEntry : launcherMap.entrySet()) {
                    System.out.println("\t\u2022 " + StringProcessor.fillWithSpaces((String)((Class)launcherEntry.getKey()).getSimpleName(), (int)maxLauncherNameSize) + "  \u22b3  " + ((Class)launcherEntry.getKey()).getName());
                }
                System.out.println("");
                System.exit(0);
            }
        }
        catch (JPNotAvailableException ex) {
            ExceptionPrinter.printHistory((String)"Could not check if launcher should be printed.", (Throwable)ex, (Logger)logger);
        }
        logger.info("Start " + JPService.getApplicationName() + "...");
        HashMap launchableFutureMap = new HashMap();
        try {
            for (final Map.Entry launcherEntry : launcherMap.entrySet()) {
                boolean exclude = false;
                try {
                    for (String exclusionPatter : (List)((JPExcludeLauncher)JPService.getProperty(JPExcludeLauncher.class)).getValue()) {
                        if (!((Class)launcherEntry.getKey()).getName().toLowerCase().contains(exclusionPatter.toLowerCase())) continue;
                        exclude = true;
                    }
                }
                catch (JPNotAvailableException ex) {
                    ExceptionPrinter.printHistory((String)"Could not process launcher exclusion!", (Throwable)ex, (Logger)logger);
                }
                if (exclude) {
                    logger.info(((Class)launcherEntry.getKey()).getSimpleName() + " excluded from execution.");
                    continue;
                }
                launchableFutureMap.put(launcherEntry, GlobalCachedExecutorService.submit((Callable)new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        ((AbstractLauncher)((Object)launcherEntry.getValue())).launch();
                        return null;
                    }
                }));
            }
            while (!Thread.interrupted() && !launchableFutureMap.isEmpty()) {
                for (Map.Entry launcherEntry : new ArrayList(launchableFutureMap.entrySet())) {
                    try {
                        ((Future)launcherEntry.getValue()).get(60000L, TimeUnit.MILLISECONDS);
                        if (!((AbstractLauncher)((Object)((Map.Entry)launcherEntry.getKey()).getValue())).isVerified()) {
                            verificationExceptionStack = MultiException.push((Object)application, (Exception)((Object)new CouldNotPerformException("Could not verify " + ((Class)((Map.Entry)launcherEntry.getKey()).getKey()).getSimpleName() + "!", (Throwable)((AbstractLauncher)((Object)((Map.Entry)launcherEntry.getKey()).getValue())).getVerificationFailedCause())), verificationExceptionStack);
                        }
                        launchableFutureMap.remove(launcherEntry.getKey());
                    }
                    catch (InterruptedException ex) {
                        throw ex;
                    }
                    catch (TimeoutException ex) {
                        ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Launcher " + ((Class)((Map.Entry)launcherEntry.getKey()).getKey()).getSimpleName() + " startup delay detected!"), (Logger)logger, (LogLevel)LogLevel.WARN);
                    }
                    catch (Exception ex) {
                        launchableFutureMap.remove(launcherEntry.getKey());
                        errorExceptionStack = MultiException.push((Object)application, (Exception)((Object)new CouldNotPerformException("Could not launch " + ((Class)((Map.Entry)launcherEntry.getKey()).getKey()).getSimpleName() + "!", (Throwable)ex)), (MultiException.ExceptionStack)errorExceptionStack);
                    }
                }
            }
        }
        catch (InterruptedException ex) {
            ExceptionPrinter.printHistoryAndExit((String)(JPService.getApplicationName() + " catched shutdown signal during startup phase!"), (Throwable)ex, (Logger)logger);
        }
        try {
            MultiException.ExceptionStack exceptionStack = null;
            try {
                MultiException.checkAndThrow((String)"Errors during startup phase!", (MultiException.ExceptionStack)errorExceptionStack);
            }
            catch (MultiException ex) {
                exceptionStack = MultiException.push((Object)application, (Exception)((Object)ex), exceptionStack);
            }
            try {
                MultiException.checkAndThrow((String)"Cause detections during startup phase!", verificationExceptionStack);
            }
            catch (MultiException ex) {
                exceptionStack = MultiException.push((Object)application, (Exception)((Object)ex), (MultiException.ExceptionStack)exceptionStack);
            }
            MultiException.checkAndThrow((String)(JPService.getApplicationName() + " was started with restrictions!"), (MultiException.ExceptionStack)exceptionStack);
            logger.info(JPService.getApplicationName() + " successfully started.");
        }
        catch (MultiException ex) {
            ExceptionPrinter.printHistory((Throwable)ex, (Logger)logger);
        }
    }

    public static enum LauncherState {
        INITALIZING,
        LAUNCHING,
        RUNNING,
        STOPPING,
        STOPPED,
        ERROR;

    }
}

