/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.registry.lib.com;

import com.google.protobuf.GeneratedMessage;
import java.util.ArrayList;
import java.util.List;
import org.openbase.bco.registry.lib.com.SynchronizedRemoteRegistry;
import org.openbase.jps.core.JPService;
import org.openbase.jps.exception.JPServiceException;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InitializationException;
import org.openbase.jul.extension.rsb.com.RSBRemoteService;
import org.openbase.jul.extension.rsb.scope.jp.JPScope;
import org.openbase.jul.pattern.Remote;
import org.openbase.jul.storage.registry.RegistryRemote;
import org.openbase.jul.storage.registry.RemoteRegistry;
import rsb.Scope;

public abstract class AbstractRegistryRemote<M extends GeneratedMessage>
extends RSBRemoteService<M>
implements RegistryRemote<M> {
    private final Class<? extends JPScope> jpScopePropery;
    private final List<RemoteRegistry> remoteRegistries;

    public AbstractRegistryRemote(Class<? extends JPScope> jpScopePropery, Class<M> dataClass) {
        super(dataClass);
        this.jpScopePropery = jpScopePropery;
        this.remoteRegistries = new ArrayList<RemoteRegistry>();
    }

    public void init() throws InitializationException, InterruptedException {
        try {
            super.init((Scope)((JPScope)JPService.getProperty(this.jpScopePropery)).getValue());
        }
        catch (JPServiceException | CouldNotPerformException ex) {
            throw new InitializationException((Object)this, ex);
        }
    }

    protected void postInit() throws InitializationException, InterruptedException {
        super.postInit();
        try {
            try {
                this.registerRemoteRegistries();
            }
            catch (CouldNotPerformException ex) {
                throw new CouldNotPerformException("Could not activate version control for all internal registries!", (Throwable)ex);
            }
        }
        catch (CouldNotPerformException ex) {
            throw new InitializationException((Object)this, (Throwable)ex);
        }
    }

    public void activate() throws InterruptedException, CouldNotPerformException {
        super.activate();
        for (RemoteRegistry remoteRegistry : this.remoteRegistries) {
            if (!(remoteRegistry instanceof SynchronizedRemoteRegistry)) continue;
            ((SynchronizedRemoteRegistry)remoteRegistry).activate();
        }
    }

    public void deactivate() throws InterruptedException, CouldNotPerformException {
        super.deactivate();
        for (RemoteRegistry remoteRegistry : this.remoteRegistries) {
            if (!(remoteRegistry instanceof SynchronizedRemoteRegistry)) continue;
            ((SynchronizedRemoteRegistry)remoteRegistry).deactivate();
        }
    }

    public void shutdown() {
        try {
            this.remoteRegistries.stream().forEach(remoteRegistry -> remoteRegistry.shutdown());
        }
        finally {
            super.shutdown();
        }
    }

    protected void registerRemoteRegistry(RemoteRegistry registry) {
        this.remoteRegistries.add(registry);
        registry.setRemote((Remote)this);
    }

    protected abstract void registerRemoteRegistries() throws CouldNotPerformException;
}

