/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.registry.lib.launch;

import com.google.protobuf.GeneratedMessage;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.openbase.jps.core.JPService;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InitializationException;
import org.openbase.jul.exception.InstantiationException;
import org.openbase.jul.exception.MultiException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.exception.VerificationFailedException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.extension.rsb.com.AbstractIdentifiableController;
import org.openbase.jul.extension.rsb.com.RPCHelper;
import org.openbase.jul.extension.rsb.iface.RSBLocalServer;
import org.openbase.jul.extension.rsb.scope.ScopeGenerator;
import org.openbase.jul.iface.Launchable;
import org.openbase.jul.iface.Shutdownable;
import org.openbase.jul.iface.VoidInitializable;
import org.openbase.jul.iface.provider.NameProvider;
import org.openbase.jul.pattern.Launcher;
import org.openbase.jul.schedule.GlobalExecutionService;
import org.openbase.jul.schedule.SyncObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rst.domotic.state.ActivationStateType;

public abstract class AbstractLauncher<L extends Launchable>
extends AbstractIdentifiableController<ActivationStateType.ActivationState, ActivationStateType.ActivationState.Builder>
implements Launcher,
VoidInitializable,
NameProvider {
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    public static final long LAUNCHER_TIMEOUT = 60000L;
    public static final String SCOPE_PREFIX_LAUNCHER = "/launcher";
    private final Class<L> launchableClass;
    private final Class applicationClass;
    private L launchable;
    private long launchTime = -1L;
    private LauncherState state;
    private boolean verified;
    private final SyncObject LAUNCHER_LOCK = new SyncObject((Object)this);

    public AbstractLauncher(Class applicationClass, Class<L> launchableClass) throws InstantiationException {
        super((GeneratedMessage.Builder)ActivationStateType.ActivationState.newBuilder());
        this.launchableClass = launchableClass;
        this.applicationClass = applicationClass;
        Shutdownable.registerShutdownHook((Shutdownable)this);
    }

    public void init() throws InitializationException, InterruptedException {
        try {
            super.init("/launcher/" + ScopeGenerator.convertIntoValidScopeComponent((String)this.getName()));
        }
        catch (NotAvailableException ex) {
            throw new InitializationException((Object)this, (Throwable)ex);
        }
    }

    public void registerMethods(RSBLocalServer server) throws CouldNotPerformException {
        RPCHelper.registerInterface(Launcher.class, (Object)((Object)this), (RSBLocalServer)server);
    }

    public L getLaunchable() {
        return this.launchable;
    }

    public String getName() throws NotAvailableException {
        return this.applicationClass.getSimpleName();
    }

    protected L instantiateLaunchable() throws CouldNotPerformException {
        try {
            return (L)((Launchable)this.launchableClass.newInstance());
        }
        catch (IllegalAccessException | java.lang.InstantiationException ex) {
            throw new CouldNotPerformException("Could not load launchable class!", (Throwable)ex);
        }
    }

    protected abstract void loadProperties();

    protected void verify() throws VerificationFailedException, InterruptedException {
    }

    private void setState(LauncherState state) {
        this.state = state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void launch() throws CouldNotPerformException, InterruptedException {
        SyncObject syncObject = this.LAUNCHER_LOCK;
        synchronized (syncObject) {
            this.setState(LauncherState.INITALIZING);
            this.launchable = this.instantiateLaunchable();
            try {
                this.launchable.init();
                this.setState(LauncherState.LAUNCHING);
                this.launchable.activate();
                this.launchTime = System.currentTimeMillis();
                this.setState(LauncherState.RUNNING);
                try {
                    this.verify();
                    this.verified = false;
                }
                catch (VerificationFailedException ex) {
                    this.verified = true;
                    ExceptionPrinter.printHistory((Throwable)ex, (Logger)this.logger);
                }
            }
            catch (CouldNotPerformException ex) {
                this.setState(LauncherState.ERROR);
                this.launchable.shutdown();
                throw new CouldNotPerformException("Could not launch " + this.getName(), (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void relaunch() throws CouldNotPerformException, InterruptedException {
        SyncObject syncObject = this.LAUNCHER_LOCK;
        synchronized (syncObject) {
            this.stop();
            this.launch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        SyncObject syncObject = this.LAUNCHER_LOCK;
        synchronized (syncObject) {
            this.setState(LauncherState.STOPPING);
            if (this.launchable != null) {
                this.launchable.shutdown();
            }
            this.setState(LauncherState.STOPPED);
        }
    }

    public void shutdown() {
        this.stop();
        super.shutdown();
    }

    public long getUpTime() {
        if (this.launchTime < 0L) {
            return 0L;
        }
        return System.currentTimeMillis() - this.launchTime;
    }

    public long getLaunchTime() {
        return this.launchTime;
    }

    public boolean isVerified() {
        return this.verified;
    }

    public static void main(String[] args, Class application, Class<? extends AbstractLauncher> ... launchers) {
        Logger logger = LoggerFactory.getLogger(Launcher.class);
        JPService.setApplicationName((Class)application);
        MultiException.ExceptionStack exceptionStack = null;
        HashMap<Class<? extends AbstractLauncher>, AbstractLauncher> launcherMap = new HashMap<Class<? extends AbstractLauncher>, AbstractLauncher>();
        for (Class<? extends AbstractLauncher> launcherClass : launchers) {
            try {
                launcherMap.put(launcherClass, launcherClass.newInstance());
            }
            catch (IllegalAccessException | java.lang.InstantiationException ex) {
                exceptionStack = MultiException.push((Object)application, (Exception)((Object)new CouldNotPerformException("Could not load launcher class!", (Throwable)ex)), exceptionStack);
            }
        }
        for (AbstractLauncher launcher : launcherMap.values()) {
            launcher.loadProperties();
        }
        JPService.parseAndExitOnError((String[])args);
        logger.info("Start " + JPService.getApplicationName() + "...");
        HashMap launchableFutureMap = new HashMap();
        try {
            for (final Map.Entry launcherEntry : launcherMap.entrySet()) {
                launchableFutureMap.put(launcherEntry, GlobalExecutionService.submit((Callable)new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        ((AbstractLauncher)((Object)launcherEntry.getValue())).launch();
                        return null;
                    }
                }));
            }
            for (Map.Entry launcherEntry : launchableFutureMap.entrySet()) {
                try {
                    ((Future)launcherEntry.getValue()).get(60000L, TimeUnit.MILLISECONDS);
                }
                catch (ExecutionException ex) {
                    exceptionStack = MultiException.push((Object)application, (Exception)((Object)new CouldNotPerformException("Could not launch " + ((Class)((Map.Entry)launcherEntry.getKey()).getKey()).getSimpleName() + "!", (Throwable)ex)), (MultiException.ExceptionStack)exceptionStack);
                }
                catch (TimeoutException ex) {
                    exceptionStack = MultiException.push((Object)application, (Exception)((Object)new CouldNotPerformException("Launcher " + ((Class)((Map.Entry)launcherEntry.getKey()).getKey()).getSimpleName() + " not responding!", (Throwable)ex)), (MultiException.ExceptionStack)exceptionStack);
                }
            }
        }
        catch (InterruptedException ex) {
            ExceptionPrinter.printHistoryAndExit((String)(JPService.getApplicationName() + " catched shutdown signal during startup phase!"), (Throwable)ex, (Logger)logger);
        }
        try {
            MultiException.checkAndThrow((String)"Errors during startup phase!", (MultiException.ExceptionStack)exceptionStack);
            logger.info(JPService.getApplicationName() + " successfully started.");
        }
        catch (MultiException ex) {
            ExceptionPrinter.printHistory((String)(JPService.getApplicationName() + " was startet with some errors!"), (Throwable)ex, (Logger)logger);
        }
    }

    public static enum LauncherState {
        INITALIZING,
        LAUNCHING,
        RUNNING,
        STOPPING,
        STOPPED,
        ERROR;

    }
}

