/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.registry.lib.com;

import com.google.protobuf.Descriptors;
import com.google.protobuf.GeneratedMessage;
import java.util.ArrayList;
import java.util.Map;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InstantiationException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.extension.protobuf.IdentifiableMessage;
import org.openbase.jul.extension.protobuf.processing.ProtoBufFieldProcessor;
import org.openbase.jul.extension.rsb.com.RSBRemoteService;
import org.openbase.jul.iface.Activatable;
import org.openbase.jul.pattern.Observable;
import org.openbase.jul.pattern.Observer;
import org.openbase.jul.storage.registry.RemoteRegistry;
import org.slf4j.Logger;

public class SynchronizedRemoteRegistry<KEY, M extends GeneratedMessage, MB extends GeneratedMessage.Builder<MB>>
extends RemoteRegistry<KEY, M, MB>
implements Activatable {
    private final Descriptors.FieldDescriptor[] fieldDescriptors;
    private final RSBRemoteService<M> remoteService;
    private final RemoteRegistrySynchronizer remoteRegistrySynchronizer;
    private boolean active;

    public SynchronizedRemoteRegistry(RSBRemoteService remoteService, int ... protobufFieldNumbers) throws InstantiationException {
        try {
            this.fieldDescriptors = ProtoBufFieldProcessor.getFieldDescriptors((Class)remoteService.getDataClass(), (int[])protobufFieldNumbers);
            this.remoteService = remoteService;
            this.remoteRegistrySynchronizer = new RemoteRegistrySynchronizer();
        }
        catch (CouldNotPerformException ex) {
            throw new InstantiationException((Object)this, (Throwable)ex);
        }
    }

    public SynchronizedRemoteRegistry(RSBRemoteService<M> remoteService, Descriptors.FieldDescriptor ... fieldDescriptors) throws InstantiationException {
        this.fieldDescriptors = fieldDescriptors;
        this.remoteService = remoteService;
        this.remoteRegistrySynchronizer = new RemoteRegistrySynchronizer();
    }

    public SynchronizedRemoteRegistry(RSBRemoteService<M> remoteService, Map<KEY, IdentifiableMessage<KEY, M, MB>> internalMap, Descriptors.FieldDescriptor ... fieldDescriptors) throws InstantiationException {
        super(internalMap);
        this.fieldDescriptors = fieldDescriptors;
        this.remoteService = remoteService;
        this.remoteRegistrySynchronizer = new RemoteRegistrySynchronizer();
    }

    public Descriptors.FieldDescriptor[] getFieldDescriptors() {
        return this.fieldDescriptors;
    }

    public RSBRemoteService<M> getRemoteService() {
        return this.remoteService;
    }

    public void activate() throws CouldNotPerformException, InterruptedException {
        this.remoteService.addDataObserver((Observer)this.remoteRegistrySynchronizer);
        this.active = true;
    }

    public void deactivate() throws CouldNotPerformException, InterruptedException {
        this.remoteService.removeDataObserver((Observer)this.remoteRegistrySynchronizer);
        this.active = false;
    }

    public boolean isActive() {
        return this.active;
    }

    public String getName() {
        if (this.fieldDescriptors.length == 0) {
            return ((Object)((Object)this)).getClass().getSimpleName() + "[" + this.remoteService.toString() + "]";
        }
        String fieldDescritorNames = "[";
        fieldDescritorNames = fieldDescritorNames + this.fieldDescriptors[0].getName();
        for (int i = 1; i < this.fieldDescriptors.length; ++i) {
            fieldDescritorNames = fieldDescritorNames + ", " + this.fieldDescriptors[i].getName();
        }
        fieldDescritorNames = fieldDescritorNames + "]";
        return ((Object)((Object)this)).getClass().getSimpleName() + "[" + this.remoteService.toString() + "]" + fieldDescritorNames;
    }

    class RemoteRegistrySynchronizer
    implements Observer<M> {
        RemoteRegistrySynchronizer() {
        }

        public void update(Observable<M> source, M data) throws Exception {
            try {
                if (data == null) {
                    throw new NotAvailableException("RegistryData");
                }
                ArrayList<GeneratedMessage> entryList = new ArrayList<GeneratedMessage>();
                for (Descriptors.FieldDescriptor fieldDescriptor : SynchronizedRemoteRegistry.this.fieldDescriptors) {
                    int entryCount = data.getRepeatedFieldCount(fieldDescriptor);
                    for (int i = 0; i < entryCount; ++i) {
                        entryList.add((GeneratedMessage)data.getRepeatedField(fieldDescriptor, i));
                    }
                }
                SynchronizedRemoteRegistry.this.notifyRegistryUpdate(entryList);
            }
            catch (ClassCastException | IndexOutOfBoundsException | NullPointerException | CouldNotPerformException ex) {
                ExceptionPrinter.printHistory((String)"Registry synchronization failed!", (Throwable)ex, (Logger)SynchronizedRemoteRegistry.this.logger);
            }
        }
    }
}

