/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.registry.lib.util;

import java.lang.reflect.InvocationTargetException;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.VerificationFailedException;
import org.openbase.jul.processing.StringProcessor;
import rst.domotic.unit.UnitConfigType;
import rst.domotic.unit.UnitTemplateType;

public class UnitConfigProcessor {
    public static boolean isHostUnit(UnitConfigType.UnitConfig unitConfig) throws CouldNotPerformException {
        UnitConfigProcessor.verifyUnitConfig(unitConfig, unitConfig.getType());
        return UnitConfigProcessor.isHostUnit(unitConfig.getType());
    }

    public static boolean isHostUnit(UnitTemplateType.UnitTemplate.UnitType unitType) {
        switch (unitType) {
            case APP: 
            case DEVICE: {
                return true;
            }
        }
        return false;
    }

    public static boolean isDalUnit(UnitConfigType.UnitConfig unitConfig) throws CouldNotPerformException {
        UnitConfigProcessor.verifyUnitConfig(unitConfig, unitConfig.getType());
        return UnitConfigProcessor.isDalUnit(unitConfig.getType());
    }

    public static boolean isDalUnit(UnitTemplateType.UnitTemplate.UnitType unitType) {
        return !UnitConfigProcessor.isBaseUnit(unitType);
    }

    public static boolean isBaseUnit(UnitConfigType.UnitConfig unitConfig) throws CouldNotPerformException {
        UnitConfigProcessor.verifyUnitConfig(unitConfig, unitConfig.getType());
        return UnitConfigProcessor.isBaseUnit(unitConfig.getType());
    }

    public static boolean isBaseUnit(UnitTemplateType.UnitTemplate.UnitType unitType) {
        switch (unitType) {
            case APP: 
            case DEVICE: 
            case AGENT: 
            case AUTHORIZATION_GROUP: 
            case CONNECTION: 
            case LOCATION: 
            case SCENE: 
            case UNIT_GROUP: 
            case USER: {
                return true;
            }
        }
        return false;
    }

    public static void verifyUnitType(UnitConfigType.UnitConfig unitConfig, UnitTemplateType.UnitTemplate.UnitType unitType) throws VerificationFailedException {
        if (!unitConfig.hasType()) {
            throw new VerificationFailedException("UnitType not available!");
        }
        if (unitConfig.getType() != unitType) {
            throw new VerificationFailedException("UnitType verification failed. Expected[" + unitType + "] but was[" + unitConfig.getType() + "]!");
        }
    }

    public static void verifyUnitConfig(UnitConfigType.UnitConfig unitConfig, UnitTemplateType.UnitTemplate.UnitType unitType) throws VerificationFailedException {
        UnitConfigProcessor.verifyUnitType(unitConfig, unitType);
        if (UnitConfigProcessor.isBaseUnit(unitType)) {
            try {
                if (!((Boolean)unitConfig.getClass().getMethod("has" + StringProcessor.transformUpperCaseToCamelCase((String)unitType.name()) + "Config", new Class[0]).invoke((Object)unitConfig, new Object[0])).booleanValue()) {
                    throw new VerificationFailedException("UnitType config missing of given UnitConfig!");
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | NullPointerException | SecurityException | InvocationTargetException ex) {
                throw new VerificationFailedException("Given unit config is not compatible with current programm version!", (Throwable)ex);
            }
        }
    }
}

