/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.registry.lib.com;

import com.google.protobuf.GeneratedMessage;
import java.util.ArrayList;
import java.util.List;
import org.openbase.bco.registry.lib.com.SynchronizedRemoteRegistry;
import org.openbase.jps.core.JPService;
import org.openbase.jps.exception.JPServiceException;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InitializationException;
import org.openbase.jul.exception.InstantiationException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.exception.printer.LogLevel;
import org.openbase.jul.extension.rsb.com.RSBCommunicationService;
import org.openbase.jul.extension.rsb.scope.jp.JPScope;
import org.openbase.jul.storage.file.ProtoBufJSonFileProvider;
import org.openbase.jul.storage.registry.ConsistencyHandler;
import org.openbase.jul.storage.registry.ProtoBufFileSynchronizedRegistry;
import org.openbase.jul.storage.registry.Registry;
import org.openbase.jul.storage.registry.RegistryController;
import org.openbase.jul.storage.registry.RegistryRemote;
import org.openbase.jul.storage.registry.RemoteRegistry;
import org.slf4j.Logger;
import rsb.Scope;

public abstract class AbstractRegistryController<M extends GeneratedMessage, MB extends GeneratedMessage.Builder<MB>>
extends RSBCommunicationService<M, MB>
implements RegistryController<M> {
    protected ProtoBufJSonFileProvider protoBufJSonFileProvider = new ProtoBufJSonFileProvider();
    private final List<RegistryRemote> registryRemotes;
    private final List<RemoteRegistry> remoteRegistries;
    private final List<ProtoBufFileSynchronizedRegistry> registries;
    private final Class<? extends JPScope> jpScopePropery;

    public AbstractRegistryController(Class<? extends JPScope> jpScopePropery, MB builder) throws InstantiationException {
        super(builder);
        this.jpScopePropery = jpScopePropery;
        this.registryRemotes = new ArrayList<RegistryRemote>();
        this.registries = new ArrayList<ProtoBufFileSynchronizedRegistry>();
        this.remoteRegistries = new ArrayList<RemoteRegistry>();
        this.protoBufJSonFileProvider = new ProtoBufJSonFileProvider();
    }

    public void init() throws InitializationException, InterruptedException {
        try {
            super.init((Scope)((JPScope)JPService.getProperty(this.jpScopePropery)).getValue());
        }
        catch (JPServiceException | CouldNotPerformException ex) {
            throw new InitializationException((Object)this, ex);
        }
    }

    protected void postInit() throws InitializationException, InterruptedException {
        super.postInit();
        try {
            try {
                this.registerRegistries();
            }
            catch (CouldNotPerformException ex) {
                throw new CouldNotPerformException("Could not register all internal registries!", (Throwable)ex);
            }
            try {
                this.registerRegistryRemotes();
            }
            catch (CouldNotPerformException ex) {
                throw new CouldNotPerformException("Could not register all registry remotes!", (Throwable)ex);
            }
            try {
                this.registerRemoteRegistries();
            }
            catch (CouldNotPerformException ex) {
                throw new CouldNotPerformException("Could not activate version control for all internal registries!", (Throwable)ex);
            }
            try {
                this.initRemoteRegistries();
            }
            catch (CouldNotPerformException ex) {
                throw new CouldNotPerformException("Could not init all remote registries!", (Throwable)ex);
            }
            try {
                this.activateVersionControl();
            }
            catch (CouldNotPerformException ex) {
                throw new CouldNotPerformException("Could not activate version control for all internal registries!", (Throwable)ex);
            }
            try {
                this.loadRegistries();
            }
            catch (CouldNotPerformException ex) {
                throw new CouldNotPerformException("Could not load all internal registries!", (Throwable)ex);
            }
            try {
                this.registerConsistencyHandler();
            }
            catch (CouldNotPerformException ex) {
                throw new CouldNotPerformException("Could not register consistency handler for all internal registries!", (Throwable)ex);
            }
            try {
                this.registerPlugins();
            }
            catch (CouldNotPerformException ex) {
                throw new CouldNotPerformException("Could not register plugins for all internal registries!", (Throwable)ex);
            }
            try {
                this.registerObserver();
            }
            catch (CouldNotPerformException ex) {
                throw new CouldNotPerformException("Could not register observer for all internal registries!", (Throwable)ex);
            }
        }
        catch (CouldNotPerformException ex) {
            throw new InitializationException((Object)this, (Throwable)ex);
        }
    }

    public void activate() throws InterruptedException, CouldNotPerformException {
        try {
            super.activate();
            this.activateRemoteRegistries();
            this.activateRegistryRemotes();
            this.registerDependencies();
            this.performInitialConsistencyCheck();
        }
        catch (CouldNotPerformException ex) {
            throw new CouldNotPerformException("Could not activate location registry!", (Throwable)ex);
        }
    }

    public void deactivate() throws InterruptedException, CouldNotPerformException {
        super.deactivate();
        this.deactivateRemoteRegistries();
        this.deactivateRegistryRemotes();
        this.removeDependencies();
    }

    public void shutdown() {
        super.shutdown();
        this.registryRemotes.stream().forEach(remote -> remote.shutdown());
        this.remoteRegistries.stream().forEach(remoteRegistry -> remoteRegistry.shutdown());
        this.registries.stream().forEach(registry -> registry.shutdown());
    }

    public void notifyChange() throws CouldNotPerformException, InterruptedException {
        this.syncRegistryFlags();
        super.notifyChange();
    }

    private void initRemoteRegistries() throws CouldNotPerformException, InterruptedException {
        for (RegistryRemote remote : this.registryRemotes) {
            remote.init();
        }
    }

    private void activateRemoteRegistries() throws CouldNotPerformException, InterruptedException {
        for (RemoteRegistry remoteRegistry : this.remoteRegistries) {
            if (!(remoteRegistry instanceof SynchronizedRemoteRegistry)) continue;
            ((SynchronizedRemoteRegistry)remoteRegistry).activate();
        }
    }

    private void activateRegistryRemotes() throws CouldNotPerformException, InterruptedException {
        for (RegistryRemote remote : this.registryRemotes) {
            remote.activate();
        }
        for (RegistryRemote remote : this.registryRemotes) {
            remote.waitForData();
        }
    }

    private void deactivateRemoteRegistries() throws CouldNotPerformException, InterruptedException {
        for (RemoteRegistry remoteRegistry : this.remoteRegistries) {
            if (!(remoteRegistry instanceof SynchronizedRemoteRegistry)) continue;
            ((SynchronizedRemoteRegistry)remoteRegistry).deactivate();
        }
    }

    private void deactivateRegistryRemotes() throws CouldNotPerformException, InterruptedException {
        for (RegistryRemote remote : this.registryRemotes) {
            remote.deactivate();
        }
    }

    private void removeDependencies() throws CouldNotPerformException {
        this.registries.stream().forEach(registry -> registry.removeAllDependencies());
    }

    private void registerObserver() throws CouldNotPerformException {
        this.registries.stream().forEach(registry -> registry.addObserver((source, data) -> this.notifyChange()));
    }

    private void loadRegistries() throws CouldNotPerformException {
        for (ProtoBufFileSynchronizedRegistry registry : this.registries) {
            registry.loadRegistry();
        }
    }

    private void activateVersionControl() throws CouldNotPerformException {
        for (ProtoBufFileSynchronizedRegistry registry : this.registries) {
            Package versionConverterPackage;
            try {
                versionConverterPackage = this.detectVersionConverterPackage();
            }
            catch (NotAvailableException ex) {
                ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Skip version control activation for " + registry + "!", (Throwable)ex), (Logger)this.logger, (LogLevel)LogLevel.WARN);
                continue;
            }
            registry.activateVersionControl(versionConverterPackage);
        }
    }

    private void performInitialConsistencyCheck() throws CouldNotPerformException, InterruptedException {
        for (ProtoBufFileSynchronizedRegistry registry : this.registries) {
            try {
                registry.checkConsistency();
            }
            catch (CouldNotPerformException ex) {
                ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Initial consistency check failed!", (Throwable)ex), (Logger)this.logger, (LogLevel)LogLevel.WARN);
                this.notifyChange();
            }
        }
    }

    protected void registerDependency(Registry dependency, Class messageClass) throws CouldNotPerformException {
        for (ProtoBufFileSynchronizedRegistry registry : this.registries) {
            registry.registerDependency(dependency);
        }
    }

    protected void registerRegistryRemote(RegistryRemote registry) {
        this.registryRemotes.add(registry);
    }

    protected void registerRegistry(ProtoBufFileSynchronizedRegistry registry) {
        this.registries.add(registry);
    }

    protected void registerRemoteRegistry(RemoteRegistry registry) {
        this.remoteRegistries.add(registry);
    }

    protected void registerConsistencyHandler(ConsistencyHandler consistencyHandler, Class messageClass) throws CouldNotPerformException {
        for (ProtoBufFileSynchronizedRegistry registry : this.registries) {
            if (!messageClass.equals(registry.getMessageClass())) continue;
            registry.registerConsistencyHandler(consistencyHandler);
        }
    }

    protected List<RegistryRemote> getRegistryRemotes() {
        return this.registryRemotes;
    }

    protected List<RemoteRegistry> getRemoteRegistries() {
        return this.remoteRegistries;
    }

    protected List<ProtoBufFileSynchronizedRegistry> getRegistries() {
        return this.registries;
    }

    private Package detectVersionConverterPackage() throws CouldNotPerformException {
        Package converterPackage;
        try {
            converterPackage = Class.forName(((Object)((Object)this)).getClass().getPackage().getName() + "." + "dbconvert" + ".ConverterPackageIdentifier").getPackage();
        }
        catch (ClassNotFoundException ex) {
            throw new NotAvailableException("ConverterPackage[" + ((Object)((Object)this)).getClass().getPackage().getName() + "." + "dbconvert" + ".ConverterPackageIdentifier" + "]", (Throwable)ex);
        }
        return converterPackage;
    }

    protected abstract void registerConsistencyHandler() throws CouldNotPerformException;

    protected abstract void registerPlugins() throws CouldNotPerformException, InterruptedException;

    protected abstract void registerRegistryRemotes() throws CouldNotPerformException;

    protected abstract void registerRegistries() throws CouldNotPerformException;

    protected abstract void registerDependencies() throws CouldNotPerformException;

    protected abstract void syncRegistryFlags() throws CouldNotPerformException, InterruptedException;

    protected abstract void registerRemoteRegistries() throws CouldNotPerformException;
}

