/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.authentication.lib;

import java.io.IOException;
import java.io.Serializable;
import java.security.KeyPair;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.BadPaddingException;
import org.openbase.bco.authentication.lib.AuthenticationClientHandler;
import org.openbase.bco.authentication.lib.CachedAuthenticationRemote;
import org.openbase.bco.authentication.lib.CredentialStore;
import org.openbase.bco.authentication.lib.EncryptionHelper;
import org.openbase.bco.authentication.lib.exception.SessionExpiredException;
import org.openbase.bco.authentication.lib.jp.JPAuthentication;
import org.openbase.jps.core.JPService;
import org.openbase.jps.exception.JPNotAvailableException;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InitializationException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.exception.PermissionDeniedException;
import org.openbase.jul.exception.RejectedException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.exception.printer.LogLevel;
import org.openbase.jul.pattern.ObservableImpl;
import org.openbase.jul.pattern.Observer;
import org.openbase.jul.schedule.GlobalCachedExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rst.domotic.authentication.AuthenticatorType;
import rst.domotic.authentication.LoginCredentialsChangeType;
import rst.domotic.authentication.TicketAuthenticatorWrapperType;
import rst.domotic.authentication.TicketSessionKeyWrapperType;

public class SessionManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(SessionManager.class);
    private static final String STORE_FILENAME = "client_credential_store.json";
    private static SessionManager instance;
    private TicketAuthenticatorWrapperType.TicketAuthenticatorWrapper ticketAuthenticatorWrapper;
    private byte[] sessionKey;
    private CredentialStore store;
    private String clientId;
    private String previousClientId;
    private String userId;
    private String userPassword;
    private final ObservableImpl<String> loginObservable = new ObservableImpl();

    public static synchronized SessionManager getInstance() {
        if (instance == null) {
            instance = new SessionManager();
        }
        return instance;
    }

    public SessionManager() {
        this(null, null);
    }

    public SessionManager(byte[] sessionKey) {
        this(null, sessionKey);
    }

    public SessionManager(CredentialStore userStore) {
        this(userStore, null);
    }

    public SessionManager(CredentialStore userStore, byte[] sessionKey) {
        this.loginObservable.setExecutorService((ExecutorService)GlobalCachedExecutorService.getInstance().getExecutorService());
        this.store = userStore;
        if (sessionKey != null) {
            this.sessionKey = sessionKey;
        }
    }

    public void initStore() throws InitializationException {
        if (this.store == null) {
            this.store = new CredentialStore(STORE_FILENAME);
        }
        this.store.init();
    }

    public TicketAuthenticatorWrapperType.TicketAuthenticatorWrapper getTicketAuthenticatorWrapper() {
        return this.ticketAuthenticatorWrapper;
    }

    public synchronized void setTicketAuthenticatorWrapper(TicketAuthenticatorWrapperType.TicketAuthenticatorWrapper ticketAuthenticatorWrapper) throws IOException, BadPaddingException {
        if (this.ticketAuthenticatorWrapper == null) {
            this.ticketAuthenticatorWrapper = ticketAuthenticatorWrapper;
        } else {
            AuthenticatorType.Authenticator lastAuthenticator = EncryptionHelper.decryptSymmetric(this.ticketAuthenticatorWrapper.getAuthenticator(), this.getSessionKey(), AuthenticatorType.Authenticator.class);
            AuthenticatorType.Authenticator currentAuthenticator = EncryptionHelper.decryptSymmetric(ticketAuthenticatorWrapper.getAuthenticator(), this.getSessionKey(), AuthenticatorType.Authenticator.class);
            if (currentAuthenticator.getTimestamp().getTime() > lastAuthenticator.getTimestamp().getTime()) {
                this.ticketAuthenticatorWrapper = ticketAuthenticatorWrapper;
            }
        }
    }

    public byte[] getSessionKey() {
        return this.sessionKey;
    }

    public TicketAuthenticatorWrapperType.TicketAuthenticatorWrapper initializeServiceServerRequest() throws RejectedException {
        try {
            return AuthenticationClientHandler.initServiceServerRequest(this.getSessionKey(), this.getTicketAuthenticatorWrapper());
        }
        catch (IOException | BadPaddingException ex) {
            throw new RejectedException("Initializing request rejected", (Throwable)ex);
        }
    }

    public synchronized boolean login(String userId, String userPassword) throws CouldNotPerformException, NotAvailableException {
        return this.login(userId, userPassword, false);
    }

    public synchronized boolean login(String userId, String userPassword, boolean rememberPassword) throws CouldNotPerformException, NotAvailableException {
        byte[] clientPasswordHash = EncryptionHelper.hash(userPassword);
        if (rememberPassword) {
            this.userPassword = userPassword;
        }
        return this.internalLogin(userId, clientPasswordHash, true);
    }

    public synchronized boolean login(String clientId) throws CouldNotPerformException, NotAvailableException {
        byte[] key = this.getCredentials(clientId);
        return this.internalLogin(clientId, key, false);
    }

    public synchronized boolean relog() throws CouldNotPerformException, NotAvailableException {
        this.ticketAuthenticatorWrapper = null;
        this.sessionKey = null;
        if (this.canUserLoginAgain()) {
            return this.login(this.userId, this.userPassword, true);
        }
        if (this.canClientLoginAgain()) {
            return this.login(this.previousClientId);
        }
        this.logout();
        throw new CouldNotPerformException("Your session has expired. You have been logged out for security reasons. Please log in again.");
    }

    private boolean internalLogin(String id, byte[] key, boolean isUser) throws CouldNotPerformException, NotAvailableException {
        try {
            if (!((Boolean)((JPAuthentication)JPService.getProperty(JPAuthentication.class)).getValue()).booleanValue()) {
                return false;
            }
        }
        catch (JPNotAvailableException ex) {
            throw new CouldNotPerformException("Could not check JPEnableAuthenticationProperty", (Throwable)ex);
        }
        TicketAuthenticatorWrapperType.TicketAuthenticatorWrapper tmpTicketAuthenticatorWrapper = null;
        byte[] tmpSessionKey = null;
        String tmpUserId = null;
        String tmpUserPassword = null;
        boolean result = false;
        if (this.isLoggedIn()) {
            if (id.equals(this.userId) || id.equals(this.clientId)) {
                return true;
            }
            tmpTicketAuthenticatorWrapper = this.ticketAuthenticatorWrapper;
            tmpSessionKey = this.sessionKey;
            tmpUserId = this.userId;
            tmpUserPassword = this.userPassword;
            this.logout();
        }
        if (isUser) {
            this.userId = id;
        } else {
            this.clientId = id;
            this.previousClientId = id;
        }
        try {
            String userIdAtClientId = "@";
            byte[] userKey = null;
            byte[] clientKey = null;
            if (this.previousClientId != null) {
                userIdAtClientId = userIdAtClientId + this.previousClientId;
                clientKey = this.getCredentials(this.previousClientId);
            }
            if (isUser) {
                userIdAtClientId = id + userIdAtClientId;
                userKey = key;
            } else {
                clientKey = key;
            }
            TicketSessionKeyWrapperType.TicketSessionKeyWrapper ticketSessionKeyWrapper = CachedAuthenticationRemote.getRemote().requestTicketGrantingTicket(userIdAtClientId).get();
            List<Object> list = AuthenticationClientHandler.handleKeyDistributionCenterResponse(userIdAtClientId, userKey, clientKey, ticketSessionKeyWrapper);
            TicketAuthenticatorWrapperType.TicketAuthenticatorWrapper taw = (TicketAuthenticatorWrapperType.TicketAuthenticatorWrapper)list.get(0);
            byte[] ticketGrantingServiceSessionKey = (byte[])list.get(1);
            ticketSessionKeyWrapper = CachedAuthenticationRemote.getRemote().requestClientServerTicket(taw).get();
            list = AuthenticationClientHandler.handleTicketGrantingServiceResponse(userIdAtClientId, ticketGrantingServiceSessionKey, ticketSessionKeyWrapper);
            this.ticketAuthenticatorWrapper = (TicketAuthenticatorWrapperType.TicketAuthenticatorWrapper)list.get(0);
            this.sessionKey = (byte[])list.get(1);
            try {
                this.loginObservable.notifyObservers((Object)this.getUserAtClientId());
            }
            catch (CouldNotPerformException ex) {
                LOGGER.warn("Could not notify login to observer", (Throwable)ex);
            }
            boolean bl = result = true;
            return bl;
        }
        catch (BadPaddingException ex) {
            throw new CouldNotPerformException("The password you have entered was wrong. Please try again!");
        }
        catch (ExecutionException ex) {
            Throwable cause = ex.getCause();
            Pattern pattern = Pattern.compile("NotAvailableException: (.*)[\n\r]");
            Matcher matcher = pattern.matcher(cause.getMessage());
            if (matcher.find()) {
                ExceptionPrinter.printHistory((Throwable)cause, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
                throw new NotAvailableException(matcher.group(1));
            }
            ExceptionPrinter.printHistory((Throwable)cause, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
            throw new CouldNotPerformException("Internal server error.", cause);
        }
        catch (IOException | InterruptedException | CouldNotPerformException ex) {
            throw new CouldNotPerformException("Login failed! Please try again.", ex);
        }
        finally {
            if (!result) {
                this.ticketAuthenticatorWrapper = tmpTicketAuthenticatorWrapper;
                this.sessionKey = tmpSessionKey;
                this.userId = tmpUserId;
                this.userPassword = tmpUserPassword;
            }
        }
    }

    public synchronized void logout() {
        if (this.userId != null) {
            this.userId = null;
            this.userPassword = null;
            if (this.previousClientId != null) {
                try {
                    this.login(this.previousClientId);
                }
                catch (CouldNotPerformException ex) {
                    ExceptionPrinter.printHistory((Throwable)ex, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
                }
                return;
            }
        }
        if (this.clientId != null) {
            this.clientId = null;
        }
        this.ticketAuthenticatorWrapper = null;
        this.sessionKey = null;
        try {
            this.loginObservable.notifyObservers((Object)this.getUserAtClientId());
        }
        catch (CouldNotPerformException ex) {
            LOGGER.warn("Could not notify logout to observer", (Throwable)ex);
        }
    }

    public synchronized void completeLogout() {
        this.userId = null;
        this.userPassword = null;
        this.previousClientId = null;
        this.clientId = null;
        this.sessionKey = null;
        this.ticketAuthenticatorWrapper = null;
        try {
            this.loginObservable.notifyObservers((Object)this.getUserAtClientId());
        }
        catch (CouldNotPerformException ex) {
            LOGGER.warn("Could not notify complete logout to observer", (Throwable)ex);
        }
    }

    public boolean isLoggedIn() {
        return this.ticketAuthenticatorWrapper != null && this.sessionKey != null;
    }

    public synchronized boolean isAdmin() {
        if (!this.isLoggedIn()) {
            return false;
        }
        try {
            return CachedAuthenticationRemote.getRemote().isAdmin(this.userId).get();
        }
        catch (InterruptedException | ExecutionException | CouldNotPerformException ex) {
            ExceptionPrinter.printHistory((Throwable)ex, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
            return false;
        }
    }

    public boolean canUserLoginAgain() {
        if (this.userId != null) {
            return this.userPassword != null;
        }
        return false;
    }

    public boolean canClientLoginAgain() {
        return this.previousClientId != null && this.store != null && this.store.hasEntry(this.previousClientId);
    }

    public synchronized boolean isAuthenticated() throws CouldNotPerformException {
        if (!this.isLoggedIn()) {
            return false;
        }
        try {
            Observer observer = (source, data) -> LOGGER.warn("Login state change while in isAuthenticated to [" + data + "]" + this.sessionKey);
            this.loginObservable.addObserver(observer);
            byte[] before = this.sessionKey;
            TicketAuthenticatorWrapperType.TicketAuthenticatorWrapper request = AuthenticationClientHandler.initServiceServerRequest(this.sessionKey, this.ticketAuthenticatorWrapper);
            byte[] init = this.sessionKey;
            TicketAuthenticatorWrapperType.TicketAuthenticatorWrapper response = CachedAuthenticationRemote.getRemote().validateClientServerTicket(request).get();
            byte[] after = this.sessionKey;
            if (this.sessionKey == null) {
                this.loginObservable.removeObserver(observer);
                throw new CouldNotPerformException("Why is this happening?[" + before + ", " + init + ", " + after + "]");
            }
            this.ticketAuthenticatorWrapper = response = AuthenticationClientHandler.handleServiceServerResponse(this.sessionKey, request, response);
            this.loginObservable.removeObserver(observer);
            return true;
        }
        catch (IOException | BadPaddingException ex) {
            this.logout();
            ExceptionPrinter.printHistory((Throwable)ex, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
            throw new CouldNotPerformException("Decryption failed. You have been logged out for security reasons. Please log in again.");
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new CouldNotPerformException("Action was interrupted.", (Throwable)ex);
        }
        catch (ExecutionException ex) {
            Throwable cause = ex.getCause();
            Pattern pattern = Pattern.compile("RejectedException: (.*)[\n\r]");
            Matcher matcher = pattern.matcher(cause.getMessage());
            if (matcher.find()) {
                ExceptionPrinter.printHistory((Throwable)cause, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
                throw new RejectedException(matcher.group(1));
            }
            pattern = Pattern.compile("PermissionDeniedException: (.*)[\n\r]");
            matcher = pattern.matcher(cause.getMessage());
            if (matcher.find()) {
                ExceptionPrinter.printHistory((Throwable)cause, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
                throw new PermissionDeniedException(matcher.group(1));
            }
            pattern = Pattern.compile("SessionExpiredException: (.*)[\n\r]");
            matcher = pattern.matcher(cause.getMessage());
            if (matcher.find()) {
                throw new SessionExpiredException();
            }
            ExceptionPrinter.printHistory((Throwable)cause, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
            throw new CouldNotPerformException("Internal server error.", cause);
        }
    }

    public synchronized void changeCredentials(String clientId, String oldCredentials, String newCredentials) throws CouldNotPerformException {
        if (!this.isLoggedIn()) {
            throw new CouldNotPerformException("Please log in first!");
        }
        if (clientId == null) {
            clientId = this.userId;
        }
        try {
            this.ticketAuthenticatorWrapper = AuthenticationClientHandler.initServiceServerRequest(this.sessionKey, this.ticketAuthenticatorWrapper);
            byte[] oldHash = EncryptionHelper.hash(oldCredentials);
            byte[] newHash = EncryptionHelper.hash(newCredentials);
            LoginCredentialsChangeType.LoginCredentialsChange loginCredentialsChange = LoginCredentialsChangeType.LoginCredentialsChange.newBuilder().setId(clientId).setOldCredentials(EncryptionHelper.encryptSymmetric((Serializable)oldHash, this.sessionKey)).setNewCredentials(EncryptionHelper.encryptSymmetric((Serializable)newHash, this.sessionKey)).setTicketAuthenticatorWrapper(this.ticketAuthenticatorWrapper).build();
            TicketAuthenticatorWrapperType.TicketAuthenticatorWrapper newTicketAuthenticatorWrapper = CachedAuthenticationRemote.getRemote().changeCredentials(loginCredentialsChange).get();
            this.ticketAuthenticatorWrapper = AuthenticationClientHandler.handleServiceServerResponse(this.sessionKey, this.ticketAuthenticatorWrapper, newTicketAuthenticatorWrapper);
        }
        catch (IOException | BadPaddingException ex) {
            this.logout();
            ExceptionPrinter.printHistory((Throwable)ex, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
            throw new CouldNotPerformException("Decryption failed. You have been logged out for security reasons. Please log in again.");
        }
        catch (NotAvailableException | RejectedException ex) {
            throw (CouldNotPerformException)ExceptionPrinter.printHistoryAndReturnThrowable((Throwable)ex, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
        }
        catch (InterruptedException ex) {
            ExceptionPrinter.printHistory((Throwable)ex, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
            throw new CouldNotPerformException("Action was interrupted.", (Throwable)ex);
        }
        catch (ExecutionException ex) {
            Throwable cause = ex.getCause();
            Pattern pattern = Pattern.compile("RejectedException: (.*)[\n\r]");
            Matcher matcher = pattern.matcher(cause.getMessage());
            if (matcher.find()) {
                ExceptionPrinter.printHistory((Throwable)cause, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
                throw new RejectedException(matcher.group(1));
            }
            pattern = Pattern.compile("PermissionDeniedException: (.*)[\n\r]");
            matcher = pattern.matcher(cause.getMessage());
            if (matcher.find()) {
                ExceptionPrinter.printHistory((Throwable)cause, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
                throw new PermissionDeniedException(matcher.group(1));
            }
            ExceptionPrinter.printHistory((Throwable)cause, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
            throw new CouldNotPerformException("Internal server error.", cause);
        }
    }

    public synchronized void registerClient(String clientId) throws CouldNotPerformException {
        if (this.store == null) {
            try {
                this.initStore();
            }
            catch (InitializationException ex) {
                throw new NotAvailableException((Throwable)ex);
            }
        }
        KeyPair keyPair = EncryptionHelper.generateKeyPair();
        this.internalRegister(clientId, keyPair.getPublic().getEncoded(), false);
        this.store.setCredentials(clientId, keyPair.getPrivate().getEncoded());
    }

    public synchronized boolean hasCredentialsForId(String id) {
        if (this.store == null) {
            try {
                this.initStore();
            }
            catch (InitializationException ex) {
                return false;
            }
        }
        return this.store.hasEntry(id);
    }

    public synchronized void registerUser(String userId, String password, boolean isAdmin) throws CouldNotPerformException {
        byte[] key = EncryptionHelper.hash(password);
        this.internalRegister(userId, key, isAdmin);
    }

    private void internalRegister(String id, byte[] key, boolean isAdmin) throws CouldNotPerformException {
        if (!this.isLoggedIn()) {
            throw new CouldNotPerformException("Please log in first!");
        }
        try {
            this.ticketAuthenticatorWrapper = AuthenticationClientHandler.initServiceServerRequest(this.sessionKey, this.ticketAuthenticatorWrapper);
            LoginCredentialsChangeType.LoginCredentialsChange loginCredentialsChange = LoginCredentialsChangeType.LoginCredentialsChange.newBuilder().setId(id).setNewCredentials(EncryptionHelper.encryptSymmetric((Serializable)key, this.sessionKey)).setTicketAuthenticatorWrapper(this.ticketAuthenticatorWrapper).setAdmin(isAdmin).build();
            TicketAuthenticatorWrapperType.TicketAuthenticatorWrapper wrapper = CachedAuthenticationRemote.getRemote().register(loginCredentialsChange).get();
            this.ticketAuthenticatorWrapper = AuthenticationClientHandler.handleServiceServerResponse(this.sessionKey, this.ticketAuthenticatorWrapper, wrapper);
        }
        catch (IOException | BadPaddingException ex) {
            this.logout();
            ExceptionPrinter.printHistory((Throwable)ex, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
            throw new CouldNotPerformException("Decryption failed. You have been logged out for security reasons. Please log in again.");
        }
        catch (NotAvailableException | RejectedException ex) {
            throw (CouldNotPerformException)ExceptionPrinter.printHistoryAndReturnThrowable((Throwable)ex, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
        }
        catch (InterruptedException ex) {
            ExceptionPrinter.printHistory((Throwable)ex, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
            throw new CouldNotPerformException("Action was interrupted.", (Throwable)ex);
        }
        catch (ExecutionException ex) {
            Throwable cause = ex.getCause();
            Pattern pattern = Pattern.compile("RejectedException: (.*)[\n\r]");
            Matcher matcher = pattern.matcher(cause.getMessage());
            if (matcher.find()) {
                ExceptionPrinter.printHistory((Throwable)cause, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
                throw new RejectedException(matcher.group(1));
            }
            pattern = Pattern.compile("PermissionDeniedException: (.*)[\n\r]");
            matcher = pattern.matcher(cause.getMessage());
            if (matcher.find()) {
                ExceptionPrinter.printHistory((Throwable)cause, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
                throw new PermissionDeniedException(matcher.group(1));
            }
            ExceptionPrinter.printHistory((Throwable)cause, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
            throw new CouldNotPerformException("Internal server error.", cause);
        }
    }

    public synchronized void removeUser(String id) throws CouldNotPerformException {
        if (!this.isAdmin()) {
            throw new CouldNotPerformException("You have to be an admin to perform this action");
        }
        try {
            this.ticketAuthenticatorWrapper = AuthenticationClientHandler.initServiceServerRequest(this.sessionKey, this.ticketAuthenticatorWrapper);
            LoginCredentialsChangeType.LoginCredentialsChange loginCredentialsChange = LoginCredentialsChangeType.LoginCredentialsChange.newBuilder().setId(id).setTicketAuthenticatorWrapper(this.ticketAuthenticatorWrapper).build();
            TicketAuthenticatorWrapperType.TicketAuthenticatorWrapper wrapper = CachedAuthenticationRemote.getRemote().removeUser(loginCredentialsChange).get();
            this.ticketAuthenticatorWrapper = AuthenticationClientHandler.handleServiceServerResponse(this.sessionKey, this.ticketAuthenticatorWrapper, wrapper);
        }
        catch (IOException | BadPaddingException ex) {
            this.logout();
            ExceptionPrinter.printHistory((Throwable)ex, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
            throw new CouldNotPerformException("Decryption failed. You have been logged out for security reasons. Please log in again.");
        }
        catch (NotAvailableException | RejectedException ex) {
            throw (CouldNotPerformException)ExceptionPrinter.printHistoryAndReturnThrowable((Throwable)ex, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
        }
        catch (InterruptedException ex) {
            ExceptionPrinter.printHistory((Throwable)ex, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
            throw new CouldNotPerformException("Action was interrupted.", (Throwable)ex);
        }
        catch (ExecutionException ex) {
            Throwable cause = ex.getCause();
            Pattern pattern = Pattern.compile("RejectedException: (.*)[\n\r]");
            Matcher matcher = pattern.matcher(cause.getMessage());
            if (matcher.find()) {
                ExceptionPrinter.printHistory((Throwable)cause, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
                throw new RejectedException(matcher.group(1));
            }
            pattern = Pattern.compile("PermissionDeniedException: (.*)[\n\r]");
            matcher = pattern.matcher(cause.getMessage());
            if (matcher.find()) {
                ExceptionPrinter.printHistory((Throwable)cause, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
                throw new PermissionDeniedException(matcher.group(1));
            }
            ExceptionPrinter.printHistory((Throwable)cause, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
            throw new CouldNotPerformException("Internal server error.", cause);
        }
    }

    public synchronized void setAdministrator(String id, boolean isAdmin) throws CouldNotPerformException {
        if (!this.isLoggedIn()) {
            throw new CouldNotPerformException("Please log in first!");
        }
        try {
            this.ticketAuthenticatorWrapper = AuthenticationClientHandler.initServiceServerRequest(this.sessionKey, this.ticketAuthenticatorWrapper);
            LoginCredentialsChangeType.LoginCredentialsChange loginCredentialsChange = LoginCredentialsChangeType.LoginCredentialsChange.newBuilder().setId(id).setTicketAuthenticatorWrapper(this.ticketAuthenticatorWrapper).setAdmin(isAdmin).build();
            TicketAuthenticatorWrapperType.TicketAuthenticatorWrapper wrapper = CachedAuthenticationRemote.getRemote().setAdministrator(loginCredentialsChange).get();
            this.ticketAuthenticatorWrapper = AuthenticationClientHandler.handleServiceServerResponse(this.sessionKey, this.ticketAuthenticatorWrapper, wrapper);
        }
        catch (IOException | BadPaddingException ex) {
            this.logout();
            ExceptionPrinter.printHistory((Throwable)ex, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
            throw new CouldNotPerformException("Decryption failed. You have been logged out for security reasons. Please log in again.");
        }
        catch (NotAvailableException | RejectedException ex) {
            throw (CouldNotPerformException)ExceptionPrinter.printHistoryAndReturnThrowable((Throwable)ex, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
        }
        catch (InterruptedException ex) {
            ExceptionPrinter.printHistory((Throwable)ex, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
            throw new CouldNotPerformException("Action was interrupted.", (Throwable)ex);
        }
        catch (ExecutionException ex) {
            Throwable cause = ex.getCause();
            Pattern pattern = Pattern.compile("RejectedException: (.*)[\n\r]");
            Matcher matcher = pattern.matcher(cause.getMessage());
            if (matcher.find()) {
                ExceptionPrinter.printHistory((Throwable)cause, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
                throw new RejectedException(matcher.group(1));
            }
            pattern = Pattern.compile("PermissionDeniedException: (.*)[\n\r]");
            matcher = pattern.matcher(cause.getMessage());
            if (matcher.find()) {
                ExceptionPrinter.printHistory((Throwable)cause, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
                throw new PermissionDeniedException(matcher.group(1));
            }
            ExceptionPrinter.printHistory((Throwable)cause, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
            throw new CouldNotPerformException("Internal server error.", cause);
        }
    }

    private byte[] getCredentials(String clientId) throws NotAvailableException {
        if (this.store == null) {
            try {
                this.initStore();
            }
            catch (InitializationException ex) {
                throw new NotAvailableException((Throwable)ex);
            }
        }
        byte[] key = this.store.getCredentials(clientId);
        return key;
    }

    public String getUserAtClientId() {
        String userAtClient = "";
        if (this.userId != null) {
            userAtClient = userAtClient + this.userId;
        }
        userAtClient = userAtClient + "@";
        if (this.clientId != null) {
            userAtClient = userAtClient + this.clientId;
        }
        return userAtClient;
    }

    public String getUserId() {
        return this.userId;
    }

    public void addLoginObserver(Observer<String> observer) {
        this.loginObservable.addObserver(observer);
    }

    public void removeLoginObserver(Observer<String> observer) {
        this.loginObservable.removeObserver(observer);
    }

    public String getClientId() {
        return this.clientId;
    }
}

