/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ImmutableMap;
import com.samskivert.mustache.Mustache;
import com.samskivert.mustache.Template;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.oas.models.examples.Example;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.DefaultCodegen;
import org.openapitools.codegen.GeneratorLanguage;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.meta.GeneratorMetadata;
import org.openapitools.codegen.meta.Stability;
import org.openapitools.codegen.model.ModelMap;
import org.openapitools.codegen.model.OperationMap;
import org.openapitools.codegen.model.OperationsMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JetbrainsHttpClientClientCodegen
extends DefaultCodegen
implements CodegenConfig {
    private final Logger LOGGER = LoggerFactory.getLogger(JetbrainsHttpClientClientCodegen.class);
    public static final String JSON_ESCAPE_NEW_LINE = "\n";
    public static final String JSON_ESCAPE_DOUBLE_QUOTE = "\"";
    public static final String REQUEST_PARAMETER_GENERATION_DEFAULT_VALUE = "Example";
    protected String requestParameterGeneration = "Example";
    public static final String PROJECT_NAME = "Jetbrains HTTP Client";
    public static final String BODY_VARIABLES = "bodyVariables";
    public List<String> bodyVariables = new ArrayList<String>();
    public static final String CUSTOM_HEADERS = "customHeaders";
    public List<String> customHeaders = new ArrayList<String>();
    private final Map<String, Object> customVariables = new HashMap<String, Object>();

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "jetbrains-http-client";
    }

    @Override
    public String getHelp() {
        return "Generates a jetbrains-http client. See https://www.jetbrains.com/help/idea/http-client-in-product-code-editor.html";
    }

    @Override
    public GeneratorLanguage generatorLanguage() {
        return GeneratorLanguage.HTTP;
    }

    public JetbrainsHttpClientClientCodegen() {
        this.generatorMetadata = GeneratorMetadata.newBuilder((GeneratorMetadata)this.generatorMetadata).stability(Stability.EXPERIMENTAL).build();
        this.outputFolder = "generated-code" + File.separator + "jetbrains-http-client";
        this.apiTemplateFiles.put("api.mustache", ".http");
        this.templateDir = "jetbrains-http-client";
        this.embeddedTemplateDir = "jetbrains-http-client";
        this.apiPackage = "Apis";
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        this.supportingFiles.add(new SupportingFile("http-client.template.env.mustache", "Apis", "http-client.template.env.json"));
        this.cliOptions.clear();
        this.cliOptions.add(CliOption.newString(BODY_VARIABLES, "whether to convert body placeholders (i.e. VAR_1) into variables (i.e. {{VAR_1}})"));
        this.cliOptions.add(CliOption.newString(CUSTOM_HEADERS, "custom headers that can be set for each request. Can be used for unsupported features, for example auth methods like oauth."));
    }

    @Override
    public void processOpts() {
        super.processOpts();
        Map<String, Object> additionalProperties = this.additionalProperties();
        if (additionalProperties.containsKey(BODY_VARIABLES)) {
            this.bodyVariables = Arrays.asList(additionalProperties.get(BODY_VARIABLES).toString().split("-"));
        }
        if (additionalProperties.containsKey(CUSTOM_HEADERS)) {
            this.customHeaders = Arrays.asList(additionalProperties.get(CUSTOM_HEADERS).toString().split("&"));
        }
        this.bodyVariables.forEach(variable -> this.customVariables.put((String)variable, ""));
        for (String header : this.customHeaders) {
            List<String> variables = JetbrainsHttpClientClientCodegen.extractDoubleCurlyBraces(header);
            if (variables.isEmpty()) continue;
            variables.forEach(v -> this.customVariables.put((String)v, ""));
        }
    }

    @Override
    protected ImmutableMap.Builder<String, Mustache.Lambda> addMustacheLambdas() {
        return super.addMustacheLambdas().put((Object)"doubleMustache", (Object)new DoubleMustacheLambda());
    }

    @Override
    public OperationsMap postProcessOperationsWithModels(OperationsMap objs, List<ModelMap> allModels) {
        OperationsMap results = super.postProcessOperationsWithModels(objs, allModels);
        OperationMap ops = results.getOperations();
        List<CodegenOperation> opList = ops.getOperation();
        for (CodegenOperation codegenOperation : opList) {
            List<RequestItem> requests = this.getRequests(codegenOperation);
            if (requests == null) continue;
            codegenOperation.vendorExtensions.put("requests", requests);
            codegenOperation.vendorExtensions.put(CUSTOM_HEADERS, this.customHeaders);
        }
        return results;
    }

    @Override
    public Map<String, Object> postProcessSupportingFileData(Map<String, Object> objs) {
        ArrayList<String> variables = new ArrayList<String>(this.customVariables.keySet());
        objs.put("vendorExtensionsVariables", variables);
        return objs;
    }

    List<RequestItem> getRequests(CodegenOperation codegenOperation) {
        ArrayList<RequestItem> items = new ArrayList<RequestItem>();
        if (codegenOperation.getHasBodyParam()) {
            if (this.requestParameterGeneration.equalsIgnoreCase("Schema")) {
                items.add(new RequestItem(codegenOperation.summary, this.getJsonFromSchema(codegenOperation.bodyParam)));
            } else if (codegenOperation.bodyParam.example != null) {
                items.add(new RequestItem(codegenOperation.summary, this.formatJson(codegenOperation.bodyParam.example)));
            } else if (codegenOperation.bodyParam.getContent().get("application/json") != null && codegenOperation.bodyParam.getContent().get("application/json").getExamples() != null) {
                for (Map.Entry<String, Example> entry : codegenOperation.bodyParam.getContent().get("application/json").getExamples().entrySet()) {
                    String exampleRef = entry.getValue().get$ref();
                    if (exampleRef == null) continue;
                    Example example = (Example)this.openAPI.getComponents().getExamples().get(this.extractExampleByName(exampleRef));
                    String exampleAsString = this.getJsonFromExample(example);
                    items.add(new RequestItem(example.getSummary(), exampleAsString));
                }
            } else if (codegenOperation.bodyParam.getSchema() != null) {
                String exampleAsString = codegenOperation.bodyParam.getSchema().getExample();
                items.add(new RequestItem(codegenOperation.summary, exampleAsString));
            } else {
                items.add(new RequestItem(codegenOperation.summary, this.getJsonFromSchema(codegenOperation.bodyParam)));
            }
        } else {
            items.add(new RequestItem(codegenOperation.summary, null));
        }
        codegenOperation.headerParams.forEach(param -> this.customVariables.put(param.baseName, ""));
        codegenOperation.queryParams.forEach(param -> this.customVariables.put(param.paramName, ""));
        List<String> pathVariables = JetbrainsHttpClientClientCodegen.extractSingleCurlyBraces(codegenOperation.path);
        pathVariables.forEach(pv -> this.customVariables.put((String)pv, ""));
        return this.handleCustomVariablesInRequests(items);
    }

    public static List<String> extractDoubleCurlyBraces(String input) {
        ArrayList<String> result = new ArrayList<String>();
        Pattern pattern = Pattern.compile("\\{\\{([^}]+)\\}\\}");
        Matcher matcher = pattern.matcher(input);
        while (matcher.find()) {
            result.add(matcher.group(1));
        }
        return result;
    }

    public static List<String> extractSingleCurlyBraces(String input) {
        ArrayList<String> result = new ArrayList<String>();
        Pattern pattern = Pattern.compile("\\{([^}]+)\\}");
        Matcher matcher = pattern.matcher(input);
        while (matcher.find()) {
            result.add(matcher.group(1));
        }
        return result;
    }

    private List<RequestItem> handleCustomVariablesInRequests(List<RequestItem> items) {
        if (!this.bodyVariables.isEmpty()) {
            for (RequestItem item : items) {
                for (String customVariable : this.bodyVariables) {
                    String body = item.getBody();
                    if (body == null) continue;
                    body = body.replace(customVariable, "{{" + customVariable + "}}");
                    item.setBody(body);
                }
            }
        }
        return items;
    }

    @Override
    public void postProcess() {
        System.out.println("##########################################################################################");
        System.out.println("# Thanks for using OpenAPI Generator.                                                    #");
        System.out.println("# Please consider donation to help us maintain this project \ud83d\ude4f                 #");
        System.out.println("# https://opencollective.com/openapi_generator/donate                                    #");
        System.out.println("#                                                                                        #");
        System.out.println("# This generator was written by Julien Lengrand-Lambert (https://github.com/jlengrand)   #");
        System.out.println("##########################################################################################");
    }

    public String getJsonFromSchema(CodegenParameter codegenParameter) {
        Object ret = "{\n ";
        int numVars = codegenParameter.vars.size();
        int counter = 1;
        for (CodegenProperty codegenProperty : codegenParameter.vars) {
            ret = (String)ret + JSON_ESCAPE_DOUBLE_QUOTE + codegenProperty.baseName + "\": \"<" + this.getType(codegenProperty) + ">\"";
            if (counter < numVars) {
                ret = (String)ret + ",\n ";
            }
            ++counter;
        }
        ret = (String)ret + "\n}";
        return ret;
    }

    public String getType(CodegenProperty codegenProperty) {
        if (codegenProperty.isNumeric) {
            return "number";
        }
        if (codegenProperty.isDate) {
            return "date";
        }
        return "string";
    }

    public String formatJson(String json) {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            JsonNode actualObj = objectMapper.readTree(json);
            json = Json.pretty((Object)actualObj);
        }
        catch (JsonProcessingException e) {
            this.LOGGER.warn("Error formatting JSON", (Throwable)e);
            json = "";
        }
        return json;
    }

    public String extractExampleByName(String ref) {
        return ref.substring(ref.lastIndexOf("/") + 1);
    }

    public String getJsonFromExample(Example example) {
        String ret = "";
        if (example == null) {
            return ret;
        }
        if (example.getValue() instanceof ObjectNode) {
            ret = this.convertToJson((ObjectNode)example.getValue());
        } else if (example.getValue() instanceof LinkedHashMap) {
            ret = this.convertToJson((LinkedHashMap)example.getValue());
        }
        return ret;
    }

    public String convertToJson(ObjectNode objectNode) {
        return this.formatJson(objectNode.toString());
    }

    public String convertToJson(LinkedHashMap<String, Object> linkedHashMap) {
        String ret = "";
        return this.traverseMap(linkedHashMap, ret);
    }

    private String traverseMap(LinkedHashMap<String, Object> linkedHashMap, String ret) {
        ret = (String)ret + "{\n ";
        int numVars = linkedHashMap.entrySet().size();
        int counter = 1;
        for (Map.Entry<String, Object> mapElement : linkedHashMap.entrySet()) {
            String key = mapElement.getKey();
            Object value = mapElement.getValue();
            if (value instanceof String) {
                value = ((String)value).replace("\\\"", JSON_ESCAPE_DOUBLE_QUOTE);
                ret = (String)ret + JSON_ESCAPE_DOUBLE_QUOTE + key + "\": \"" + value + JSON_ESCAPE_DOUBLE_QUOTE;
            } else if (value instanceof Integer || value instanceof Boolean) {
                ret = (String)ret + JSON_ESCAPE_DOUBLE_QUOTE + key + "\": " + value;
            } else if (value instanceof HashMap) {
                String in = (String)ret + JSON_ESCAPE_DOUBLE_QUOTE + key + "\": ";
                ret = this.traverseMap((LinkedHashMap)value, in);
            } else if (value instanceof List) {
                List items = (List)value;
                StringBuilder jsonBuilder = new StringBuilder("[");
                for (int i = 0; i < items.size(); ++i) {
                    jsonBuilder.append(JSON_ESCAPE_DOUBLE_QUOTE).append(items.get(i)).append(JSON_ESCAPE_DOUBLE_QUOTE);
                    if (i >= items.size() - 1) continue;
                    jsonBuilder.append(",");
                }
                jsonBuilder.append("]");
                ret = (String)ret + JSON_ESCAPE_DOUBLE_QUOTE + key + "\": " + jsonBuilder;
            } else {
                this.LOGGER.warn("Value type unrecognised: " + value.getClass());
                ret = ((String)ret).substring(0, ((String)ret).length() - 3);
            }
            if (counter < numVars) {
                ret = (String)ret + ",\n ";
            }
            ++counter;
        }
        ret = (String)ret + "\n}";
        return ret;
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input;
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input;
    }

    public class RequestItem {
        private String name;
        private String body;

        public RequestItem(String name, String body) {
            this.name = name;
            this.body = body;
        }

        public String getName() {
            return this.name;
        }

        public String getBody() {
            return this.body;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setBody(String body) {
            this.body = body;
        }
    }

    public static class DoubleMustacheLambda
    implements Mustache.Lambda {
        public void execute(Template.Fragment fragment, Writer writer) throws IOException {
            String text = fragment.execute();
            writer.write(text.replaceAll("\\{", "{{").replaceAll("}", "}}"));
        }
    }
}

