/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import java.io.File;
import java.util.List;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenResponse;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.languages.JavaClientCodegen;
import org.openapitools.codegen.model.ModelMap;
import org.openapitools.codegen.model.OperationMap;
import org.openapitools.codegen.model.OperationsMap;

public class JavaMicroprofileServerCodegen
extends JavaClientCodegen {
    public static final String PROJECT_NAME = "projectName";
    public static final String MICROPROFILE_SERVER = "microprofileServer";
    protected boolean microprofileServer = true;

    public JavaMicroprofileServerCodegen() {
        this.outputFolder = "generated-code" + File.separator + "microprofile";
        this.invokerPackage = "org.openapitools.server";
        this.artifactId = "openapi-microprofile-server";
        this.apiPackage = "org.openapitools.server.api";
        this.modelPackage = "org.openapitools.server.model";
        this.setLibrary("microprofile");
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    @Override
    public String getName() {
        return "java-microprofile";
    }

    @Override
    public String getHelp() {
        return "Generates a microprofile server.";
    }

    @Override
    public void processOpts() {
        super.processOpts();
        this.additionalProperties.put(MICROPROFILE_SERVER, this.microprofileServer);
    }

    @Override
    public OperationsMap postProcessOperationsWithModels(OperationsMap objs, List<ModelMap> allModels) {
        super.postProcessOperationsWithModels(objs, allModels);
        OperationMap operations = objs.getOperations();
        if (operations != null) {
            List<CodegenOperation> ops = operations.getOperation();
            for (CodegenOperation operation : ops) {
                List<CodegenResponse> responses = operation.responses;
                if (!this.multiple2xxResponsesSpecified(responses)) continue;
                operation.vendorExtensions.put("x-multiple-2xx-response-operation", true);
            }
        }
        return objs;
    }

    private boolean multiple2xxResponsesSpecified(List<CodegenResponse> responses) {
        int responseIs2xxCount = 0;
        for (CodegenResponse response : responses) {
            if (!response.is2xx) continue;
            ++responseIs2xxCount;
        }
        return responseIs2xxCount > 1;
    }
}

