/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen;

import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.headers.Header;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.BooleanSchema;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.IntegerSchema;
import io.swagger.v3.oas.models.media.JsonSchema;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.NumberSchema;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.openapitools.codegen.utils.ModelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenAPINormalizer {
    private OpenAPI openAPI;
    private Map<String, String> inputRules = new HashMap<String, String>();
    private Map<String, Boolean> rules = new HashMap<String, Boolean>();
    private TreeSet<String> anyTypeTreeSet = new TreeSet();
    final Logger LOGGER = LoggerFactory.getLogger(OpenAPINormalizer.class);
    Set<String> ruleNames = new TreeSet<String>();
    Set<String> rulesDefaultToTrue = new TreeSet<String>();
    final String ENABLE_ALL = "ENABLE_ALL";
    boolean enableAll;
    final String DISABLE_ALL = "DISABLE_ALL";
    boolean disableAll;
    final String REF_AS_PARENT_IN_ALLOF = "REF_AS_PARENT_IN_ALLOF";
    final String KEEP_ONLY_FIRST_TAG_IN_OPERATION = "KEEP_ONLY_FIRST_TAG_IN_OPERATION";
    final String REMOVE_ANYOF_ONEOF_AND_KEEP_PROPERTIES_ONLY = "REMOVE_ANYOF_ONEOF_AND_KEEP_PROPERTIES_ONLY";
    final String SIMPLIFY_ANYOF_STRING_AND_ENUM_STRING = "SIMPLIFY_ANYOF_STRING_AND_ENUM_STRING";
    final String SIMPLIFY_ONEOF_ANYOF = "SIMPLIFY_ONEOF_ANYOF";
    final String SIMPLIFY_BOOLEAN_ENUM = "SIMPLIFY_BOOLEAN_ENUM";
    final String SET_TAGS_FOR_ALL_OPERATIONS = "SET_TAGS_FOR_ALL_OPERATIONS";
    String setTagsForAllOperations;
    final String SET_TAGS_TO_OPERATIONID = "SET_TAGS_TO_OPERATIONID";
    String setTagsToOperationId;
    final String ADD_UNSIGNED_TO_INTEGER_WITH_INVALID_MAX_VALUE = "ADD_UNSIGNED_TO_INTEGER_WITH_INVALID_MAX_VALUE";
    final String REFACTOR_ALLOF_WITH_PROPERTIES_ONLY = "REFACTOR_ALLOF_WITH_PROPERTIES_ONLY";
    final String NORMALIZE_31SPEC = "NORMALIZE_31SPEC";
    final String REMOVE_X_INTERNAL = "REMOVE_X_INTERNAL";
    final String X_INTERNAL = "x-internal";
    boolean removeXInternal;
    final String FILTER = "FILTER";
    HashSet<String> operationIdFilters = new HashSet();
    final String SET_CONTAINER_TO_NULLABLE = "SET_CONTAINER_TO_NULLABLE";
    HashSet<String> setContainerToNullable = new HashSet();
    boolean updateArrayToNullable;
    boolean updateSetToNullable;
    boolean updateMapToNullable;
    final String SET_PRIMITIVE_TYPES_TO_NULLABLE = "SET_PRIMITIVE_TYPES_TO_NULLABLE";
    HashSet<String> setPrimitiveTypesToNullable = new HashSet();
    boolean updateStringToNullable;
    boolean updateIntegerToNullable;
    boolean updateNumberToNullable;
    boolean updateBooleanToNullable;

    public OpenAPINormalizer(OpenAPI openAPI, Map<String, String> inputRules) {
        this.openAPI = openAPI;
        this.inputRules = inputRules;
        if (Boolean.parseBoolean(inputRules.get("DISABLE_ALL"))) {
            this.disableAll = true;
            return;
        }
        this.ruleNames.add("REF_AS_PARENT_IN_ALLOF");
        this.ruleNames.add("REMOVE_ANYOF_ONEOF_AND_KEEP_PROPERTIES_ONLY");
        this.ruleNames.add("SIMPLIFY_ANYOF_STRING_AND_ENUM_STRING");
        this.ruleNames.add("SIMPLIFY_ONEOF_ANYOF");
        this.ruleNames.add("SIMPLIFY_BOOLEAN_ENUM");
        this.ruleNames.add("KEEP_ONLY_FIRST_TAG_IN_OPERATION");
        this.ruleNames.add("SET_TAGS_FOR_ALL_OPERATIONS");
        this.ruleNames.add("SET_TAGS_TO_OPERATIONID");
        this.ruleNames.add("ADD_UNSIGNED_TO_INTEGER_WITH_INVALID_MAX_VALUE");
        this.ruleNames.add("REFACTOR_ALLOF_WITH_PROPERTIES_ONLY");
        this.ruleNames.add("NORMALIZE_31SPEC");
        this.ruleNames.add("REMOVE_X_INTERNAL");
        this.ruleNames.add("FILTER");
        this.ruleNames.add("SET_CONTAINER_TO_NULLABLE");
        this.ruleNames.add("SET_PRIMITIVE_TYPES_TO_NULLABLE");
        this.rules.put("SIMPLIFY_ONEOF_ANYOF", true);
        this.rules.put("SIMPLIFY_BOOLEAN_ENUM", true);
        this.processRules(inputRules);
        this.anyTypeTreeSet.add("string");
        this.anyTypeTreeSet.add("number");
        this.anyTypeTreeSet.add("integer");
        this.anyTypeTreeSet.add("boolean");
        this.anyTypeTreeSet.add("object");
        this.anyTypeTreeSet.add("array");
    }

    public boolean getRule(String ruleName) {
        if (!this.rules.containsKey(ruleName)) {
            return false;
        }
        return this.rules.get(ruleName);
    }

    public void processRules(Map<String, String> inputRules) {
        if (Boolean.TRUE.equals(this.rules.get("enableAll"))) {
            this.enableAll = true;
        }
        for (Map.Entry<String, String> rule : inputRules.entrySet()) {
            this.LOGGER.debug("processing rule {} => {}", (Object)rule.getKey(), (Object)rule.getValue());
            if (!this.ruleNames.contains(rule.getKey())) {
                this.LOGGER.warn("Invalid openapi-normalizer rule name: {}", (Object)rule.getKey());
                continue;
            }
            if (this.enableAll) {
                this.rules.put(rule.getKey(), true);
                continue;
            }
            this.rules.put(rule.getKey(), Boolean.parseBoolean(rule.getValue()));
        }
        this.setTagsForAllOperations = inputRules.get("SET_TAGS_FOR_ALL_OPERATIONS");
        if (this.setTagsForAllOperations != null) {
            this.rules.put("SET_TAGS_FOR_ALL_OPERATIONS", true);
        }
        if (inputRules.get("FILTER") != null) {
            this.rules.put("FILTER", true);
            String[] filterStrs = inputRules.get("FILTER").split(":");
            if (filterStrs.length != 2) {
                this.LOGGER.error("FILTER rule must be in the form of `operationId:name1|name2|name3`: {}", (Object)inputRules.get("FILTER"));
            } else if ("operationId".equals(filterStrs[0])) {
                this.operationIdFilters = new HashSet<String>(Arrays.asList(filterStrs[1].split("[|]")));
            } else {
                this.LOGGER.error("FILTER rule must be in the form of `operationId:name1|name2|name3`: {}", (Object)inputRules.get("FILTER"));
            }
        }
        if (inputRules.get("SET_CONTAINER_TO_NULLABLE") != null) {
            this.rules.put("SET_CONTAINER_TO_NULLABLE", true);
            this.setContainerToNullable = new HashSet<String>(Arrays.asList(inputRules.get("SET_CONTAINER_TO_NULLABLE").split("[|]")));
            if (this.setContainerToNullable.contains("array")) {
                this.updateArrayToNullable = true;
            }
            if (this.setContainerToNullable.contains("set")) {
                this.updateSetToNullable = true;
            }
            if (this.setContainerToNullable.contains("map")) {
                this.updateMapToNullable = true;
            }
            if (!(this.updateArrayToNullable || this.updateSetToNullable || this.updateMapToNullable)) {
                this.LOGGER.error("SET_CONTAINER_TO_NULLABLE rule must be in the form of `array|set|map`, e.g. `set`, `array|map`: {}", (Object)inputRules.get("SET_CONTAINER_TO_NULLABLE"));
            }
        }
        if (inputRules.get("SET_PRIMITIVE_TYPES_TO_NULLABLE") != null) {
            this.rules.put("SET_PRIMITIVE_TYPES_TO_NULLABLE", true);
            this.setPrimitiveTypesToNullable = new HashSet<String>(Arrays.asList(inputRules.get("SET_PRIMITIVE_TYPES_TO_NULLABLE").split("[|]")));
            if (this.setPrimitiveTypesToNullable.contains("string")) {
                this.updateStringToNullable = true;
            }
            if (this.setPrimitiveTypesToNullable.contains("integer")) {
                this.updateIntegerToNullable = true;
            }
            if (this.setPrimitiveTypesToNullable.contains("number")) {
                this.updateNumberToNullable = true;
            }
            if (this.setPrimitiveTypesToNullable.contains("boolean")) {
                this.updateBooleanToNullable = true;
            }
            if (!(this.updateStringToNullable || this.updateIntegerToNullable || this.updateNumberToNullable || this.updateBooleanToNullable)) {
                this.LOGGER.error("SET_PRIMITIVE_TYPES_TO_NULLABLE rule must be in the form of `string|integer|number|boolean`, e.g. `string`, `integer|number`: {}", (Object)inputRules.get("SET_PRIMITIVE_TYPES_TO_NULLABLE"));
            }
        }
    }

    void normalize() {
        if (this.rules == null || this.rules.isEmpty() || this.disableAll) {
            return;
        }
        if (this.openAPI.getComponents() == null) {
            this.openAPI.setComponents(new Components());
        }
        if (this.openAPI.getComponents().getSchemas() == null) {
            this.openAPI.getComponents().setSchemas(new HashMap());
        }
        this.normalizePaths();
        this.normalizeComponentsSchemas();
    }

    private void normalizePaths() {
        Paths paths = this.openAPI.getPaths();
        if (paths == null) {
            return;
        }
        for (Map.Entry pathsEntry : paths.entrySet()) {
            PathItem path = (PathItem)pathsEntry.getValue();
            ArrayList operations = new ArrayList(path.readOperations());
            for (Operation operation : path.readOperations()) {
                Map callbacks = operation.getCallbacks();
                if (callbacks == null) continue;
                operations.addAll(callbacks.values().stream().flatMap(callback -> callback.values().stream()).flatMap(pathItem -> pathItem.readOperations().stream()).collect(Collectors.toList()));
            }
            this.normalizeParameters(path.getParameters());
            for (Operation operation : operations) {
                if (this.operationIdFilters.size() > 0) {
                    if (this.operationIdFilters.contains(operation.getOperationId())) {
                        operation.addExtension("x-internal", (Object)false);
                    } else {
                        this.LOGGER.info("operation `{}` marked as internal only (x-internal: true) by the FILTER", (Object)operation.getOperationId());
                        operation.addExtension("x-internal", (Object)true);
                    }
                }
                this.normalizeOperation(operation);
                this.normalizeRequestBody(operation);
                this.normalizeParameters(operation.getParameters());
                this.normalizeResponses(operation);
            }
        }
    }

    private void normalizeOperation(Operation operation) {
        this.processRemoveXInternalFromOperation(operation);
        this.processKeepOnlyFirstTagInOperation(operation);
        this.processSetTagsForAllOperations(operation);
        this.processSetTagsToOperationId(operation);
    }

    private void normalizeContent(Content content) {
        if (content == null || content.isEmpty()) {
            return;
        }
        for (String contentType : content.keySet()) {
            MediaType mediaType = (MediaType)content.get((Object)contentType);
            if (mediaType == null || mediaType.getSchema() == null) continue;
            Schema newSchema = this.normalizeSchema(mediaType.getSchema(), new HashSet<Schema>());
            mediaType.setSchema(newSchema);
        }
    }

    private void normalizeRequestBody(Operation operation) {
        RequestBody requestBody = operation.getRequestBody();
        if (requestBody == null) {
            return;
        }
        if (requestBody.get$ref() != null) {
            String ref = ModelUtils.getSimpleRef(requestBody.get$ref());
            requestBody = (RequestBody)this.openAPI.getComponents().getRequestBodies().get(ref);
            if (requestBody == null) {
                return;
            }
        }
        this.normalizeContent(requestBody.getContent());
    }

    private void normalizeParameters(List<Parameter> parameters) {
        if (parameters == null) {
            return;
        }
        for (Parameter parameter : parameters) {
            if (StringUtils.isNotEmpty((CharSequence)parameter.get$ref())) {
                parameter = ModelUtils.getReferencedParameter(this.openAPI, parameter);
            }
            if (parameter.getSchema() == null) continue;
            Schema newSchema = this.normalizeSchema(parameter.getSchema(), new HashSet<Schema>());
            parameter.setSchema(newSchema);
        }
    }

    private void normalizeResponses(Operation operation) {
        ApiResponses responses = operation.getResponses();
        if (responses == null) {
            return;
        }
        for (Map.Entry responsesEntry : responses.entrySet()) {
            if (responsesEntry.getValue() == null) continue;
            this.normalizeContent(ModelUtils.getReferencedApiResponse(this.openAPI, (ApiResponse)responsesEntry.getValue()).getContent());
            this.normalizeHeaders(ModelUtils.getReferencedApiResponse(this.openAPI, (ApiResponse)responsesEntry.getValue()).getHeaders());
        }
    }

    private void normalizeHeaders(Map<String, Header> headers) {
        if (headers == null || headers.isEmpty()) {
            return;
        }
        for (String headerKey : headers.keySet()) {
            Header h = headers.get(headerKey);
            Schema updatedHeader = this.normalizeSchema(h.getSchema(), new HashSet<Schema>());
            h.setSchema(updatedHeader);
        }
    }

    private void normalizeComponentsSchemas() {
        Map schemas = this.openAPI.getComponents().getSchemas();
        if (schemas == null) {
            return;
        }
        ArrayList schemaNames = new ArrayList(schemas.keySet());
        for (String schemaName : schemaNames) {
            Schema schema = (Schema)schemas.get(schemaName);
            if (schema == null) {
                this.LOGGER.warn("{} not fount found in openapi/components/schemas.", (Object)schemaName);
                continue;
            }
            if (schema.getExtensions() != null && this.getRule("REMOVE_X_INTERNAL") && Boolean.parseBoolean(String.valueOf(schema.getExtensions().get("x-internal")))) {
                schema.getExtensions().remove("x-internal");
            }
            schemas.put(schemaName, this.normalizeSchema(schema, new HashSet<Schema>()));
        }
    }

    public Schema normalizeSchema(Schema schema, Set<Schema> visitedSchemas) {
        if (schema == null) {
            return schema;
        }
        if (StringUtils.isNotEmpty((CharSequence)schema.get$ref())) {
            return schema;
        }
        if (visitedSchemas.contains(schema)) {
            return schema;
        }
        visitedSchemas.add(schema);
        if (ModelUtils.isArraySchema(schema)) {
            Schema result = this.normalizeArraySchema(schema);
            this.normalizeSchema(result.getItems(), visitedSchemas);
            return result;
        }
        if (schema.getAdditionalProperties() instanceof Schema) {
            this.normalizeMapSchema(schema);
            this.normalizeSchema((Schema)schema.getAdditionalProperties(), visitedSchemas);
        } else {
            if (ModelUtils.isOneOf(schema)) {
                return this.normalizeOneOf(schema, visitedSchemas);
            }
            if (ModelUtils.isAnyOf(schema)) {
                return this.normalizeAnyOf(schema, visitedSchemas);
            }
            if (ModelUtils.isAllOfWithProperties(schema)) {
                schema = this.normalizeAllOfWithProperties(schema, visitedSchemas);
                this.normalizeSchema(schema, visitedSchemas);
            } else {
                if (ModelUtils.isAllOf(schema)) {
                    return this.normalizeAllOf(schema, visitedSchemas);
                }
                if (ModelUtils.isComposedSchema(schema)) {
                    if (ModelUtils.isComplexComposedSchema(schema)) {
                        schema = this.normalizeComplexComposedSchema(schema, visitedSchemas);
                    }
                    if (schema.getAllOf() != null && !schema.getAllOf().isEmpty()) {
                        return this.normalizeAllOf(schema, visitedSchemas);
                    }
                    if (schema.getOneOf() != null && !schema.getOneOf().isEmpty()) {
                        return this.normalizeOneOf(schema, visitedSchemas);
                    }
                    if (schema.getAnyOf() != null && !schema.getAnyOf().isEmpty()) {
                        return this.normalizeAnyOf(schema, visitedSchemas);
                    }
                    if (schema.getProperties() != null && !schema.getProperties().isEmpty()) {
                        this.normalizeProperties(schema.getProperties(), visitedSchemas);
                    }
                    if (schema.getAdditionalProperties() != null) {
                        // empty if block
                    }
                    return schema;
                }
                if (schema.getProperties() != null && !schema.getProperties().isEmpty()) {
                    this.normalizeProperties(schema.getProperties(), visitedSchemas);
                } else if (schema instanceof BooleanSchema) {
                    this.normalizeBooleanSchema(schema, visitedSchemas);
                } else if (schema instanceof IntegerSchema) {
                    this.normalizeIntegerSchema(schema, visitedSchemas);
                } else {
                    if (schema instanceof Schema) {
                        return this.normalizeSimpleSchema(schema, visitedSchemas);
                    }
                    throw new RuntimeException("Unknown schema type found in normalizer: " + schema);
                }
            }
        }
        return schema;
    }

    private Schema normalizeArraySchema(Schema schema) {
        Schema result = this.processNormalize31Spec(schema, new HashSet<Schema>());
        return this.processSetArraytoNullable(result);
    }

    private Schema normalizeMapSchema(Schema schema) {
        return this.processSetMapToNullable(schema);
    }

    private Schema normalizeSimpleSchema(Schema schema, Set<Schema> visitedSchemas) {
        Schema result = this.processNormalize31Spec(schema, visitedSchemas);
        return this.processSetPrimitiveTypesToNullable(result);
    }

    private void normalizeBooleanSchema(Schema schema, Set<Schema> visitedSchemas) {
        this.processSimplifyBooleanEnum(schema);
        this.processSetPrimitiveTypesToNullable(schema);
    }

    private void normalizeIntegerSchema(Schema schema, Set<Schema> visitedSchemas) {
        this.processAddUnsignedToIntegerWithInvalidMaxValue(schema);
        this.processSetPrimitiveTypesToNullable(schema);
    }

    private void normalizeProperties(Map<String, Schema> properties, Set<Schema> visitedSchemas) {
        if (properties == null) {
            return;
        }
        for (Map.Entry<String, Schema> propertiesEntry : properties.entrySet()) {
            Schema property = propertiesEntry.getValue();
            Schema newProperty = this.normalizeSchema(property, new HashSet<Schema>());
            propertiesEntry.setValue(newProperty);
        }
    }

    private Schema normalizeAllOf(Schema schema, Set<Schema> visitedSchemas) {
        for (Object item : schema.getAllOf()) {
            if (!(item instanceof Schema)) {
                throw new RuntimeException("Error! allOf schema is not of the type Schema: " + item);
            }
            this.normalizeSchema((Schema)item, visitedSchemas);
        }
        this.processUseAllOfRefAsParent(schema);
        return schema;
    }

    private Schema normalizeAllOfWithProperties(Schema schema, Set<Schema> visitedSchemas) {
        for (Object item : schema.getAllOf()) {
            if (!(item instanceof Schema)) {
                throw new RuntimeException("Error! allOf schema is not of the type Schema: " + item);
            }
            this.normalizeSchema((Schema)item, visitedSchemas);
        }
        schema = this.processRefactorAllOfWithPropertiesOnly(schema);
        return schema;
    }

    private Schema normalizeOneOf(Schema schema, Set<Schema> visitedSchemas) {
        for (Object item : schema.getOneOf()) {
            if (item == null) continue;
            if (!(item instanceof Schema)) {
                throw new RuntimeException("Error! oneOf schema is not of the type Schema: " + item);
            }
            this.normalizeSchema((Schema)item, visitedSchemas);
        }
        schema = this.processSimplifyOneOf(schema);
        return schema;
    }

    private Schema normalizeAnyOf(Schema schema, Set<Schema> visitedSchemas) {
        for (Object item : schema.getAnyOf()) {
            if (item == null) continue;
            if (!(item instanceof Schema)) {
                throw new RuntimeException("Error! anyOf schema is not of the type Schema: " + item);
            }
            this.normalizeSchema((Schema)item, visitedSchemas);
        }
        schema = this.processSimplifyAnyOf(schema);
        return this.processSimplifyAnyOfStringAndEnumString(schema);
    }

    private Schema normalizeComplexComposedSchema(Schema schema, Set<Schema> visitedSchemas) {
        if (schema.getProperties() != null && !schema.getProperties().isEmpty()) {
            this.normalizeProperties(schema.getProperties(), visitedSchemas);
        }
        this.processRemoveAnyOfOneOfAndKeepPropertiesOnly(schema);
        return schema;
    }

    private void processUseAllOfRefAsParent(Schema schema) {
        if (!this.getRule("REF_AS_PARENT_IN_ALLOF")) {
            return;
        }
        if (schema.getAllOf() == null) {
            return;
        }
        if (schema.getAllOf().size() == 1) {
            return;
        }
        for (Object item : schema.getAllOf()) {
            if (!(item instanceof Schema)) {
                throw new RuntimeException("Error! allOf schema is not of the type Schema: " + item);
            }
            Schema s = (Schema)item;
            if (!StringUtils.isNotEmpty((CharSequence)s.get$ref())) continue;
            String ref = ModelUtils.getSimpleRef(s.get$ref());
            Schema refSchema = (Schema)this.openAPI.getComponents().getSchemas().get(ref);
            if (refSchema == null) {
                throw new RuntimeException("schema cannot be null with ref " + ref);
            }
            if (refSchema.getExtensions() == null) {
                refSchema.setExtensions(new HashMap());
            }
            if (!refSchema.getExtensions().containsKey("x-parent")) {
                refSchema.getExtensions().put("x-parent", true);
            }
            this.LOGGER.debug("processUseAllOfRefAsParent added `x-parent: true` to {}", (Object)refSchema);
        }
    }

    private void processRemoveXInternalFromOperation(Operation operation) {
        if (!this.getRule("REMOVE_X_INTERNAL")) {
            return;
        }
        if (operation.getExtensions() == null) {
            return;
        }
        if (Boolean.parseBoolean(String.valueOf(operation.getExtensions().get("x-internal")))) {
            operation.getExtensions().remove("x-internal");
        }
    }

    private void processKeepOnlyFirstTagInOperation(Operation operation) {
        if (!this.getRule("KEEP_ONLY_FIRST_TAG_IN_OPERATION")) {
            return;
        }
        if (operation.getTags() != null && !operation.getTags().isEmpty() && operation.getTags().size() > 1) {
            String firstTag = (String)operation.getTags().get(0);
            operation.setTags(null);
            operation.addTagsItem(firstTag);
        }
    }

    private void processSetTagsForAllOperations(Operation operation) {
        if (StringUtils.isEmpty((CharSequence)this.setTagsForAllOperations)) {
            return;
        }
        operation.setTags(null);
        operation.addTagsItem(this.setTagsForAllOperations);
    }

    private void processSetTagsToOperationId(Operation operation) {
        if (!this.getRule("SET_TAGS_TO_OPERATIONID")) {
            return;
        }
        operation.setTags(null);
        if (StringUtils.isNotEmpty((CharSequence)operation.getOperationId())) {
            operation.addTagsItem(operation.getOperationId());
        } else {
            operation.addTagsItem("default");
        }
    }

    private void processRemoveAnyOfOneOfAndKeepPropertiesOnly(Schema schema) {
        if (!this.getRule("REMOVE_ANYOF_ONEOF_AND_KEEP_PROPERTIES_ONLY")) {
            return;
        }
        if ((schema.getOneOf() != null && !schema.getOneOf().isEmpty() || schema.getAnyOf() != null && !schema.getAnyOf().isEmpty()) && schema.getProperties() != null && !schema.getProperties().isEmpty() && schema.getAllOf() == null) {
            schema.setOneOf(null);
            schema.setAnyOf(null);
        }
    }

    private Schema processSimplifyAnyOfStringAndEnumString(Schema schema) {
        if (!this.getRule("SIMPLIFY_ANYOF_STRING_AND_ENUM_STRING")) {
            return schema;
        }
        if (schema.getAnyOf() == null) {
            return schema;
        }
        Object result = null;
        Schema<?> s0 = null;
        Schema<?> s1 = null;
        if (schema.getAnyOf().size() != 2) {
            return schema;
        }
        s0 = ModelUtils.unaliasSchema(this.openAPI, (Schema)schema.getAnyOf().get(0));
        s1 = ModelUtils.unaliasSchema(this.openAPI, (Schema)schema.getAnyOf().get(1));
        s0 = ModelUtils.getReferencedSchema(this.openAPI, (Schema)s0);
        s1 = ModelUtils.getReferencedSchema(this.openAPI, (Schema)s1);
        result = s0 instanceof StringSchema && s1 instanceof StringSchema ? (((StringSchema)s0).getEnum() != null ? (StringSchema)s0 : (((StringSchema)s1).getEnum() != null ? (StringSchema)s1 : schema)) : schema;
        if (schema.getNullable() != null) {
            result.setNullable(schema.getNullable());
        }
        if (schema.getDefault() != null) {
            result.setDefault(schema.getDefault());
        }
        return result;
    }

    public boolean isNullTypeSchema(Schema schema) {
        Schema<?> referencedSchema;
        if (schema == null) {
            return true;
        }
        if (ModelUtils.hasAllOf(schema) || ModelUtils.hasOneOf(schema) || ModelUtils.hasAnyOf(schema)) {
            return false;
        }
        if (schema.getTypes() != null && !schema.getTypes().isEmpty()) {
            if (schema.getTypes().size() == 1) {
                String type = (String)schema.getTypes().iterator().next();
                return type == null || "null".equals(type);
            }
            return false;
        }
        if (schema instanceof JsonSchema) {
            if (Boolean.TRUE.equals(schema.getNullable())) {
                return true;
            }
            if (schema.getTypes() == null && schema.get$ref() == null) {
                return true;
            }
        } else if ((schema.getType() == null || schema.getType().equals("null")) && schema.get$ref() == null) {
            return true;
        }
        return (referencedSchema = ModelUtils.getReferencedSchema(this.openAPI, schema)).getEnum() != null && referencedSchema.getEnum().size() == 1 && "null".equals(String.valueOf(referencedSchema.getEnum().get(0)));
    }

    private Schema processSimplifyOneOf(Schema schema) {
        if (!this.getRule("SIMPLIFY_ONEOF_ANYOF")) {
            return schema;
        }
        List oneOfSchemas = schema.getOneOf();
        if (oneOfSchemas != null) {
            if (oneOfSchemas.size() == 6) {
                TreeSet<String> ts = new TreeSet<String>();
                for (Schema<?> s : oneOfSchemas) {
                    String type = ModelUtils.getType(s = ModelUtils.getReferencedSchema(this.openAPI, (Schema)s));
                    if (type == null) {
                        this.LOGGER.debug("Error null type found in schema when simplifying any type with 6 sub-schemas: {}", s);
                        continue;
                    }
                    ts.add(type);
                }
                if (ts.equals(this.anyTypeTreeSet)) {
                    Schema anyType = new Schema();
                    anyType.setDescription(schema.getDescription());
                    anyType.setNullable(schema.getNullable());
                    anyType.setExtensions(schema.getExtensions());
                    anyType.setTitle(schema.getTitle());
                    anyType.setExample(schema.getExample());
                    anyType.setExamples(schema.getExamples());
                    anyType.setDefault(schema.getDefault());
                    anyType.setDeprecated(schema.getDeprecated());
                    return anyType;
                }
            }
            if (oneOfSchemas.removeIf(oneOf -> this.isNullTypeSchema((Schema)oneOf))) {
                schema.setNullable(Boolean.valueOf(true));
                if (oneOfSchemas.size() == 1) {
                    if (Boolean.TRUE.equals(schema.getNullable())) {
                        ((Schema)oneOfSchemas.get(0)).setNullable(Boolean.valueOf(true));
                    }
                    return (Schema)oneOfSchemas.get(0);
                }
            }
        }
        return schema;
    }

    private Schema processSetArraytoNullable(Schema schema) {
        if (!this.getRule("SET_CONTAINER_TO_NULLABLE")) {
            return schema;
        }
        if (Boolean.TRUE.equals(schema.getUniqueItems()) ? this.updateSetToNullable : this.updateArrayToNullable) {
            return this.setNullable(schema);
        }
        return schema;
    }

    private Schema processSetPrimitiveTypesToNullable(Schema schema) {
        if (!this.getRule("SET_PRIMITIVE_TYPES_TO_NULLABLE")) {
            return schema;
        }
        if (this.updateStringToNullable && "string".equals(schema.getType())) {
            return this.setNullable(schema);
        }
        if (this.updateIntegerToNullable && "integer".equals(schema.getType())) {
            return this.setNullable(schema);
        }
        if (this.updateNumberToNullable && "number".equals(schema.getType())) {
            return this.setNullable(schema);
        }
        if (this.updateBooleanToNullable && "boolean".equals(schema.getType())) {
            return this.setNullable(schema);
        }
        return schema;
    }

    private Schema setNullable(Schema schema) {
        if (schema.getNullable() != null || schema.getExtensions() != null && schema.getExtensions().containsKey("x-nullable")) {
            return schema;
        }
        schema.setNullable(Boolean.valueOf(true));
        return schema;
    }

    private Schema processSetMapToNullable(Schema schema) {
        if (!this.getRule("SET_CONTAINER_TO_NULLABLE")) {
            return schema;
        }
        if (this.updateMapToNullable) {
            return this.setNullable(schema);
        }
        return schema;
    }

    private Schema processSimplifyAnyOf(Schema schema) {
        if (!this.getRule("SIMPLIFY_ONEOF_ANYOF")) {
            return schema;
        }
        List anyOfSchemas = schema.getAnyOf();
        if (anyOfSchemas != null) {
            if (anyOfSchemas.size() == 6) {
                TreeSet<String> ts = new TreeSet<String>();
                for (Schema<?> s : anyOfSchemas) {
                    String type = ModelUtils.getType(s = ModelUtils.getReferencedSchema(this.openAPI, (Schema)s));
                    if (type == null) {
                        this.LOGGER.debug("Error null type found in schema when simplifying any type with 6 sub-schemas: {}", s);
                        continue;
                    }
                    ts.add(type);
                }
                if (ts.equals(this.anyTypeTreeSet)) {
                    Schema anyType = new Schema();
                    anyType.setDescription(schema.getDescription());
                    anyType.setNullable(schema.getNullable());
                    anyType.setExtensions(schema.getExtensions());
                    anyType.setTitle(schema.getTitle());
                    anyType.setExample(schema.getExample());
                    anyType.setExamples(schema.getExamples());
                    anyType.setDefault(schema.getDefault());
                    anyType.setDeprecated(schema.getDeprecated());
                    return anyType;
                }
            }
            if (anyOfSchemas.removeIf(anyOf -> this.isNullTypeSchema((Schema)anyOf))) {
                schema.setNullable(Boolean.valueOf(true));
            }
            if (anyOfSchemas.size() == 1) {
                if (Boolean.TRUE.equals(schema.getNullable())) {
                    ((Schema)anyOfSchemas.get(0)).setNullable(Boolean.valueOf(true));
                }
                return (Schema)anyOfSchemas.get(0);
            }
        }
        return schema;
    }

    private void processSimplifyBooleanEnum(Schema schema) {
        BooleanSchema bs;
        if (!this.getRule("SIMPLIFY_BOOLEAN_ENUM")) {
            return;
        }
        if (schema instanceof BooleanSchema && (bs = (BooleanSchema)schema).getEnum() != null && !bs.getEnum().isEmpty()) {
            bs.setEnum(null);
        }
    }

    private void processAddUnsignedToIntegerWithInvalidMaxValue(Schema schema) {
        if (!this.getRule("ADD_UNSIGNED_TO_INTEGER_WITH_INVALID_MAX_VALUE")) {
            return;
        }
        if (schema instanceof IntegerSchema) {
            if (ModelUtils.isLongSchema(schema)) {
                if ("18446744073709551615".equals(String.valueOf(schema.getMaximum())) && "0".equals(String.valueOf(schema.getMinimum()))) {
                    schema.addExtension("x-unsigned", (Object)true);
                }
            } else if ("4294967295".equals(String.valueOf(schema.getMaximum())) && "0".equals(String.valueOf(schema.getMinimum()))) {
                schema.addExtension("x-unsigned", (Object)true);
            }
        }
    }

    private Schema processRefactorAllOfWithPropertiesOnly(Schema schema) {
        if (!this.getRule("REFACTOR_ALLOF_WITH_PROPERTIES_ONLY")) {
            return schema;
        }
        ObjectSchema os = new ObjectSchema();
        os.setProperties(schema.getProperties());
        os.setRequired(schema.getRequired());
        os.setAdditionalProperties(schema.getAdditionalProperties());
        os.setNullable(schema.getNullable());
        os.setDescription(schema.getDescription());
        os.setDeprecated(schema.getDeprecated());
        os.setExample(schema.getExample());
        os.setExamples(schema.getExamples());
        os.setTitle(schema.getTitle());
        schema.getAllOf().add(os);
        schema.setProperties(null);
        schema.setRequired(null);
        schema.setAdditionalProperties(null);
        schema.setNullable(null);
        schema.setDescription(null);
        schema.setDeprecated(null);
        schema.setExample(null);
        schema.setExamples(null);
        schema.setTitle(null);
        return schema;
    }

    private Schema processNormalize31Spec(Schema schema, Set<Schema> visitedSchemas) {
        if (!this.getRule("NORMALIZE_31SPEC")) {
            return schema;
        }
        if (schema == null) {
            return null;
        }
        if (schema instanceof JsonSchema && schema.get$schema() == null && schema.getTypes() == null && schema.getType() == null) {
            return new Schema();
        }
        if (schema.getTypes() == null) {
            return schema;
        }
        if (schema.getTypes().contains("null")) {
            schema.setNullable(Boolean.valueOf(true));
            schema.getTypes().remove("null");
        }
        if (schema.getTypes().size() == 1) {
            String type = String.valueOf(schema.getTypes().iterator().next());
            if (ModelUtils.isArraySchema(schema)) {
                ArraySchema as = new ArraySchema();
                as.setDescription(schema.getDescription());
                as.setDefault(schema.getDefault());
                if (schema.getExample() != null) {
                    as.setExample(schema.getExample());
                }
                if (schema.getExamples() != null) {
                    as.setExamples(schema.getExamples());
                }
                as.setMinItems(schema.getMinItems());
                as.setMaxItems(schema.getMaxItems());
                as.setExtensions(schema.getExtensions());
                as.setXml(schema.getXml());
                as.setUniqueItems(schema.getUniqueItems());
                if (schema.getItems() != null) {
                    if (StringUtils.isNotEmpty((CharSequence)schema.getItems().get$ref())) {
                        Schema ref = new Schema();
                        ref.set$ref(schema.getItems().get$ref());
                        as.setItems(ref);
                    } else {
                        Schema updatedItems = this.normalizeSchema(schema.getItems(), visitedSchemas);
                        as.setItems(updatedItems);
                    }
                }
                return as;
            }
            schema.setType(type);
        } else {
            block12: for (Object type : schema.getTypes()) {
                switch (String.valueOf(type)) {
                    case "string": {
                        schema.addAnyOfItem((Schema)new StringSchema());
                        continue block12;
                    }
                    case "integer": {
                        schema.addAnyOfItem((Schema)new IntegerSchema());
                        continue block12;
                    }
                    case "number": {
                        schema.addAnyOfItem((Schema)new NumberSchema());
                        continue block12;
                    }
                    case "boolean": {
                        schema.addAnyOfItem((Schema)new BooleanSchema());
                        continue block12;
                    }
                }
                this.LOGGER.error("Type {} not yet supported in openapi-normalizer to process OpenAPI 3.1 spec with multiple types.");
                this.LOGGER.error("Please report the issue via https://github.com/OpenAPITools/openapi-generator/issues/new/.");
            }
        }
        return schema;
    }
}

