/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.openapitools.codegen.DryRunStatus;
import org.openapitools.codegen.api.TemplateProcessor;
import org.openapitools.codegen.templating.TemplateManagerOptions;

public class DryRunTemplateManager
implements TemplateProcessor {
    private final TemplateManagerOptions options;
    private final Map<String, DryRunStatus> dryRunStatusMap = new HashMap<String, DryRunStatus>();
    private final Map<String, Map<String, Object>> capturedTemplateData = new HashMap<String, Map<String, Object>>();
    private boolean recordTemplateData = false;

    public DryRunTemplateManager(TemplateManagerOptions options) {
        this.options = options;
    }

    public Map<String, DryRunStatus> getDryRunStatusMap() {
        return Collections.unmodifiableMap(this.dryRunStatusMap);
    }

    public File write(Map<String, Object> data, String template, File target) throws IOException {
        if (this.recordTemplateData) {
            this.capturedTemplateData.put(target.getAbsolutePath(), data);
        }
        return this.writeToFile(target.getAbsolutePath(), "dummy".getBytes(StandardCharsets.UTF_8));
    }

    public File writeToFile(String filename, byte[] contents) throws IOException {
        Path path = Paths.get(filename, new String[0]);
        File outputFile = path.toFile();
        DryRunStatus status = new DryRunStatus(path);
        if (outputFile.exists()) {
            if (this.options.isSkipOverwrite()) {
                status = new DryRunStatus(path, DryRunStatus.State.SkippedOverwrite, "File exists and skip overwrite option is enabled.");
            } else if (this.options.isMinimalUpdate()) {
                status.setState(DryRunStatus.State.WriteIfNewer);
            } else {
                status.setState(DryRunStatus.State.Write);
            }
        } else if (this.options.isMinimalUpdate()) {
            status.setState(DryRunStatus.State.WriteIfNewer);
        } else {
            status.setState(DryRunStatus.State.Write);
        }
        this.dryRunStatusMap.put(filename, status);
        return outputFile;
    }

    public void ignore(Path path, String context) {
        this.dryRunStatusMap.put(path.toString(), new DryRunStatus(path, DryRunStatus.State.Ignored, context));
    }

    public void skip(Path path, String context) {
        DryRunStatus status = new DryRunStatus(path, DryRunStatus.State.Skipped, context);
        if (this.options.isSkipOverwrite() && path.toFile().exists()) {
            status.setState(DryRunStatus.State.SkippedOverwrite);
        }
        this.dryRunStatusMap.put(path.toString(), status);
    }

    public void error(Path path, String context) {
        this.dryRunStatusMap.put(path.toString(), new DryRunStatus(path, DryRunStatus.State.Error, context));
    }

    public DryRunTemplateManager enableTemplateDataCapturing() {
        this.recordTemplateData = true;
        return this;
    }

    public Map<String, Object> getCapturedTemplateData(Path generatedFile) {
        return this.capturedTemplateData.getOrDefault(generatedFile.toString(), Map.of());
    }
}

