/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Schema;
import java.io.File;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenSecurity;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.DefaultCodegen;
import org.openapitools.codegen.GeneratorLanguage;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.meta.features.GlobalFeature;
import org.openapitools.codegen.meta.features.ParameterFeature;
import org.openapitools.codegen.meta.features.SchemaSupportFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.meta.features.WireFormatFeature;
import org.openapitools.codegen.model.ModelMap;
import org.openapitools.codegen.model.OperationMap;
import org.openapitools.codegen.model.OperationsMap;
import org.openapitools.codegen.utils.ModelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScalaFinchServerCodegen
extends DefaultCodegen
implements CodegenConfig {
    private final Logger LOGGER = LoggerFactory.getLogger(ScalaFinchServerCodegen.class);
    protected String invokerPackage = "org.openapitools.client";
    protected String groupId = "org.openapitools";
    protected String artifactId = "finch-server";
    protected String artifactVersion = "1.0.0";
    protected String sourceFolder = "src/main/scala";
    protected String packageName = "org.openapitools";

    public ScalaFinchServerCodegen() {
        this.modifyFeatureSet(features -> features.includeDocumentationFeatures(new DocumentationFeature[]{DocumentationFeature.Readme}).wireFormatFeatures(EnumSet.of(WireFormatFeature.JSON, WireFormatFeature.XML, WireFormatFeature.Custom)).securityFeatures(EnumSet.noneOf(SecurityFeature.class)).excludeGlobalFeatures(new GlobalFeature[]{GlobalFeature.XMLStructureDefinitions, GlobalFeature.Callbacks, GlobalFeature.LinkObjects, GlobalFeature.ParameterStyling}).excludeSchemaSupportFeatures(new SchemaSupportFeature[]{SchemaSupportFeature.Polymorphism}).excludeParameterFeatures(new ParameterFeature[]{ParameterFeature.Cookie}));
        this.outputFolder = "generated-code/finch";
        this.modelTemplateFiles.put("model.mustache", ".scala");
        this.apiTemplateFiles.put("api.mustache", ".scala");
        this.templateDir = "scala-finch";
        this.embeddedTemplateDir = "scala-finch";
        this.apiPackage = this.packageName + ".apis";
        this.modelPackage = this.packageName + ".models";
        this.setReservedWordsLowerCase(Arrays.asList("abstract", "case", "catch", "class", "def", "do", "else", "extends", "false", "final", "finally", "for", "forSome", "if", "implicit", "import", "lazy", "match", "new", "null", "object", "override", "package", "private", "protected", "return", "sealed", "super", "this", "throw", "trait", "try", "true", "type", "val", "var", "while", "with", "yield", "abstract", "continue", "switch", "assert", "default", "synchronized", "goto", "break", "double", "implements", "byte", "public", "throws", "enum", "instanceof", "transient", "int", "short", "char", "interface", "static", "void", "finally", "long", "strictfp", "volatile", "const", "float", "native"));
        this.defaultIncludes = new HashSet<String>(Arrays.asList("double", "Int", "Long", "Float", "Double", "char", "float", "String", "boolean", "Boolean", "Double", "Integer", "Long", "Float", "List", "Set", "Map"));
        this.typeMapping = new HashMap();
        this.typeMapping.put("string", "String");
        this.typeMapping.put("boolean", "Boolean");
        this.typeMapping.put("integer", "Int");
        this.typeMapping.put("long", "Long");
        this.typeMapping.put("float", "Float");
        this.typeMapping.put("double", "Double");
        this.typeMapping.put("number", "BigDecimal");
        this.typeMapping.put("decimal", "BigDecimal");
        this.typeMapping.put("date-time", "ZonedDateTime");
        this.typeMapping.put("date", "LocalDateTime");
        this.typeMapping.put("file", "File");
        this.typeMapping.put("array", "Seq");
        this.typeMapping.put("list", "List");
        this.typeMapping.put("map", "Map");
        this.typeMapping.put("object", "Object");
        this.typeMapping.put("binary", "Array[Byte]");
        this.typeMapping.put("Date", "LocalDateTime");
        this.typeMapping.put("DateTime", "ZonedDateTime");
        this.additionalProperties.put("modelPackage", this.modelPackage());
        this.additionalProperties.put("apiPackage", this.apiPackage());
        this.additionalProperties.put("appName", "OpenAPI Sample");
        this.additionalProperties.put("appDescription", "A sample openapi server");
        this.additionalProperties.put("infoUrl", "http://org.openapitools");
        this.additionalProperties.put("infoEmail", "team@openapitools.org");
        this.additionalProperties.put("licenseInfo", "Apache 2.0");
        this.additionalProperties.put("licenseUrl", "http://apache.org/licenses/LICENSE-2.0.html");
        this.additionalProperties.put("invokerPackage", this.invokerPackage);
        this.additionalProperties.put("groupId", this.groupId);
        this.additionalProperties.put("artifactId", this.artifactId);
        this.additionalProperties.put("artifactVersion", this.artifactVersion);
        if (this.additionalProperties.containsKey("packageName")) {
            this.setPackageName((String)this.additionalProperties.get("packageName"));
        } else {
            this.additionalProperties.put("packageName", this.packageName);
        }
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        this.supportingFiles.add(new SupportingFile("build.sbt", "", "build.sbt"));
        this.supportingFiles.add(new SupportingFile("Server.mustache", this.sourceFolder, "Server.scala"));
        this.supportingFiles.add(new SupportingFile("DataAccessor.mustache", this.sourceFolder, "DataAccessor.scala"));
        this.supportingFiles.add(new SupportingFile("project/build.properties", "project", "build.properties"));
        this.supportingFiles.add(new SupportingFile("project/plugins.sbt", "project", "plugins.sbt"));
        this.supportingFiles.add(new SupportingFile("sbt", "", "sbt"));
        this.supportingFiles.add(new SupportingFile("endpoint.mustache", this.sourceFolder, "endpoint.scala"));
        this.supportingFiles.add(new SupportingFile("errors.mustache", this.sourceFolder, "errors.scala"));
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("String", "Boolean", "Double", "Int", "Integer", "Long", "Float", "Any", "AnyVal", "AnyRef", "Object"));
        this.instantiationTypes.put("array", "ArrayList");
        this.instantiationTypes.put("map", "HashMap");
        this.importMapping = new HashMap();
        this.importMapping.put("UUID", "java.util.UUID");
        this.importMapping.put("URI", "java.net.URI");
        this.importMapping.put("File", "java.io.File");
        this.importMapping.put("Date", "java.util.Date");
        this.importMapping.put("Timestamp", "java.sql.Timestamp");
        this.importMapping.put("Map", "scala.collection.immutable.Map");
        this.importMapping.put("HashMap", "scala.collection.immutable.HashMap");
        this.importMapping.put("Seq", "scala.collection.immutable.Seq");
        this.importMapping.put("ArrayBuffer", "scala.collection.mutable.ArrayBuffer");
        this.importMapping.put("DateTime", "java.time.LocalDateTime");
        this.importMapping.put("LocalDateTime", "java.time.LocalDateTime");
        this.importMapping.put("LocalDate", "java.time.LocalDate");
        this.importMapping.put("LocalTime", "java.time.LocalTime");
        this.importMapping.put("ZonedDateTime", "java.time.ZonedDateTime");
        this.cliOptions.clear();
        this.cliOptions.add(new CliOption("packageName", "Finch package name (e.g. org.openapitools).").defaultValue(this.packageName));
        this.cliOptions.add(new CliOption("modelPackage", "package for generated models"));
        this.cliOptions.add(new CliOption("apiPackage", "package for generated api classes"));
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    @Override
    public String getName() {
        return "scala-finch";
    }

    @Override
    public String getHelp() {
        return "Generates a Scala server application with Finch.";
    }

    @Override
    public String escapeReservedWord(String name) {
        return "_" + name;
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separator + this.sourceFolder + File.separator + this.apiPackage().replace('.', File.separatorChar);
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + File.separator + this.sourceFolder + File.separator + this.modelPackage().replace('.', File.separatorChar);
    }

    @Override
    public OperationsMap postProcessOperationsWithModels(OperationsMap objs, List<ModelMap> allModels) {
        OperationMap operations = objs.getOperations();
        List<CodegenOperation> operationList = operations.getOperation();
        for (CodegenOperation op : operationList) {
            this.generateScalaPath(op);
            this.generateInputParameters(op);
            this.authParameters(op);
            this.concatParameters(op);
        }
        return objs;
    }

    @Override
    public String getTypeDeclaration(Schema p) {
        if (ModelUtils.isArraySchema(p)) {
            ArraySchema ap = (ArraySchema)p;
            Schema inner = ap.getItems();
            return this.getSchemaType(p) + "[" + this.getTypeDeclaration(inner) + "]";
        }
        if (ModelUtils.isMapSchema(p)) {
            Schema inner = ModelUtils.getAdditionalProperties(p);
            return this.getSchemaType(p) + "[String, " + this.getTypeDeclaration(inner) + "]";
        }
        return super.getTypeDeclaration(p);
    }

    @Override
    public String getSchemaType(Schema p) {
        String type;
        String schemaType = super.getSchemaType(p);
        if (this.typeMapping.containsKey(schemaType)) {
            type = (String)this.typeMapping.get(schemaType);
            if (this.languageSpecificPrimitives.contains(type)) {
                return this.toModelName(type);
            }
        } else {
            type = schemaType;
        }
        return this.toModelName(type);
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("\"", "");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("*/", "*_/").replace("/*", "/_*");
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    private String toPrimitive(String prim, Boolean isRequired, Boolean canBeOptional) {
        String converter = ".map(_.to" + prim + ")";
        return canBeOptional.booleanValue() ? (isRequired.booleanValue() ? converter : ".map(_" + converter + ")") : "";
    }

    private String toPathParameter(CodegenParameter p, String paramType, Boolean canBeOptional) {
        Boolean isNotAString = !"String".equals(p.dataType);
        return paramType + (canBeOptional != false && !p.required ? "Option" : "") + "(\"" + p.baseName + "\")" + (isNotAString != false ? this.toPrimitive(p.dataType, p.required, canBeOptional) : "");
    }

    private String toInputParameter(CodegenParameter p) {
        return (p.required ? "" : "Option[") + p.dataType + (p.required ? "" : "]");
    }

    private String concat(String original, String addition, String op) {
        return original + (original.isEmpty() ? "" : (addition.isEmpty() ? "" : op)) + addition;
    }

    private String csvConcat(String original, String addition) {
        return this.concat(original, addition, ", ");
    }

    private String colConcat(String original, String addition) {
        return this.concat(original, addition, " :: ");
    }

    private void authParameters(CodegenOperation op) {
        String authParams = "";
        String authInputParams = "";
        String typedAuthInputParams = "";
        if (op.authMethods != null) {
            for (CodegenSecurity s : op.authMethods) {
                if (s.isApiKey.booleanValue() && s.isKeyInHeader.booleanValue()) {
                    authParams = this.colConcat(authParams, "header(\"" + s.keyParamName + "\")");
                } else if (s.isApiKey.booleanValue() && s.isKeyInQuery.booleanValue()) {
                    authParams = this.colConcat(authParams, "param(\"" + s.keyParamName + "\")");
                }
                if (!s.isApiKey.booleanValue()) continue;
                typedAuthInputParams = this.csvConcat(typedAuthInputParams, "authParam" + s.name + ": String");
                authInputParams = this.csvConcat(authInputParams, "authParam" + s.name);
            }
        }
        op.vendorExtensions.put("x-codegen-auth-params", authParams);
        op.vendorExtensions.put("x-codegen-auth-input-params", authInputParams);
        op.vendorExtensions.put("x-codegen-typed-auth-input-params", typedAuthInputParams);
    }

    private void generateScalaPath(CodegenOperation op) {
        op.httpMethod = op.httpMethod.toLowerCase(Locale.ROOT);
        String path = op.path;
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        String[] items = path.split("/", -1);
        String scalaPath = "";
        Integer pathParamIndex = 0;
        for (String item : items) {
            if (item.matches("^\\{(.*)}$")) {
                CodegenParameter cp = op.pathParams.get(pathParamIndex);
                scalaPath = this.colConcat(scalaPath, cp.dataType.toLowerCase(Locale.ROOT));
                Integer n = pathParamIndex;
                Integer n2 = pathParamIndex = Integer.valueOf(pathParamIndex + 1);
                continue;
            }
            scalaPath = this.colConcat(scalaPath, "\"" + item + "\"");
        }
        op.vendorExtensions.put("x-codegen-path", scalaPath);
    }

    private void concatParameters(CodegenOperation op) {
        String path = this.colConcat(this.colConcat(op.vendorExtensions.get("x-codegen-path").toString(), op.vendorExtensions.get("x-codegen-path-params").toString()), op.vendorExtensions.get("x-codegen-auth-params").toString());
        String parameters = this.csvConcat(op.vendorExtensions.get("x-codegen-input-params").toString(), op.vendorExtensions.get("x-codegen-auth-input-params").toString());
        String typedParameters = this.csvConcat(op.vendorExtensions.get("x-codegen-typed-input-params").toString(), op.vendorExtensions.get("x-codegen-typed-auth-input-params").toString());
        op.vendorExtensions.put("x-codegen-paths", path);
        op.vendorExtensions.put("x-codegen-params", parameters);
        op.vendorExtensions.put("x-codegen-typed-params", typedParameters);
    }

    private void generateInputParameters(CodegenOperation op) {
        String inputParams = "";
        String typedInputParams = "";
        String pathParams = "";
        for (CodegenParameter p : op.allParams) {
            if (p.isBodyParam) {
                p.vendorExtensions.put("x-codegen-normalized-path-type", "jsonBody[" + p.dataType + "]");
                p.vendorExtensions.put("x-codegen-normalized-input-type", p.dataType);
            } else if (p.isContainer || p.isArray) {
                p.vendorExtensions.put("x-codegen-normalized-path-type", this.toPathParameter(p, "params", false));
                p.vendorExtensions.put("x-codegen-normalized-input-type", p.dataType.replaceAll("^[^\\[]+", "Seq"));
            } else if (p.isQueryParam) {
                p.vendorExtensions.put("x-codegen-normalized-path-type", this.toPathParameter(p, "param", true));
                p.vendorExtensions.put("x-codegen-normalized-input-type", this.toInputParameter(p));
            } else if (p.isHeaderParam) {
                p.vendorExtensions.put("x-codegen-normalized-path-type", this.toPathParameter(p, "header", true));
                p.vendorExtensions.put("x-codegen-normalized-input-type", this.toInputParameter(p));
            } else if (p.isFile) {
                p.vendorExtensions.put("x-codegen-normalized-path-type", "fileUpload(\"" + p.paramName + "\")");
                p.vendorExtensions.put("x-codegen-normalized-input-type", "FileUpload");
            } else if (p.isPrimitiveType && !p.isPathParam) {
                if (!p.required) {
                    p.vendorExtensions.put("x-codegen-normalized-path-type", this.toPathParameter(p, "param", true));
                } else {
                    p.vendorExtensions.put("x-codegen-normalized-path-type", p.dataType.toLowerCase(Locale.ROOT));
                }
                p.vendorExtensions.put("x-codegen-normalized-input-type", this.toInputParameter(p));
            } else {
                p.vendorExtensions.put("x-codegen-normalized-input-type", p.dataType);
            }
            if (p.vendorExtensions.get("x-codegen-normalized-path-type") != null) {
                pathParams = this.colConcat(pathParams, p.vendorExtensions.get("x-codegen-normalized-path-type").toString());
            }
            inputParams = this.csvConcat(inputParams, p.paramName);
            typedInputParams = this.csvConcat(typedInputParams, p.paramName + ": " + p.vendorExtensions.get("x-codegen-normalized-input-type"));
        }
        op.vendorExtensions.put("x-codegen-path-params", pathParams);
        op.vendorExtensions.put("x-codegen-input-params", inputParams);
        op.vendorExtensions.put("x-codegen-typed-input-params", typedInputParams);
    }

    @Override
    public void postProcess() {
        System.out.println("################################################################################");
        System.out.println("# Thanks for using OpenAPI Generator.                                          #");
        System.out.println("# Please consider donation to help us maintain this project \ud83d\ude4f                 #");
        System.out.println("# https://opencollective.com/openapi_generator/donate                          #");
        System.out.println("#                                                                              #");
        System.out.println("# This generator's contributed by Jim Schubert (https://github.com/jimschubert)#");
        System.out.println("# Please support his work directly via https://patreon.com/jimschubert \ud83d\ude4f      #");
        System.out.println("################################################################################");
    }

    @Override
    public GeneratorLanguage generatorLanguage() {
        return GeneratorLanguage.SCALA;
    }
}

