/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FilenameUtils;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenConstants;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.DefaultCodegen;
import org.openapitools.codegen.GeneratorLanguage;
import org.openapitools.codegen.meta.features.ClientModificationFeature;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.meta.features.GlobalFeature;
import org.openapitools.codegen.meta.features.SchemaSupportFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.meta.features.WireFormatFeature;
import org.openapitools.codegen.model.ModelMap;
import org.openapitools.codegen.model.ModelsMap;
import org.openapitools.codegen.utils.CamelizeOption;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTypeScriptClientCodegen
extends DefaultCodegen
implements CodegenConfig {
    private final Logger LOGGER = LoggerFactory.getLogger(AbstractTypeScriptClientCodegen.class);
    private static final String X_DISCRIMINATOR_TYPE = "x-discriminator-value";
    private static final String UNDEFINED_VALUE = "undefined";
    public static final String NPM_NAME = "npmName";
    public static final String NPM_VERSION = "npmVersion";
    public static final String SNAPSHOT = "snapshot";
    public static final String MODEL_PROPERTY_NAMING_DESC_WITH_WARNING = "Naming convention for the property: 'camelCase', 'PascalCase', 'snake_case' and 'original', which keeps the original name. Only change it if you provide your own run-time code for (de-)serialization of models";
    public static final String ENUM_PROPERTY_NAMING_REPLACE_SPECIAL_CHAR = "enumPropertyNamingReplaceSpecialChar";
    public static final String ENUM_PROPERTY_NAMING_REPLACE_SPECIAL_CHAR_DESC = "Set to true to replace '-' and '+' symbols with 'minus_' and 'plus_' in enum of type string";
    public static final String NULL_SAFE_ADDITIONAL_PROPS = "nullSafeAdditionalProps";
    public static final String NULL_SAFE_ADDITIONAL_PROPS_DESC = "Set to make additional properties types declare that their indexer may return undefined";
    protected static final ThreadLocal<SimpleDateFormat> SNAPSHOT_SUFFIX_FORMAT = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyyMMddHHmm", Locale.ROOT));
    protected CodegenConstants.MODEL_PROPERTY_NAMING_TYPE modelPropertyNaming = CodegenConstants.MODEL_PROPERTY_NAMING_TYPE.original;
    protected CodegenConstants.ENUM_PROPERTY_NAMING_TYPE enumPropertyNaming = CodegenConstants.ENUM_PROPERTY_NAMING_TYPE.PascalCase;
    protected CodegenConstants.PARAM_NAMING_TYPE paramNaming = CodegenConstants.PARAM_NAMING_TYPE.camelCase;
    protected boolean enumPropertyNamingReplaceSpecialChar = false;
    protected Boolean supportsES6 = false;
    protected Boolean nullSafeAdditionalProps = false;
    protected HashSet<String> languageGenericTypes;
    protected String npmName = null;
    protected String npmVersion = "1.0.0";
    protected String enumSuffix = "Enum";
    protected String classEnumSeparator = ".";

    public AbstractTypeScriptClientCodegen() {
        this.modifyFeatureSet(features -> features.includeDocumentationFeatures(new DocumentationFeature[]{DocumentationFeature.Readme}).wireFormatFeatures(EnumSet.of(WireFormatFeature.JSON, WireFormatFeature.XML)).securityFeatures(EnumSet.of(SecurityFeature.ApiKey, SecurityFeature.BasicAuth, SecurityFeature.OAuth2_Implicit)).excludeGlobalFeatures(new GlobalFeature[]{GlobalFeature.XMLStructureDefinitions, GlobalFeature.Callbacks, GlobalFeature.LinkObjects, GlobalFeature.ParameterStyling}).includeSchemaSupportFeatures(new SchemaSupportFeature[]{SchemaSupportFeature.Polymorphism}).includeClientModificationFeatures(new ClientModificationFeature[]{ClientModificationFeature.BasePath}));
        this.importMapping.clear();
        this.supportsInheritance = true;
        this.reservedWords.addAll(Arrays.asList("varLocalPath", "queryParameters", "headerParams", "formParams", "useFormData", "varLocalDeferred", "requestOptions", "abstract", "await", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "debugger", "default", "delete", "do", "double", "else", "enum", "export", "extends", "false", "final", "finally", "float", "for", "function", "goto", "if", "implements", "import", "in", "instanceof", "int", "interface", "let", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "super", "switch", "synchronized", "this", "throw", "transient", "true", "try", "typeof", "var", "void", "volatile", "while", "with", "yield"));
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("string", "String", "boolean", "Boolean", "Double", "Integer", "Long", "Float", "Object", "Array", "ReadonlyArray", "Date", "number", "any", "File", "Error", "Map", "object", "Set"));
        this.languageGenericTypes = new HashSet<String>(Collections.singletonList("Array"));
        this.instantiationTypes.put("array", "Array");
        this.typeMapping = new HashMap();
        this.typeMapping.put("Set", "Set");
        this.typeMapping.put("set", "Set");
        this.typeMapping.put("Array", "Array");
        this.typeMapping.put("array", "Array");
        this.typeMapping.put("boolean", "boolean");
        this.typeMapping.put("string", "string");
        this.typeMapping.put("int", "number");
        this.typeMapping.put("float", "number");
        this.typeMapping.put("number", "number");
        this.typeMapping.put("long", "number");
        this.typeMapping.put("short", "number");
        this.typeMapping.put("char", "string");
        this.typeMapping.put("double", "number");
        this.typeMapping.put("object", "object");
        this.typeMapping.put("integer", "number");
        this.typeMapping.put("Map", "any");
        this.typeMapping.put("map", "any");
        this.typeMapping.put("date", "string");
        this.typeMapping.put("DateTime", "string");
        this.typeMapping.put("binary", "any");
        this.typeMapping.put("File", "any");
        this.typeMapping.put("file", "any");
        this.typeMapping.put("ByteArray", "string");
        this.typeMapping.put("UUID", "string");
        this.typeMapping.put("URI", "string");
        this.typeMapping.put("Error", "Error");
        this.typeMapping.put("AnyType", "any");
        this.cliOptions.add(new CliOption("enumNameSuffix", "Suffix that will be appended to all enum names.").defaultValue(this.enumSuffix));
        this.cliOptions.add(new CliOption("enumPropertyNaming", "Naming convention for enum properties: 'camelCase', 'PascalCase', 'snake_case', 'UPPERCASE', and 'original'").defaultValue(this.enumPropertyNaming.name()));
        this.cliOptions.add(new CliOption("modelPropertyNaming", MODEL_PROPERTY_NAMING_DESC_WITH_WARNING).defaultValue(this.modelPropertyNaming.name()));
        this.cliOptions.add(new CliOption("supportsES6", "Generate code that conforms to ES6.").defaultValue(String.valueOf(this.getSupportsES6())));
        this.cliOptions.add(new CliOption("paramNaming", "Naming convention for parameters: 'camelCase', 'PascalCase', 'snake_case' and 'original', which keeps the original name").defaultValue(this.paramNaming.name()));
        this.cliOptions.add(new CliOption(NPM_NAME, "The name under which you want to publish generated npm package. Required to generate a full package"));
        this.cliOptions.add(new CliOption(NPM_VERSION, "The version of your npm package. If not provided, using the version from the OpenAPI specification file.").defaultValue(this.getNpmVersion()));
        this.cliOptions.add(CliOption.newBoolean(SNAPSHOT, "When setting this property to true, the version will be suffixed with -SNAPSHOT." + SNAPSHOT_SUFFIX_FORMAT.get().toPattern(), false));
        this.cliOptions.add(new CliOption(NULL_SAFE_ADDITIONAL_PROPS, NULL_SAFE_ADDITIONAL_PROPS_DESC).defaultValue(String.valueOf(this.getNullSafeAdditionalProps())));
        this.cliOptions.add(CliOption.newBoolean(ENUM_PROPERTY_NAMING_REPLACE_SPECIAL_CHAR, ENUM_PROPERTY_NAMING_REPLACE_SPECIAL_CHAR_DESC, false));
    }

    protected void supportModelPropertyNaming(CodegenConstants.MODEL_PROPERTY_NAMING_TYPE defaultModelPropertyNaming) {
        this.removeOption("modelPropertyNaming");
        this.modelPropertyNaming = defaultModelPropertyNaming;
        this.cliOptions.add(new CliOption("modelPropertyNaming", "Naming convention for the property: 'camelCase', 'PascalCase', 'snake_case' and 'original', which keeps the original name").defaultValue(this.modelPropertyNaming.name()));
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)System.getenv("TS_POST_PROCESS_FILE"))) {
            this.LOGGER.info("Hint: Environment variable 'TS_POST_PROCESS_FILE' (optional) not defined. E.g. to format the source code, please try 'export TS_POST_PROCESS_FILE=\"/usr/local/bin/prettier --write\"' (Linux/Mac)");
            this.LOGGER.info("Note: To enable file post-processing, 'enablePostProcessFile' must be set to `true` (--enable-post-process-file for CLI).");
        } else if (!this.isEnablePostProcessFile()) {
            this.LOGGER.info("Warning: Environment variable 'TS_POST_PROCESS_FILE' is set but file post-processing is not enabled. To enable file post-processing, 'enablePostProcessFile' must be set to `true` (--enable-post-process-file for CLI).");
        }
        if (this.additionalProperties.containsKey("enumNameSuffix")) {
            this.enumSuffix = this.additionalProperties.get("enumNameSuffix").toString();
        }
        if (this.additionalProperties.containsKey("enumPropertyNaming")) {
            this.setEnumPropertyNaming((String)this.additionalProperties.get("enumPropertyNaming"));
        }
        if (this.additionalProperties.containsKey(ENUM_PROPERTY_NAMING_REPLACE_SPECIAL_CHAR)) {
            this.setEnumPropertyNamingReplaceSpecialChar(Boolean.valueOf(this.additionalProperties.get(ENUM_PROPERTY_NAMING_REPLACE_SPECIAL_CHAR).toString()));
        }
        if (this.additionalProperties.containsKey("modelPropertyNaming")) {
            this.setModelPropertyNaming((String)this.additionalProperties.get("modelPropertyNaming"));
        }
        if (this.additionalProperties.containsKey("paramNaming")) {
            this.setParamNaming((String)this.additionalProperties.get("paramNaming"));
        }
        this.setSupportsES6(this.convertPropertyToBooleanAndWriteBack("supportsES6"));
        if (this.additionalProperties.containsKey(NULL_SAFE_ADDITIONAL_PROPS)) {
            this.setNullSafeAdditionalProps(Boolean.valueOf(this.additionalProperties.get(NULL_SAFE_ADDITIONAL_PROPS).toString()));
        }
        if (this.additionalProperties.containsKey(NPM_NAME)) {
            this.setNpmName(this.additionalProperties.get(NPM_NAME).toString());
        }
    }

    @Override
    public String toModelImport(String name) {
        if (this.isUnionType(name)) {
            this.LOGGER.warn("The import is a union type. Consider using the toModelImportMap method.");
            return this.toModelImportMap(name).values().stream().collect(Collectors.joining("|"));
        }
        if (this.isIntersectionType(name)) {
            this.LOGGER.warn("The import is a intersection type. Consider using the toModelImportMap method.");
            return this.toModelImportMap(name).values().stream().collect(Collectors.joining("&"));
        }
        return super.toModelImport(name);
    }

    @Override
    public Map<String, String> toModelImportMap(String name) {
        return this.toImportMap(this.splitComposedType(name));
    }

    private String[] splitComposedType(String name) {
        return name.replace(" ", "").split("[|&<>]");
    }

    private boolean isUnionType(String name) {
        return name.contains("|");
    }

    private boolean isIntersectionType(String name) {
        return name.contains("&");
    }

    private Map<String, String> toImportMap(String ... names) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String name : names) {
            if (!this.needToImport(name)) continue;
            result.put(this.toModelImport(name), name);
        }
        return result;
    }

    @Override
    public void preprocessOpenAPI(OpenAPI openAPI) {
        if (this.additionalProperties.containsKey(NPM_NAME)) {
            if (this.additionalProperties.containsKey(NPM_VERSION)) {
                this.setNpmVersion(this.additionalProperties.get(NPM_VERSION).toString());
            } else if (openAPI.getInfo() != null && openAPI.getInfo().getVersion() != null) {
                this.setNpmVersion(openAPI.getInfo().getVersion());
            }
            if (this.additionalProperties.containsKey(SNAPSHOT) && Boolean.parseBoolean(this.additionalProperties.get(SNAPSHOT).toString())) {
                if (this.npmVersion.toUpperCase(Locale.ROOT).matches("^.*-SNAPSHOT$")) {
                    this.setNpmVersion(this.npmVersion + "." + SNAPSHOT_SUFFIX_FORMAT.get().format(new Date()));
                } else {
                    this.setNpmVersion(this.npmVersion + "-SNAPSHOT." + SNAPSHOT_SUFFIX_FORMAT.get().format(new Date()));
                }
            }
            this.additionalProperties.put(NPM_VERSION, this.npmVersion);
        }
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String escapeReservedWord(String name) {
        if (this.reservedWordsMappings().containsKey(name)) {
            return this.reservedWordsMappings().get(name);
        }
        return "_" + name;
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separator + this.apiPackage().replace('.', File.separatorChar);
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + File.separator + this.modelPackage().replace('.', File.separatorChar);
    }

    @Override
    public String toParamName(String name) {
        if (this.parameterNameMapping.containsKey(name)) {
            return (String)this.parameterNameMapping.get(name);
        }
        if ("_".equals(name = this.sanitizeName(name, "[^\\w$]"))) {
            name = "_u";
        }
        name = this.getNameUsingParamNaming(name);
        name = this.toSafeIdentifier(name);
        return name;
    }

    @Override
    public String toVarName(String name) {
        if (this.nameMapping.containsKey(name)) {
            return (String)this.nameMapping.get(name);
        }
        if ("_".equals(name = this.sanitizeName(name, "[^\\w$]"))) {
            name = "_u";
        }
        name = this.getNameUsingModelPropertyNaming(name);
        name = this.toSafeIdentifier(name);
        return name;
    }

    private String toSafeIdentifier(String name) {
        if (this.isReservedWord(name) || name.matches("^\\d.*")) {
            name = this.escapeReservedWord(name);
        }
        return name;
    }

    @Override
    public String toModelName(String name) {
        if (this.modelNameMapping.containsKey(name)) {
            return (String)this.modelNameMapping.get(name);
        }
        String fullModelName = name;
        fullModelName = this.addPrefix(fullModelName, this.modelNamePrefix);
        fullModelName = this.addSuffix(fullModelName, this.modelNameSuffix);
        return this.toTypescriptTypeName(fullModelName, "Model");
    }

    protected String addPrefix(String name, String prefix) {
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)prefix)) {
            name = prefix + "_" + (String)name;
        }
        return name;
    }

    protected String addSuffix(String name, String suffix) {
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)suffix)) {
            name = (String)name + "_" + suffix;
        }
        return name;
    }

    protected String toTypescriptTypeName(String name, String safePrefix) {
        ArrayList<String> exceptions = new ArrayList<String>(Arrays.asList("\\|", " "));
        String sanName = this.sanitizeName(name, "(?![| ])\\W", exceptions);
        if (this.isReservedWord(sanName = StringUtils.camelize(sanName))) {
            String modelName = safePrefix + sanName;
            this.LOGGER.warn("{} (reserved word) cannot be used as model name. Renamed to {}", (Object)sanName, (Object)modelName);
            return modelName;
        }
        if (sanName.matches("^\\d.*")) {
            String modelName = safePrefix + sanName;
            this.LOGGER.warn("{} (model name starts with number) cannot be used as model name. Renamed to {}", (Object)sanName, (Object)modelName);
            return modelName;
        }
        if (this.languageSpecificPrimitives.contains(sanName)) {
            String modelName = safePrefix + sanName;
            this.LOGGER.warn("{} (model name matches existing language type) cannot be used as a model name. Renamed to {}", (Object)sanName, (Object)modelName);
            return modelName;
        }
        return sanName;
    }

    @Override
    public String toModelFilename(String name) {
        return this.toModelName(name);
    }

    @Override
    public String getTypeDeclaration(Schema p) {
        if (ModelUtils.isArraySchema(p)) {
            Schema<?> items = this.getSchemaItems((ArraySchema)p);
            return this.getSchemaType(p) + "<" + this.getTypeDeclaration(this.unaliasSchema(items)) + ">";
        }
        if (ModelUtils.isMapSchema(p)) {
            Object nullSafeSuffix;
            Schema<?> inner = this.getSchemaAdditionalProperties(p);
            Object object = nullSafeSuffix = this.getNullSafeAdditionalProps() != false ? " | undefined" : "";
            if (Boolean.TRUE.equals(inner.getNullable())) {
                nullSafeSuffix = (String)nullSafeSuffix + " | null";
            }
            return "{ [key: string]: " + this.getTypeDeclaration(this.unaliasSchema(inner)) + (String)nullSafeSuffix + "; }";
        }
        if (ModelUtils.isFileSchema(p)) {
            return "File";
        }
        if (ModelUtils.isBinarySchema(p)) {
            return "ArrayBuffer";
        }
        return super.getTypeDeclaration(p);
    }

    @Override
    protected String getParameterDataType(Parameter parameter, Schema p) {
        if (ModelUtils.isArraySchema(p)) {
            ArraySchema mp1 = (ArraySchema)p;
            Schema inner = mp1.getItems();
            return this.getSchemaType(p) + "<" + this.getParameterDataType(parameter, inner) + ">";
        }
        if (ModelUtils.isMapSchema(p)) {
            Schema inner = ModelUtils.getAdditionalProperties(p);
            return "{ [key: string]: " + this.getParameterDataType(parameter, inner) + "; }";
        }
        if (ModelUtils.isStringSchema(p)) {
            if (p.getEnum() != null) {
                return this.enumValuesToEnumTypeUnion(p.getEnum(), "string");
            }
        } else if (ModelUtils.isIntegerSchema(p) ? p.getEnum() != null : ModelUtils.isNumberSchema(p) && p.getEnum() != null) {
            return this.numericEnumValuesToEnumTypeUnion(new ArrayList<Number>(p.getEnum()));
        }
        return this.getTypeDeclaration(p);
    }

    private String enumValuesToEnumTypeUnion(List<String> values, String dataType) {
        StringBuilder b = new StringBuilder();
        boolean isFirst = true;
        for (String value : values) {
            if (!isFirst) {
                b.append(" | ");
            }
            b.append(this.toEnumValue(value, dataType));
            isFirst = false;
        }
        return b.toString();
    }

    private String numericEnumValuesToEnumTypeUnion(List<Number> values) {
        ArrayList<String> stringValues = new ArrayList<String>();
        for (Number value : values) {
            stringValues.add(value.toString());
        }
        return this.enumValuesToEnumTypeUnion(stringValues, "number");
    }

    @Override
    public String toDefaultValue(Schema p) {
        if (ModelUtils.isBooleanSchema(p)) {
            if (p.getDefault() != null) {
                return p.getDefault().toString();
            }
            return UNDEFINED_VALUE;
        }
        if (ModelUtils.isDateSchema(p)) {
            if (p.getDefault() != null) {
                return p.getDefault().toString();
            }
            return UNDEFINED_VALUE;
        }
        if (ModelUtils.isDateTimeSchema(p)) {
            if (p.getDefault() != null) {
                return p.getDefault().toString();
            }
            return UNDEFINED_VALUE;
        }
        if (ModelUtils.isNumberSchema(p) || ModelUtils.isIntegerSchema(p)) {
            if (p.getDefault() != null) {
                return p.getDefault().toString();
            }
            return UNDEFINED_VALUE;
        }
        if (ModelUtils.isStringSchema(p)) {
            if (p.getDefault() != null) {
                return "'" + this.escapeText(String.valueOf(p.getDefault())) + "'";
            }
            return UNDEFINED_VALUE;
        }
        return UNDEFINED_VALUE;
    }

    @Override
    protected boolean isReservedWord(String word) {
        return this.reservedWords.contains(word);
    }

    @Override
    public String getSchemaType(Schema p) {
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)p.get$ref())) {
            Schema unaliasSchema = this.unaliasSchema(p);
            Schema actualSchema = ModelUtils.getReferencedSchema(this.openAPI, unaliasSchema);
            String modelName = ModelUtils.getSimpleRef(unaliasSchema.get$ref());
            if (ModelUtils.isModel(actualSchema) && this.modelNameMapping.containsKey(modelName)) {
                return this.toModelName((String)this.modelNameMapping.get(modelName));
            }
        }
        String openAPIType = super.getSchemaType(p);
        String type = null;
        if (ModelUtils.isComposedSchema(p)) {
            return openAPIType;
        }
        if (this.typeMapping.containsKey(openAPIType)) {
            type = (String)this.typeMapping.get(openAPIType);
            if (this.languageSpecificPrimitives.contains(type)) {
                return type;
            }
        } else {
            type = openAPIType;
        }
        return this.toModelName(type);
    }

    @Override
    public String toOperationId(String operationId) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)operationId)) {
            throw new RuntimeException("Empty method name (operationId) not allowed");
        }
        operationId = StringUtils.camelize(this.sanitizeName(operationId), CamelizeOption.LOWERCASE_FIRST_LETTER);
        operationId = this.toSafeIdentifier(operationId);
        return operationId;
    }

    public void setModelPropertyNaming(String naming) {
        try {
            this.modelPropertyNaming = CodegenConstants.MODEL_PROPERTY_NAMING_TYPE.valueOf(naming);
        }
        catch (IllegalArgumentException e) {
            String values = Stream.of(CodegenConstants.MODEL_PROPERTY_NAMING_TYPE.values()).map(value -> "'" + value.name() + "'").collect(Collectors.joining(", "));
            String msg = String.format(Locale.ROOT, "Invalid model property naming '%s'. Must be one of %s.", naming, values);
            throw new IllegalArgumentException(msg);
        }
    }

    public void setParamNaming(String naming) {
        try {
            this.paramNaming = CodegenConstants.PARAM_NAMING_TYPE.valueOf(naming);
        }
        catch (IllegalArgumentException e) {
            String values = Stream.of(CodegenConstants.PARAM_NAMING_TYPE.values()).map(value -> "'" + value.name() + "'").collect(Collectors.joining(", "));
            String msg = String.format(Locale.ROOT, "Invalid parameter naming '%s'. Must be one of %s.", naming, values);
            throw new IllegalArgumentException(msg);
        }
    }

    public CodegenConstants.MODEL_PROPERTY_NAMING_TYPE getModelPropertyNaming() {
        return this.modelPropertyNaming;
    }

    public CodegenConstants.PARAM_NAMING_TYPE getParamNaming() {
        return this.paramNaming;
    }

    private String getNameUsingParamNaming(String name) {
        switch (this.getParamNaming()) {
            case original: {
                return name;
            }
            case camelCase: {
                return StringUtils.camelize(name, CamelizeOption.LOWERCASE_FIRST_LETTER);
            }
            case PascalCase: {
                return StringUtils.camelize(name);
            }
            case snake_case: {
                return StringUtils.underscore(name);
            }
        }
        throw new IllegalArgumentException("Invalid param naming '" + name + "'. Must be 'original', 'camelCase', 'PascalCase' or 'snake_case'");
    }

    private String getNameUsingModelPropertyNaming(String name) {
        switch (this.getModelPropertyNaming()) {
            case original: {
                return name;
            }
            case camelCase: {
                return StringUtils.camelize(name, CamelizeOption.LOWERCASE_FIRST_LETTER);
            }
            case PascalCase: {
                return StringUtils.camelize(name);
            }
            case snake_case: {
                return StringUtils.underscore(name);
            }
        }
        throw new IllegalArgumentException("Invalid model property naming '" + name + "'. Must be 'original', 'camelCase', 'PascalCase' or 'snake_case'");
    }

    @Override
    public String toEnumValue(String value, String datatype) {
        if ("number".equals(datatype) || "boolean".equals(datatype)) {
            return value;
        }
        return "'" + this.escapeText(value) + "'";
    }

    @Override
    public String toEnumDefaultValue(String value, String datatype) {
        return datatype + "_" + value;
    }

    @Override
    public String toEnumVarName(String name, String datatype) {
        if (name.length() == 0) {
            return this.getNameUsingEnumPropertyNaming("empty");
        }
        if (this.getSymbolName(name) != null) {
            return this.getNameUsingEnumPropertyNaming(this.getSymbolName(name));
        }
        Object varName = name;
        if ("number".equals(datatype)) {
            varName = "NUMBER_" + (String)varName;
            varName = ((String)varName).replaceAll("-", "MINUS_");
            varName = ((String)varName).replaceAll("\\+", "PLUS_");
            varName = ((String)varName).replaceAll("\\.", "_DOT_");
            return varName;
        }
        if (this.isEnumPropertyNamingReplaceSpecialChar()) {
            varName = ((String)varName).replaceAll("-", "_minus_");
            varName = ((String)varName).replaceAll("\\+", "_plus_");
            varName = ((String)varName).replaceAll("_+", "_");
        }
        varName = this.sanitizeName((String)varName);
        varName = ((String)varName).replaceFirst("^_", "");
        varName = ((String)varName).replaceFirst("_$", "");
        if (((String)(varName = this.getNameUsingEnumPropertyNaming((String)varName))).matches("\\d.*")) {
            return "_" + (String)varName;
        }
        return varName;
    }

    @Override
    public String toEnumName(CodegenProperty property) {
        String enumName = property.name;
        enumName = this.addSuffix(enumName, this.enumSuffix);
        return this.toTypescriptTypeName(enumName, "_");
    }

    protected void setEnumPropertyNaming(String naming) {
        try {
            this.enumPropertyNaming = CodegenConstants.ENUM_PROPERTY_NAMING_TYPE.valueOf(naming);
        }
        catch (IllegalArgumentException e) {
            String values = Stream.of(CodegenConstants.ENUM_PROPERTY_NAMING_TYPE.values()).map(value -> "'" + value.name() + "'").collect(Collectors.joining(", "));
            String msg = String.format(Locale.ROOT, "Invalid enum property naming '%s'. Must be one of %s.", naming, values);
            throw new IllegalArgumentException(msg);
        }
    }

    protected CodegenConstants.ENUM_PROPERTY_NAMING_TYPE getEnumPropertyNaming() {
        return this.enumPropertyNaming;
    }

    protected void setEnumPropertyNamingReplaceSpecialChar(boolean replaceSpecialChars) {
        this.enumPropertyNamingReplaceSpecialChar = replaceSpecialChars;
    }

    protected boolean isEnumPropertyNamingReplaceSpecialChar() {
        return this.enumPropertyNamingReplaceSpecialChar;
    }

    private String getNameUsingEnumPropertyNaming(String name) {
        switch (this.getEnumPropertyNaming()) {
            case original: {
                return name;
            }
            case camelCase: {
                return StringUtils.camelize(StringUtils.underscore(name), CamelizeOption.LOWERCASE_FIRST_LETTER);
            }
            case PascalCase: {
                return StringUtils.camelize(StringUtils.underscore(name));
            }
            case snake_case: {
                return StringUtils.underscore(name);
            }
            case UPPERCASE: {
                return StringUtils.underscore(name).toUpperCase(Locale.ROOT);
            }
        }
        throw new IllegalArgumentException("Unsupported enum property naming: '" + name);
    }

    @Override
    protected void addImport(CodegenModel m, String type) {
        String[] parts;
        if (type == null) {
            return;
        }
        for (String s : parts = this.splitComposedType(type)) {
            if (!this.needToImport(s)) continue;
            m.imports.add(s);
        }
    }

    @Override
    public ModelsMap postProcessModels(ModelsMap objs) {
        List<ModelMap> models = this.postProcessModelsEnum(objs).getModels();
        for (ModelMap mo : models) {
            CodegenModel cm = mo.getModel();
            cm.imports = new TreeSet<String>(cm.imports);
            for (CodegenProperty var : cm.vars) {
                if (!Boolean.TRUE.equals(var.isEnum)) continue;
                var.datatypeWithEnum = var.datatypeWithEnum.replace(var.enumName, cm.classname + this.classEnumSeparator + var.enumName);
            }
            if (cm.parent == null) continue;
            for (CodegenProperty var : cm.allVars) {
                if (!Boolean.TRUE.equals(var.isEnum)) continue;
                var.datatypeWithEnum = var.datatypeWithEnum.replace(var.enumName, cm.classname + this.classEnumSeparator + var.enumName);
            }
        }
        return objs;
    }

    @Override
    public Map<String, ModelsMap> postProcessAllModels(Map<String, ModelsMap> objs) {
        Map<String, ModelsMap> result = super.postProcessAllModels(objs);
        for (ModelsMap entry : result.values()) {
            for (ModelMap mo : entry.getModels()) {
                CodegenModel cm = mo.getModel();
                if (cm.discriminator == null || cm.children == null) continue;
                for (CodegenModel child : cm.children) {
                    this.setDiscriminatorValue(child, cm.discriminator.getPropertyName(), this.getDiscriminatorValue(child));
                }
            }
        }
        return result;
    }

    public void setSupportsES6(Boolean value) {
        this.supportsES6 = value;
    }

    public Boolean getSupportsES6() {
        return this.supportsES6;
    }

    public Boolean getNullSafeAdditionalProps() {
        return this.nullSafeAdditionalProps;
    }

    public void setNullSafeAdditionalProps(Boolean value) {
        this.nullSafeAdditionalProps = value;
    }

    public String getNpmName() {
        return this.npmName;
    }

    public void setNpmName(String npmName) {
        this.npmName = npmName;
    }

    public String getNpmVersion() {
        return this.npmVersion;
    }

    public void setNpmVersion(String npmVersion) {
        this.npmVersion = npmVersion;
    }

    private void setDiscriminatorValue(CodegenModel model, String baseName, String value) {
        for (CodegenProperty prop : model.allVars) {
            if (!prop.baseName.equals(baseName)) continue;
            prop.discriminatorValue = value;
        }
        if (model.children != null) {
            boolean newDiscriminator = model.discriminator != null;
            for (CodegenModel child : model.children) {
                this.setDiscriminatorValue(child, baseName, newDiscriminator ? value : this.getDiscriminatorValue(child));
            }
        }
    }

    private String getDiscriminatorValue(CodegenModel model) {
        return model.vendorExtensions.containsKey(X_DISCRIMINATOR_TYPE) ? (String)model.vendorExtensions.get(X_DISCRIMINATOR_TYPE) : model.classname;
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("\"", "").replace("'", "");
    }

    @Override
    public String escapeText(String input) {
        if (input == null) {
            return input;
        }
        return super.escapeText(input).replace("'", "\\'");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("*/", "*_/").replace("/*", "/_*");
    }

    @Override
    public void postProcessFile(File file, String fileType) {
        super.postProcessFile(file, fileType);
        if (file == null) {
            return;
        }
        String tsPostProcessFile = System.getenv("TS_POST_PROCESS_FILE");
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)tsPostProcessFile)) {
            return;
        }
        if ("ts".equals(FilenameUtils.getExtension((String)file.toString()))) {
            String command = tsPostProcessFile + " " + file;
            try {
                Process p = Runtime.getRuntime().exec(command);
                int exitValue = p.waitFor();
                if (exitValue != 0) {
                    this.LOGGER.error("Error running the command ({}). Exit value: {}", (Object)command, (Object)exitValue);
                } else {
                    this.LOGGER.info("Successfully executed: {}", (Object)command);
                }
            }
            catch (IOException | InterruptedException e) {
                this.LOGGER.error("Error running the command ({}). Exception: {}", (Object)command, (Object)e.getMessage());
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public String toAnyOfName(List<String> names, Schema composedSchema) {
        List<String> types = this.getTypesFromSchemas(composedSchema.getAnyOf());
        return String.join((CharSequence)" | ", types);
    }

    @Override
    public String toOneOfName(List<String> names, Schema composedSchema) {
        List<String> types = this.getTypesFromSchemas(composedSchema.getOneOf());
        return String.join((CharSequence)" | ", types);
    }

    @Override
    public String toAllOfName(List<String> names, Schema composedSchema) {
        List<String> types = this.getTypesFromSchemas(composedSchema.getAllOf());
        return String.join((CharSequence)" & ", types);
    }

    protected List<String> getTypesFromSchemas(List<Schema> schemas) {
        List<Schema> filteredSchemas = schemas.size() > 1 ? schemas.stream().filter(schema -> !"AnyType".equals(super.getSchemaType((Schema)schema))).collect(Collectors.toList()) : schemas;
        return filteredSchemas.stream().map(schema -> {
            Object schemaType = this.getSchemaType((Schema)schema);
            if (ModelUtils.isArraySchema(schema)) {
                ArraySchema ap = (ArraySchema)schema;
                Schema inner = ap.getItems();
                schemaType = (String)schemaType + "<" + this.getSchemaType(inner) + ">";
            }
            return schemaType;
        }).distinct().collect(Collectors.toList());
    }

    @Override
    public GeneratorLanguage generatorLanguage() {
        return GeneratorLanguage.TYPESCRIPT;
    }

    public static class ParameterExpander {
        private static final Pattern JS_QUOTE_PATTERN = Pattern.compile("\"");
        private static final String JS_QUOTE_REPLACEMENT = "\\\"";
        private final StringBuilder parameterName = new StringBuilder();
        private final CodegenOperation op;
        private final Function<String, String> toParameterName;

        public ParameterExpander(CodegenOperation op, Function<String, String> toParameterName) {
            this.op = op;
            this.toParameterName = toParameterName;
        }

        private void reset() {
            this.parameterName.setLength(0);
        }

        public void appendToParameterName(char c) {
            this.parameterName.append(c);
        }

        public String buildPathEntry() {
            CodegenParameter parameter = this.findPathParameterByName();
            String result = "";
            if (parameter != null) {
                String generatedParameterName = this.toParameterName.apply(this.parameterName.toString());
                result = this.buildPathEntry(parameter, generatedParameterName);
            }
            this.reset();
            return result;
        }

        private String buildPathEntry(CodegenParameter parameter, String generatedParameterName) {
            Location location = Location.fromParam(this.op, parameter);
            String style = location.defaultStyle(parameter.style);
            String optsObject = String.format(Locale.ROOT, "{name: %s, value: %s, in: %s, style: %s, explode: %s, dataType: %s, dataFormat: %s}", ParameterExpander.quotedJSString(parameter.paramName), generatedParameterName, ParameterExpander.quotedJSString(location.name()), ParameterExpander.quotedJSString(style), parameter.isExplode, ParameterExpander.quotedJSString(parameter.dataType), this.nullableQuotedJSString(parameter.dataFormat));
            String result = String.format(Locale.ROOT, "${this.configuration.encodeParam(%s)}", optsObject);
            return result;
        }

        private @Nullable CodegenParameter findPathParameterByName() {
            for (CodegenParameter param : this.op.pathParams) {
                if (!param.baseName.equals(this.parameterName.toString())) continue;
                return param;
            }
            return null;
        }

        private static String quotedJSString(String string) {
            String escaped = ParameterExpander.escapeForQuotedJSString(string);
            String result = "\"" + escaped + "\"";
            return result;
        }

        protected static String escapeForQuotedJSString(String string) {
            String quoted = JS_QUOTE_PATTERN.matcher(string).replaceAll(JS_QUOTE_REPLACEMENT);
            return quoted;
        }

        protected String nullableQuotedJSString(@Nullable String string) {
            if (string == null) {
                return AbstractTypeScriptClientCodegen.UNDEFINED_VALUE;
            }
            String result = ParameterExpander.quotedJSString(string);
            return result;
        }

        public static enum Location {
            query((operation, param) -> operation.queryParams.contains(param), ParamStyle.form),
            header((operation, param) -> operation.headerParams.contains(param), ParamStyle.simple),
            path((operation, param) -> operation.pathParams.contains(param), ParamStyle.simple),
            cookie((operation, param) -> operation.cookieParams.contains(param), ParamStyle.form);

            public final ParamStyle defaultStyle;
            public final BiPredicate<CodegenOperation, CodegenParameter> isPresentIn;

            private Location(BiPredicate<CodegenOperation, CodegenParameter> isPresentIn, ParamStyle defaultStyle) {
                this.defaultStyle = defaultStyle;
                this.isPresentIn = isPresentIn;
            }

            public String defaultStyle(@Nullable String style) {
                if (style != null && !style.trim().isEmpty()) {
                    return style;
                }
                return this.defaultStyle.asString();
            }

            public static Location fromParam(CodegenOperation op, CodegenParameter param) {
                return Arrays.stream(Location.values()).filter(v -> v.isPresentIn.test(op, param)).findAny().orElseThrow(() -> new IllegalArgumentException(String.format(Locale.ROOT, "Cannot find param ' %s' in operation '%s'", param, op.operationId)));
            }
        }

        public static enum ParamStyle {
            matrix,
            label,
            form,
            simple,
            spaceDelimited,
            pipeDelimited,
            deepObject;


            public String asString() {
                return this.name();
            }
        }
    }
}

