/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.templating.mustache;

import com.samskivert.mustache.Mustache;
import com.samskivert.mustache.Template;
import java.io.IOException;
import java.io.Writer;
import org.apache.commons.lang3.StringUtils;

public class IndentedLambda
implements Mustache.Lambda {
    private final int prefixSpaceCount;
    private final String prefix;
    private final int spaceCode;
    private final boolean indentFirstLine;

    public IndentedLambda() {
        this(4, " ", null, false);
    }

    public IndentedLambda(int prefixSpaceCount, String indentionCharacter, boolean indentFirstLine) {
        this(prefixSpaceCount, Character.codePointAt(indentionCharacter, 0), null, indentFirstLine);
    }

    public IndentedLambda(int prefixSpaceCount, String indentionCharacter, String prefix, boolean indentFirstLine) {
        this(prefixSpaceCount, Character.codePointAt(indentionCharacter, 0), prefix, indentFirstLine);
    }

    private IndentedLambda(int prefixSpaceCount, int indentionCodePoint, String prefix, boolean indentFirstLine) {
        if (prefixSpaceCount <= 0) {
            throw new IllegalArgumentException("prefixSpaceCount must be greater than 0");
        }
        if (!Character.isValidCodePoint(indentionCodePoint)) {
            throw new IllegalArgumentException("indentionCodePoint is an invalid code point ");
        }
        this.prefixSpaceCount = prefixSpaceCount;
        this.spaceCode = indentionCodePoint;
        this.prefix = prefix;
        this.indentFirstLine = indentFirstLine;
    }

    public void execute(Template.Fragment fragment, Writer writer) throws IOException {
        String text = fragment.execute();
        if (text == null || text.length() == 0) {
            return;
        }
        String prefixedIndention = StringUtils.repeat((String)new String(Character.toChars(this.spaceCode)), (int)this.prefixSpaceCount);
        StringBuilder sb = new StringBuilder();
        String[] lines = text.split("\n");
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            if (this.indentFirstLine || i > 0) {
                sb.append(prefixedIndention);
                if (this.prefix != null) {
                    sb.append(this.prefix);
                }
            }
            sb.append(line);
            if (i >= lines.length - 1) continue;
            sb.append("\n");
        }
        writer.write(sb.toString());
    }
}

