/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractScalaCodegen;
import org.openapitools.codegen.meta.features.ClientModificationFeature;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.meta.features.GlobalFeature;
import org.openapitools.codegen.meta.features.ParameterFeature;
import org.openapitools.codegen.meta.features.SchemaSupportFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.meta.features.WireFormatFeature;
import org.openapitools.codegen.utils.ModelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScalaGatlingCodegen
extends AbstractScalaCodegen
implements CodegenConfig {
    private final Logger LOGGER = LoggerFactory.getLogger(ScalaGatlingCodegen.class);
    protected String resourceFolder = "src" + File.separator + "gatling" + File.separator + "resources";
    protected String confFolder = this.resourceFolder + File.separator + "conf";
    protected String dataFolder = this.resourceFolder + File.separator + "data";
    protected String apiVersion = "1.0.0";

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "scala-gatling";
    }

    @Override
    public String getHelp() {
        return "Generates a gatling simulation library (beta).";
    }

    public ScalaGatlingCodegen() {
        this.modifyFeatureSet(features -> features.includeDocumentationFeatures(new DocumentationFeature[]{DocumentationFeature.Readme}).wireFormatFeatures(EnumSet.of(WireFormatFeature.JSON, WireFormatFeature.XML, WireFormatFeature.Custom)).securityFeatures(EnumSet.noneOf(SecurityFeature.class)).excludeGlobalFeatures(new GlobalFeature[]{GlobalFeature.XMLStructureDefinitions, GlobalFeature.Callbacks, GlobalFeature.LinkObjects, GlobalFeature.ParameterStyling}).excludeSchemaSupportFeatures(new SchemaSupportFeature[]{SchemaSupportFeature.Polymorphism}).excludeParameterFeatures(new ParameterFeature[]{ParameterFeature.Cookie}).includeClientModificationFeatures(new ClientModificationFeature[]{ClientModificationFeature.BasePath}));
        this.sourceFolder = "src" + File.separator + "gatling" + File.separator + "scala";
        this.outputFolder = "generated-code/gatling";
        this.apiTemplateFiles.put("api.mustache", "Simulation.scala");
        this.modelTemplateFiles.put("model.mustache", ".scala");
        this.templateDir = "scala-gatling";
        this.apiPackage = "org.openapitools.client.api";
        this.modelPackage = "org.openapitools.client.model";
        this.additionalProperties.put("apiVersion", this.apiVersion);
        this.supportingFiles.add(new SupportingFile("build.gradle", "", "build.gradle"));
        this.supportingFiles.add(new SupportingFile("logback.xml", this.confFolder, "logback.xml"));
        this.supportingFiles.add(new SupportingFile("default.conf.mustache", this.confFolder, "default.conf"));
        this.supportingFiles.add(new SupportingFile("default.conf.mustache", this.confFolder, "CI.conf"));
        this.supportingFiles.add(new SupportingFile("default.conf.mustache", this.confFolder, "CD.conf"));
        this.supportingFiles.add(new SupportingFile("default.conf.mustache", this.confFolder, "stress.conf"));
        this.supportingFiles.add(new SupportingFile("default.conf.mustache", this.confFolder, "baseline.conf"));
        this.supportingFiles.add(new SupportingFile("default.conf.mustache", this.confFolder, "longevity.conf"));
        this.importMapping.remove("List");
        this.importMapping.remove("Set");
        this.importMapping.remove("Map");
        this.importMapping.put("Date", "java.util.Date");
        this.typeMapping = new HashMap();
        this.typeMapping.put("enum", "NSString");
        this.typeMapping.put("array", "List");
        this.typeMapping.put("set", "Set");
        this.typeMapping.put("boolean", "Boolean");
        this.typeMapping.put("string", "String");
        this.typeMapping.put("int", "Int");
        this.typeMapping.put("long", "Long");
        this.typeMapping.put("float", "Float");
        this.typeMapping.put("byte", "Byte");
        this.typeMapping.put("short", "Short");
        this.typeMapping.put("char", "Char");
        this.typeMapping.put("double", "Double");
        this.typeMapping.put("object", "Any");
        this.typeMapping.put("file", "File");
        this.typeMapping.put("binary", "String");
        this.typeMapping.put("ByteArray", "String");
        this.typeMapping.put("date-time", "Date");
        this.typeMapping.put("DateTime", "Date");
        this.instantiationTypes.put("array", "ListBuffer");
        this.instantiationTypes.put("map", "HashMap");
        this.setReservedWordsLowerCase(Arrays.asList("path", "contentTypes", "contentType", "queryParams", "headerParams", "formParams", "postBody", "mp", "basePath", "apiInvoker", "abstract", "case", "catch", "class", "def", "do", "else", "extends", "false", "final", "finally", "for", "forSome", "if", "implicit", "import", "lazy", "match", "new", "null", "object", "override", "package", "private", "protected", "return", "sealed", "super", "this", "throw", "trait", "try", "true", "type", "val", "var", "while", "with", "yield"));
    }

    @Override
    public String escapeReservedWord(String name) {
        return name;
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + File.separator + this.sourceFolder + File.separator + this.modelPackage().replace('.', File.separatorChar);
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separator + this.sourceFolder + File.separator + this.apiPackage().replace('.', File.separatorChar);
    }

    @Override
    public void preprocessOpenAPI(OpenAPI openAPI) {
        for (Map.Entry openAPIGetPathsEntry : openAPI.getPaths().entrySet()) {
            String pathname = (String)openAPIGetPathsEntry.getKey();
            PathItem path = (PathItem)openAPIGetPathsEntry.getValue();
            if (path.readOperations() == null) continue;
            for (Operation operation : path.readOperations()) {
                if (operation.getExtensions() == null) {
                    operation.setExtensions(new HashMap());
                }
                if (!operation.getExtensions().keySet().contains("x-gatling-path")) {
                    if (pathname.contains("{")) {
                        String gatlingPath = pathname.replaceAll("\\{", "\\$\\{");
                        operation.addExtension("x-gatling-path", (Object)gatlingPath);
                    } else {
                        operation.addExtension("x-gatling-path", (Object)pathname);
                    }
                }
                HashSet<Parameter> headerParameters = new HashSet<Parameter>();
                HashSet<Parameter> formParameters = new HashSet<Parameter>();
                HashSet<Parameter> queryParameters = new HashSet<Parameter>();
                HashSet<Parameter> pathParameters = new HashSet<Parameter>();
                if (operation.getParameters() != null) {
                    for (Parameter parameter : operation.getParameters()) {
                        if ("header".equalsIgnoreCase(parameter.getIn())) {
                            headerParameters.add(parameter);
                        }
                        if ("query".equalsIgnoreCase(parameter.getIn())) {
                            queryParameters.add(parameter);
                        }
                        if (!"path".equalsIgnoreCase(parameter.getIn())) continue;
                        pathParameters.add(parameter);
                    }
                }
                this.prepareGatlingData(operation, headerParameters, "header");
                this.prepareGatlingData(operation, formParameters, "form");
                this.prepareGatlingData(operation, queryParameters, "query");
                this.prepareGatlingData(operation, pathParameters, "path");
            }
        }
    }

    private void prepareGatlingData(Operation operation, Set<Parameter> parameters, String parameterType) {
        if (parameters.size() > 0) {
            ArrayList<String> parameterNames = new ArrayList<String>();
            ArrayList vendorList = new ArrayList();
            for (Parameter parameter : parameters) {
                HashMap<String, Object> extensionMap = new HashMap<String, Object>();
                extensionMap.put("gatlingParamName", parameter.getName());
                extensionMap.put("gatlingParamValue", "${" + parameter.getName() + "}");
                vendorList.add(extensionMap);
                parameterNames.add(parameter.getName());
            }
            operation.addExtension("x-gatling-" + parameterType.toLowerCase(Locale.ROOT) + "-params", vendorList);
            operation.addExtension("x-gatling-" + parameterType.toLowerCase(Locale.ROOT) + "-feeder", (Object)(operation.getOperationId() + parameterType.toUpperCase(Locale.ROOT) + "Feeder"));
            try {
                FileUtils.writeStringToFile((File)new File(this.outputFolder + File.separator + this.dataFolder + File.separator + operation.getOperationId() + "-" + parameterType.toLowerCase(Locale.ROOT) + "Params.csv"), (String)StringUtils.join(parameterNames, (String)","), (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException ioe) {
                this.LOGGER.error("Could not create feeder file for operationId" + operation.getOperationId(), (Throwable)ioe);
            }
        }
    }

    @Override
    public String getTypeDeclaration(Schema p) {
        if (ModelUtils.isArraySchema(p)) {
            ArraySchema ap = (ArraySchema)p;
            Schema inner = ap.getItems();
            return this.getSchemaType(p) + "[" + this.getTypeDeclaration(inner) + "]";
        }
        if (ModelUtils.isMapSchema(p)) {
            Schema inner = this.getAdditionalProperties(p);
            return this.getSchemaType(p) + "[String, " + this.getTypeDeclaration(inner) + "]";
        }
        return super.getTypeDeclaration(p);
    }

    @Override
    public String getSchemaType(Schema p) {
        String schemaType = super.getSchemaType(p);
        String type = null;
        if (this.typeMapping.containsKey(schemaType)) {
            type = (String)this.typeMapping.get(schemaType);
            if (this.languageSpecificPrimitives.contains(type)) {
                return this.toModelName(type);
            }
        } else {
            type = schemaType;
        }
        return this.toModelName(type);
    }
}

