/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import com.google.common.collect.Iterables;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.Schema;
import java.io.File;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractGoCodegen;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.meta.features.GlobalFeature;
import org.openapitools.codegen.meta.features.ParameterFeature;
import org.openapitools.codegen.meta.features.SchemaSupportFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.meta.features.WireFormatFeature;
import org.openapitools.codegen.model.ModelMap;
import org.openapitools.codegen.model.ModelsMap;
import org.openapitools.codegen.model.OperationMap;
import org.openapitools.codegen.model.OperationsMap;
import org.openapitools.codegen.utils.ModelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoServerCodegen
extends AbstractGoCodegen {
    private static final String ROUTER_SWITCH = "router";
    private static final String ROUTER_SWITCH_DESC = "Specify the router which should be used.";
    private static final String[] ROUTERS = new String[]{"mux", "chi"};
    private final Logger LOGGER = LoggerFactory.getLogger(GoServerCodegen.class);
    protected String packageVersion = "1.0.0";
    protected int serverPort = 8080;
    protected String projectName = "openapi-server";
    protected String sourceFolder = "go";
    protected Boolean corsFeatureEnabled = false;
    protected Boolean addResponseHeaders = false;
    protected Boolean outputAsLibrary = false;
    protected Boolean onlyInterfaces = false;

    public GoServerCodegen() {
        this.modifyFeatureSet(features -> features.includeDocumentationFeatures(new DocumentationFeature[]{DocumentationFeature.Readme}).wireFormatFeatures(EnumSet.of(WireFormatFeature.JSON, WireFormatFeature.XML)).securityFeatures(EnumSet.noneOf(SecurityFeature.class)).excludeGlobalFeatures(new GlobalFeature[]{GlobalFeature.XMLStructureDefinitions, GlobalFeature.Callbacks, GlobalFeature.LinkObjects, GlobalFeature.ParameterStyling}).excludeSchemaSupportFeatures(new SchemaSupportFeature[]{SchemaSupportFeature.Polymorphism}).excludeParameterFeatures(new ParameterFeature[]{ParameterFeature.Cookie}));
        this.outputFolder = "generated-code/go";
        this.cliOptions.add(new CliOption("sourceFolder", "source folder for generated code").defaultValue(this.sourceFolder));
        CliOption frameworkOption = new CliOption(ROUTER_SWITCH, ROUTER_SWITCH_DESC);
        for (String option : ROUTERS) {
            frameworkOption.addEnum(option, option);
        }
        frameworkOption.defaultValue(ROUTERS[0]);
        this.cliOptions.add(frameworkOption);
        CliOption optServerPort = new CliOption("serverPort", "The network port the generated server binds to");
        optServerPort.setType("int");
        optServerPort.defaultValue(Integer.toString(this.serverPort));
        this.cliOptions.add(optServerPort);
        CliOption optFeatureCORS = new CliOption("featureCORS", "Enable Cross-Origin Resource Sharing middleware");
        optFeatureCORS.setType("bool");
        optFeatureCORS.defaultValue(this.corsFeatureEnabled.toString());
        this.cliOptions.add(optFeatureCORS);
        this.cliOptions.add(CliOption.newBoolean("enumClassPrefix", "Prefix enum with class name"));
        CliOption optAddResponseHeaders = new CliOption("addResponseHeaders", "To include response headers in ImplResponse");
        optAddResponseHeaders.setType("bool");
        optAddResponseHeaders.defaultValue(this.addResponseHeaders.toString());
        this.cliOptions.add(optAddResponseHeaders);
        CliOption optOnlyInterfaces = new CliOption("onlyInterfaces", "Exclude default service creators from output; only generate interfaces");
        optOnlyInterfaces.setType("bool");
        optOnlyInterfaces.defaultValue(this.onlyInterfaces.toString());
        this.cliOptions.add(optOnlyInterfaces);
        CliOption optOutputAsLibrary = new CliOption("outputAsLibrary", "Exclude main.go, go.mod, and Dockerfile from output");
        optOutputAsLibrary.setType("bool");
        optOutputAsLibrary.defaultValue(this.outputAsLibrary.toString());
        this.cliOptions.add(optOutputAsLibrary);
        this.modelTemplateFiles.put("model.mustache", ".go");
        this.apiTemplateFiles.put("controller-api.mustache", ".go");
        this.apiTemplateFiles.put("service.mustache", "_service.go");
        this.templateDir = "go-server";
        this.embeddedTemplateDir = "go-server";
        this.setReservedWordsLowerCase(Arrays.asList("string", "bool", "uint", "uint8", "uint16", "uint32", "uint64", "int", "int8", "int16", "int32", "int64", "float32", "float64", "complex64", "complex128", "rune", "byte", "uintptr", "break", "default", "func", "interface", "select", "case", "defer", "go", "map", "struct", "chan", "else", "goto", "package", "switch", "const", "fallthrough", "if", "range", "type", "continue", "for", "import", "return", "var", "error", "nil"));
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey("packageName")) {
            this.setPackageName((String)this.additionalProperties.get("packageName"));
        } else {
            this.setPackageName("openapi");
            this.additionalProperties.put("packageName", this.packageName);
        }
        if (this.additionalProperties.containsKey("packageVersion")) {
            this.setPackageVersion((String)this.additionalProperties.get("packageVersion"));
        } else {
            this.additionalProperties.put("packageVersion", this.packageVersion);
        }
        if (this.additionalProperties.containsKey("sourceFolder")) {
            this.setSourceFolder((String)this.additionalProperties.get("sourceFolder"));
        } else {
            this.additionalProperties.put("sourceFolder", this.sourceFolder);
        }
        if (this.additionalProperties.containsKey("serverPort") && this.additionalProperties.get("serverPort") instanceof Integer) {
            this.setServerPort((Integer)this.additionalProperties.get("serverPort"));
        } else if (this.additionalProperties.containsKey("serverPort") && this.additionalProperties.get("serverPort") instanceof String) {
            try {
                this.setServerPort(Integer.parseInt(this.additionalProperties.get("serverPort").toString()));
                this.additionalProperties.put("serverPort", this.serverPort);
            }
            catch (NumberFormatException e) {
                this.LOGGER.warn("serverPort is not a valid integer... defaulting to {}", (Object)this.serverPort);
                this.additionalProperties.put("serverPort", this.serverPort);
            }
        } else {
            this.additionalProperties.put("serverPort", this.serverPort);
        }
        if (this.additionalProperties.containsKey("featureCORS")) {
            this.setFeatureCORS(this.convertPropertyToBooleanAndWriteBack("featureCORS"));
        } else {
            this.additionalProperties.put("featureCORS", this.corsFeatureEnabled);
        }
        if (this.additionalProperties.containsKey("addResponseHeaders")) {
            this.setAddResponseHeaders(this.convertPropertyToBooleanAndWriteBack("addResponseHeaders"));
        } else {
            this.additionalProperties.put("addResponseHeaders", this.addResponseHeaders);
        }
        if (this.additionalProperties.containsKey("onlyInterfaces")) {
            this.setOnlyInterfaces(this.convertPropertyToBooleanAndWriteBack("onlyInterfaces"));
        } else {
            this.additionalProperties.put("onlyInterfaces", this.onlyInterfaces);
        }
        if (this.onlyInterfaces.booleanValue()) {
            this.apiTemplateFiles.remove("service.mustache");
        }
        if (this.additionalProperties.containsKey("outputAsLibrary")) {
            this.setOutputAsLibrary(this.convertPropertyToBooleanAndWriteBack("outputAsLibrary"));
        } else {
            this.additionalProperties.put("outputAsLibrary", this.outputAsLibrary);
        }
        if (this.additionalProperties.containsKey("enumClassPrefix")) {
            this.setEnumClassPrefix(Boolean.parseBoolean(this.additionalProperties.get("enumClassPrefix").toString()));
            if (this.enumClassPrefix) {
                this.additionalProperties.put("enumClassPrefix", true);
            }
        }
        this.additionalProperties.putIfAbsent(ROUTER_SWITCH, ROUTERS[0]);
        Object propRouter = this.additionalProperties.get(ROUTER_SWITCH);
        HashMap<String, Boolean> routers = new HashMap<String, Boolean>();
        for (String router : ROUTERS) {
            routers.put(router, router.equals(propRouter));
        }
        this.additionalProperties.put("routers", routers);
        this.modelPackage = this.packageName;
        this.apiPackage = this.packageName;
        if (!this.outputAsLibrary.booleanValue()) {
            this.supportingFiles.add(new SupportingFile("main.mustache", "", "main.go"));
            this.supportingFiles.add(new SupportingFile("Dockerfile.mustache", "", "Dockerfile"));
            this.supportingFiles.add(new SupportingFile("go.mod.mustache", "", "go.mod"));
        }
        this.supportingFiles.add(new SupportingFile("openapi.mustache", "api", "openapi.yaml"));
        this.supportingFiles.add(new SupportingFile("routers.mustache", this.sourceFolder, "routers.go"));
        this.supportingFiles.add(new SupportingFile("logger.mustache", this.sourceFolder, "logger.go"));
        this.supportingFiles.add(new SupportingFile("impl.mustache", this.sourceFolder, "impl.go"));
        this.supportingFiles.add(new SupportingFile("helpers.mustache", this.sourceFolder, "helpers.go"));
        this.supportingFiles.add(new SupportingFile("api.mustache", this.sourceFolder, "api.go"));
        this.supportingFiles.add(new SupportingFile("error.mustache", this.sourceFolder, "error.go"));
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md").doNotOverwrite());
    }

    @Override
    public ModelsMap postProcessModels(ModelsMap objs) {
        objs = super.postProcessModels(objs);
        List<Map<String, String>> imports = objs.getImports();
        for (ModelMap m : objs.getModels()) {
            imports.add(this.createMapping("import", "encoding/json"));
            CodegenModel model = m.getModel();
            if (model.isEnum) continue;
            Boolean importErrors = false;
            for (CodegenProperty param : Iterables.concat(model.vars, model.allVars, model.requiredVars, model.optionalVars)) {
                if (!param.isNumeric || !StringUtils.isNotEmpty((CharSequence)param.minimum) && !StringUtils.isNotEmpty((CharSequence)param.maximum)) continue;
                importErrors = true;
            }
            if (!importErrors.booleanValue()) continue;
            imports.add(this.createMapping("import", "errors"));
        }
        return objs;
    }

    @Override
    public OperationsMap postProcessOperationsWithModels(OperationsMap objs, List<ModelMap> allModels) {
        objs = super.postProcessOperationsWithModels(objs, allModels);
        OperationMap objectMap = objs.getOperations();
        List<CodegenOperation> operations = objectMap.getOperation();
        List<Map<String, String>> imports = objs.getImports();
        if (imports == null) {
            return objs;
        }
        imports.clear();
        boolean addedTimeImport = false;
        boolean addedOSImport = false;
        for (CodegenOperation operation : operations) {
            for (CodegenParameter param : operation.allParams) {
                if (!addedOSImport && ("*os.File".equals(param.dataType) || "[]*os.File".equals(param.dataType))) {
                    imports.add(this.createMapping("import", "os"));
                    addedOSImport = true;
                }
                if (!param.required || addedTimeImport || !"time.Time".equals(param.dataType)) continue;
                imports.add(this.createMapping("import", "time"));
                addedTimeImport = true;
            }
        }
        return objs;
    }

    @Override
    public String apiPackage() {
        return this.sourceFolder;
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    @Override
    public String getName() {
        return "go-server";
    }

    @Override
    public String getHelp() {
        return "Generates a Go server library using OpenAPI-Generator. By default, it will also generate service classes -- which you can disable with the `-Dnoservice` environment variable.";
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separator + this.apiPackage().replace('.', File.separatorChar);
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + File.separator + this.apiPackage().replace('.', File.separatorChar);
    }

    public void setSourceFolder(String sourceFolder) {
        this.sourceFolder = sourceFolder;
    }

    public void setPackageVersion(String packageVersion) {
        this.packageVersion = packageVersion;
    }

    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
    }

    public void setFeatureCORS(Boolean featureCORS) {
        this.corsFeatureEnabled = featureCORS;
    }

    public void setAddResponseHeaders(Boolean addResponseHeaders) {
        this.addResponseHeaders = addResponseHeaders;
    }

    public void setOnlyInterfaces(Boolean onlyInterfaces) {
        this.onlyInterfaces = onlyInterfaces;
    }

    public void setOutputAsLibrary(Boolean outputAsLibrary) {
        this.outputAsLibrary = outputAsLibrary;
    }

    @Override
    protected void updateModelForObject(CodegenModel m, Schema schema) {
        if (schema.getProperties() != null || schema.getRequired() != null && !(schema instanceof ComposedSchema)) {
            this.addVars(m, this.unaliasPropertySchema(schema.getProperties()), schema.getRequired(), null, null);
        }
        if (ModelUtils.isMapSchema(schema)) {
            this.addAdditionPropertiesToCodeGenModel(m, schema);
        } else {
            m.setIsMap(false);
            if (ModelUtils.isFreeFormObject(this.openAPI, schema)) {
                this.addAdditionPropertiesToCodeGenModel(m, schema);
            }
        }
        this.setAddProps(schema, m);
    }
}

