/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import io.swagger.v3.oas.models.media.Schema;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractCppCodegen;
import org.openapitools.codegen.meta.GeneratorMetadata;
import org.openapitools.codegen.meta.Stability;
import org.openapitools.codegen.meta.features.DataTypeFeature;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.meta.features.GlobalFeature;
import org.openapitools.codegen.meta.features.ParameterFeature;
import org.openapitools.codegen.meta.features.SchemaSupportFeature;
import org.openapitools.codegen.meta.features.WireFormatFeature;
import org.openapitools.codegen.model.ModelMap;
import org.openapitools.codegen.model.OperationsMap;
import org.openapitools.codegen.utils.ModelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CppTinyClientCodegen
extends AbstractCppCodegen
implements CodegenConfig {
    public static final String PROJECT_NAME = "TinyClient";
    final Logger LOGGER = LoggerFactory.getLogger(CppTinyClientCodegen.class);
    public static final String MICROCONTROLLER = "controller";
    public static final String rootFolder = "";
    protected String controller = "esp32";
    private static final String sourceFolder = "src";
    private static final String libFolder = "lib";
    private static final String serviceFolder = "lib" + File.separator + "service";

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "cpp-tiny";
    }

    @Override
    public String getHelp() {
        return "Generates a C++ Arduino REST API client.";
    }

    public void addControllerToAdditionalProperties() {
        HashMap<String, String> supportedControllers = new HashMap<String, String>();
        supportedControllers.put("esp32", "isESP32");
        supportedControllers.put("esp8266", "isESP8266");
        if (!supportedControllers.containsKey(this.controller)) {
            throw new UnsupportedOperationException("Supported controllers are: ESP32, ESP8266");
        }
        this.additionalProperties.put((String)supportedControllers.get(this.controller), true);
    }

    public CppTinyClientCodegen() {
        this.modifyFeatureSet(feature -> feature.excludeGlobalFeatures(new GlobalFeature[]{GlobalFeature.XMLStructureDefinitions, GlobalFeature.Callbacks, GlobalFeature.LinkObjects, GlobalFeature.ParameterStyling, GlobalFeature.MultiServer}).excludeSchemaSupportFeatures(new SchemaSupportFeature[]{SchemaSupportFeature.Polymorphism}).excludeParameterFeatures(new ParameterFeature[]{ParameterFeature.Cookie, ParameterFeature.Header, ParameterFeature.FormUnencoded, ParameterFeature.FormMultipart, ParameterFeature.Query}).excludeDataTypeFeatures(new DataTypeFeature[]{DataTypeFeature.Enum, DataTypeFeature.Maps, DataTypeFeature.MapOfCollectionOfEnum, DataTypeFeature.MapOfCollectionOfModel, DataTypeFeature.MapOfCollectionOfPrimitives, DataTypeFeature.MapOfEnum, DataTypeFeature.MapOfModel}).excludeWireFormatFeatures(new WireFormatFeature[]{WireFormatFeature.XML, WireFormatFeature.PROTOBUF, WireFormatFeature.Custom}).includeDocumentationFeatures(new DocumentationFeature[]{DocumentationFeature.Readme}));
        this.generatorMetadata = GeneratorMetadata.newBuilder((GeneratorMetadata)this.generatorMetadata).stability(Stability.BETA).build();
        this.outputFolder = "generated-code" + File.separator + "cpp-tiny";
        this.templateDir = "cpp-tiny";
        this.embeddedTemplateDir = "cpp-tiny";
        String libFolder = libFolder;
        this.modelPackage = libFolder + File.separator + "Models";
        this.modelTemplateFiles.put("model-header.mustache", ".h");
        this.modelTemplateFiles.put("model-body.mustache", ".cpp");
        this.supportingFiles.add(new SupportingFile("helpers-header.mustache", this.modelPackage, "Helpers.h"));
        this.supportingFiles.add(new SupportingFile("helpers-body.mustache", this.modelPackage, "Helpers.cpp"));
        this.testPackage = libFolder + File.separator + "TestFiles";
        this.modelTestTemplateFiles.put("unit-test-model.mustache", ".cpp");
        this.supportingFiles.add(new SupportingFile("run-tests.mustache", "test", "RunTests.cpp"));
        this.apiPackage = libFolder + File.separator + "service";
        this.apiTemplateFiles.put("service/api-header.mustache".replace('/', File.separatorChar), ".h");
        this.apiTemplateFiles.put("service/api-body.mustache".replace('/', File.separatorChar), ".cpp");
        this.supportingFiles.add(new SupportingFile("service/Response.h.mustache", serviceFolder, "Response.h"));
        this.supportingFiles.add(new SupportingFile("service/Service.h.mustache", serviceFolder, "Service.h"));
        this.supportingFiles.add(new SupportingFile("service/Service.cpp.mustache", serviceFolder, "Service.cpp"));
        this.supportingFiles.add(new SupportingFile("main.mustache", sourceFolder, "main.cpp"));
        this.supportingFiles.add(new SupportingFile("README.mustache", rootFolder, "README.md"));
        this.supportingFiles.add(new SupportingFile("platformio.ini.mustache", rootFolder, "platformio.ini"));
        this.supportingFiles.add(new SupportingFile("root.cert.mustache", rootFolder, "root.cert"));
        this.supportingFiles.add(new SupportingFile("pre_compiling_bourne.py.mustache", rootFolder, "pre_compiling_bourne.py"));
        this.defaultIncludes = new HashSet<String>(Arrays.asList("bool", "int", "long", "double", "float"));
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("bool", "int", "long", "double", "float", "std::string"));
        this.typeMapping = new HashMap();
        this.typeMapping.put("string", "std::string");
        this.typeMapping.put("integer", "int");
        this.typeMapping.put("boolean", "bool");
        this.typeMapping.put("array", "std::list");
        this.typeMapping.put("DateTime", "std::string");
        this.cliOptions.add(new CliOption(MICROCONTROLLER, "name of microcontroller (e.g esp32 or esp8266)").defaultValue("esp32"));
        this.makeTypeMappings();
    }

    @Override
    public String getTypeDeclaration(String str) {
        return str;
    }

    private void makeTypeMappings() {
        String cpp_array_type = "std::list";
        this.typeMapping = new HashMap();
        this.typeMapping.put("string", "std::string");
        this.typeMapping.put("integer", "int");
        this.typeMapping.put("float", "float");
        this.typeMapping.put("long", "long");
        this.typeMapping.put("boolean", "bool");
        this.typeMapping.put("double", "double");
        this.typeMapping.put("array", cpp_array_type);
        this.typeMapping.put("number", "long");
        this.typeMapping.put("binary", "std::string");
        this.typeMapping.put("password", "std::string");
        this.typeMapping.put("file", "std::string");
        this.typeMapping.put("DateTime", "std::string");
        this.typeMapping.put("Date", "std::string");
        this.typeMapping.put("UUID", "std::string");
        this.typeMapping.put("URI", "std::string");
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey(MICROCONTROLLER)) {
            this.controller = this.additionalProperties.get(MICROCONTROLLER).toString();
        }
        this.addControllerToAdditionalProperties();
        this.LOGGER.info("Generator targeting the following microcontroller: {}", (Object)this.controller);
    }

    @Override
    public String toInstantiationType(Schema p) {
        if (ModelUtils.isArraySchema(p)) {
            return (String)this.instantiationTypes.get("array");
        }
        return null;
    }

    @Override
    public String getTypeDeclaration(Schema p) {
        String openAPIType = this.getSchemaType(p);
        if (this.languageSpecificPrimitives.contains(openAPIType)) {
            return this.toModelName(openAPIType);
        }
        return openAPIType;
    }

    @Override
    public String getSchemaType(Schema p) {
        String openAPIType = super.getSchemaType(p);
        String type = null;
        if (this.typeMapping.containsKey(openAPIType)) {
            type = (String)this.typeMapping.get(openAPIType);
            if (this.languageSpecificPrimitives.contains(type)) {
                return this.toModelName(type);
            }
        } else {
            type = openAPIType;
        }
        return this.toModelName(type);
    }

    @Override
    public String toModelName(String type) {
        if (this.typeMapping.keySet().contains(type) || this.typeMapping.values().contains(type) || this.defaultIncludes.contains(type) || this.languageSpecificPrimitives.contains(type)) {
            return type;
        }
        return Character.toUpperCase(type.charAt(0)) + type.substring(1);
    }

    @Override
    public String toModelImport(String name) {
        if (name.equals("std::string")) {
            return "#include <string>";
        }
        if (name.equals("std::list")) {
            return "#include <list>";
        }
        if (name.equals("Map")) {
            return "#include <map>";
        }
        return "#include \"" + name + ".h\"";
    }

    @Override
    public String toApiImport(String name) {
        return super.toApiImport(name);
    }

    @Override
    public String toVarName(String name) {
        Object paramName = name.replaceAll("[^a-zA-Z0-9_]", rootFolder);
        if (name.length() > 0) {
            paramName = Character.toLowerCase(((String)paramName).charAt(0)) + ((String)paramName).substring(1);
        }
        if (this.isReservedWord((String)paramName)) {
            return this.escapeReservedWord((String)paramName);
        }
        return paramName;
    }

    @Override
    public String toDefaultValue(Schema p) {
        if (ModelUtils.isBooleanSchema(p)) {
            return "bool(false)";
        }
        if (ModelUtils.isNumberSchema(p)) {
            return "float(0)";
        }
        if (ModelUtils.isIntegerSchema(p)) {
            if ("int64".equals(p.getFormat())) {
                return "long(0)";
            }
            return "int(0)";
        }
        if (ModelUtils.isArraySchema(p)) {
            return "std::list";
        }
        if (!StringUtils.isEmpty((CharSequence)p.get$ref())) {
            return this.toModelName(ModelUtils.getSimpleRef(p.get$ref())) + "()";
        }
        if (ModelUtils.isDateSchema(p) || ModelUtils.isDateTimeSchema(p)) {
            return "std::string()";
        }
        if (ModelUtils.isStringSchema(p)) {
            return "std::string()";
        }
        return "null";
    }

    @Override
    public OperationsMap postProcessOperationsWithModels(OperationsMap objs, List<ModelMap> allModels) {
        objs = super.postProcessOperationsWithModels(objs, allModels);
        this.removeImport(objs, "#include <list>");
        return objs;
    }
}

