/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Schema;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.DefaultCodegen;
import org.openapitools.codegen.GeneratorLanguage;
import org.openapitools.codegen.model.ModelMap;
import org.openapitools.codegen.model.ModelsMap;
import org.openapitools.codegen.model.OperationMap;
import org.openapitools.codegen.model.OperationsMap;
import org.openapitools.codegen.utils.CamelizeOption;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEiffelCodegen
extends DefaultCodegen
implements CodegenConfig {
    private final Logger LOGGER = LoggerFactory.getLogger(AbstractEiffelCodegen.class);
    private final Set<String> parentModels = new HashSet<String>();
    private final Multimap<String, CodegenModel> childrenByParent = ArrayListMultimap.create();

    public AbstractEiffelCodegen() {
        this.hideGenerationTimestamp = Boolean.FALSE;
        this.setReservedWordsLowerCase(Arrays.asList("across", "agent", "alias", "all", "and", "as", "assign", "attached", "attribute", "check", "class", "convert", "create", "Current", "debug", "deferred", "detachable", "do", "else", "elseif", "end", "ensure", "expanded", "export", "external", "False", "feature", "from", "frozen", "if", "implies", "inherit", "inspect", "invariant", "like", "local", "loop", "not", "note", "obsolete", "old", "once", "only", "or", "Precursor", "redefine", "rename", "require", "rescue", "Result", "retry", "select", "separate", "then", "True", "TUPLE", "undefine", "until", "variant", "Void", "when", "xor"));
        this.defaultIncludes = new HashSet<String>(Arrays.asList("map", "array"));
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("BOOLEAN", "INTEGER_8", "INTEGER_16", "INTEGER_32", "INTEGER_64", "NATURAL_8", "NATURAL_16", "NATURAL_32", "NATURAL_64", "REAL_32", "REAL_64"));
        this.instantiationTypes.clear();
        this.typeMapping.clear();
        this.typeMapping.put("integer", "INTEGER_32");
        this.typeMapping.put("long", "INTEGER_64");
        this.typeMapping.put("number", "REAL_32");
        this.typeMapping.put("float", "REAL_32");
        this.typeMapping.put("decimal", "REAL_64");
        this.typeMapping.put("double", "REAL_64");
        this.typeMapping.put("boolean", "BOOLEAN");
        this.typeMapping.put("string", "STRING_32");
        this.typeMapping.put("UUID", "UUID");
        this.typeMapping.put("URI", "STRING");
        this.typeMapping.put("date", "DATE");
        this.typeMapping.put("DateTime", "DATE_TIME");
        this.typeMapping.put("date-time", "DATE_TIME");
        this.typeMapping.put("password", "STRING");
        this.typeMapping.put("File", "FILE");
        this.typeMapping.put("file", "FILE");
        this.typeMapping.put("binary", "FILE");
        this.typeMapping.put("ByteArray", "ARRAY [NATURAL_8]");
        this.typeMapping.put("object", "ANY");
        this.typeMapping.put("map", "STRING_TABLE");
        this.typeMapping.put("array", "LIST");
        this.typeMapping.put("list", "LIST");
        this.typeMapping.put("AnyType", "ANY");
        this.instantiationTypes.put("array", "ARRAYED_LIST");
        this.instantiationTypes.put("list", "ARRAYED_LIST");
        this.instantiationTypes.put("map", "STRING_TABLE");
        this.importMapping.put("List", "LIST");
        this.importMapping.put("Set", "SET");
        this.importMapping.put("file", "FILE");
        this.importMapping.put("File", "FILE");
        this.importMapping.put("Map", "STRING_TABLE");
        this.cliOptions.clear();
        this.cliOptions.add(new CliOption("packageName", "Eiffel Cluster name (convention: lowercase).").defaultValue("openapi"));
        this.cliOptions.add(new CliOption("packageVersion", "Eiffel package version.").defaultValue("1.0.0"));
        this.cliOptions.add(new CliOption("hideGenerationTimestamp", "Hides the generation timestamp when files are generated.").defaultValue(Boolean.TRUE.toString()));
    }

    @Override
    public String escapeReservedWord(String name) {
        if (this.reservedWordsMappings().containsKey(name)) {
            return this.reservedWordsMappings().get(name);
        }
        if (name.matches("^\\d.*")) {
            return "var_" + name;
        }
        return "var_" + name;
    }

    @Override
    public String toVarName(String name) {
        if (((String)(name = this.sanitizeName(((String)name).replaceAll("-", "_")))).matches("^[A-Z_]*$")) {
            return name;
        }
        if (((String)(name = this.unCamelize((String)name))).startsWith("_")) {
            name = "var" + (String)name;
        }
        if (this.isReservedWord((String)name)) {
            name = this.escapeReservedWord((String)name);
        }
        if (((String)name).matches("^\\d.*")) {
            name = this.escapeReservedWord((String)name);
        }
        return name;
    }

    @Override
    public String toParamName(String name) {
        return this.toVarName(name).toLowerCase(Locale.ROOT);
    }

    @Override
    public String toModelName(String name) {
        return this.toModelFilename(name).toUpperCase(Locale.ROOT);
    }

    @Override
    public String toModelFilename(String name) {
        if (this.schemaMapping.containsKey(name)) {
            return (String)this.schemaMapping.get(name);
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.modelNamePrefix)) {
            name = this.modelNamePrefix + "_" + (String)name;
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.modelNameSuffix)) {
            name = (String)name + "_" + this.modelNameSuffix;
        }
        if (this.isReservedWord((String)(name = this.sanitizeName((String)name)))) {
            this.LOGGER.warn("{} (reserved word) cannot be used as model name. Renamed to {}", name, (Object)("model_" + (String)name));
            name = "model_" + (String)name;
        }
        if (((String)name).matches("^\\d.*")) {
            this.LOGGER.warn("{} (model name starts with number) cannot be used as model name. Renamed to {}", name, (Object)("model_" + (String)name));
            name = "model_" + (String)name;
        }
        if (((String)name).startsWith("_")) {
            this.LOGGER.warn("{} (model name starts with _) cannot be used as model name. Renamed to {}", name, (Object)("model" + (String)name));
            name = "model" + (String)name;
        }
        return StringUtils.underscore((String)name);
    }

    @Override
    public String toApiFilename(String name) {
        name = name.replaceAll("-", "_");
        return StringUtils.underscore(name) + "_api";
    }

    @Override
    public String toApiTestFilename(String name) {
        return this.toApiName(name).toLowerCase(Locale.ROOT) + "_test";
    }

    @Override
    public String toApiName(String name) {
        if (name.length() == 0) {
            return "DEFAULT_API";
        }
        return name.toUpperCase(Locale.ROOT) + "_API";
    }

    @Override
    public void postProcessParameter(CodegenParameter parameter) {
        super.postProcessParameter(parameter);
        char firstChar = parameter.paramName.charAt(0);
        if (Character.isUpperCase(firstChar)) {
            parameter.vendorExtensions.put("x-export-param-name", parameter.paramName);
        }
        StringBuilder sb = new StringBuilder(parameter.paramName);
        sb.setCharAt(0, Character.toUpperCase(firstChar));
        parameter.vendorExtensions.put("x-export-param-name", sb.toString());
    }

    @Override
    public void postProcessModelProperty(CodegenModel model, CodegenProperty property) {
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)model.parent)) {
            this.parentModels.add(model.parent);
            if (!this.childrenByParent.containsEntry((Object)model.parent, (Object)model)) {
                this.childrenByParent.put((Object)model.parent, (Object)model);
            }
        }
    }

    @Override
    public String toModelDocFilename(String name) {
        return this.toModelName(name);
    }

    @Override
    public String toApiDocFilename(String name) {
        return this.toApiName(name);
    }

    @Override
    public String getTypeDeclaration(Schema p) {
        if (ModelUtils.isArraySchema(p)) {
            ArraySchema ap = (ArraySchema)p;
            Schema inner = ap.getItems();
            return "LIST [" + this.getTypeDeclaration(inner) + "]";
        }
        if (ModelUtils.isMapSchema(p)) {
            Schema inner = this.getAdditionalProperties(p);
            return this.getSchemaType(p) + " [" + this.getTypeDeclaration(inner) + "]";
        }
        String schemaType = this.getSchemaType(p);
        if (this.typeMapping.containsKey(schemaType)) {
            return (String)this.typeMapping.get(schemaType);
        }
        if (this.typeMapping.containsValue(schemaType)) {
            return schemaType;
        }
        if (this.languageSpecificPrimitives.contains(schemaType)) {
            return schemaType;
        }
        return this.toModelName(schemaType);
    }

    @Override
    public String getSchemaType(Schema p) {
        String schemaType = super.getSchemaType(p);
        String type = null;
        if (this.typeMapping.containsKey(schemaType)) {
            type = (String)this.typeMapping.get(schemaType);
            if (this.languageSpecificPrimitives.contains(type)) {
                return type;
            }
        } else {
            type = schemaType;
        }
        return type;
    }

    @Override
    public String toOperationId(String operationId) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)operationId)) {
            throw new RuntimeException("Empty method/operation name (operationId) not allowed");
        }
        Object sanitizedOperationId = StringUtils.camelize(this.sanitizeName(operationId), CamelizeOption.LOWERCASE_FIRST_LETTER);
        if (this.isReservedWord((String)sanitizedOperationId)) {
            this.LOGGER.warn("{} (reserved word) cannot be used as method name. Renamed to {}", (Object)operationId, (Object)StringUtils.camelize("call_" + operationId));
            sanitizedOperationId = "call_" + (String)sanitizedOperationId;
        }
        if (operationId.matches("^\\d.*")) {
            this.LOGGER.warn(operationId + " (starting with a number) cannot be used as method sname. Renamed to " + StringUtils.camelize("call_" + operationId), (Object)true);
            sanitizedOperationId = StringUtils.camelize("call_" + (String)sanitizedOperationId, CamelizeOption.LOWERCASE_FIRST_LETTER);
        }
        sanitizedOperationId = this.unCamelize((String)sanitizedOperationId);
        return this.toEiffelFeatureStyle((String)sanitizedOperationId);
    }

    @Override
    public OperationsMap postProcessOperationsWithModels(OperationsMap objs, List<ModelMap> allModels) {
        List<Map<String, String>> recursiveImports;
        OperationMap objectMap = objs.getOperations();
        List<CodegenOperation> operations = objectMap.getOperation();
        for (CodegenOperation operation : operations) {
            operation.httpMethod = StringUtils.camelize(operation.httpMethod.toLowerCase(Locale.ROOT));
        }
        List<Map<String, String>> imports = objs.getImports();
        if (imports == null) {
            return objs;
        }
        Iterator<Map<String, String>> iterator = imports.iterator();
        while (iterator.hasNext()) {
            String _import = iterator.next().get("import");
            if (!_import.startsWith(this.apiPackage())) continue;
            iterator.remove();
        }
        for (CodegenOperation operation : operations) {
            if (operation.returnBaseType == null || !this.needToImport(operation.returnBaseType)) continue;
            imports.add(this.createMapping("import", "encoding/json"));
            break;
        }
        for (CodegenOperation operation : operations) {
            if (operation.pathParams == null || operation.pathParams.size() <= 0) continue;
            imports.add(this.createMapping("import", "fmt"));
            break;
        }
        if ((recursiveImports = objs.getImports()) == null) {
            return objs;
        }
        ListIterator<Map<String, String>> listIterator = imports.listIterator();
        while (listIterator.hasNext()) {
            String _import = listIterator.next().get("import");
            if (!this.importMapping.containsKey(_import)) continue;
            listIterator.add(this.createMapping("import", (String)this.importMapping.get(_import)));
        }
        return objs;
    }

    @Override
    public ModelsMap postProcessModels(ModelsMap objs) {
        return this.postProcessModelsEnum(objs);
    }

    @Override
    public Map<String, ModelsMap> postProcessAllModels(Map<String, ModelsMap> models) {
        Map<String, ModelsMap> processed = super.postProcessAllModels(models);
        this.postProcessParentModels(models);
        return processed;
    }

    private void postProcessParentModels(Map<String, ModelsMap> models) {
        for (String parent : this.parentModels) {
            CodegenModel parentModel = ModelUtils.getModelByName(parent, models);
            Collection childrenModels = this.childrenByParent.get((Object)parent);
            for (CodegenModel child : childrenModels) {
                this.processParentPropertiesInChildModel(parentModel, child);
            }
        }
    }

    private void processParentPropertiesInChildModel(CodegenModel parent, CodegenModel child) {
        HashMap<String, CodegenProperty> childPropertiesByName = new HashMap<String, CodegenProperty>(child.vars.size());
        for (CodegenProperty childProperty : child.vars) {
            childPropertiesByName.put(childProperty.name, childProperty);
        }
        if (parent != null) {
            for (CodegenProperty parentProperty : parent.vars) {
                CodegenProperty duplicatedByParent = (CodegenProperty)childPropertiesByName.get(parentProperty.name);
                if (duplicatedByParent == null) continue;
                duplicatedByParent.isInherited = true;
            }
        }
    }

    @Override
    public CodegenModel fromModel(String name, Schema model) {
        Map<String, Schema> allDefinitions = ModelUtils.getSchemas(this.openAPI);
        CodegenModel codegenModel = super.fromModel(name, model);
        if (allDefinitions != null && codegenModel.parentSchema != null && codegenModel.hasEnums) {
            Schema parentModel = allDefinitions.get(codegenModel.parentSchema);
            CodegenModel parentCodegenModel = super.fromModel(codegenModel.parent, parentModel);
            codegenModel = AbstractEiffelCodegen.reconcileInlineEnums(codegenModel, parentCodegenModel);
        }
        return codegenModel;
    }

    private static CodegenModel reconcileInlineEnums(CodegenModel codegenModel, CodegenModel parentCodegenModel) {
        if (parentCodegenModel == null || !parentCodegenModel.hasEnums) {
            return codegenModel;
        }
        List<CodegenProperty> parentModelCodegenProperties = parentCodegenModel.vars;
        List<CodegenProperty> codegenProperties = codegenModel.vars;
        boolean removedChildEnum = false;
        for (CodegenProperty parentModelCodegenProperty : parentModelCodegenProperties) {
            if (!parentModelCodegenProperty.isEnum) continue;
            Iterator<CodegenProperty> iterator = codegenProperties.iterator();
            while (iterator.hasNext()) {
                CodegenProperty codegenProperty = iterator.next();
                if (!codegenProperty.isEnum || !codegenProperty.equals(parentModelCodegenProperty)) continue;
                iterator.remove();
                removedChildEnum = true;
            }
        }
        if (removedChildEnum) {
            codegenModel.vars = codegenProperties;
        }
        return codegenModel;
    }

    @Override
    protected boolean needToImport(String type) {
        return !this.defaultIncludes.contains(type) && !this.languageSpecificPrimitives.contains(type);
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("\"", "");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("*/", "*_/").replace("/*", "/_*");
    }

    public Map<String, String> createMapping(String key, String value) {
        HashMap<String, String> customImport = new HashMap<String, String>();
        customImport.put(key, value);
        return customImport;
    }

    @Override
    public String toInstantiationType(Schema p) {
        return this.getTypeDeclaration(p);
    }

    public String unCamelize(String name) {
        return name.replaceAll("(.)(\\p{Upper})", "$1_$2").toLowerCase(Locale.ROOT);
    }

    public String toEiffelFeatureStyle(String operationId) {
        if (operationId.startsWith("get_")) {
            return operationId.substring(4);
        }
        return operationId;
    }

    @Override
    protected void updatePropertyForArray(CodegenProperty property, CodegenProperty innerProperty) {
        if (innerProperty == null) {
            this.LOGGER.warn("skipping invalid array property {}", (Object)Json.pretty((Object)property));
            return;
        }
        property.dataFormat = innerProperty.dataFormat;
        if (!this.languageSpecificPrimitives.contains(innerProperty.baseType)) {
            property.complexType = innerProperty.baseType;
        } else {
            property.isPrimitiveType = true;
        }
        property.items = innerProperty;
        if (this.isPropertyInnerMostEnum(property).booleanValue()) {
            // empty if block
        }
    }

    @Override
    public GeneratorLanguage generatorLanguage() {
        return GeneratorLanguage.EIFFEL;
    }
}

