/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import com.google.common.collect.Sets;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.servers.Server;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.commons.io.FilenameUtils;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenResponse;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.DefaultCodegen;
import org.openapitools.codegen.GeneratorLanguage;
import org.openapitools.codegen.languages.DartClientCodegen;
import org.openapitools.codegen.meta.features.ClientModificationFeature;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.meta.features.GlobalFeature;
import org.openapitools.codegen.meta.features.ParameterFeature;
import org.openapitools.codegen.meta.features.SchemaSupportFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.meta.features.WireFormatFeature;
import org.openapitools.codegen.model.ModelMap;
import org.openapitools.codegen.model.ModelsMap;
import org.openapitools.codegen.model.OperationMap;
import org.openapitools.codegen.model.OperationsMap;
import org.openapitools.codegen.utils.CamelizeOption;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDartCodegen
extends DefaultCodegen {
    private final Logger LOGGER = LoggerFactory.getLogger(AbstractDartCodegen.class);
    protected static final List<String> DEFAULT_SUPPORTED_CONTENT_TYPES = Arrays.asList("application/json", "application/x-www-form-urlencoded", "multipart/form-data");
    public static final String PUB_LIBRARY = "pubLibrary";
    public static final String PUB_NAME = "pubName";
    public static final String PUB_VERSION = "pubVersion";
    public static final String PUB_DESCRIPTION = "pubDescription";
    public static final String PUB_AUTHOR = "pubAuthor";
    public static final String PUB_AUTHOR_EMAIL = "pubAuthorEmail";
    public static final String PUB_HOMEPAGE = "pubHomepage";
    public static final String USE_ENUM_EXTENSION = "useEnumExtension";
    protected String pubLibrary = "openapi.api";
    protected String pubName = "openapi";
    protected String pubVersion = "1.0.0";
    protected String pubDescription = "OpenAPI API client";
    protected String pubAuthor = "Author";
    protected String pubAuthorEmail = "author@homepage";
    protected String pubHomepage = "homepage";
    protected boolean useEnumExtension = false;
    protected String sourceFolder = "src";
    protected String libPath = "lib" + File.separator;
    protected String apiDocPath = "doc" + File.separator;
    protected String modelDocPath = "doc" + File.separator;
    protected String apiTestPath = "test" + File.separator;
    protected String modelTestPath = "test" + File.separator;
    protected Map<String, String> imports = new HashMap<String, String>();

    public AbstractDartCodegen() {
        this.modifyFeatureSet(features -> features.includeDocumentationFeatures(new DocumentationFeature[]{DocumentationFeature.Readme}).securityFeatures(EnumSet.of(SecurityFeature.OAuth2_Implicit, SecurityFeature.BasicAuth, SecurityFeature.BearerToken, SecurityFeature.ApiKey)).excludeGlobalFeatures(new GlobalFeature[]{GlobalFeature.XMLStructureDefinitions, GlobalFeature.Callbacks, GlobalFeature.LinkObjects, GlobalFeature.ParameterStyling}).excludeSchemaSupportFeatures(new SchemaSupportFeature[]{SchemaSupportFeature.Polymorphism, SchemaSupportFeature.Union, SchemaSupportFeature.Composite}).includeParameterFeatures(new ParameterFeature[]{ParameterFeature.Cookie}).includeClientModificationFeatures(new ClientModificationFeature[]{ClientModificationFeature.BasePath}).excludeWireFormatFeatures(new WireFormatFeature[]{WireFormatFeature.XML}));
        this.outputFolder = "generated-code/dart";
        this.modelTemplateFiles.put("model.mustache", ".dart");
        this.apiTemplateFiles.put("api.mustache", ".dart");
        this.templateDir = "dart2";
        this.embeddedTemplateDir = "dart2";
        this.apiPackage = "api";
        this.modelPackage = "model";
        this.modelDocTemplateFiles.put("object_doc.mustache", ".md");
        this.apiDocTemplateFiles.put("api_doc.mustache", ".md");
        this.modelTestTemplateFiles.put("model_test.mustache", ".dart");
        this.apiTestTemplateFiles.put("api_test.mustache", ".dart");
        ArrayList<String> reservedWordsList = new ArrayList<String>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(DartClientCodegen.class.getResourceAsStream("/dart/dart-keywords.txt"), StandardCharsets.UTF_8));){
            while (reader.ready()) {
                reservedWordsList.add(reader.readLine());
            }
        }
        catch (Exception e) {
            this.LOGGER.error("Error reading dart keywords. Exception: {}", (Object)e.getMessage());
        }
        this.setReservedWordsLowerCase(reservedWordsList);
        this.languageSpecificPrimitives = Sets.newHashSet((Object[])new String[]{"String", "bool", "int", "num", "double"});
        this.typeMapping = new HashMap();
        this.typeMapping.put("Array", "List");
        this.typeMapping.put("array", "List");
        this.typeMapping.put("map", "Map");
        this.typeMapping.put("List", "List");
        this.typeMapping.put("set", "Set");
        this.typeMapping.put("boolean", "bool");
        this.typeMapping.put("string", "String");
        this.typeMapping.put("char", "String");
        this.typeMapping.put("int", "int");
        this.typeMapping.put("long", "int");
        this.typeMapping.put("short", "int");
        this.typeMapping.put("number", "num");
        this.typeMapping.put("float", "double");
        this.typeMapping.put("double", "double");
        this.typeMapping.put("decimal", "double");
        this.typeMapping.put("integer", "int");
        this.typeMapping.put("Date", "DateTime");
        this.typeMapping.put("date", "DateTime");
        this.typeMapping.put("DateTime", "DateTime");
        this.typeMapping.put("file", "MultipartFile");
        this.typeMapping.put("binary", "MultipartFile");
        this.typeMapping.put("UUID", "String");
        this.typeMapping.put("URI", "String");
        this.typeMapping.put("ByteArray", "String");
        this.typeMapping.put("object", "Object");
        this.typeMapping.put("AnyType", "Object");
        this.defaultIncludes = Sets.newHashSet((Object[])new String[]{"String", "bool", "int", "num", "double", "List", "Set", "Map", "DateTime", "Object"});
        this.imports.put("String", "dart:core");
        this.imports.put("bool", "dart:core");
        this.imports.put("int", "dart:core");
        this.imports.put("num", "dart:core");
        this.imports.put("double", "dart:core");
        this.imports.put("List", "dart:core");
        this.imports.put("Set", "dart:core");
        this.imports.put("Map", "dart:core");
        this.imports.put("DateTime", "dart:core");
        this.imports.put("Object", "dart:core");
        this.imports.put("MultipartFile", "package:http/http.dart");
        this.addOption(PUB_LIBRARY, "Library name in generated code", this.pubLibrary);
        this.addOption(PUB_NAME, "Name in generated pubspec", this.pubName);
        this.addOption(PUB_VERSION, "Version in generated pubspec", this.pubVersion);
        this.addOption(PUB_DESCRIPTION, "Description in generated pubspec", this.pubDescription);
        this.addOption(PUB_AUTHOR, "Author name in generated pubspec", this.pubAuthor);
        this.addOption(PUB_AUTHOR_EMAIL, "Email address of the author in generated pubspec", this.pubAuthorEmail);
        this.addOption(PUB_HOMEPAGE, "Homepage in generated pubspec", this.pubHomepage);
        this.addOption(USE_ENUM_EXTENSION, "Allow the 'x-enum-values' extension for enums", String.valueOf(this.useEnumExtension));
        this.addOption("sourceFolder", "source folder for generated code", this.sourceFolder);
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "dart";
    }

    @Override
    public String getHelp() {
        return "Generates a Dart 2.x client library.";
    }

    @Override
    public void processOpts() {
        super.processOpts();
        this.modelPackage = this.modelPackage.replace('.', '/');
        this.apiPackage = this.apiPackage.replace('.', '/');
        this.additionalProperties.put("modelPackage", this.modelPackage);
        this.additionalProperties.put("apiPackage", this.apiPackage);
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)System.getenv("DART_POST_PROCESS_FILE"))) {
            this.LOGGER.info("Environment variable DART_POST_PROCESS_FILE not defined so the Dart code may not be properly formatted. To define it, try `export DART_POST_PROCESS_FILE=\"/usr/local/bin/dartfmt -w\"` (Linux/Mac)");
            this.LOGGER.info("NOTE: To enable file post-processing, 'enablePostProcessFile' must be set to `true` (--enable-post-process-file for CLI).");
        }
        if (this.additionalProperties.containsKey(PUB_NAME)) {
            this.setPubName((String)this.additionalProperties.get(PUB_NAME));
        } else {
            this.additionalProperties.put(PUB_NAME, this.pubName);
        }
        if (this.additionalProperties.containsKey(PUB_LIBRARY)) {
            this.setPubLibrary((String)this.additionalProperties.get(PUB_LIBRARY));
        } else {
            this.additionalProperties.put(PUB_LIBRARY, this.pubLibrary);
        }
        if (this.additionalProperties.containsKey(PUB_VERSION)) {
            this.setPubVersion((String)this.additionalProperties.get(PUB_VERSION));
        } else {
            this.additionalProperties.put(PUB_VERSION, this.pubVersion);
        }
        if (this.additionalProperties.containsKey(PUB_DESCRIPTION)) {
            this.setPubDescription((String)this.additionalProperties.get(PUB_DESCRIPTION));
        } else {
            this.additionalProperties.put(PUB_DESCRIPTION, this.pubDescription);
        }
        if (this.additionalProperties.containsKey(PUB_AUTHOR)) {
            this.setPubAuthor((String)this.additionalProperties.get(PUB_AUTHOR));
        } else {
            this.additionalProperties.put(PUB_AUTHOR, this.pubAuthor);
        }
        if (this.additionalProperties.containsKey(PUB_AUTHOR_EMAIL)) {
            this.setPubAuthorEmail((String)this.additionalProperties.get(PUB_AUTHOR_EMAIL));
        } else {
            this.additionalProperties.put(PUB_AUTHOR_EMAIL, this.pubAuthorEmail);
        }
        if (this.additionalProperties.containsKey(PUB_HOMEPAGE)) {
            this.setPubHomepage((String)this.additionalProperties.get(PUB_HOMEPAGE));
        } else {
            this.additionalProperties.put(PUB_HOMEPAGE, this.pubHomepage);
        }
        if (this.additionalProperties.containsKey(USE_ENUM_EXTENSION)) {
            this.setUseEnumExtension(this.convertPropertyToBooleanAndWriteBack(USE_ENUM_EXTENSION));
        } else {
            this.additionalProperties.put(USE_ENUM_EXTENSION, this.useEnumExtension);
        }
        if (this.additionalProperties.containsKey("sourceFolder")) {
            String srcFolder = (String)this.additionalProperties.get("sourceFolder");
            this.setSourceFolder(srcFolder.replace('/', File.separatorChar));
        }
        this.additionalProperties.put("sourceFolder", this.sourceFolder);
        this.additionalProperties.put("apiDocPath", this.apiDocPath);
        this.additionalProperties.put("modelDocPath", this.modelDocPath);
        if (this.templateDir == null) {
            this.templateDir = "dart2";
            this.embeddedTemplateDir = "dart2";
        }
    }

    @Override
    protected boolean needToImport(String type) {
        return org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)type) && (!this.imports.containsKey(type) || !this.imports.get(type).equals("dart:core"));
    }

    @Override
    protected boolean isReservedWord(String word) {
        return super.isReservedWord(word) || this.reservedWordsMappings().containsKey(word) || this.defaultIncludes().contains(word);
    }

    @Override
    public String escapeReservedWord(String name) {
        if (this.reservedWordsMappings().containsKey(name)) {
            return this.reservedWordsMappings().get(name);
        }
        return name + "_";
    }

    @Override
    public String apiFileFolder() {
        return (this.outputFolder + File.separator + this.libPath + this.sourceFolder + File.separator + this.apiPackage()).replace('/', File.separatorChar);
    }

    @Override
    public String modelFileFolder() {
        return (this.outputFolder + File.separator + this.libPath + this.sourceFolder + File.separator + this.modelPackage()).replace('/', File.separatorChar);
    }

    @Override
    public String apiTestFileFolder() {
        return this.outputFolder + File.separator + this.apiTestPath;
    }

    @Override
    public String modelTestFileFolder() {
        return this.outputFolder + File.separator + this.modelTestPath;
    }

    @Override
    public String apiDocFileFolder() {
        return this.outputFolder + File.separator + this.apiDocPath;
    }

    @Override
    public String modelDocFileFolder() {
        return this.outputFolder + File.separator + this.modelDocPath;
    }

    @Override
    public String toVarName(String name) {
        name = name.replace("-", "_");
        if ((name = name.replaceAll("^_", "")).matches("^[A-Z_]*$")) {
            return name;
        }
        if (name.chars().anyMatch(character -> this.specialCharReplacements.containsKey(String.valueOf((char)character)))) {
            name = StringUtils.escape(name, this.specialCharReplacements, Collections.singletonList("_"), "_");
        }
        name = this.sanitizeName(name);
        if ((name = StringUtils.camelize(name, CamelizeOption.LOWERCASE_FIRST_LETTER)).matches("^\\d.*")) {
            name = "n" + name;
        }
        if (this.isReservedWord(name)) {
            name = this.escapeReservedWord(name);
        }
        return name;
    }

    @Override
    public String toParamName(String name) {
        return this.toVarName(name);
    }

    @Override
    public String toModelName(String name) {
        String sanitizedName = this.sanitizeName(name);
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.modelNamePrefix)) {
            sanitizedName = this.modelNamePrefix + "_" + sanitizedName;
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.modelNameSuffix)) {
            sanitizedName = sanitizedName + "_" + this.modelNameSuffix;
        }
        String camelizedName = StringUtils.camelize(sanitizedName);
        if (this.typeMapping().containsKey(camelizedName)) {
            String typeName = this.typeMapping().get(camelizedName);
            if (this.imports.containsKey(typeName)) {
                String modelName = "Model" + camelizedName;
                this.LOGGER.warn("{} (existing type) cannot be used as model name. Renamed to {}", (Object)camelizedName, (Object)modelName);
                return modelName;
            }
            return typeName;
        }
        if (this.isReservedWord(camelizedName)) {
            String modelName = "Model" + camelizedName;
            this.LOGGER.warn("{} (reserved word) cannot be used as model name. Renamed to {}", (Object)camelizedName, (Object)modelName);
            return modelName;
        }
        if (camelizedName.matches("^\\d.*")) {
            String modelName = "Model" + camelizedName;
            this.LOGGER.warn("{} (model name starts with number) cannot be used as model name. Renamed to {}", (Object)name, (Object)modelName);
            return modelName;
        }
        return camelizedName;
    }

    @Override
    public String toModelFilename(String name) {
        return StringUtils.underscore(this.toModelName(name));
    }

    @Override
    public String toModelDocFilename(String name) {
        return this.toModelName(name);
    }

    @Override
    public String toApiFilename(String name) {
        return StringUtils.underscore(this.toApiName(name));
    }

    @Override
    public String toApiTestFilename(String name) {
        return this.toApiFilename(name) + "_test";
    }

    @Override
    public String toModelTestFilename(String name) {
        return this.toModelFilename(name) + "_test";
    }

    @Override
    public String toDefaultValue(Schema schema) {
        if (ModelUtils.isMapSchema(schema) || ModelUtils.isSet(schema)) {
            return "const {}";
        }
        if (ModelUtils.isArraySchema(schema)) {
            return "const []";
        }
        if (schema.getDefault() != null) {
            if (ModelUtils.isDateSchema(schema) || ModelUtils.isDateTimeSchema(schema)) {
                return null;
            }
            if (ModelUtils.isStringSchema(schema)) {
                return "'" + schema.getDefault().toString().replace("'", "\\'") + "'";
            }
            return schema.getDefault().toString();
        }
        return null;
    }

    @Override
    public String getTypeDeclaration(Schema p) {
        Schema target;
        Schema schema = this.unaliasSchema(p);
        Schema schema2 = target = ModelUtils.isGenerateAliasAsModel() ? p : schema;
        if (ModelUtils.isArraySchema(target)) {
            Schema<?> items = this.getSchemaItems((ArraySchema)schema);
            return this.getSchemaType(target) + "<" + this.getTypeDeclaration(items) + ">";
        }
        if (ModelUtils.isMapSchema(target)) {
            Schema inner = this.getAdditionalProperties(target);
            if (inner == null) {
                this.LOGGER.error("`{}` (map property) does not have a proper inner type defined. Default to type:string", (Object)p.getName());
                inner = new StringSchema().description("TODO default missing map inner type to string");
                p.setAdditionalProperties((Object)inner);
            }
            return this.getSchemaType(target) + "<String, " + this.getTypeDeclaration(inner) + ">";
        }
        return super.getTypeDeclaration(p);
    }

    @Override
    public String getSchemaType(Schema p) {
        String openAPIType = super.getSchemaType(p);
        if (openAPIType == null) {
            this.LOGGER.error("No Type defined for Schema {}", (Object)p);
        }
        if (this.typeMapping().containsKey(openAPIType)) {
            return this.typeMapping().get(openAPIType);
        }
        return this.toModelName(openAPIType);
    }

    @Override
    public ModelsMap postProcessModels(ModelsMap objs) {
        return this.postProcessModelsEnum(objs);
    }

    @Override
    public void postProcessModelProperty(CodegenModel model, CodegenProperty property) {
        super.postProcessModelProperty(model, property);
        if (!model.isEnum && property.isEnum && property.getComposedSchemas() == null) {
            String enumName = model.classname + property.enumName;
            if (property.items != null) {
                property.setDatatypeWithEnum(property.datatypeWithEnum.replace(property.items.datatypeWithEnum, enumName));
                property.items.setDatatypeWithEnum(enumName);
                property.items.setEnumName(enumName);
            } else {
                property.setDatatypeWithEnum(property.datatypeWithEnum.replace(property.enumName, enumName));
            }
            property.setEnumName(enumName);
        }
    }

    @Override
    public CodegenProperty fromProperty(String name, Schema p, boolean required) {
        ComposedSchema composed;
        long count;
        CodegenProperty property = super.fromProperty(name, p, required);
        if (ModelUtils.isComposedSchema(p) && (!ModelUtils.isAllOf(p) || p.getAllOf().size() != 1) && (count = Stream.of((composed = (ComposedSchema)p).getAllOf(), composed.getAnyOf(), composed.getOneOf()).filter(list -> list != null && list.size() == 1).count()) == 1L) {
            Stream.of(composed.getAllOf(), composed.getAnyOf(), composed.getOneOf()).filter(list -> list != null && list.size() == 1).findFirst().map(list -> ((Schema)list.get(0)).get$ref()).map(ModelUtils::getSimpleRef).map(ref -> ModelUtils.getSchemas(this.openAPI).get(ref)).ifPresent(schema -> {
                property.isEnum = schema.getEnum() != null;
                property.isModel = true;
            });
        }
        return property;
    }

    @Override
    public CodegenOperation fromOperation(String path, String httpMethod, Operation operation, List<Server> servers) {
        CodegenOperation op = super.fromOperation(path, httpMethod, operation, servers);
        for (CodegenResponse r : op.responses) {
            String value;
            if (r.containerType == null || !this.typeMapping().containsKey(r.containerType) || !this.needToImport(value = this.typeMapping().get(r.containerType))) continue;
            op.imports.add(value);
        }
        for (CodegenParameter p : op.allParams) {
            String value;
            String type;
            if (!p.isContainer) continue;
            String string = type = p.isArray ? "array" : "map";
            if (!this.typeMapping().containsKey(type) || !this.needToImport(value = this.typeMapping().get(type))) continue;
            op.imports.add(value);
        }
        return op;
    }

    @Override
    public OperationsMap postProcessOperationsWithModels(OperationsMap objs, List<ModelMap> allModels) {
        super.postProcessOperationsWithModels(objs, allModels);
        OperationMap operations = objs.getOperations();
        if (operations != null) {
            List<CodegenOperation> ops = operations.getOperation();
            for (CodegenOperation op : ops) {
                if (!op.hasConsumes) continue;
                if (!op.formParams.isEmpty() || op.isMultipart) {
                    op.prioritizedContentTypes = op.consumes;
                    continue;
                }
                op.prioritizedContentTypes = this.prioritizeContentTypes(op.consumes);
                String mediaType = op.prioritizedContentTypes.get(0).get("mediaType");
                if (DEFAULT_SUPPORTED_CONTENT_TYPES.contains(mediaType)) continue;
                this.LOGGER.warn("The media-type '{}' for operation '{}' is not support in the Dart generators by default.", (Object)mediaType, (Object)op.path);
            }
        }
        return objs;
    }

    private List<Map<String, String>> prioritizeContentTypes(List<Map<String, String>> consumes) {
        if (consumes.size() <= 1) {
            return consumes;
        }
        ArrayList<Map<String, String>> prioritizedContentTypes = new ArrayList<Map<String, String>>(consumes.size());
        ArrayList<Map<String, String>> jsonVendorMimeTypes = new ArrayList<Map<String, String>>(consumes.size());
        ArrayList<Map<String, String>> jsonMimeTypes = new ArrayList<Map<String, String>>(consumes.size());
        for (Map<String, String> consume : consumes) {
            String mediaType = consume.get("mediaType");
            if (AbstractDartCodegen.isJsonVendorMimeType(mediaType)) {
                jsonVendorMimeTypes.add(consume);
                continue;
            }
            if (AbstractDartCodegen.isJsonMimeType(mediaType)) {
                jsonMimeTypes.add(consume);
                continue;
            }
            prioritizedContentTypes.add(consume);
        }
        prioritizedContentTypes.addAll(0, jsonMimeTypes);
        prioritizedContentTypes.addAll(0, jsonVendorMimeTypes);
        return prioritizedContentTypes;
    }

    @Override
    protected void updateEnumVarsWithExtensions(List<Map<String, Object>> enumVars, Map<String, Object> vendorExtensions, String dataType) {
        if (vendorExtensions != null && this.useEnumExtension && vendorExtensions.containsKey("x-enum-values")) {
            enumVars.clear();
            Object extension = vendorExtensions.get("x-enum-values");
            List values = (List)extension;
            for (Map value : values) {
                HashMap<String, Object> enumVar = new HashMap<String, Object>();
                enumVar.put("name", this.toEnumVarName((String)value.get("identifier"), dataType));
                enumVar.put("value", this.toEnumValue(value.get("numericValue").toString(), dataType));
                enumVar.put("isString", this.isDataTypeString(dataType));
                if (value.containsKey("description")) {
                    enumVar.put("description", value.get("description").toString());
                }
                enumVars.add(enumVar);
            }
        } else {
            super.updateEnumVarsWithExtensions(enumVars, vendorExtensions, dataType);
        }
    }

    @Override
    public String toEnumVarName(String value, String datatype) {
        if (value.length() == 0) {
            return "empty";
        }
        if (("number".equalsIgnoreCase(datatype) || "double".equalsIgnoreCase(datatype) || "int".equalsIgnoreCase(datatype)) && value.matches("^-?\\d.*")) {
            boolean isNegative = value.startsWith("-");
            return this.toVarName("number" + (isNegative ? "_negative" : "") + value);
        }
        return this.toVarName(value);
    }

    @Override
    public String toEnumValue(String value, String datatype) {
        if ("number".equalsIgnoreCase(datatype) || "int".equalsIgnoreCase(datatype)) {
            return value;
        }
        return "'" + this.escapeText(value) + "'";
    }

    @Override
    public String toOperationId(String operationId) {
        operationId = super.toOperationId(operationId);
        if (this.isReservedWord(operationId = StringUtils.camelize(this.sanitizeName(operationId), CamelizeOption.LOWERCASE_FIRST_LETTER))) {
            String newOperationId = StringUtils.camelize("call_" + operationId, CamelizeOption.LOWERCASE_FIRST_LETTER);
            this.LOGGER.warn("{} (reserved word) cannot be used as method name. Renamed to {}", (Object)operationId, (Object)newOperationId);
            return newOperationId;
        }
        if (operationId.matches("^\\d.*")) {
            String newOperationId = StringUtils.camelize("call_" + operationId, CamelizeOption.LOWERCASE_FIRST_LETTER);
            this.LOGGER.warn("{} (starting with a number) cannot be used as method name. Renamed to {}", (Object)operationId, (Object)newOperationId);
            operationId = newOperationId;
        }
        return operationId;
    }

    public void setPubLibrary(String pubLibrary) {
        this.pubLibrary = pubLibrary;
    }

    public void setPubName(String pubName) {
        this.pubName = pubName;
    }

    public void setPubVersion(String pubVersion) {
        this.pubVersion = pubVersion;
    }

    public void setPubDescription(String pubDescription) {
        this.pubDescription = pubDescription;
    }

    public void setPubAuthor(String pubAuthor) {
        this.pubAuthor = pubAuthor;
    }

    public void setPubAuthorEmail(String pubAuthorEmail) {
        this.pubAuthorEmail = pubAuthorEmail;
    }

    public void setPubHomepage(String pubHomepage) {
        this.pubHomepage = pubHomepage;
    }

    public void setUseEnumExtension(boolean useEnumExtension) {
        this.useEnumExtension = useEnumExtension;
    }

    public void setSourceFolder(String sourceFolder) {
        this.sourceFolder = sourceFolder;
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("\"", "");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("*/", "*_/").replace("/*", "/_*");
    }

    @Override
    public void postProcessFile(File file, String fileType) {
        super.postProcessFile(file, fileType);
        if (file == null) {
            return;
        }
        String dartPostProcessFile = System.getenv("DART_POST_PROCESS_FILE");
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)dartPostProcessFile)) {
            return;
        }
        if ("dart".equals(FilenameUtils.getExtension((String)file.toString()))) {
            String command = dartPostProcessFile + " " + file;
            try {
                Process p = Runtime.getRuntime().exec(command);
                int exitValue = p.waitFor();
                if (exitValue != 0) {
                    this.LOGGER.error("Error running the command ({}). Exit code: {}", (Object)command, (Object)exitValue);
                } else {
                    this.LOGGER.info("Successfully executed: {}", (Object)command);
                }
            }
            catch (IOException | InterruptedException e) {
                this.LOGGER.error("Error running the command ({}). Exception: {}", (Object)command, (Object)e.getMessage());
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public GeneratorLanguage generatorLanguage() {
        return GeneratorLanguage.DART;
    }
}

