/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import com.google.common.collect.ImmutableMap;
import com.samskivert.mustache.Mustache;
import com.samskivert.mustache.Template;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.info.License;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.servers.Server;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringEscapeUtils;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenConstants;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenResponse;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.DefaultCodegen;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.meta.GeneratorMetadata;
import org.openapitools.codegen.meta.Stability;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class K6ClientCodegen
extends DefaultCodegen
implements CodegenConfig {
    private final Logger LOGGER = LoggerFactory.getLogger(K6ClientCodegen.class);
    public static final String PROJECT_NAME = "projectName";
    public static final String MODULE_NAME = "moduleName";
    public static final String PROJECT_DESCRIPTION = "projectDescription";
    public static final String PROJECT_VERSION = "projectVersion";
    public static final String BASE_URL = "baseURL";
    public static final String PRESERVE_LEADING_PARAM_CHAR = "preserveLeadingParamChar";
    static final Collection<String> INVOKER_PKG_SUPPORTING_FILES = Arrays.asList("script.mustache", "README.mustache");
    static final String[][] JAVASCRIPT_SUPPORTING_FILES = new String[][]{{"script.mustache", "script.js"}, {"README.mustache", "README.md"}};
    protected String projectName;
    protected String moduleName;
    protected String projectDescription;
    protected String projectVersion;
    protected String licenseName;
    protected String invokerPackage;
    protected String sourceFolder = "";
    private String modelPropertyNaming = "camelCase";
    protected boolean preserveLeadingParamChar = false;

    public K6ClientCodegen() {
        this.generatorMetadata = GeneratorMetadata.newBuilder((GeneratorMetadata)this.generatorMetadata).stability(Stability.BETA).build();
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "k6";
    }

    @Override
    public String getHelp() {
        return "Generates a k6 script (beta).";
    }

    @Override
    public void processOpts() {
        this.templateDir = "k6";
        this.embeddedTemplateDir = "k6";
        super.processOpts();
        if (this.additionalProperties.containsKey(PROJECT_NAME)) {
            this.setProjectName((String)this.additionalProperties.get(PROJECT_NAME));
        }
        if (this.additionalProperties.containsKey(MODULE_NAME)) {
            this.setModuleName((String)this.additionalProperties.get(MODULE_NAME));
        }
        if (this.additionalProperties.containsKey(PROJECT_DESCRIPTION)) {
            this.setProjectDescription((String)this.additionalProperties.get(PROJECT_DESCRIPTION));
        }
        if (this.additionalProperties.containsKey(PROJECT_VERSION)) {
            this.setProjectVersion((String)this.additionalProperties.get(PROJECT_VERSION));
        }
        if (this.additionalProperties.containsKey("licenseName")) {
            this.setLicenseName((String)this.additionalProperties.get("licenseName"));
        }
        if (this.additionalProperties.containsKey("sourceFolder")) {
            this.setSourceFolder((String)this.additionalProperties.get("sourceFolder"));
        }
        if (this.additionalProperties.containsKey("invokerPackage")) {
            this.setInvokerPackage((String)this.additionalProperties.get("invokerPackage"));
        }
        if (this.additionalProperties.containsKey("modelPropertyNaming")) {
            this.setModelPropertyNaming((String)this.additionalProperties.get("modelPropertyNaming"));
        }
        boolean preserveLeadingParamChar = this.convertPropertyToBooleanAndWriteBack(PRESERVE_LEADING_PARAM_CHAR);
        this.setPreserveLeadingParamChar(preserveLeadingParamChar);
    }

    @Override
    public void preprocessOpenAPI(OpenAPI openAPI) {
        super.preprocessOpenAPI(openAPI);
        if (openAPI.getInfo() != null) {
            Info info = openAPI.getInfo();
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)this.projectName) && info.getTitle() != null) {
                this.projectName = this.sanitizeName(StringUtils.dashize(info.getTitle()));
            }
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)this.projectVersion)) {
                this.projectVersion = this.escapeUnsafeCharacters(this.escapeQuotationMark(info.getVersion()));
            }
            if (this.projectDescription == null) {
                this.projectDescription = this.sanitizeName(info.getDescription());
            }
            if (this.additionalProperties.get("licenseName") == null && info.getLicense() != null) {
                License license = info.getLicense();
                this.licenseName = license.getName();
            }
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)this.projectName)) {
            this.projectName = "swagger-k6-client";
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)this.moduleName)) {
            this.moduleName = StringUtils.camelize(StringUtils.underscore(this.projectName));
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)this.projectVersion)) {
            this.projectVersion = "1.0.0";
        }
        if (this.projectDescription == null) {
            this.projectDescription = "Client library of " + this.projectName;
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)this.licenseName)) {
            this.licenseName = "Unlicense";
        }
        this.additionalProperties.put(PROJECT_NAME, this.projectName);
        this.additionalProperties.put(MODULE_NAME, this.moduleName);
        this.additionalProperties.put(PROJECT_DESCRIPTION, this.escapeText(this.projectDescription));
        this.additionalProperties.put(PROJECT_VERSION, this.projectVersion);
        this.additionalProperties.put("licenseName", this.licenseName);
        this.additionalProperties.put("apiPackage", this.apiPackage);
        this.additionalProperties.put("invokerPackage", this.invokerPackage);
        this.additionalProperties.put("modelPackage", this.modelPackage);
        this.additionalProperties.put("sourceFolder", this.sourceFolder);
        String baseURL = ((Server)openAPI.getServers().get(0)).getUrl();
        for (Server server : openAPI.getServers()) {
            if (!server.getUrl().contains("https://")) continue;
            baseURL = server.getUrl();
        }
        this.additionalProperties.put(BASE_URL, baseURL);
        ArrayList<HTTPRequestGroup> requestGroups = new ArrayList<HTTPRequestGroup>();
        HashSet<Parameter> extraParameters = new HashSet<Parameter>();
        HashMap pathVariables = new HashMap();
        for (String path : openAPI.getPaths().keySet()) {
            ArrayList<HTTPRequest> requests = new ArrayList<HTTPRequest>();
            HashSet<Parameter> variables = new HashSet<Parameter>();
            for (Map.Entry methodOperation : ((PathItem)openAPI.getPaths().get((Object)path)).readOperationsMap().entrySet()) {
                Object contentTypeValue2;
                ArrayList<Parameter> httpParams = new ArrayList<Parameter>();
                ArrayList<Parameter> queryParams = new ArrayList<Parameter>();
                ArrayList<Parameter> bodyOrFormParams = new ArrayList<Parameter>();
                ArrayList<k6Check> k6Checks = new ArrayList<k6Check>();
                HashSet<String> imports = new HashSet<String>();
                Operation operation = (Operation)methodOperation.getValue();
                PathItem.HttpMethod method = (PathItem.HttpMethod)methodOperation.getKey();
                for (Map.Entry resp : operation.getResponses().entrySet()) {
                    String statusData = ((String)resp.getKey()).equals("default") ? "200" : (String)resp.getKey();
                    int status = Integer.parseInt(statusData);
                    if (status < 200 || status >= 300) continue;
                    k6Checks.add(new k6Check(status, ((ApiResponse)resp.getValue()).getDescription()));
                }
                if (this.hasBodyParameter(openAPI, operation) || this.hasFormParameter(openAPI, operation)) {
                    String defaultContentType = this.hasFormParameter(openAPI, operation) ? "application/x-www-form-urlencoded" : "application/json";
                    ArrayList<String> consumes = new ArrayList<String>(K6ClientCodegen.getConsumesInfo(openAPI, operation));
                    Object object = contentTypeValue2 = consumes == null || consumes.isEmpty() ? defaultContentType : (String)consumes.get(0);
                    if (((String)contentTypeValue2).equals("*/*")) {
                        contentTypeValue2 = "application/json";
                    }
                    Parameter contentType = new Parameter("Content-Type", this.getDoubleQuotedString((String)contentTypeValue2));
                    httpParams.add(contentType);
                    RequestBody requestBody = ModelUtils.getReferencedRequestBody(openAPI, operation.getRequestBody());
                    for (Map.Entry responseEntry : operation.getResponses().entrySet()) {
                        CodegenResponse r = this.fromResponse((String)responseEntry.getKey(), (ApiResponse)responseEntry.getValue());
                        if (r.baseType == null || this.defaultIncludes.contains(r.baseType) || this.languageSpecificPrimitives.contains(r.baseType)) continue;
                        imports.add(r.baseType);
                    }
                    List<CodegenParameter> formParameters = this.fromRequestBodyToFormParameters(requestBody, imports);
                    for (CodegenParameter parameter : formParameters) {
                        String reference = "";
                        if (parameter.isModel) {
                            Schema nestedSchema = ModelUtils.getSchema(openAPI, parameter.baseType);
                            CodegenModel model = this.fromModel(parameter.paramName, nestedSchema);
                            reference = this.generateNestedModelTemplate(model);
                            if (parameter.dataType.equals("List")) {
                                reference = "[" + reference + "]";
                            }
                        }
                        Parameter k6Parameter = parameter.dataType.equals("File") ? new Parameter(parameter.paramName, "http.file(open(\"/path/to/file.bin\", \"b\"), \"test.bin\")") : new Parameter(parameter.paramName, !reference.isEmpty() ? reference : this.getDoubleQuotedString(parameter.dataType.toLowerCase(Locale.ROOT)));
                        bodyOrFormParams.add(k6Parameter);
                    }
                }
                String accepts = K6ClientCodegen.getAccept(openAPI, operation);
                String responseType = this.getDoubleQuotedString(accepts);
                try {
                    contentTypeValue2 = operation.getParameters().iterator();
                    while (contentTypeValue2.hasNext()) {
                        io.swagger.v3.oas.models.parameters.Parameter parameter = (io.swagger.v3.oas.models.parameters.Parameter)contentTypeValue2.next();
                        switch (parameter.getIn()) {
                            case "header": {
                                httpParams.add(new Parameter(parameter.getName(), this.getTemplateString(this.toVarName(parameter.getName()))));
                                extraParameters.add(new Parameter(this.toVarName(parameter.getName()), parameter.getName().toUpperCase(Locale.ROOT)));
                                break;
                            }
                            case "path": 
                            case "query": {
                                if (parameter.getIn().equals("query")) {
                                    queryParams.add(new Parameter(parameter.getName(), this.getTemplateVariable(parameter.getName())));
                                }
                                if (pathVariables.containsKey(path)) break;
                                if (Objects.nonNull(parameter.getExample())) {
                                    variables.add(new Parameter(this.toVarName(parameter.getName()), parameter.getExample(), true));
                                    break;
                                }
                                if (Objects.nonNull(parameter.getExamples())) {
                                    variables.add(new Parameter(this.toVarName(parameter.getName()), parameter.getExamples(), true));
                                    break;
                                }
                                variables.add(new Parameter(this.toVarName(parameter.getName()), parameter.getName().toUpperCase(Locale.ROOT)));
                                break;
                            }
                        }
                    }
                }
                catch (NullPointerException contentTypeValue2) {
                    // empty catch block
                }
                pathVariables.put(path, variables);
                HTTPParameters params = new HTTPParameters(null, null, httpParams, null, null, null, null, null, responseType.length() > 0 ? responseType : null);
                assert (params.headers != null);
                requests.add(new HTTPRequest(method.toString().toLowerCase(Locale.ROOT), path, queryParams.size() > 0 ? queryParams : null, bodyOrFormParams.size() > 0 ? new HTTPBody(bodyOrFormParams) : null, params.headers.size() > 0 ? params : null, k6Checks.size() > 0 ? k6Checks : null));
            }
            requestGroups.add(new HTTPRequestGroup(path, (Set)pathVariables.get(path), requests));
        }
        for (HTTPRequestGroup requestGroup : requestGroups) {
            for (HTTPRequest request : requestGroup.requests) {
                if (!request.path.contains("/{")) continue;
                request.path = request.path.replace("/{", "/${");
            }
        }
        this.additionalProperties.put("requestGroups", requestGroups);
        this.additionalProperties.put("extra", extraParameters);
        for (String[] supportingTemplateFile : JAVASCRIPT_SUPPORTING_FILES) {
            String templateFile = supportingTemplateFile[0];
            String folder = INVOKER_PKG_SUPPORTING_FILES.contains(templateFile) ? this.createPath(this.sourceFolder, this.invokerPackage) : "";
            this.supportingFiles.add(new SupportingFile(templateFile, folder, supportingTemplateFile[1]));
        }
    }

    private String generateNestedModelTemplate(CodegenModel model) {
        StringBuilder reference = new StringBuilder();
        int modelEntrySetSize = model.getAllVars().size();
        for (CodegenProperty property : model.getAllVars()) {
            reference.append(this.getDoubleQuotedString(property.name)).append(": ").append(this.getDoubleQuotedString(property.dataType.toLowerCase(Locale.ROOT)));
            if (modelEntrySetSize <= 1) continue;
            reference.append(", ");
        }
        reference = new StringBuilder("{" + reference + "}");
        reference = new StringBuilder(reference.toString().replace(", }", "}"));
        return reference.toString();
    }

    private String getTemplateVariable(String input) {
        return "${" + input + "}";
    }

    public String getModelPropertyNaming() {
        return this.modelPropertyNaming;
    }

    private String getNameUsingModelPropertyNaming(String name) {
        switch (CodegenConstants.MODEL_PROPERTY_NAMING_TYPE.valueOf(this.getModelPropertyNaming())) {
            case original: {
                return name;
            }
            case camelCase: {
                return StringUtils.camelize(name, true);
            }
            case PascalCase: {
                return StringUtils.camelize(name);
            }
            case snake_case: {
                return StringUtils.underscore(name);
            }
        }
        throw new IllegalArgumentException("Invalid model property naming '" + name + "'. Must be 'original', 'camelCase', 'PascalCase' or 'snake_case'");
    }

    @Override
    public String toVarName(String name) {
        if ("_".equals(name = this.sanitizeName(name))) {
            name = "_u";
        }
        if (name.matches("^[A-Z_]*$")) {
            return name;
        }
        if (this.isReservedWord(name = this.getNameUsingModelPropertyNaming(name)) || name.matches("^\\d.*")) {
            name = this.escapeReservedWord(name);
        }
        return name;
    }

    @Override
    public String escapeReservedWord(String name) {
        if (this.reservedWordsMappings().containsKey(name)) {
            return this.reservedWordsMappings().get(name);
        }
        return "_" + name;
    }

    private String getTemplateString(String input) {
        return "`" + this.getTemplateVariable(input) + "`";
    }

    private String getDoubleQuotedString(String input) {
        return "\"" + input + "\"";
    }

    private String createPath(String ... segments) {
        StringBuilder buf = new StringBuilder();
        for (String segment : segments) {
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)segment) || segment.equals(".")) continue;
            if (buf.length() != 0) {
                buf.append(File.separatorChar);
            }
            buf.append(segment);
        }
        for (int i = 0; i < buf.length(); ++i) {
            char c = buf.charAt(i);
            if (c != '/' && c != '\\' || c == File.separatorChar) continue;
            buf.setCharAt(i, File.separatorChar);
        }
        return buf.toString();
    }

    @Override
    public String apiFileFolder() {
        return this.createPath(this.outputFolder, this.sourceFolder, this.invokerPackage, this.apiPackage());
    }

    public String getInvokerPackage() {
        return this.invokerPackage;
    }

    public void setInvokerPackage(String invokerPackage) {
        this.invokerPackage = invokerPackage;
    }

    public void setSourceFolder(String sourceFolder) {
        this.sourceFolder = sourceFolder;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public void setProjectDescription(String projectDescription) {
        this.projectDescription = projectDescription;
    }

    public void setProjectVersion(String projectVersion) {
        this.projectVersion = projectVersion;
    }

    public void setLicenseName(String licenseName) {
        this.licenseName = licenseName;
    }

    public void setModelPropertyNaming(String naming) {
        if (!("original".equals(naming) || "camelCase".equals(naming) || "PascalCase".equals(naming) || "snake_case".equals(naming))) {
            throw new IllegalArgumentException("Invalid model property naming '" + naming + "'. Must be 'original', 'camelCase', 'PascalCase' or 'snake_case'");
        }
        this.modelPropertyNaming = naming;
    }

    public void setPreserveLeadingParamChar(boolean preserveLeadingParamChar) {
        this.preserveLeadingParamChar = preserveLeadingParamChar;
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("\"", "").replace("'", "");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("*/", "*_/").replace("/*", "/_*");
    }

    private static String getAccept(OpenAPI openAPI, Operation operation) {
        String accepts = null;
        String defaultContentType = "application/json";
        Set<String> producesInfo = K6ClientCodegen.getProducesInfo(openAPI, operation);
        if (producesInfo != null && !producesInfo.isEmpty()) {
            ArrayList<String> produces = new ArrayList<String>(producesInfo);
            StringBuilder sb = new StringBuilder();
            for (String produce : produces) {
                if (defaultContentType.equalsIgnoreCase(produce)) {
                    accepts = defaultContentType;
                    break;
                }
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(produce);
            }
            if (accepts == null) {
                accepts = sb.toString();
            }
        } else {
            accepts = defaultContentType;
        }
        return accepts;
    }

    @Override
    protected ImmutableMap.Builder<String, Mustache.Lambda> addMustacheLambdas() {
        return super.addMustacheLambdas().put((Object)"handleParamValue", (Object)new ParameterValueLambda());
    }

    public static class HTTPRequestGroup {
        String groupName;
        Set<Parameter> variables;
        List<HTTPRequest> requests;

        public HTTPRequestGroup(String groupName, Set<Parameter> variables, List<HTTPRequest> requests) {
            this.groupName = groupName;
            this.variables = variables;
            this.requests = requests;
        }
    }

    static class HTTPRequest {
        String method;
        String path;
        @Nullable
        List<Parameter> query;
        @Nullable
        HTTPBody body;
        @Nullable
        HTTPParameters params;
        @Nullable
        List<k6Check> k6Checks;

        public HTTPRequest(String method, String path, @Nullable List<Parameter> query, @Nullable HTTPBody body, @Nullable HTTPParameters params, @Nullable List<k6Check> k6Checks) {
            this.method = method.equals("delete") ? "del" : method;
            this.path = path;
            this.query = query;
            this.body = body;
            this.params = params;
            this.k6Checks = k6Checks;
        }
    }

    static class k6Check {
        Integer status;
        String description;

        public k6Check(Integer status, String description) {
            this.status = status;
            this.description = description;
        }
    }

    static class HTTPParameters {
        @Nullable
        String auth;
        @Nullable
        List<Parameter> cookies;
        @Nullable
        List<Parameter> headers;
        @Nullable
        List<Parameter> jar;
        @Nullable
        Integer redirects;
        @Nullable
        List<Parameter> tags;
        @Nullable
        Integer timeout;
        @Nullable
        String compression;
        @Nullable
        String responseType;

        public HTTPParameters(@Nullable String auth, @Nullable List<Parameter> cookies, @Nullable List<Parameter> headers, @Nullable List<Parameter> jar, @Nullable Integer redirects, @Nullable List<Parameter> tags, @Nullable Integer timeout, @Nullable String compression, @Nullable String responseType) {
            this.auth = auth;
            this.cookies = cookies;
            this.headers = headers;
            this.jar = jar;
            this.redirects = redirects;
            this.tags = tags;
            this.timeout = timeout;
            this.compression = compression;
            this.responseType = responseType;
        }
    }

    static class HTTPBody {
        List<Parameter> parameters;

        public HTTPBody(List<Parameter> parameters) {
            this.parameters = parameters;
        }
    }

    static class ParameterValueLambda
    implements Mustache.Lambda {
        private static final String NO_EXAMPLE_PARAM_VALUE_PREFIX = "TODO_EDIT_THE_";

        ParameterValueLambda() {
        }

        public void execute(Template.Fragment fragment, Writer writer) throws IOException {
            String noExampleParamValue = String.join((CharSequence)"", ParameterValueLambda.quoteExample(String.join((CharSequence)"", NO_EXAMPLE_PARAM_VALUE_PREFIX, fragment.execute())), ";", " // specify value as there is no example value for this parameter in OpenAPI spec");
            if (fragment.context() instanceof Parameter && ((Parameter)fragment.context()).hasExample) {
                Object rawValue = ((Parameter)fragment.context()).value;
                if (rawValue instanceof Map) {
                    Set exampleValues = ((Map)rawValue).values().stream().map(x -> ParameterValueLambda.quoteExample(StringEscapeUtils.escapeEcmaScript((String)String.valueOf(x.getValue())))).collect(Collectors.toCollection(() -> new TreeSet()));
                    if (!exampleValues.isEmpty()) {
                        writer.write(String.join((CharSequence)"", Arrays.toString(exampleValues.toArray()), ".shift();", " // first element from list extracted from 'examples' field defined at the parameter level of OpenAPI spec"));
                    } else {
                        writer.write(noExampleParamValue);
                    }
                } else {
                    writer.write(String.join((CharSequence)"", ParameterValueLambda.quoteExample(StringEscapeUtils.escapeEcmaScript((String)String.valueOf(((Parameter)fragment.context()).value))), ";", " // extracted from 'example' field defined at the parameter level of OpenAPI spec"));
                }
            } else {
                writer.write(noExampleParamValue);
            }
        }

        private static String quoteExample(String exampleValue) {
            return org.apache.commons.lang3.StringUtils.wrap((String)exampleValue, (String)"'");
        }
    }

    static class Parameter {
        String key;
        Object value;
        boolean hasExample;

        public Parameter(String key, Object value) {
            this.key = key;
            this.value = value;
        }

        public Parameter(String key, Object exampleValue, boolean hasExample) {
            this.key = key;
            this.value = exampleValue;
            this.hasExample = hasExample;
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Parameter p = (Parameter)obj;
            return this.key.equals(p.key) && this.value.equals(p.value) && this.hasExample == p.hasExample;
        }
    }
}

