/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import com.samskivert.mustache.Mustache;
import com.samskivert.mustache.Template;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.security.SecurityScheme;
import io.swagger.v3.oas.models.servers.Server;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenResponse;
import org.openapitools.codegen.CodegenSecurity;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractScalaCodegen;
import org.openapitools.codegen.meta.GeneratorMetadata;
import org.openapitools.codegen.meta.Stability;
import org.openapitools.codegen.meta.features.ClientModificationFeature;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.meta.features.GlobalFeature;
import org.openapitools.codegen.meta.features.ParameterFeature;
import org.openapitools.codegen.meta.features.SchemaSupportFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.meta.features.WireFormatFeature;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScalaSttpClientCodegen
extends AbstractScalaCodegen
implements CodegenConfig {
    private static final StringProperty STTP_CLIENT_VERSION = new StringProperty("sttpClientVersion", "The version of sttp client", "2.2.9");
    private static final BooleanProperty USE_SEPARATE_ERROR_CHANNEL = new BooleanProperty("separateErrorChannel", "Whether to return response as F[Either[ResponseError[ErrorType], ReturnType]]] or to flatten response's error raising them through enclosing monad (F[ReturnType]).", true);
    private static final StringProperty JODA_TIME_VERSION = new StringProperty("jodaTimeVersion", "The version of joda-time library", "2.10.10");
    private static final StringProperty JSON4S_VERSION = new StringProperty("json4sVersion", "The version of json4s library", "3.6.11");
    private static final StringProperty CIRCE_VERSION = new StringProperty("circeVersion", "The version of circe library", "0.13.0");
    private static final JsonLibraryProperty JSON_LIBRARY_PROPERTY = new JsonLibraryProperty();
    public static final String DEFAULT_PACKAGE_NAME = "org.openapitools.client";
    private static final PackageProperty PACKAGE_PROPERTY = new PackageProperty();
    private static final List<Property<?>> properties = Arrays.asList(STTP_CLIENT_VERSION, USE_SEPARATE_ERROR_CHANNEL, JODA_TIME_VERSION, JSON4S_VERSION, CIRCE_VERSION, JSON_LIBRARY_PROPERTY, PACKAGE_PROPERTY);
    private final Logger LOGGER = LoggerFactory.getLogger(ScalaSttpClientCodegen.class);
    protected String groupId = "org.openapitools";
    protected String artifactId = "openapi-client";
    protected String artifactVersion = "1.0.0";
    protected boolean registerNonStandardStatusCodes = true;
    protected boolean renderJavadoc = true;
    protected boolean removeOAuthSecurities = true;

    public ScalaSttpClientCodegen() {
        this.generatorMetadata = GeneratorMetadata.newBuilder((GeneratorMetadata)this.generatorMetadata).stability(Stability.BETA).build();
        this.modifyFeatureSet(features -> features.includeDocumentationFeatures(new DocumentationFeature[]{DocumentationFeature.Readme}).wireFormatFeatures(EnumSet.of(WireFormatFeature.JSON, WireFormatFeature.XML, WireFormatFeature.Custom)).securityFeatures(EnumSet.of(SecurityFeature.BasicAuth, SecurityFeature.ApiKey, SecurityFeature.BearerToken)).excludeGlobalFeatures(new GlobalFeature[]{GlobalFeature.XMLStructureDefinitions, GlobalFeature.Callbacks, GlobalFeature.LinkObjects, GlobalFeature.ParameterStyling}).excludeSchemaSupportFeatures(new SchemaSupportFeature[]{SchemaSupportFeature.Polymorphism}).excludeParameterFeatures(new ParameterFeature[]{ParameterFeature.Cookie}).includeClientModificationFeatures(new ClientModificationFeature[]{ClientModificationFeature.BasePath, ClientModificationFeature.UserAgent}));
        this.outputFolder = "generated-code/scala-sttp";
        this.modelTemplateFiles.put("model.mustache", ".scala");
        this.apiTemplateFiles.put("api.mustache", ".scala");
        this.templateDir = "scala-sttp";
        this.embeddedTemplateDir = "scala-sttp";
        this.additionalProperties.put("groupId", this.groupId);
        this.additionalProperties.put("artifactId", this.artifactId);
        this.additionalProperties.put("artifactVersion", this.artifactVersion);
        if (this.renderJavadoc) {
            this.additionalProperties.put("javadocRenderer", new JavadocLambda());
        }
        this.additionalProperties.put("fnCapitalize", new CapitalizeLambda());
        this.additionalProperties.put("fnCamelize", new CamelizeLambda(false));
        this.additionalProperties.put("fnEnumEntry", new EnumEntryLambda());
        this.importMapping.remove("Seq");
        this.importMapping.remove("List");
        this.importMapping.remove("Set");
        this.importMapping.remove("Map");
        this.typeMapping = new HashMap();
        this.typeMapping.put("array", "Seq");
        this.typeMapping.put("set", "Set");
        this.typeMapping.put("boolean", "Boolean");
        this.typeMapping.put("string", "String");
        this.typeMapping.put("int", "Int");
        this.typeMapping.put("integer", "Int");
        this.typeMapping.put("long", "Long");
        this.typeMapping.put("float", "Float");
        this.typeMapping.put("byte", "Byte");
        this.typeMapping.put("short", "Short");
        this.typeMapping.put("char", "Char");
        this.typeMapping.put("double", "Double");
        this.typeMapping.put("object", "Any");
        this.typeMapping.put("file", "File");
        this.typeMapping.put("binary", "File");
        this.typeMapping.put("number", "Double");
        this.typeMapping.put("decimal", "BigDecimal");
        this.instantiationTypes.put("array", "ListBuffer");
        this.instantiationTypes.put("map", "Map");
        properties.stream().map(Property::toCliOptions).flatMap(Collection::stream).forEach(option -> this.cliOptions.add(option));
    }

    @Override
    public void processOpts() {
        super.processOpts();
        properties.forEach(p -> p.updateAdditionalProperties(this.additionalProperties));
        this.invokerPackage = PACKAGE_PROPERTY.getInvokerPackage(this.additionalProperties);
        this.apiPackage = PACKAGE_PROPERTY.getApiPackage(this.additionalProperties);
        this.modelPackage = PACKAGE_PROPERTY.getModelPackage(this.additionalProperties);
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        this.supportingFiles.add(new SupportingFile("build.sbt.mustache", "", "build.sbt"));
        String invokerFolder = (this.sourceFolder + File.separator + this.invokerPackage).replace(".", File.separator);
        this.supportingFiles.add(new SupportingFile("jsonSupport.mustache", invokerFolder, "JsonSupport.scala"));
        this.supportingFiles.add(new SupportingFile("project/build.properties.mustache", "project", "build.properties"));
        this.supportingFiles.add(new SupportingFile("dateSerializers.mustache", invokerFolder, "DateSerializers.scala"));
    }

    @Override
    public String getName() {
        return "scala-sttp";
    }

    @Override
    public String getHelp() {
        return "Generates a Scala client library (beta) based on Sttp.";
    }

    @Override
    public String encodePath(String input) {
        String path = super.encodePath(input);
        StringBuffer buf = new StringBuffer(path.length());
        Matcher matcher = Pattern.compile("[{](.*?)[}]").matcher(path);
        while (matcher.find()) {
            matcher.appendReplacement(buf, "\\${" + this.toParamName(matcher.group(0)) + "}");
        }
        matcher.appendTail(buf);
        return buf.toString();
    }

    @Override
    public CodegenOperation fromOperation(String path, String httpMethod, Operation operation, List<Server> servers) {
        CodegenOperation op = super.fromOperation(path, httpMethod, operation, servers);
        op.path = this.encodePath(path);
        return op;
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String escapeReservedWord(String name) {
        if (this.reservedWordsMappings().containsKey(name)) {
            return this.reservedWordsMappings().get(name);
        }
        return "`" + name + "`";
    }

    @Override
    public Map<String, Object> postProcessOperationsWithModels(Map<String, Object> objs, List<Object> allModels) {
        if (this.registerNonStandardStatusCodes) {
            try {
                Map opsMap = (Map)objs.get("operations");
                HashSet<Integer> unknownCodes = new HashSet<Integer>();
                for (CodegenOperation operation : (ArrayList)opsMap.get("operation")) {
                    for (CodegenResponse response : operation.responses) {
                        if ("default".equals(response.code)) continue;
                        try {
                            int code = Integer.parseInt(response.code);
                            if (code < 600) continue;
                            unknownCodes.add(code);
                        }
                        catch (NumberFormatException e) {
                            this.LOGGER.error("Status code is not an integer : response.code", (Throwable)e);
                        }
                    }
                }
                if (!unknownCodes.isEmpty()) {
                    this.additionalProperties.put("unknownStatusCodes", unknownCodes);
                }
            }
            catch (Exception e) {
                this.LOGGER.error("Unable to find operations List", (Throwable)e);
            }
        }
        return super.postProcessOperationsWithModels(objs, allModels);
    }

    @Override
    public List<CodegenSecurity> fromSecurity(Map<String, SecurityScheme> schemes) {
        List<CodegenSecurity> codegenSecurities = super.fromSecurity(schemes);
        if (!this.removeOAuthSecurities) {
            return codegenSecurities;
        }
        Iterator<CodegenSecurity> it = codegenSecurities.iterator();
        while (it.hasNext()) {
            CodegenSecurity security = it.next();
            if (!security.isOAuth.booleanValue()) continue;
            it.remove();
        }
        if (codegenSecurities.isEmpty()) {
            return null;
        }
        return codegenSecurities;
    }

    @Override
    public String toParamName(String name) {
        return this.formatIdentifier(name, false);
    }

    @Override
    public String toEnumName(CodegenProperty property) {
        return this.formatIdentifier(property.baseName, true);
    }

    @Override
    public String toDefaultValue(Schema p) {
        if (p.getRequired() != null && p.getRequired().contains(p.getName())) {
            return "None";
        }
        if (ModelUtils.isBooleanSchema(p)) {
            return null;
        }
        if (ModelUtils.isDateSchema(p)) {
            return null;
        }
        if (ModelUtils.isDateTimeSchema(p)) {
            return null;
        }
        if (ModelUtils.isNumberSchema(p)) {
            return null;
        }
        if (ModelUtils.isIntegerSchema(p)) {
            return null;
        }
        if (ModelUtils.isMapSchema(p)) {
            String inner = this.getSchemaType(this.getAdditionalProperties(p));
            return "Map[String, " + inner + "].empty ";
        }
        if (ModelUtils.isArraySchema(p)) {
            ArraySchema ap = (ArraySchema)p;
            String inner = this.getSchemaType(ap.getItems());
            if (ModelUtils.isSet((Schema)ap)) {
                return "Set[" + inner + "].empty ";
            }
            return "Seq[" + inner + "].empty ";
        }
        if (ModelUtils.isStringSchema(p)) {
            return null;
        }
        return null;
    }

    private class EnumEntryLambda
    extends CustomLambda {
        private EnumEntryLambda() {
        }

        @Override
        public String formatFragment(String fragment) {
            return ScalaSttpClientCodegen.this.formatIdentifier(fragment, true);
        }
    }

    private static class CamelizeLambda
    extends CustomLambda {
        private final boolean capitalizeFirst;

        public CamelizeLambda(boolean capitalizeFirst) {
            this.capitalizeFirst = capitalizeFirst;
        }

        @Override
        public String formatFragment(String fragment) {
            return StringUtils.camelize(fragment, !this.capitalizeFirst);
        }
    }

    private static class CapitalizeLambda
    extends CustomLambda {
        private CapitalizeLambda() {
        }

        @Override
        public String formatFragment(String fragment) {
            return org.apache.commons.lang3.StringUtils.capitalize((String)fragment);
        }
    }

    private static class JavadocLambda
    extends CustomLambda {
        private JavadocLambda() {
        }

        @Override
        public String formatFragment(String fragment) {
            String[] lines = fragment.split("\\r?\\n");
            StringBuilder sb = new StringBuilder();
            sb.append("  /**\n");
            for (String line : lines) {
                sb.append("   * ").append(line).append("\n");
            }
            sb.append("   */\n");
            return sb.toString();
        }
    }

    private static abstract class CustomLambda
    implements Mustache.Lambda {
        private CustomLambda() {
        }

        public void execute(Template.Fragment frag, Writer out) throws IOException {
            StringWriter tempWriter = new StringWriter();
            frag.execute((Writer)tempWriter);
            out.write(this.formatFragment(tempWriter.toString()));
        }

        public abstract String formatFragment(String var1);
    }

    public static class PackageProperty
    extends StringProperty {
        public PackageProperty() {
            super("mainPackage", "Top-level package name, which defines 'apiPackage', 'modelPackage', 'invokerPackage'", ScalaSttpClientCodegen.DEFAULT_PACKAGE_NAME);
        }

        @Override
        public void updateAdditionalProperties(Map<String, Object> additionalProperties) {
            Object mainPackage = this.getValue((Map)additionalProperties);
            if (!additionalProperties.containsKey("apiPackage")) {
                String apiPackage = (String)mainPackage + ".api";
                additionalProperties.put("apiPackage", apiPackage);
            }
            if (!additionalProperties.containsKey("modelPackage")) {
                String modelPackage = (String)mainPackage + ".model";
                additionalProperties.put("modelPackage", modelPackage);
            }
            if (!additionalProperties.containsKey("invokerPackage")) {
                String invokerPackage = (String)mainPackage + ".core";
                additionalProperties.put("invokerPackage", invokerPackage);
            }
        }

        public String getApiPackage(Map<String, Object> additionalProperties) {
            return additionalProperties.getOrDefault("apiPackage", "org.openapitools.client.api").toString();
        }

        public String getModelPackage(Map<String, Object> additionalProperties) {
            return additionalProperties.getOrDefault("modelPackage", "org.openapitools.client.model").toString();
        }

        public String getInvokerPackage(Map<String, Object> additionalProperties) {
            return additionalProperties.getOrDefault("invokerPackage", "org.openapitools.client.core").toString();
        }
    }

    public static class JsonLibraryProperty
    extends StringProperty {
        private static final String JSON4S = "json4s";
        private static final String CIRCE = "circe";

        public JsonLibraryProperty() {
            super("jsonLibrary", "Json library to use. Possible values are: json4s and circe.", JSON4S);
        }

        @Override
        public void updateAdditionalProperties(Map<String, Object> additionalProperties) {
            Object value = this.getValue((Map)additionalProperties);
            if (!CIRCE.equals(value) && !JSON4S.equals(value)) {
                IllegalArgumentException exception = new IllegalArgumentException("Invalid json library: " + (String)value + ". Must be " + CIRCE + " or " + JSON4S);
                throw exception;
            }
            additionalProperties.put(CIRCE, CIRCE.equals(value));
            additionalProperties.put(JSON4S, JSON4S.equals(value));
        }
    }

    public static class BooleanProperty
    extends Property<Boolean> {
        public BooleanProperty(String name, String description, Boolean defaultValue) {
            super(name, description, defaultValue);
        }

        @Override
        public List<CliOption> toCliOptions() {
            return Collections.singletonList(CliOption.newBoolean(this.name, this.description, (Boolean)this.defaultValue));
        }

        @Override
        public void updateAdditionalProperties(Map<String, Object> additionalProperties) {
            Object value = this.getValue((Map)additionalProperties);
            additionalProperties.put(this.name, value);
        }

        @Override
        public Boolean getValue(Map<String, Object> additionalProperties) {
            return Boolean.valueOf(additionalProperties.getOrDefault(this.name, ((Boolean)this.defaultValue).toString()).toString());
        }
    }

    public static class StringProperty
    extends Property<String> {
        public StringProperty(String name, String description, String defaultValue) {
            super(name, description, defaultValue);
        }

        @Override
        public List<CliOption> toCliOptions() {
            return Collections.singletonList(CliOption.newString(this.name, this.description).defaultValue((String)this.defaultValue));
        }

        @Override
        public void updateAdditionalProperties(Map<String, Object> additionalProperties) {
            if (!additionalProperties.containsKey(this.name)) {
                additionalProperties.put(this.name, this.defaultValue);
            }
        }

        @Override
        public String getValue(Map<String, Object> additionalProperties) {
            return additionalProperties.getOrDefault(this.name, this.defaultValue).toString();
        }
    }

    public static abstract class Property<T> {
        final String name;
        final String description;
        final T defaultValue;

        public Property(String name, String description, T defaultValue) {
            this.name = name;
            this.description = description;
            this.defaultValue = defaultValue;
        }

        public abstract List<CliOption> toCliOptions();

        public abstract void updateAdditionalProperties(Map<String, Object> var1);

        public abstract T getValue(Map<String, Object> var1);

        public void setValue(Map<String, Object> additionalProperties, T value) {
            additionalProperties.put(this.name, value);
        }
    }
}

