/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import org.openapitools.codegen.DryRunStatus;
import org.openapitools.codegen.api.TemplateProcessor;
import org.openapitools.codegen.templating.TemplateManagerOptions;

public class DryRunTemplateManager
implements TemplateProcessor {
    private final TemplateManagerOptions options;
    private final Map<String, DryRunStatus> dryRunStatusMap = new HashMap<String, DryRunStatus>();

    public DryRunTemplateManager(TemplateManagerOptions options) {
        this.options = options;
    }

    public Map<String, DryRunStatus> getDryRunStatusMap() {
        return ImmutableMap.copyOf(this.dryRunStatusMap);
    }

    public File write(Map<String, Object> data, String template, File target) throws IOException {
        if (this.options.isSkipOverwrite() && target.exists()) {
            this.dryRunStatusMap.put(target.toString(), new DryRunStatus(target.toPath(), DryRunStatus.State.SkippedOverwrite, "File exists and skip overwrite option is enabled."));
        }
        return target;
    }

    public File writeToFile(String filename, byte[] contents) throws IOException {
        Path path = Paths.get(filename, new String[0]);
        DryRunStatus status = new DryRunStatus(path);
        if (this.options.isMinimalUpdate()) {
            status.setState(DryRunStatus.State.WriteIfNewer);
        } else {
            status.setState(DryRunStatus.State.Write);
        }
        this.dryRunStatusMap.put(filename, status);
        return path.toFile();
    }

    public void ignore(Path path, String context) {
        this.dryRunStatusMap.put(path.toString(), new DryRunStatus(path, DryRunStatus.State.Ignored, context));
    }

    public void skip(Path path, String context) {
        if (this.options.isSkipOverwrite() && path.toFile().exists()) {
            this.dryRunStatusMap.put(path.toString(), new DryRunStatus(path, DryRunStatus.State.SkippedOverwrite, context));
            return;
        }
        this.dryRunStatusMap.put(path.toString(), new DryRunStatus(path, DryRunStatus.State.Skipped, context));
    }

    public void error(Path path, String context) {
        this.dryRunStatusMap.put(path.toString(), new DryRunStatus(path, DryRunStatus.State.Error));
    }
}

