/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FilenameUtils;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenConstants;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.DefaultCodegen;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractKotlinCodegen
extends DefaultCodegen
implements CodegenConfig {
    public static final String SERIALIZATION_LIBRARY_DESC = "What serialization library to use: 'moshi' (default), or 'gson' or 'jackson'";
    public static final String MODEL_MUTABLE = "modelMutable";
    public static final String MODEL_MUTABLE_DESC = "Create mutable models";
    private final Logger LOGGER = LoggerFactory.getLogger(AbstractKotlinCodegen.class);
    protected String artifactId;
    protected String artifactVersion = "1.0.0";
    protected String groupId = "org.openapitools";
    protected String packageName = "org.openapitools";
    protected String apiSuffix = "Api";
    protected String sourceFolder = "src/main/kotlin";
    protected String testFolder = "src/test/kotlin";
    protected String apiDocPath = "docs/";
    protected String modelDocPath = "docs/";
    protected boolean parcelizeModels = false;
    protected boolean serializableModel = false;
    protected boolean needsDataClassBody = false;
    protected boolean nonPublicApi = false;
    protected CodegenConstants.ENUM_PROPERTY_NAMING_TYPE enumPropertyNaming = CodegenConstants.ENUM_PROPERTY_NAMING_TYPE.camelCase;
    protected SERIALIZATION_LIBRARY_TYPE serializationLibrary = SERIALIZATION_LIBRARY_TYPE.moshi;

    public AbstractKotlinCodegen() {
        this.supportsInheritance = true;
        this.setSortModelPropertiesByRequiredFlag(true);
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("kotlin.Byte", "kotlin.ByteArray", "kotlin.Short", "kotlin.Int", "kotlin.Long", "kotlin.Float", "kotlin.Double", "kotlin.Boolean", "kotlin.Char", "kotlin.String", "kotlin.Array", "kotlin.collections.List", "kotlin.collections.Map", "kotlin.collections.Set"));
        this.reservedWords = new HashSet<String>(Arrays.asList("as", "break", "class", "continue", "do", "else", "false", "for", "fun", "if", "in", "interface", "is", "null", "object", "package", "return", "super", "this", "throw", "true", "try", "typealias", "typeof", "val", "var", "when", "while"));
        this.defaultIncludes = new HashSet<String>(Arrays.asList("kotlin.Byte", "kotlin.ByteArray", "kotlin.Short", "kotlin.Int", "kotlin.Long", "kotlin.Float", "kotlin.Double", "kotlin.Boolean", "kotlin.Char", "kotlin.Array", "kotlin.collections.List", "kotlin.collections.Set", "kotlin.collections.Map"));
        this.typeMapping = new HashMap();
        this.typeMapping.put("string", "kotlin.String");
        this.typeMapping.put("boolean", "kotlin.Boolean");
        this.typeMapping.put("integer", "kotlin.Int");
        this.typeMapping.put("float", "kotlin.Float");
        this.typeMapping.put("long", "kotlin.Long");
        this.typeMapping.put("double", "kotlin.Double");
        this.typeMapping.put("ByteArray", "kotlin.ByteArray");
        this.typeMapping.put("number", "java.math.BigDecimal");
        this.typeMapping.put("decimal", "java.math.BigDecimal");
        this.typeMapping.put("date-time", "java.time.OffsetDateTime");
        this.typeMapping.put("date", "java.time.LocalDate");
        this.typeMapping.put("file", "java.io.File");
        this.typeMapping.put("array", "kotlin.Array");
        this.typeMapping.put("list", "kotlin.collections.List");
        this.typeMapping.put("set", "kotlin.collections.Set");
        this.typeMapping.put("map", "kotlin.collections.Map");
        this.typeMapping.put("object", "kotlin.Any");
        this.typeMapping.put("binary", "kotlin.ByteArray");
        this.typeMapping.put("Date", "java.time.LocalDate");
        this.typeMapping.put("DateTime", "java.time.OffsetDateTime");
        this.instantiationTypes.put("array", "kotlin.collections.ArrayList");
        this.instantiationTypes.put("list", "kotlin.collections.ArrayList");
        this.instantiationTypes.put("map", "kotlin.collections.HashMap");
        this.importMapping = new HashMap();
        this.importMapping.put("BigDecimal", "java.math.BigDecimal");
        this.importMapping.put("UUID", "java.util.UUID");
        this.importMapping.put("URI", "java.net.URI");
        this.importMapping.put("File", "java.io.File");
        this.importMapping.put("Date", "java.time.LocalDate");
        this.importMapping.put("Timestamp", "java.sql.Timestamp");
        this.importMapping.put("DateTime", "java.time.OffsetDateTime");
        this.importMapping.put("LocalDateTime", "java.time.LocalDateTime");
        this.importMapping.put("LocalDate", "java.time.LocalDate");
        this.importMapping.put("LocalTime", "java.time.LocalTime");
        this.specialCharReplacements.put(";", "Semicolon");
        this.cliOptions.clear();
        this.addOption("sourceFolder", "source folder for generated code", this.sourceFolder);
        this.addOption("packageName", "Generated artifact package name.", this.packageName);
        this.addOption("apiSuffix", "suffix for api classes", this.apiSuffix);
        this.addOption("groupId", "Generated artifact package's organization (i.e. maven groupId).", this.groupId);
        this.addOption("artifactId", "Generated artifact id (name of jar).", this.artifactId);
        this.addOption("artifactVersion", "Generated artifact's package version.", this.artifactVersion);
        CliOption enumPropertyNamingOpt = new CliOption("enumPropertyNaming", "Naming convention for enum properties: 'camelCase', 'PascalCase', 'snake_case', 'UPPERCASE', and 'original'");
        this.cliOptions.add(enumPropertyNamingOpt.defaultValue(this.enumPropertyNaming.name()));
        CliOption serializationLibraryOpt = new CliOption("serializationLibrary", SERIALIZATION_LIBRARY_DESC);
        this.cliOptions.add(serializationLibraryOpt.defaultValue(this.serializationLibrary.name()));
        this.cliOptions.add(new CliOption("parcelizeModels", "toggle \"@Parcelize\" for generated models"));
        this.cliOptions.add(new CliOption("serializableModel", "boolean - toggle \"implements Serializable\" for generated models"));
        this.cliOptions.add(new CliOption("sortParamsByRequiredFlag", "Sort method arguments to place required parameters before optional parameters."));
        this.cliOptions.add(new CliOption("sortModelPropertiesByRequiredFlag", "Sort model properties to place required parameters before optional parameters."));
        this.cliOptions.add(CliOption.newBoolean(MODEL_MUTABLE, MODEL_MUTABLE_DESC, false));
    }

    @Override
    public String apiDocFileFolder() {
        return (this.outputFolder + File.separator + this.apiDocPath).replace('/', File.separatorChar);
    }

    @Override
    public String apiFileFolder() {
        return (this.outputFolder + File.separator + this.sourceFolder + File.separator + this.apiPackage().replace('.', File.separatorChar)).replace('/', File.separatorChar);
    }

    @Override
    public String apiTestFileFolder() {
        return (this.outputFolder + File.separator + this.testFolder + File.separator + this.apiPackage().replace('.', File.separatorChar)).replace('/', File.separatorChar);
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("\"", "");
    }

    @Override
    public String escapeReservedWord(String name) {
        return String.format(Locale.ROOT, "`%s`", name);
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("*/", "*_/").replace("/*", "/_*");
    }

    public CodegenConstants.ENUM_PROPERTY_NAMING_TYPE getEnumPropertyNaming() {
        return this.enumPropertyNaming;
    }

    public SERIALIZATION_LIBRARY_TYPE getSerializationLibrary() {
        return this.serializationLibrary;
    }

    public void setEnumPropertyNaming(String enumPropertyNamingType) {
        try {
            this.enumPropertyNaming = CodegenConstants.ENUM_PROPERTY_NAMING_TYPE.valueOf(enumPropertyNamingType);
        }
        catch (IllegalArgumentException ex) {
            StringBuilder sb = new StringBuilder(enumPropertyNamingType + " is an invalid enum property naming option. Please choose from:");
            for (CodegenConstants.ENUM_PROPERTY_NAMING_TYPE t : CodegenConstants.ENUM_PROPERTY_NAMING_TYPE.values()) {
                sb.append("\n  ").append(t.name());
            }
            throw new RuntimeException(sb.toString());
        }
    }

    public void setSerializationLibrary(String enumSerializationLibrary) {
        try {
            this.serializationLibrary = SERIALIZATION_LIBRARY_TYPE.valueOf(enumSerializationLibrary);
        }
        catch (IllegalArgumentException ex) {
            StringBuilder sb = new StringBuilder(enumSerializationLibrary + " is an invalid enum property naming option. Please choose from:");
            for (SERIALIZATION_LIBRARY_TYPE t : SERIALIZATION_LIBRARY_TYPE.values()) {
                sb.append("\n  ").append(t.name());
            }
            throw new RuntimeException(sb.toString());
        }
    }

    @Override
    public String getSchemaType(Schema p) {
        String type;
        String openAPIType = super.getSchemaType(p);
        if (this.typeMapping.containsKey(openAPIType)) {
            type = (String)this.typeMapping.get(openAPIType);
            if (this.languageSpecificPrimitives.contains(type)) {
                return this.toModelName(type);
            }
        } else {
            type = openAPIType;
        }
        return this.toModelName(type);
    }

    @Override
    public String getTypeDeclaration(Schema p) {
        Schema target;
        Schema schema = ModelUtils.unaliasSchema(this.openAPI, p, this.importMapping);
        Schema schema2 = target = ModelUtils.isGenerateAliasAsModel() ? p : schema;
        if (ModelUtils.isArraySchema(target)) {
            Schema<?> items = this.getSchemaItems((ArraySchema)schema);
            return this.getSchemaType(target) + "<" + this.getTypeDeclaration(items) + ">";
        }
        if (ModelUtils.isMapSchema(target)) {
            Schema inner = this.getAdditionalProperties(target);
            if (inner == null) {
                this.LOGGER.error("`{}` (map property) does not have a proper inner type defined. Default to type:string", (Object)p.getName());
                inner = new StringSchema().description("TODO default missing map inner type to string");
                p.setAdditionalProperties((Object)inner);
            }
            return this.getSchemaType(target) + "<kotlin.String, " + this.getTypeDeclaration(inner) + ">";
        }
        return super.getTypeDeclaration(target);
    }

    @Override
    public String modelDocFileFolder() {
        return (this.outputFolder + "/" + this.modelDocPath).replace('/', File.separatorChar);
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + File.separator + this.sourceFolder + File.separator + this.modelPackage().replace('.', File.separatorChar);
    }

    @Override
    public Map<String, Object> postProcessModels(Map<String, Object> objs) {
        objs = super.postProcessModelsEnum(objs);
        List models = (List)objs.get("models");
        block0: for (Object _mo : models) {
            Map mo = (Map)_mo;
            CodegenModel cm = (CodegenModel)mo.get("model");
            if (cm.getDiscriminator() != null) {
                cm.vendorExtensions.put("x-has-data-class-body", true);
                break;
            }
            for (CodegenProperty var : cm.vars) {
                if (!var.isEnum && !this.isSerializableModel()) continue;
                cm.vendorExtensions.put("x-has-data-class-body", true);
                continue block0;
            }
        }
        return this.postProcessModelsEnum(objs);
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)System.getenv("KOTLIN_POST_PROCESS_FILE"))) {
            this.LOGGER.info("Environment variable KOTLIN_POST_PROCESS_FILE not defined so the Kotlin code may not be properly formatted. To define it, try 'export KOTLIN_POST_PROCESS_FILE=\"/usr/local/bin/ktlint -F\"' (Linux/Mac)");
            this.LOGGER.info("NOTE: To enable file post-processing, 'enablePostProcessFile' must be set to `true` (--enable-post-process-file for CLI).");
        }
        if (this.additionalProperties.containsKey("enumPropertyNaming")) {
            this.setEnumPropertyNaming((String)this.additionalProperties.get("enumPropertyNaming"));
        }
        if (this.additionalProperties.containsKey("serializationLibrary")) {
            this.setSerializationLibrary((String)this.additionalProperties.get("serializationLibrary"));
            this.additionalProperties.put(this.serializationLibrary.name(), true);
        } else {
            this.additionalProperties.put(this.serializationLibrary.name(), true);
        }
        if (this.additionalProperties.containsKey("sourceFolder")) {
            this.setSourceFolder((String)this.additionalProperties.get("sourceFolder"));
        } else {
            this.additionalProperties.put("sourceFolder", this.sourceFolder);
        }
        if (this.additionalProperties.containsKey("packageName")) {
            this.setPackageName((String)this.additionalProperties.get("packageName"));
            if (!this.additionalProperties.containsKey("modelPackage")) {
                this.setModelPackage(this.packageName + ".models");
            }
            if (!this.additionalProperties.containsKey("apiPackage")) {
                this.setApiPackage(this.packageName + ".apis");
            }
        } else {
            this.additionalProperties.put("packageName", this.packageName);
        }
        if (this.additionalProperties.containsKey("apiSuffix")) {
            this.setApiSuffix((String)this.additionalProperties.get("apiSuffix"));
        }
        if (this.additionalProperties.containsKey("artifactId")) {
            this.setArtifactId((String)this.additionalProperties.get("artifactId"));
        } else {
            this.additionalProperties.put("artifactId", this.artifactId);
        }
        if (this.additionalProperties.containsKey("groupId")) {
            this.setGroupId((String)this.additionalProperties.get("groupId"));
        } else {
            this.additionalProperties.put("groupId", this.groupId);
        }
        if (this.additionalProperties.containsKey("artifactVersion")) {
            this.setArtifactVersion((String)this.additionalProperties.get("artifactVersion"));
        } else {
            this.additionalProperties.put("artifactVersion", this.artifactVersion);
        }
        if (this.additionalProperties.containsKey("invokerPackage")) {
            this.LOGGER.warn("invokerPackage with " + this.getName() + " generator is ignored. Use " + "packageName" + ".");
        }
        if (this.additionalProperties.containsKey("serializableModel")) {
            this.setSerializableModel(this.convertPropertyToBooleanAndWriteBack("serializableModel"));
        } else {
            this.additionalProperties.put("serializableModel", this.serializableModel);
        }
        if (this.additionalProperties.containsKey("parcelizeModels")) {
            this.setParcelizeModels(this.convertPropertyToBooleanAndWriteBack("parcelizeModels"));
        } else {
            this.additionalProperties.put("parcelizeModels", this.parcelizeModels);
        }
        if (this.additionalProperties.containsKey("nonPublicApi")) {
            this.setNonPublicApi(this.convertPropertyToBooleanAndWriteBack("nonPublicApi"));
        } else {
            this.additionalProperties.put("nonPublicApi", this.nonPublicApi);
        }
        this.additionalProperties.put("sortParamsByRequiredFlag", this.getSortParamsByRequiredFlag());
        this.additionalProperties.put("sortModelPropertiesByRequiredFlag", this.getSortModelPropertiesByRequiredFlag());
        this.additionalProperties.put("apiPackage", this.apiPackage());
        this.additionalProperties.put("modelPackage", this.modelPackage());
        this.additionalProperties.put("apiDocPath", this.apiDocPath);
        this.additionalProperties.put("modelDocPath", this.modelDocPath);
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public void setArtifactVersion(String artifactVersion) {
        this.artifactVersion = artifactVersion;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void setApiSuffix(String apiSuffix) {
        this.apiSuffix = apiSuffix;
    }

    public void setSourceFolder(String sourceFolder) {
        this.sourceFolder = sourceFolder;
    }

    public void setTestFolder(String testFolder) {
        this.testFolder = testFolder;
    }

    public Boolean getParcelizeModels() {
        return this.parcelizeModels;
    }

    public void setParcelizeModels(Boolean parcelizeModels) {
        this.parcelizeModels = parcelizeModels;
    }

    public boolean isSerializableModel() {
        return this.serializableModel;
    }

    public void setSerializableModel(boolean serializableModel) {
        this.serializableModel = serializableModel;
    }

    public boolean nonPublicApi() {
        return this.nonPublicApi;
    }

    public void setNonPublicApi(boolean nonPublicApi) {
        this.nonPublicApi = nonPublicApi;
    }

    public boolean isNeedsDataClassBody() {
        return this.needsDataClassBody;
    }

    public void setNeedsDataClassBody(boolean needsDataClassBody) {
        this.needsDataClassBody = needsDataClassBody;
    }

    @Override
    public String toEnumVarName(String value, String datatype) {
        String modified;
        if (value.length() == 0) {
            modified = "EMPTY";
        } else {
            modified = value;
            modified = this.sanitizeKotlinSpecificNames(modified);
        }
        switch (this.getEnumPropertyNaming()) {
            case original: {
                modified = value;
                break;
            }
            case camelCase: {
                modified = StringUtils.camelize(modified, true);
                break;
            }
            case PascalCase: {
                String result = StringUtils.camelize(modified);
                modified = this.titleCase(result);
                break;
            }
            case snake_case: {
                modified = StringUtils.underscore(modified);
                break;
            }
            case UPPERCASE: {
                modified = StringUtils.underscore(modified).toUpperCase(Locale.ROOT);
            }
        }
        if (this.reservedWords.contains(modified)) {
            return this.escapeReservedWord(modified);
        }
        return this.sanitizeKotlinSpecificNames(modified);
    }

    @Override
    public String toApiName(String name) {
        if (name.length() == 0) {
            return "DefaultApi";
        }
        return this.apiSuffix.isEmpty() ? StringUtils.camelize(name) : StringUtils.camelize(name) + this.apiSuffix;
    }

    @Override
    public String toModelImport(String name) {
        if (this.needToImport(name)) {
            return super.toModelImport(name);
        }
        return name;
    }

    @Override
    public String toModelName(String name) {
        String sanitizedName;
        if (name.startsWith("kotlin.") || name.startsWith("java.")) {
            return name;
        }
        if (this.importMapping.containsKey(name)) {
            return (String)this.importMapping.get(name);
        }
        String modifiedName = name.replaceAll("\\.", "");
        String nameWithPrefixSuffix = sanitizedName = this.sanitizeKotlinSpecificNames(modifiedName);
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.modelNamePrefix)) {
            nameWithPrefixSuffix = this.modelNamePrefix + "_" + nameWithPrefixSuffix;
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.modelNameSuffix)) {
            nameWithPrefixSuffix = nameWithPrefixSuffix + "_" + this.modelNameSuffix;
        }
        if (this.isReservedWord(modifiedName = StringUtils.camelize(nameWithPrefixSuffix))) {
            String modelName = "Model" + modifiedName;
            this.LOGGER.warn(modifiedName + " (reserved word) cannot be used as model name. Renamed to " + modelName);
            return modelName;
        }
        if (modifiedName.matches("^\\d.*")) {
            String modelName = "Model" + modifiedName;
            this.LOGGER.warn(name + " (model name starts with number) cannot be used as model name. Renamed to " + modelName);
            return modelName;
        }
        return this.titleCase(modifiedName);
    }

    @Override
    public String toOperationId(String operationId) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)operationId)) {
            throw new RuntimeException("Empty method/operation name (operationId) not allowed");
        }
        if (this.isReservedWord(operationId = StringUtils.camelize(this.sanitizeName(operationId), true))) {
            String newOperationId = StringUtils.camelize("call_" + operationId, true);
            this.LOGGER.warn(operationId + " (reserved word) cannot be used as method name. Renamed to " + newOperationId);
            return newOperationId;
        }
        if (operationId.matches("^\\d.*")) {
            this.LOGGER.warn(operationId + " (starting with a number) cannot be used as method sname. Renamed to " + StringUtils.camelize("call_" + operationId), (Object)true);
            operationId = StringUtils.camelize("call_" + operationId, true);
        }
        return operationId;
    }

    @Override
    public String toModelFilename(String name) {
        return this.toModelName(name);
    }

    private String sanitizeKotlinSpecificNames(String name) {
        String word = name;
        for (Map.Entry<String, String> entry : this.specialCharReplacements.entrySet()) {
            word = this.replaceSpecialCharacters(word, entry);
        }
        if ((word = word.replaceAll("\\W+", "_")).matches("\\d.*")) {
            word = "_" + word;
        }
        if (word.matches("^_*$")) {
            word = word.replaceAll("\\Q_\\E", "Underscore");
        }
        return word;
    }

    private String replaceSpecialCharacters(String word, Map.Entry<String, String> specialCharacters) {
        String specialChar = specialCharacters.getKey();
        String replacementChar = specialCharacters.getValue();
        if (!specialChar.equals("_") && word.contains(specialChar)) {
            return this.replaceCharacters(word, specialChar, replacementChar);
        }
        return word;
    }

    private String replaceCharacters(String word, String oldValue, String newValue) {
        if (!word.contains(oldValue)) {
            return word;
        }
        if (word.equals(oldValue)) {
            return newValue;
        }
        int i = word.indexOf(oldValue);
        String start = word.substring(0, i);
        String end = this.recurseOnEndOfWord(word, oldValue, newValue, i);
        return start + newValue + end;
    }

    private String recurseOnEndOfWord(String word, String oldValue, String newValue, int lastReplacedValue) {
        String end = word.substring(lastReplacedValue + 1);
        if (!end.isEmpty()) {
            end = this.titleCase(end);
            end = this.replaceCharacters(end, oldValue, newValue);
        }
        return end;
    }

    private String titleCase(String input) {
        return input.substring(0, 1).toUpperCase(Locale.ROOT) + input.substring(1);
    }

    @Override
    protected boolean isReservedWord(String word) {
        return this.reservedWords.contains(word);
    }

    @Override
    protected boolean needToImport(String type) {
        boolean imports = !type.startsWith("kotlin.") && !type.startsWith("java.") && !this.defaultIncludes.contains(type) && !this.languageSpecificPrimitives.contains(type) && !type.contains(".");
        return imports;
    }

    @Override
    public CodegenModel fromModel(String name, Schema schema) {
        CodegenModel m = super.fromModel(name, schema);
        m.optionalVars = m.optionalVars.stream().distinct().collect(Collectors.toList());
        Map allVarsMap = m.allVars.stream().collect(Collectors.toMap(CodegenProperty::getBaseName, Function.identity()));
        allVarsMap.keySet().removeAll(m.vars.stream().map(CodegenProperty::getBaseName).collect(Collectors.toSet()));
        allVarsMap.values().forEach(p -> {
            p.isInherited = true;
        });
        Stream.of(m.requiredVars, m.optionalVars).flatMap(Collection::stream).filter(p -> allVarsMap.containsKey(p.baseName)).forEach(p -> {
            p.isInherited = true;
        });
        return m;
    }

    @Override
    public String toEnumValue(String value, String datatype) {
        if ("kotlin.Int".equals(datatype) || "kotlin.Long".equals(datatype)) {
            return value;
        }
        if ("kotlin.Double".equals(datatype)) {
            if (value.contains(".")) {
                return value;
            }
            return value + ".0";
        }
        if ("kotlin.Float".equals(datatype)) {
            return value + "f";
        }
        return "\"" + this.escapeText(value) + "\"";
    }

    @Override
    public boolean isDataTypeString(String dataType) {
        return "String".equals(dataType) || "kotlin.String".equals(dataType);
    }

    @Override
    public String toParamName(String name) {
        if ("callback".equals(name)) {
            return "paramCallback";
        }
        return this.toVarName(name);
    }

    @Override
    public String toVarName(String name) {
        name = this.sanitizeName(name, "\\W-[\\$]");
        if ((name = this.sanitizeKotlinSpecificNames(name)).toLowerCase(Locale.ROOT).matches("^_*class$")) {
            return "propertyClass";
        }
        if ("_".equals(name)) {
            name = "_u";
        }
        if (name.matches("^[A-Z0-9_]*$")) {
            return name;
        }
        if (this.startsWithTwoUppercaseLetters(name)) {
            name = name.substring(0, 2).toLowerCase(Locale.ROOT) + name.substring(2);
        }
        if (name.chars().anyMatch(character -> this.specialCharReplacements.keySet().contains("" + (char)character))) {
            ArrayList<String> allowedCharacters = new ArrayList<String>();
            allowedCharacters.add("_");
            allowedCharacters.add("$");
            name = StringUtils.escape(name, this.specialCharReplacements, allowedCharacters, "_");
        }
        if (this.isReservedWord(name = StringUtils.camelize(name, true)) || name.matches("(^\\d.*)|(.*[$].*)")) {
            name = this.escapeReservedWord(name);
        }
        return name;
    }

    @Override
    public String toRegularExpression(String pattern) {
        return this.escapeText(pattern);
    }

    private boolean startsWithTwoUppercaseLetters(String name) {
        boolean startsWithTwoUppercaseLetters = false;
        if (name.length() > 1) {
            startsWithTwoUppercaseLetters = name.substring(0, 2).equals(name.substring(0, 2).toUpperCase(Locale.ROOT));
        }
        return startsWithTwoUppercaseLetters;
    }

    @Override
    public void postProcessFile(File file, String fileType) {
        if (file == null) {
            return;
        }
        String kotlinPostProcessFile = System.getenv("KOTLIN_POST_PROCESS_FILE");
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)kotlinPostProcessFile)) {
            return;
        }
        if ("kt".equals(FilenameUtils.getExtension((String)file.toString()))) {
            String command = kotlinPostProcessFile + " " + file.toString();
            try {
                Process p = Runtime.getRuntime().exec(command);
                p.waitFor();
                int exitValue = p.exitValue();
                if (exitValue != 0) {
                    this.LOGGER.error("Error running the command ({}). Exit value: {}", (Object)command, (Object)exitValue);
                } else {
                    this.LOGGER.info("Successfully executed: " + command);
                }
            }
            catch (IOException | InterruptedException e) {
                this.LOGGER.error("Error running the command ({}). Exception: {}", (Object)command, (Object)e.getMessage());
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public String toDefaultValue(Schema schema) {
        Schema p = ModelUtils.getReferencedSchema(this.openAPI, schema);
        if (ModelUtils.isBooleanSchema(p)) {
            if (p.getDefault() != null) {
                return p.getDefault().toString();
            }
        } else if (!ModelUtils.isDateSchema(p) && !ModelUtils.isDateTimeSchema(p)) {
            if (ModelUtils.isNumberSchema(p)) {
                if (p.getDefault() != null) {
                    return p.getDefault().toString();
                }
            } else if (ModelUtils.isIntegerSchema(p)) {
                if (p.getDefault() != null) {
                    return p.getDefault().toString();
                }
            } else if (ModelUtils.isURISchema(p)) {
                if (p.getDefault() != null) {
                    return "URI.create('" + p.getDefault() + "')";
                }
            } else if (ModelUtils.isStringSchema(p)) {
                if (p.getDefault() != null) {
                    String _default = (String)p.getDefault();
                    if (p.getEnum() == null) {
                        return "\"" + this.escapeText(_default) + "\"";
                    }
                    return _default;
                }
                return null;
            }
        }
        return null;
    }

    public static enum SERIALIZATION_LIBRARY_TYPE {
        moshi,
        gson,
        jackson,
        kotlinx_serialization;

    }
}

