/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.DefaultCodegen;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.meta.features.ClientModificationFeature;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.meta.features.GlobalFeature;
import org.openapitools.codegen.meta.features.SchemaSupportFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.meta.features.WireFormatFeature;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MysqlSchemaCodegen
extends DefaultCodegen
implements CodegenConfig {
    private final Logger LOGGER = LoggerFactory.getLogger(MysqlSchemaCodegen.class);
    public static final String VENDOR_EXTENSION_MYSQL_SCHEMA = "x-mysql-schema";
    public static final String DEFAULT_DATABASE_NAME = "defaultDatabaseName";
    public static final String JSON_DATA_TYPE_ENABLED = "jsonDataTypeEnabled";
    public static final String IDENTIFIER_NAMING_CONVENTION = "identifierNamingConvention";
    public static final String NAMED_PARAMETERS_ENABLED = "namedParametersEnabled";
    public static final Integer ENUM_MAX_ELEMENTS = 65535;
    public static final Integer IDENTIFIER_MAX_LENGTH = 64;
    protected Vector<String> mysqlNumericTypes = new Vector<String>(Arrays.asList("BIGINT", "BIT", "BOOL", "BOOLEAN", "DEC", "DECIMAL", "DOUBLE", "DOUBLE PRECISION", "FIXED", "FLOAT", "INT", "INTEGER", "MEDIUMINT", "NUMERIC", "REAL", "SMALLINT", "TINYINT"));
    protected Vector<String> mysqlDateAndTimeTypes = new Vector<String>(Arrays.asList("DATE", "DATETIME", "TIME", "TIMESTAMP", "YEAR"));
    protected Vector<String> mysqlStringTypes = new Vector<String>(Arrays.asList("BINARY", "BLOB", "CHAR", "CHAR BYTE", "CHARACTER", "ENUM", "LONGBLOB", "LONGTEXT", "MEDIUMBLOB", "MEDIUMTEXT", "SET", "TEXT", "TINYBLOB", "TINYTEXT", "VARBINARY", "VARCHAR"));
    protected Vector<String> mysqlSpatialTypes = new Vector<String>(Arrays.asList("GEOMETRY", "GEOMETRYCOLLECTION", "LINESTRING", "MULTILINESTRING", "MULTIPOINT", "MULTIPOLYGON", "POINT", "POLYGON"));
    protected String defaultDatabaseName = "";
    protected String databaseNamePrefix = "";
    protected String databaseNameSuffix = "_db";
    protected String tableNamePrefix = "tbl_";
    protected String tableNameSuffix = "";
    protected String columnNamePrefix = "col_";
    protected String columnNameSuffix = "";
    protected Boolean jsonDataTypeEnabled = true;
    protected Boolean namedParametersEnabled = false;
    protected String identifierNamingConvention = "original";

    public MysqlSchemaCodegen() {
        this.modifyFeatureSet(features -> features.includeDocumentationFeatures(new DocumentationFeature[]{DocumentationFeature.Readme}).wireFormatFeatures(EnumSet.noneOf(WireFormatFeature.class)).securityFeatures(EnumSet.noneOf(SecurityFeature.class)).excludeGlobalFeatures(new GlobalFeature[]{GlobalFeature.XMLStructureDefinitions, GlobalFeature.Callbacks, GlobalFeature.LinkObjects, GlobalFeature.ParameterStyling}).excludeSchemaSupportFeatures(new SchemaSupportFeature[]{SchemaSupportFeature.Polymorphism}).clientModificationFeatures(EnumSet.noneOf(ClientModificationFeature.class)));
        this.importMapping.clear();
        this.setModelPackage("Model");
        this.modelTemplateFiles.put("sql_query.mustache", ".sql");
        this.setReservedWordsLowerCase(Arrays.asList("ACCESSIBLE", "ADD", "ALL", "ALTER", "ANALYZE", "AND", "AS", "ASC", "ASENSITIVE", "BEFORE", "BETWEEN", "BIGINT", "BINARY", "BLOB", "BOTH", "BY", "CALL", "CASCADE", "CASE", "CHANGE", "CHAR", "CHARACTER", "CHECK", "COLLATE", "COLUMN", "CONDITION", "CONSTRAINT", "CONTINUE", "CONVERT", "CREATE", "CROSS", "CUBE", "CUME_DIST", "CURRENT_DATE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_USER", "CURSOR", "DATABASE", "DATABASES", "DAY_HOUR", "DAY_MICROSECOND", "DAY_MINUTE", "DAY_SECOND", "DEC", "DECIMAL", "DECLARE", "DEFAULT", "DELAYED", "DELETE", "DENSE_RANK", "DESC", "DESCRIBE", "DETERMINISTIC", "DISTINCT", "DISTINCTROW", "DIV", "DOUBLE", "DROP", "DUAL", "EACH", "ELSE", "ELSEIF", "EMPTY", "ENCLOSED", "ESCAPED", "EXCEPT", "EXISTS", "EXIT", "EXPLAIN", "FALSE", "FETCH", "FIRST_VALUE", "FLOAT", "FLOAT4", "FLOAT8", "FOR", "FORCE", "FOREIGN", "FROM", "FULLTEXT", "FUNCTION", "GENERATED", "GET", "GRANT", "GROUP", "GROUPING", "GROUPS", "HAVING", "HIGH_PRIORITY", "HOUR_MICROSECOND", "HOUR_MINUTE", "HOUR_SECOND", "IF", "IGNORE", "IN", "INDEX", "INFILE", "INNER", "INOUT", "INSENSITIVE", "INSERT", "INT", "INT1", "INT2", "INT3", "INT4", "INT8", "INTEGER", "INTERVAL", "INTO", "IO_AFTER_GTIDS", "IO_BEFORE_GTIDS", "IS", "ITERATE", "JOIN", "JSON_TABLE", "KEY", "KEYS", "KILL", "LAG", "LAST_VALUE", "LEAD", "LEADING", "LEAVE", "LEFT", "LIKE", "LIMIT", "LINEAR", "LINES", "LOAD", "LOCALTIME", "LOCALTIMESTAMP", "LOCK", "LONG", "LONGBLOB", "LONGTEXT", "LOOP", "LOW_PRIORITY", "MASTER_BIND", "MASTER_SSL_VERIFY_SERVER_CERT", "MATCH", "MAXVALUE", "MEDIUMBLOB", "MEDIUMINT", "MEDIUMTEXT", "MIDDLEINT", "MINUTE_MICROSECOND", "MINUTE_SECOND", "MOD", "MODIFIES", "NATURAL", "NOT", "NO_WRITE_TO_BINLOG", "NTH_VALUE", "NTILE", "NULL", "NUMERIC", "OF", "ON", "OPTIMIZE", "OPTIMIZER_COSTS", "OPTION", "OPTIONALLY", "OR", "ORDER", "OUT", "OUTER", "OUTFILE", "OVER", "PARTITION", "PERCENT_RANK", "PERSIST", "PERSIST_ONLY", "PRECISION", "PRIMARY", "PROCEDURE", "PURGE", "RANGE", "RANK", "READ", "READS", "READ_WRITE", "REAL", "RECURSIVE", "REFERENCES", "REGEXP", "RELEASE", "RENAME", "REPEAT", "REPLACE", "REQUIRE", "RESIGNAL", "RESTRICT", "RETURN", "REVOKE", "RIGHT", "RLIKE", "ROLE", "ROW", "ROWS", "ROW_NUMBER", "SCHEMA", "SCHEMAS", "SECOND_MICROSECOND", "SELECT", "SENSITIVE", "SEPARATOR", "SET", "SHOW", "SIGNAL", "SMALLINT", "SPATIAL", "SPECIFIC", "SQL", "SQLEXCEPTION", "SQLSTATE", "SQLWARNING", "SQL_BIG_RESULT", "SQL_CALC_FOUND_ROWS", "SQL_SMALL_RESULT", "SSL", "STARTING", "STORED", "STRAIGHT_JOIN", "SYSTEM", "TABLE", "TERMINATED", "THEN", "TINYBLOB", "TINYINT", "TINYTEXT", "TO", "TRAILING", "TRIGGER", "TRUE", "UNDO", "UNION", "UNIQUE", "UNLOCK", "UNSIGNED", "UPDATE", "USAGE", "USE", "USING", "UTC_DATE", "UTC_TIME", "UTC_TIMESTAMP", "VALUES", "VARBINARY", "VARCHAR", "VARCHARACTER", "VARYING", "VIRTUAL", "WHEN", "WHERE", "WHILE", "WINDOW", "WITH", "WRITE", "XOR", "YEAR_MONTH", "ZEROFILL"));
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("bool", "boolean", "int", "integer", "double", "float", "string", "date", "Date", "DateTime", "long", "short", "char", "ByteArray", "binary", "file", "UUID", "URI", "BigDecimal", "mixed", "number", "void", "byte"));
        this.typeMapping.put("array", "JSON");
        this.typeMapping.put("set", "JSON");
        this.typeMapping.put("map", "JSON");
        this.typeMapping.put("List", "JSON");
        this.typeMapping.put("boolean", "BOOL");
        this.typeMapping.put("string", "TEXT");
        this.typeMapping.put("int", "INT");
        this.typeMapping.put("byte", "TEXT");
        this.typeMapping.put("float", "DECIMAL");
        this.typeMapping.put("number", "DECIMAL");
        this.typeMapping.put("date", "DATE");
        this.typeMapping.put("Date", "DATETIME");
        this.typeMapping.put("DateTime", "DATETIME");
        this.typeMapping.put("long", "BIGINT");
        this.typeMapping.put("short", "SMALLINT");
        this.typeMapping.put("char", "TEXT");
        this.typeMapping.put("double", "DECIMAL");
        this.typeMapping.put("object", "JSON");
        this.typeMapping.put("integer", "INT");
        this.typeMapping.put("ByteArray", "MEDIUMBLOB");
        this.typeMapping.put("binary", "MEDIUMBLOB");
        this.typeMapping.put("file", "MEDIUMBLOB");
        this.typeMapping.put("UUID", "TEXT");
        this.typeMapping.put("URI", "TEXT");
        this.typeMapping.put("BigDecimal", "DECIMAL");
        this.templateDir = "mysql-schema";
        this.embeddedTemplateDir = "mysql-schema";
        this.cliOptions.clear();
        this.addOption(DEFAULT_DATABASE_NAME, "Default database name for all MySQL queries", this.defaultDatabaseName);
        this.addSwitch(JSON_DATA_TYPE_ENABLED, "Use special JSON MySQL data type for complex model properties. Requires MySQL version 5.7.8. Generates TEXT data type when disabled", this.jsonDataTypeEnabled);
        this.addSwitch(NAMED_PARAMETERS_ENABLED, "Generates model prepared SQLs with named parameters, eg. :petName. Question mark placeholder used when option disabled.", this.namedParametersEnabled);
        CliOption identifierNamingOpt = new CliOption(IDENTIFIER_NAMING_CONVENTION, "Naming convention of MySQL identifiers(table names and column names). This is not related to database name which is defined by defaultDatabaseName option");
        identifierNamingOpt.addEnum("original", "Do not transform original names").addEnum("snake_case", "Use snake_case names").setDefault("original");
        this.cliOptions.add(identifierNamingOpt);
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.SCHEMA;
    }

    @Override
    public String getName() {
        return "mysql-schema";
    }

    @Override
    public String getHelp() {
        return "Generates a MySQL schema based on the model or schema defined in the OpenAPI specification (v2, v3).";
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey(DEFAULT_DATABASE_NAME)) {
            if (this.additionalProperties.get(DEFAULT_DATABASE_NAME).equals("")) {
                this.additionalProperties.remove(DEFAULT_DATABASE_NAME);
            } else {
                this.setDefaultDatabaseName((String)this.additionalProperties.get(DEFAULT_DATABASE_NAME));
                this.additionalProperties.put(DEFAULT_DATABASE_NAME, this.getDefaultDatabaseName());
            }
        }
        if (this.additionalProperties.containsKey(JSON_DATA_TYPE_ENABLED)) {
            this.setJsonDataTypeEnabled(Boolean.valueOf(this.additionalProperties.get(JSON_DATA_TYPE_ENABLED).toString()));
        } else {
            this.additionalProperties.put(JSON_DATA_TYPE_ENABLED, this.getJsonDataTypeEnabled());
        }
        if (this.additionalProperties.containsKey(NAMED_PARAMETERS_ENABLED)) {
            this.setNamedParametersEnabled(Boolean.valueOf(this.additionalProperties.get(NAMED_PARAMETERS_ENABLED).toString()));
        }
        this.additionalProperties.put(NAMED_PARAMETERS_ENABLED, this.getNamedParametersEnabled());
        if (this.additionalProperties.containsKey(IDENTIFIER_NAMING_CONVENTION)) {
            this.setIdentifierNamingConvention((String)this.additionalProperties.get(IDENTIFIER_NAMING_CONVENTION));
        }
        this.additionalProperties.put("modelSrcPath", "./" + this.toSrcPath(this.modelPackage));
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        this.supportingFiles.add(new SupportingFile("mysql_schema.mustache", "", "mysql_schema.sql"));
    }

    @Override
    public Map<String, Object> postProcessModels(Map<String, Object> objs) {
        objs = super.postProcessModels(objs);
        List models = (List)objs.get("models");
        for (Object _mo : models) {
            Map mo = (Map)_mo;
            CodegenModel model = (CodegenModel)mo.get("model");
            String modelName = model.getName();
            String tableName = this.toTableName(modelName);
            String modelDescription = model.getDescription();
            Map<String, Object> modelVendorExtensions = model.getVendorExtensions();
            HashMap mysqlSchema = new HashMap();
            HashMap<String, String> tableDefinition = new HashMap<String, String>();
            if (this.getIdentifierNamingConvention().equals("snake_case") && !modelName.equals(tableName)) {
                String commentExtra = "Original model name - " + modelName + ".";
                String string = modelDescription = modelDescription == null || modelDescription.isEmpty() ? commentExtra : modelDescription + ". " + commentExtra;
            }
            if (modelVendorExtensions.containsKey(VENDOR_EXTENSION_MYSQL_SCHEMA)) {
                this.LOGGER.info("Found vendor extension in '" + modelName + "' model, autogeneration skipped");
                continue;
            }
            modelVendorExtensions.put(VENDOR_EXTENSION_MYSQL_SCHEMA, mysqlSchema);
            mysqlSchema.put("tableDefinition", tableDefinition);
            tableDefinition.put("tblName", tableName);
            tableDefinition.put("tblComment", modelDescription);
        }
        return objs;
    }

    @Override
    public void postProcessModelProperty(CodegenModel model, CodegenProperty property) {
        switch (property.getDataType().toUpperCase(Locale.ROOT)) {
            case "BOOL": {
                this.processBooleanTypeProperty(model, property);
                break;
            }
            case "TINYINT": 
            case "SMALLINT": 
            case "INT": 
            case "BIGINT": {
                this.processIntegerTypeProperty(model, property);
                break;
            }
            case "DECIMAL": {
                this.processDecimalTypeProperty(model, property);
                break;
            }
            case "MEDIUMBLOB": 
            case "TEXT": {
                this.processStringTypeProperty(model, property);
                break;
            }
            case "DATE": 
            case "DATETIME": {
                this.processDateTypeProperty(model, property);
                break;
            }
            case "JSON": {
                this.processJsonTypeProperty(model, property);
                break;
            }
            default: {
                this.processUnknownTypeProperty(model, property);
            }
        }
    }

    public void processIntegerTypeProperty(CodegenModel model, CodegenProperty property) {
        Map<String, Object> vendorExtensions = property.getVendorExtensions();
        HashMap mysqlSchema = new HashMap();
        HashMap<String, Object> columnDefinition = new HashMap<String, Object>();
        ArrayList<HashMap<String, Object>> columnDataTypeArguments = new ArrayList<HashMap<String, Object>>();
        String baseName = property.getBaseName();
        String colName = this.toColumnName(baseName);
        String dataType = property.getDataType();
        String dataFormat = property.getDataFormat();
        String description = property.getDescription();
        String minimum = property.getMinimum();
        String maximum = property.getMaximum();
        boolean exclusiveMinimum = property.getExclusiveMinimum();
        boolean exclusiveMaximum = property.getIExclusiveMaximum();
        String defaultValue = property.getDefaultValue();
        Boolean required = property.getRequired();
        boolean unsigned = false;
        Boolean isUuid = property.isUuid;
        Boolean isEnum = property.isEnum;
        if (vendorExtensions.containsKey(VENDOR_EXTENSION_MYSQL_SCHEMA)) {
            this.LOGGER.info("Found vendor extension in '" + baseName + "' property, autogeneration skipped");
            return;
        }
        if (this.getIdentifierNamingConvention().equals("snake_case") && !baseName.equals(colName)) {
            String commentExtra = "Original param name - " + baseName + ".";
            description = description == null || description.isEmpty() ? commentExtra : description + ". " + commentExtra;
        }
        vendorExtensions.put(VENDOR_EXTENSION_MYSQL_SCHEMA, mysqlSchema);
        mysqlSchema.put("columnDefinition", columnDefinition);
        columnDefinition.put("colName", colName);
        if (Boolean.TRUE.equals(isEnum)) {
            Map<String, Object> allowableValues = property.getAllowableValues();
            List enumValues = (List)allowableValues.get("values");
            for (int i = 0; i < enumValues.size(); ++i) {
                if (i > ENUM_MAX_ELEMENTS - 1) {
                    this.LOGGER.warn("ENUM column can have maximum of " + ENUM_MAX_ELEMENTS.toString() + " distinct elements, following value will be skipped: " + (String)enumValues.get(i));
                    break;
                }
                String value = String.valueOf(enumValues.get(i));
                columnDataTypeArguments.add(this.toCodegenMysqlDataTypeArgument(value));
            }
            columnDefinition.put("colDataType", "ENUM");
            columnDefinition.put("colDataTypeArguments", columnDataTypeArguments);
        } else if ("int64".equals(dataFormat)) {
            columnDefinition.put("colDataType", "BIGINT");
        } else {
            Long max;
            Long min = minimum != null ? Long.valueOf(Long.parseLong(minimum)) : null;
            Long l = max = maximum != null ? Long.valueOf(Long.parseLong(maximum)) : null;
            if (exclusiveMinimum && min != null) {
                min = min + 1L;
            }
            if (exclusiveMaximum && max != null) {
                max = max - 1L;
            }
            if (min != null && min >= 0L) {
                unsigned = true;
            }
            columnDefinition.put("colUnsigned", unsigned);
            columnDefinition.put("colDataType", this.getMysqlMatchedIntegerDataType(min, max, unsigned));
        }
        if (Boolean.TRUE.equals(required)) {
            columnDefinition.put("colNotNull", true);
        } else {
            columnDefinition.put("colNotNull", false);
            try {
                columnDefinition.put("colDefault", this.toCodegenMysqlDataTypeDefault(defaultValue, (String)columnDefinition.get("colDataType")));
            }
            catch (RuntimeException exception) {
                this.LOGGER.warn("Property '" + baseName + "' of model '" + model.getName() + "' mapped to MySQL data type which doesn't support default value");
                columnDefinition.put("colDefault", null);
            }
        }
        if (description != null) {
            columnDefinition.put("colComment", description);
        }
    }

    public void processDecimalTypeProperty(CodegenModel model, CodegenProperty property) {
        Map<String, Object> vendorExtensions = property.getVendorExtensions();
        HashMap mysqlSchema = new HashMap();
        HashMap<String, Object> columnDefinition = new HashMap<String, Object>();
        ArrayList<HashMap<String, Object>> columnDataTypeArguments = new ArrayList<HashMap<String, Object>>();
        String baseName = property.getBaseName();
        String colName = this.toColumnName(baseName);
        String dataType = property.getDataType();
        String dataFormat = property.getDataFormat();
        String description = property.getDescription();
        String minimum = property.getMinimum();
        String maximum = property.getMaximum();
        boolean exclusiveMinimum = property.getExclusiveMinimum();
        boolean exclusiveMaximum = property.getIExclusiveMaximum();
        String defaultValue = property.getDefaultValue();
        Boolean required = property.getRequired();
        boolean unsigned = false;
        Boolean isEnum = property.isEnum;
        if (vendorExtensions.containsKey(VENDOR_EXTENSION_MYSQL_SCHEMA)) {
            this.LOGGER.info("Found vendor extension in '" + baseName + "' property, autogeneration skipped");
            return;
        }
        if (this.getIdentifierNamingConvention().equals("snake_case") && !baseName.equals(colName)) {
            String commentExtra = "Original param name - " + baseName + ".";
            description = description == null || description.isEmpty() ? commentExtra : description + ". " + commentExtra;
        }
        vendorExtensions.put(VENDOR_EXTENSION_MYSQL_SCHEMA, mysqlSchema);
        mysqlSchema.put("columnDefinition", columnDefinition);
        columnDefinition.put("colName", colName);
        if (Boolean.TRUE.equals(isEnum)) {
            Map<String, Object> allowableValues = property.getAllowableValues();
            List enumValues = (List)allowableValues.get("values");
            for (int i = 0; i < enumValues.size(); ++i) {
                if (i > ENUM_MAX_ELEMENTS - 1) {
                    this.LOGGER.warn("ENUM column can have maximum of " + ENUM_MAX_ELEMENTS.toString() + " distinct elements, following value will be skipped: " + (String)enumValues.get(i));
                    break;
                }
                String value = String.valueOf(enumValues.get(i));
                columnDataTypeArguments.add(this.toCodegenMysqlDataTypeArgument(value));
            }
            columnDefinition.put("colDataType", "ENUM");
            columnDefinition.put("colDataTypeArguments", columnDataTypeArguments);
        } else {
            Float max;
            Float min = minimum != null ? Float.valueOf(minimum) : null;
            Float f = max = maximum != null ? Float.valueOf(maximum) : null;
            if (exclusiveMinimum && min != null) {
                min = Float.valueOf(min.floatValue() + 1.0f);
            }
            if (exclusiveMaximum && max != null) {
                max = Float.valueOf(max.floatValue() - 1.0f);
            }
            if (min != null && min.floatValue() >= 0.0f) {
                unsigned = true;
            }
            columnDefinition.put("colDataType", "DECIMAL");
            columnDefinition.put("colUnsigned", unsigned);
            columnDefinition.put("colDataTypeArguments", columnDataTypeArguments);
            columnDataTypeArguments.add(this.toCodegenMysqlDataTypeArgument(20));
            columnDataTypeArguments.add(this.toCodegenMysqlDataTypeArgument(9));
        }
        if (Boolean.TRUE.equals(required)) {
            columnDefinition.put("colNotNull", true);
        } else {
            columnDefinition.put("colNotNull", false);
            try {
                columnDefinition.put("colDefault", this.toCodegenMysqlDataTypeDefault(defaultValue, (String)columnDefinition.get("colDataType")));
            }
            catch (RuntimeException exception) {
                this.LOGGER.warn("Property '" + baseName + "' of model '" + model.getName() + "' mapped to MySQL data type which doesn't support default value");
                columnDefinition.put("colDefault", null);
            }
        }
        if (description != null) {
            columnDefinition.put("colComment", description);
        }
    }

    public void processBooleanTypeProperty(CodegenModel model, CodegenProperty property) {
        Map<String, Object> vendorExtensions = property.getVendorExtensions();
        HashMap mysqlSchema = new HashMap();
        HashMap<String, Object> columnDefinition = new HashMap<String, Object>();
        ArrayList<HashMap<String, Object>> columnDataTypeArguments = new ArrayList<HashMap<String, Object>>();
        String baseName = property.getBaseName();
        String colName = this.toColumnName(baseName);
        String description = property.getDescription();
        String defaultValue = property.getDefaultValue();
        Boolean required = property.getRequired();
        if (vendorExtensions.containsKey(VENDOR_EXTENSION_MYSQL_SCHEMA)) {
            this.LOGGER.info("Found vendor extension in '" + baseName + "' property, autogeneration skipped");
            return;
        }
        if (this.getIdentifierNamingConvention().equals("snake_case") && !baseName.equals(colName)) {
            String commentExtra = "Original param name - " + baseName + ".";
            description = description == null || description.isEmpty() ? commentExtra : description + ". " + commentExtra;
        }
        vendorExtensions.put(VENDOR_EXTENSION_MYSQL_SCHEMA, mysqlSchema);
        mysqlSchema.put("columnDefinition", columnDefinition);
        columnDefinition.put("colName", colName);
        columnDefinition.put("colDataType", "TINYINT");
        columnDefinition.put("colDataTypeArguments", columnDataTypeArguments);
        columnDataTypeArguments.add(this.toCodegenMysqlDataTypeArgument(1));
        if (Boolean.TRUE.equals(required)) {
            columnDefinition.put("colNotNull", true);
        } else {
            columnDefinition.put("colNotNull", false);
            try {
                columnDefinition.put("colDefault", this.toCodegenMysqlDataTypeDefault(defaultValue, (String)columnDefinition.get("colDataType")));
            }
            catch (RuntimeException exception) {
                this.LOGGER.warn("Property '" + baseName + "' of model '" + model.getName() + "' mapped to MySQL data type which doesn't support default value");
                columnDefinition.put("colDefault", null);
            }
        }
        if (description != null) {
            columnDefinition.put("colComment", description);
        }
    }

    public void processStringTypeProperty(CodegenModel model, CodegenProperty property) {
        Map<String, Object> vendorExtensions = property.getVendorExtensions();
        HashMap mysqlSchema = new HashMap();
        HashMap<String, Object> columnDefinition = new HashMap<String, Object>();
        ArrayList<HashMap<String, Object>> columnDataTypeArguments = new ArrayList<HashMap<String, Object>>();
        String baseName = property.getBaseName();
        String colName = this.toColumnName(baseName);
        String dataType = property.getDataType();
        String dataFormat = property.getDataFormat();
        String description = property.getDescription();
        Integer minLength = property.getMinLength();
        Integer maxLength = property.getMaxLength();
        String defaultValue = property.getDefaultValue();
        Boolean required = property.getRequired();
        Boolean isEnum = property.isEnum;
        if (vendorExtensions.containsKey(VENDOR_EXTENSION_MYSQL_SCHEMA)) {
            this.LOGGER.info("Found vendor extension in '" + baseName + "' property, autogeneration skipped");
            return;
        }
        if (this.getIdentifierNamingConvention().equals("snake_case") && !baseName.equals(colName)) {
            String commentExtra = "Original param name - " + baseName + ".";
            description = description == null || description.isEmpty() ? commentExtra : description + ". " + commentExtra;
        }
        vendorExtensions.put(VENDOR_EXTENSION_MYSQL_SCHEMA, mysqlSchema);
        mysqlSchema.put("columnDefinition", columnDefinition);
        columnDefinition.put("colName", colName);
        if (Boolean.TRUE.equals(isEnum)) {
            Map<String, Object> allowableValues = property.getAllowableValues();
            List enumValues = (List)allowableValues.get("values");
            columnDefinition.put("colDataType", "ENUM");
            columnDefinition.put("colDataTypeArguments", columnDataTypeArguments);
            for (int i = 0; i < enumValues.size(); ++i) {
                if (i > ENUM_MAX_ELEMENTS - 1) {
                    this.LOGGER.warn("ENUM column can have maximum of " + ENUM_MAX_ELEMENTS.toString() + " distinct elements, following value will be skipped: " + (String)enumValues.get(i));
                    break;
                }
                String value = String.valueOf(enumValues.get(i));
                columnDataTypeArguments.add(this.toCodegenMysqlDataTypeArgument(value));
            }
        } else if (dataType.equals("MEDIUMBLOB")) {
            columnDefinition.put("colDataType", "MEDIUMBLOB");
        } else {
            String matchedStringType = this.getMysqlMatchedStringDataType(minLength, maxLength);
            columnDefinition.put("colDataType", matchedStringType);
            if (matchedStringType.equals("CHAR") || matchedStringType.equals("VARCHAR")) {
                columnDefinition.put("colDataTypeArguments", columnDataTypeArguments);
                columnDataTypeArguments.add(this.toCodegenMysqlDataTypeArgument(maxLength != null ? maxLength : 255));
            }
        }
        if (Boolean.TRUE.equals(required)) {
            columnDefinition.put("colNotNull", true);
        } else {
            columnDefinition.put("colNotNull", false);
            try {
                columnDefinition.put("colDefault", this.toCodegenMysqlDataTypeDefault(defaultValue, (String)columnDefinition.get("colDataType")));
            }
            catch (RuntimeException exception) {
                this.LOGGER.warn("Property '" + baseName + "' of model '" + model.getName() + "' mapped to MySQL data type which doesn't support default value");
                columnDefinition.put("colDefault", null);
            }
        }
        if (description != null) {
            columnDefinition.put("colComment", description);
        }
    }

    public void processDateTypeProperty(CodegenModel model, CodegenProperty property) {
        Map<String, Object> vendorExtensions = property.getVendorExtensions();
        HashMap mysqlSchema = new HashMap();
        HashMap<String, Object> columnDefinition = new HashMap<String, Object>();
        String baseName = property.getBaseName();
        String colName = this.toColumnName(baseName);
        String dataType = property.getDataType();
        Boolean required = property.getRequired();
        String description = property.getDescription();
        String defaultValue = property.getDefaultValue();
        if (vendorExtensions.containsKey(VENDOR_EXTENSION_MYSQL_SCHEMA)) {
            this.LOGGER.info("Found vendor extension in '" + baseName + "' property, autogeneration skipped");
            return;
        }
        if (this.getIdentifierNamingConvention().equals("snake_case") && !baseName.equals(colName)) {
            String commentExtra = "Original param name - " + baseName + ".";
            description = description == null || description.isEmpty() ? commentExtra : description + ". " + commentExtra;
        }
        vendorExtensions.put(VENDOR_EXTENSION_MYSQL_SCHEMA, mysqlSchema);
        mysqlSchema.put("columnDefinition", columnDefinition);
        columnDefinition.put("colName", colName);
        columnDefinition.put("colDataType", dataType);
        if (Boolean.TRUE.equals(required)) {
            columnDefinition.put("colNotNull", true);
        } else {
            columnDefinition.put("colNotNull", false);
            try {
                columnDefinition.put("colDefault", this.toCodegenMysqlDataTypeDefault(defaultValue, (String)columnDefinition.get("colDataType")));
            }
            catch (RuntimeException exception) {
                this.LOGGER.warn("Property '" + baseName + "' of model '" + model.getName() + "' mapped to MySQL data type which doesn't support default value");
                columnDefinition.put("colDefault", null);
            }
        }
        if (description != null) {
            columnDefinition.put("colComment", description);
        }
    }

    public void processJsonTypeProperty(CodegenModel model, CodegenProperty property) {
        Map<String, Object> vendorExtensions = property.getVendorExtensions();
        HashMap mysqlSchema = new HashMap();
        HashMap<String, Object> columnDefinition = new HashMap<String, Object>();
        String baseName = property.getBaseName();
        String colName = this.toColumnName(baseName);
        String dataType = property.getDataType();
        Boolean required = property.getRequired();
        String description = property.getDescription();
        String defaultValue = property.getDefaultValue();
        if (vendorExtensions.containsKey(VENDOR_EXTENSION_MYSQL_SCHEMA)) {
            this.LOGGER.info("Found vendor extension in '" + baseName + "' property, autogeneration skipped");
            return;
        }
        if (this.getIdentifierNamingConvention().equals("snake_case") && !baseName.equals(colName)) {
            String commentExtra = "Original param name - " + baseName + ".";
            description = description == null || description.isEmpty() ? commentExtra : description + ". " + commentExtra;
        }
        vendorExtensions.put(VENDOR_EXTENSION_MYSQL_SCHEMA, mysqlSchema);
        mysqlSchema.put("columnDefinition", columnDefinition);
        columnDefinition.put("colName", colName);
        columnDefinition.put("colDataType", dataType);
        if (Boolean.FALSE.equals(this.getJsonDataTypeEnabled())) {
            columnDefinition.put("colDataType", "TEXT");
        }
        if (Boolean.TRUE.equals(required)) {
            columnDefinition.put("colNotNull", true);
        } else {
            columnDefinition.put("colNotNull", false);
            try {
                columnDefinition.put("colDefault", this.toCodegenMysqlDataTypeDefault(defaultValue, (String)columnDefinition.get("colDataType")));
            }
            catch (RuntimeException exception) {
                this.LOGGER.warn("Property '" + baseName + "' of model '" + model.getName() + "' mapped to MySQL data type which doesn't support default value");
                columnDefinition.put("colDefault", null);
            }
        }
        if (description != null) {
            columnDefinition.put("colComment", description);
        }
    }

    public void processUnknownTypeProperty(CodegenModel model, CodegenProperty property) {
        Map<String, Object> vendorExtensions = property.getVendorExtensions();
        HashMap mysqlSchema = new HashMap();
        HashMap<String, Object> columnDefinition = new HashMap<String, Object>();
        String baseName = property.getBaseName();
        String colName = this.toColumnName(baseName);
        Boolean required = property.getRequired();
        String description = property.getDescription();
        String defaultValue = property.getDefaultValue();
        if (vendorExtensions.containsKey(VENDOR_EXTENSION_MYSQL_SCHEMA)) {
            this.LOGGER.info("Found vendor extension in '" + baseName + "' property, autogeneration skipped");
            return;
        }
        if (this.getIdentifierNamingConvention().equals("snake_case") && !baseName.equals(colName)) {
            String commentExtra = "Original param name - " + baseName + ".";
            description = description == null || description.isEmpty() ? commentExtra : description + ". " + commentExtra;
        }
        vendorExtensions.put(VENDOR_EXTENSION_MYSQL_SCHEMA, mysqlSchema);
        mysqlSchema.put("columnDefinition", columnDefinition);
        columnDefinition.put("colName", colName);
        columnDefinition.put("colDataType", "TEXT");
        if (Boolean.TRUE.equals(required)) {
            columnDefinition.put("colNotNull", true);
        } else {
            columnDefinition.put("colNotNull", false);
            try {
                columnDefinition.put("colDefault", this.toCodegenMysqlDataTypeDefault(defaultValue, (String)columnDefinition.get("colDataType")));
            }
            catch (RuntimeException exception) {
                this.LOGGER.warn("Property '" + baseName + "' of model '" + model.getName() + "' mapped to MySQL data type which doesn't support default value");
                columnDefinition.put("colDefault", null);
            }
        }
        if (description != null) {
            columnDefinition.put("colComment", description);
        }
    }

    public HashMap<String, Object> toCodegenMysqlDataTypeArgument(Object value) {
        HashMap<String, Object> arg = new HashMap<String, Object>();
        if (value instanceof String) {
            arg.put("isString", true);
            arg.put("isFloat", false);
            arg.put("isInteger", false);
            arg.put("isNumeric", false);
        } else if (value instanceof Integer || value instanceof Long) {
            arg.put("isString", false);
            arg.put("isFloat", false);
            arg.put("isInteger", true);
            arg.put("isNumeric", true);
        } else if (value instanceof Number) {
            arg.put("isString", false);
            arg.put("isFloat", true);
            arg.put("isInteger", false);
            arg.put("isNumeric", true);
        } else {
            this.LOGGER.warn("MySQL data type argument can be primitive type only. Class '" + value.getClass() + "' is provided");
        }
        arg.put("argumentValue", value);
        return arg;
    }

    public HashMap<String, Object> toCodegenMysqlDataTypeDefault(String defaultValue, String mysqlDataType) {
        HashMap<String, Object> defaultMap = new HashMap<String, Object>();
        if (defaultValue == null || defaultValue.toUpperCase(Locale.ROOT).equals("NULL")) {
            defaultMap.put("defaultValue", "NULL");
            defaultMap.put("isString", false);
            defaultMap.put("isNumeric", false);
            defaultMap.put("isKeyword", true);
            return defaultMap;
        }
        switch (mysqlDataType.toUpperCase(Locale.ROOT)) {
            case "TINYINT": 
            case "SMALLINT": 
            case "MEDIUMINT": 
            case "INT": 
            case "BIGINT": {
                if (defaultValue.equals("SERIAL DEFAULT VALUE")) {
                    defaultMap.put("defaultValue", defaultValue);
                    defaultMap.put("isString", false);
                    defaultMap.put("isNumeric", false);
                    defaultMap.put("isKeyword", true);
                } else {
                    defaultMap.put("defaultValue", defaultValue);
                    defaultMap.put("isString", false);
                    defaultMap.put("isNumeric", true);
                    defaultMap.put("isKeyword", false);
                }
                return defaultMap;
            }
            case "TIMESTAMP": 
            case "DATETIME": {
                if (defaultValue.equals("CURRENT_TIMESTAMP")) {
                    defaultMap.put("defaultValue", defaultValue);
                    defaultMap.put("isString", false);
                    defaultMap.put("isNumeric", false);
                    defaultMap.put("isKeyword", true);
                } else {
                    defaultMap.put("defaultValue", defaultValue);
                    defaultMap.put("isString", true);
                    defaultMap.put("isNumeric", false);
                    defaultMap.put("isKeyword", false);
                }
                return defaultMap;
            }
            case "TINYBLOB": 
            case "BLOB": 
            case "MEDIUMBLOB": 
            case "LONGBLOB": 
            case "TINYTEXT": 
            case "TEXT": 
            case "MEDIUMTEXT": 
            case "LONGTEXT": 
            case "GEOMETRY": 
            case "JSON": {
                throw new RuntimeException("The BLOB, TEXT, GEOMETRY, and JSON data types cannot be assigned a default value");
            }
        }
        defaultMap.put("defaultValue", defaultValue);
        defaultMap.put("isString", true);
        defaultMap.put("isNumeric", false);
        defaultMap.put("isKeyword", false);
        return defaultMap;
    }

    public String getMysqlMatchedIntegerDataType(Long minimum, Long maximum, Boolean unsigned) {
        long min = minimum != null ? minimum : Integer.MIN_VALUE;
        long max = maximum != null ? maximum : Integer.MAX_VALUE;
        long actualMin = Math.min(min, max);
        long actualMax = Math.max(min, max);
        if (minimum != null && maximum != null && minimum > maximum) {
            this.LOGGER.warn("Codegen property 'minimum' cannot be greater than 'maximum'");
        }
        if (Boolean.TRUE.equals(unsigned) && actualMin >= 0L) {
            if (actualMax <= 255L) {
                return "TINYINT";
            }
            if (actualMax <= 65535L) {
                return "SMALLINT";
            }
            if (actualMax <= 0xFFFFFFL) {
                return "MEDIUMINT";
            }
            if (actualMax <= 0xFFFFFFFFL) {
                return "INT";
            }
            if (actualMax > 0xFFFFFFFFL) {
                return "BIGINT";
            }
        } else {
            if (actualMin >= -128L && actualMax <= 127L) {
                return "TINYINT";
            }
            if (actualMin >= -32768L && actualMax <= 32767L) {
                return "SMALLINT";
            }
            if (actualMin >= -8388608L && actualMax <= 0x7FFFFFL) {
                return "MEDIUMINT";
            }
            if (actualMin >= Integer.MIN_VALUE && actualMax <= Integer.MAX_VALUE) {
                return "INT";
            }
            if (actualMin < Integer.MIN_VALUE || actualMax > Integer.MAX_VALUE) {
                return "BIGINT";
            }
        }
        return "INT";
    }

    public String getMysqlMatchedStringDataType(Integer minLength, Integer maxLength) {
        int min = minLength != null && minLength >= 0 ? minLength : 0;
        int max = maxLength != null && maxLength >= 0 ? maxLength : 65535;
        Integer actualMin = Math.min(min, max);
        Integer actualMax = Math.max(min, max);
        if (minLength != null && maxLength != null && minLength > maxLength) {
            this.LOGGER.warn("Codegen property 'minLength' cannot be greater than 'maxLength'");
        }
        if (actualMax.equals(actualMin) && actualMax <= 255) {
            return "CHAR";
        }
        if (actualMax <= 255) {
            return "VARCHAR";
        }
        if (actualMax > 255 && actualMax <= 65535) {
            return "TEXT";
        }
        if (actualMax > 65535 && actualMax <= 0xFFFFFF) {
            return "MEDIUMTEXT";
        }
        if (actualMax > 0xFFFFFF) {
            return "LONGTEXT";
        }
        return "TEXT";
    }

    public Boolean isMysqlDataType(String dataType) {
        return this.mysqlNumericTypes.contains(dataType.toUpperCase(Locale.ROOT)) || this.mysqlDateAndTimeTypes.contains(dataType.toUpperCase(Locale.ROOT)) || this.mysqlStringTypes.contains(dataType.toUpperCase(Locale.ROOT)) || this.mysqlSpatialTypes.contains(dataType.toUpperCase(Locale.ROOT)) || dataType.toUpperCase(Locale.ROOT).equals("JSON");
    }

    public String toDatabaseName(String name) {
        String identifier = this.toMysqlIdentifier(name, this.databaseNamePrefix, this.databaseNameSuffix);
        if (identifier.length() > IDENTIFIER_MAX_LENGTH) {
            this.LOGGER.warn("Database name cannot exceed 64 chars. Name '" + name + "' will be truncated");
            identifier = identifier.substring(0, IDENTIFIER_MAX_LENGTH);
        }
        return identifier;
    }

    public String toTableName(String name) {
        String identifier = this.toMysqlIdentifier(name, this.tableNamePrefix, this.tableNameSuffix);
        if (this.identifierNamingConvention.equals("snake_case")) {
            identifier = StringUtils.underscore(identifier);
        }
        if (identifier.length() > IDENTIFIER_MAX_LENGTH) {
            this.LOGGER.warn("Table name cannot exceed 64 chars. Name '" + name + "' will be truncated");
            identifier = identifier.substring(0, IDENTIFIER_MAX_LENGTH);
        }
        return identifier;
    }

    public String toColumnName(String name) {
        String identifier = this.toMysqlIdentifier(name, this.columnNamePrefix, this.columnNameSuffix);
        if (this.identifierNamingConvention.equals("snake_case")) {
            identifier = StringUtils.underscore(identifier);
        }
        if (identifier.length() > IDENTIFIER_MAX_LENGTH) {
            this.LOGGER.warn("Column name cannot exceed 64 chars. Name '" + name + "' will be truncated");
            identifier = identifier.substring(0, IDENTIFIER_MAX_LENGTH);
        }
        return identifier;
    }

    public String toMysqlIdentifier(String name, String prefix, String suffix) {
        String escapedName = this.escapeMysqlQuotedIdentifier(name);
        if (escapedName.matches(".*\\s$")) {
            this.LOGGER.warn("Database, table, and column names cannot end with space characters. Check '" + name + "' name");
            escapedName = escapedName.replaceAll("\\s+$", "");
        }
        if (escapedName.matches("^\\d+$")) {
            this.LOGGER.warn("Database, table, and column names cannot consist solely of digits. Check '" + name + "' name");
            escapedName = prefix + escapedName + suffix;
        }
        if (escapedName.isEmpty()) {
            throw new RuntimeException("Empty database/table/column name for property '" + name.toString() + "' not allowed");
        }
        return escapedName;
    }

    public String escapeMysqlUnquotedIdentifier(String identifier) {
        Pattern regexp = Pattern.compile("[^0-9a-zA-z$_\\u0080-\\uFFFF]");
        Matcher matcher = regexp.matcher(identifier);
        if (matcher.find()) {
            this.LOGGER.warn("Identifier '" + identifier + "' contains unsafe characters out of [0-9,a-z,A-Z$_] and U+0080..U+FFFF range");
            identifier = identifier.replaceAll("[^0-9a-zA-z$_\\u0080-\\uFFFF]", "");
        }
        return identifier;
    }

    public String escapeMysqlQuotedIdentifier(String identifier) {
        Pattern regexp = Pattern.compile("[^\\u0001-\\u007F\\u0080-\\uFFFF]");
        Matcher matcher = regexp.matcher(identifier);
        if (matcher.find()) {
            this.LOGGER.warn("Identifier '" + identifier + "' contains unsafe characters out of U+0001..U+007F and U+0080..U+FFFF range");
            identifier = identifier.replaceAll("[^\\u0001-\\u007F\\u0080-\\uFFFF]", "");
        }
        return identifier;
    }

    @Override
    public String escapeReservedWord(String name) {
        this.LOGGER.warn("'" + name + "' is MySQL reserved word. Do not use that word or properly escape it with backticks in mustache template");
        return name;
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("'", "");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("*/", "*_/").replace("/*", "/_*");
    }

    public void setDefaultDatabaseName(String databaseName) {
        String escapedName = this.toDatabaseName(databaseName);
        if (!escapedName.equals(databaseName)) {
            this.LOGGER.error("Invalid database name. '" + databaseName + "' cannot be used as MySQL identifier. Escaped value '" + escapedName + "' will be used instead.");
        }
        this.defaultDatabaseName = escapedName;
    }

    public String getDefaultDatabaseName() {
        return this.defaultDatabaseName;
    }

    public void setJsonDataTypeEnabled(Boolean enabled) {
        this.jsonDataTypeEnabled = enabled;
    }

    public Boolean getJsonDataTypeEnabled() {
        return this.jsonDataTypeEnabled;
    }

    public void setNamedParametersEnabled(Boolean enabled) {
        this.namedParametersEnabled = enabled;
    }

    public Boolean getNamedParametersEnabled() {
        return this.namedParametersEnabled;
    }

    public void setIdentifierNamingConvention(String naming) {
        switch (naming) {
            case "original": 
            case "snake_case": {
                this.identifierNamingConvention = naming;
                break;
            }
            default: {
                this.LOGGER.warn("\"" + naming + "\" is invalid \"identifierNamingConvention\" argument. Current \"" + this.identifierNamingConvention + "\" used instead.");
            }
        }
    }

    public String getIdentifierNamingConvention() {
        return this.identifierNamingConvention;
    }

    public String toSrcPath(String packageName) {
        String packagePath = org.apache.commons.lang3.StringUtils.removeStart((String)packageName.replaceAll("[\\.\\\\/]", Matcher.quoteReplacement("/")), (String)File.separator);
        return org.apache.commons.lang3.StringUtils.removeEnd((String)packagePath, (String)File.separator);
    }
}

