/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen;

import io.swagger.v3.oas.models.ExternalDocumentation;
import io.swagger.v3.oas.models.tags.Tag;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.openapitools.codegen.CodegenCallback;
import org.openapitools.codegen.CodegenDiscriminator;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenResponse;
import org.openapitools.codegen.CodegenSecurity;
import org.openapitools.codegen.CodegenServer;

public class CodegenOperation {
    public final List<CodegenProperty> responseHeaders = new ArrayList<CodegenProperty>();
    public boolean hasAuthMethods;
    public boolean hasConsumes;
    public boolean hasProduces;
    public boolean hasParams;
    public boolean hasOptionalParams;
    public boolean hasRequiredParams;
    public boolean returnTypeIsPrimitive;
    public boolean returnSimpleType;
    public boolean subresourceOperation;
    public boolean isMap;
    public boolean isArray;
    public boolean isMultipart;
    public boolean isResponseBinary = false;
    public boolean isResponseFile = false;
    public boolean hasReference = false;
    public boolean isRestfulIndex;
    public boolean isRestfulShow;
    public boolean isRestfulCreate;
    public boolean isRestfulUpdate;
    public boolean isRestfulDestroy;
    public boolean isRestful;
    public boolean isDeprecated;
    public boolean isCallbackRequest;
    public boolean uniqueItems;
    public String path;
    public String operationId;
    public String returnType;
    public String returnFormat;
    public String httpMethod;
    public String returnBaseType;
    public String returnContainer;
    public String summary;
    public String unescapedNotes;
    public String notes;
    public String baseName;
    public String defaultResponse;
    public CodegenDiscriminator discriminator;
    public List<Map<String, String>> consumes;
    public List<Map<String, String>> produces;
    public List<Map<String, String>> prioritizedContentTypes;
    public List<CodegenServer> servers = new ArrayList<CodegenServer>();
    public CodegenParameter bodyParam;
    public List<CodegenParameter> allParams = new ArrayList<CodegenParameter>();
    public List<CodegenParameter> bodyParams = new ArrayList<CodegenParameter>();
    public List<CodegenParameter> pathParams = new ArrayList<CodegenParameter>();
    public List<CodegenParameter> queryParams = new ArrayList<CodegenParameter>();
    public List<CodegenParameter> headerParams = new ArrayList<CodegenParameter>();
    public List<CodegenParameter> formParams = new ArrayList<CodegenParameter>();
    public List<CodegenParameter> cookieParams = new ArrayList<CodegenParameter>();
    public List<CodegenParameter> requiredParams = new ArrayList<CodegenParameter>();
    public List<CodegenParameter> optionalParams = new ArrayList<CodegenParameter>();
    public List<CodegenSecurity> authMethods;
    public List<Tag> tags;
    public List<CodegenResponse> responses = new ArrayList<CodegenResponse>();
    public List<CodegenCallback> callbacks = new ArrayList<CodegenCallback>();
    public Set<String> imports = new HashSet<String>();
    public List<Map<String, String>> examples;
    public List<Map<String, String>> requestBodyExamples;
    public ExternalDocumentation externalDocs;
    public Map<String, Object> vendorExtensions = new HashMap<String, Object>();
    public String nickname;
    public String operationIdOriginal;
    public String operationIdLowerCase;
    public String operationIdCamelCase;
    public String operationIdSnakeCase;

    private static boolean nonempty(List<?> params) {
        return params != null && params.size() > 0;
    }

    public boolean getHasBodyParam() {
        return CodegenOperation.nonempty(this.bodyParams);
    }

    public boolean getHasQueryParams() {
        return CodegenOperation.nonempty(this.queryParams);
    }

    public boolean getHasHeaderParams() {
        return CodegenOperation.nonempty(this.headerParams);
    }

    public boolean getHasPathParams() {
        return CodegenOperation.nonempty(this.pathParams);
    }

    public boolean getHasFormParams() {
        return CodegenOperation.nonempty(this.formParams);
    }

    public boolean getHasBodyOrFormParams() {
        return this.getHasBodyParam() || this.getHasFormParams();
    }

    public boolean getHasCookieParams() {
        return CodegenOperation.nonempty(this.cookieParams);
    }

    public boolean getHasOptionalParams() {
        return CodegenOperation.nonempty(this.optionalParams);
    }

    public boolean getHasRequiredParams() {
        return CodegenOperation.nonempty(this.requiredParams);
    }

    public boolean getHasResponseHeaders() {
        return CodegenOperation.nonempty(this.responseHeaders);
    }

    public boolean getHasExamples() {
        return CodegenOperation.nonempty(this.examples);
    }

    public boolean isRestfulIndex() {
        return "GET".equalsIgnoreCase(this.httpMethod) && "".equals(this.pathWithoutBaseName());
    }

    public boolean isRestfulShow() {
        return "GET".equalsIgnoreCase(this.httpMethod) && this.isMemberPath();
    }

    public boolean isRestfulCreate() {
        return "POST".equalsIgnoreCase(this.httpMethod) && "".equals(this.pathWithoutBaseName());
    }

    public boolean isRestfulUpdate() {
        return Arrays.asList("PUT", "PATCH").contains(this.httpMethod.toUpperCase(Locale.ROOT)) && this.isMemberPath();
    }

    public boolean isBodyAllowed() {
        return Arrays.asList("PUT", "PATCH", "POST").contains(this.httpMethod.toUpperCase(Locale.ROOT));
    }

    public boolean isRestfulDestroy() {
        return "DELETE".equalsIgnoreCase(this.httpMethod) && this.isMemberPath();
    }

    public boolean isRestful() {
        return this.isRestfulIndex() || this.isRestfulShow() || this.isRestfulCreate() || this.isRestfulUpdate() || this.isRestfulDestroy();
    }

    private String pathWithoutBaseName() {
        return this.baseName != null ? this.path.replace("/" + this.baseName.toLowerCase(Locale.ROOT), "") : this.path;
    }

    private boolean isMemberPath() {
        if (this.pathParams.size() != 1) {
            return false;
        }
        String id = this.pathParams.get((int)0).baseName;
        return ("/{" + id + "}").equals(this.pathWithoutBaseName());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("CodegenOperation{");
        sb.append("responseHeaders=").append(this.responseHeaders);
        sb.append(", hasAuthMethods=").append(this.hasAuthMethods);
        sb.append(", hasConsumes=").append(this.hasConsumes);
        sb.append(", hasProduces=").append(this.hasProduces);
        sb.append(", hasParams=").append(this.hasParams);
        sb.append(", hasOptionalParams=").append(this.hasOptionalParams);
        sb.append(", hasRequiredParams=").append(this.hasRequiredParams);
        sb.append(", returnTypeIsPrimitive=").append(this.returnTypeIsPrimitive);
        sb.append(", returnSimpleType=").append(this.returnSimpleType);
        sb.append(", subresourceOperation=").append(this.subresourceOperation);
        sb.append(", isMap=").append(this.isMap);
        sb.append(", isArray=").append(this.isArray);
        sb.append(", isMultipart=").append(this.isMultipart);
        sb.append(", isResponseBinary=").append(this.isResponseBinary);
        sb.append(", isResponseFile=").append(this.isResponseFile);
        sb.append(", hasReference=").append(this.hasReference);
        sb.append(", isRestfulIndex=").append(this.isRestfulIndex);
        sb.append(", isRestfulShow=").append(this.isRestfulShow);
        sb.append(", isRestfulCreate=").append(this.isRestfulCreate);
        sb.append(", isRestfulUpdate=").append(this.isRestfulUpdate);
        sb.append(", isRestfulDestroy=").append(this.isRestfulDestroy);
        sb.append(", isRestful=").append(this.isRestful);
        sb.append(", isDeprecated=").append(this.isDeprecated);
        sb.append(", isCallbackRequest=").append(this.isCallbackRequest);
        sb.append(", uniqueItems='").append(this.uniqueItems);
        sb.append(", path='").append(this.path).append('\'');
        sb.append(", operationId='").append(this.operationId).append('\'');
        sb.append(", returnType='").append(this.returnType).append('\'');
        sb.append(", httpMethod='").append(this.httpMethod).append('\'');
        sb.append(", returnBaseType='").append(this.returnBaseType).append('\'');
        sb.append(", returnContainer='").append(this.returnContainer).append('\'');
        sb.append(", summary='").append(this.summary).append('\'');
        sb.append(", unescapedNotes='").append(this.unescapedNotes).append('\'');
        sb.append(", notes='").append(this.notes).append('\'');
        sb.append(", baseName='").append(this.baseName).append('\'');
        sb.append(", defaultResponse='").append(this.defaultResponse).append('\'');
        sb.append(", discriminator=").append(this.discriminator);
        sb.append(", consumes=").append(this.consumes);
        sb.append(", produces=").append(this.produces);
        sb.append(", prioritizedContentTypes=").append(this.prioritizedContentTypes);
        sb.append(", servers=").append(this.servers);
        sb.append(", bodyParam=").append(this.bodyParam);
        sb.append(", allParams=").append(this.allParams);
        sb.append(", bodyParams=").append(this.bodyParams);
        sb.append(", pathParams=").append(this.pathParams);
        sb.append(", queryParams=").append(this.queryParams);
        sb.append(", headerParams=").append(this.headerParams);
        sb.append(", formParams=").append(this.formParams);
        sb.append(", cookieParams=").append(this.cookieParams);
        sb.append(", requiredParams=").append(this.requiredParams);
        sb.append(", optionalParams=").append(this.optionalParams);
        sb.append(", authMethods=").append(this.authMethods);
        sb.append(", tags=").append(this.tags);
        sb.append(", responses=").append(this.responses);
        sb.append(", callbacks=").append(this.callbacks);
        sb.append(", imports=").append(this.imports);
        sb.append(", examples=").append(this.examples);
        sb.append(", requestBodyExamples=").append(this.requestBodyExamples);
        sb.append(", externalDocs=").append(this.externalDocs);
        sb.append(", vendorExtensions=").append(this.vendorExtensions);
        sb.append(", nickname='").append(this.nickname).append('\'');
        sb.append(", operationIdOriginal='").append(this.operationIdOriginal).append('\'');
        sb.append(", operationIdLowerCase='").append(this.operationIdLowerCase).append('\'');
        sb.append(", operationIdCamelCase='").append(this.operationIdCamelCase).append('\'');
        sb.append(", operationIdSnakeCase='").append(this.operationIdSnakeCase).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CodegenOperation that = (CodegenOperation)o;
        return this.hasAuthMethods == that.hasAuthMethods && this.hasConsumes == that.hasConsumes && this.hasProduces == that.hasProduces && this.hasParams == that.hasParams && this.hasOptionalParams == that.hasOptionalParams && this.hasRequiredParams == that.hasRequiredParams && this.returnTypeIsPrimitive == that.returnTypeIsPrimitive && this.returnSimpleType == that.returnSimpleType && this.subresourceOperation == that.subresourceOperation && this.isMap == that.isMap && this.isArray == that.isArray && this.isMultipart == that.isMultipart && this.isResponseBinary == that.isResponseBinary && this.isResponseFile == that.isResponseFile && this.hasReference == that.hasReference && this.isRestfulIndex == that.isRestfulIndex && this.isRestfulShow == that.isRestfulShow && this.isRestfulCreate == that.isRestfulCreate && this.isRestfulUpdate == that.isRestfulUpdate && this.isRestfulDestroy == that.isRestfulDestroy && this.isRestful == that.isRestful && this.isDeprecated == that.isDeprecated && this.isCallbackRequest == that.isCallbackRequest && this.uniqueItems == that.uniqueItems && Objects.equals(this.responseHeaders, that.responseHeaders) && Objects.equals(this.path, that.path) && Objects.equals(this.operationId, that.operationId) && Objects.equals(this.returnType, that.returnType) && Objects.equals(this.httpMethod, that.httpMethod) && Objects.equals(this.returnBaseType, that.returnBaseType) && Objects.equals(this.returnContainer, that.returnContainer) && Objects.equals(this.summary, that.summary) && Objects.equals(this.unescapedNotes, that.unescapedNotes) && Objects.equals(this.notes, that.notes) && Objects.equals(this.baseName, that.baseName) && Objects.equals(this.defaultResponse, that.defaultResponse) && Objects.equals(this.discriminator, that.discriminator) && Objects.equals(this.consumes, that.consumes) && Objects.equals(this.produces, that.produces) && Objects.equals(this.prioritizedContentTypes, that.prioritizedContentTypes) && Objects.equals(this.servers, that.servers) && Objects.equals(this.bodyParam, that.bodyParam) && Objects.equals(this.allParams, that.allParams) && Objects.equals(this.bodyParams, that.bodyParams) && Objects.equals(this.pathParams, that.pathParams) && Objects.equals(this.queryParams, that.queryParams) && Objects.equals(this.headerParams, that.headerParams) && Objects.equals(this.formParams, that.formParams) && Objects.equals(this.cookieParams, that.cookieParams) && Objects.equals(this.requiredParams, that.requiredParams) && Objects.equals(this.optionalParams, that.optionalParams) && Objects.equals(this.authMethods, that.authMethods) && Objects.equals(this.tags, that.tags) && Objects.equals(this.responses, that.responses) && Objects.equals(this.callbacks, that.callbacks) && Objects.equals(this.imports, that.imports) && Objects.equals(this.examples, that.examples) && Objects.equals(this.requestBodyExamples, that.requestBodyExamples) && Objects.equals(this.externalDocs, that.externalDocs) && Objects.equals(this.vendorExtensions, that.vendorExtensions) && Objects.equals(this.nickname, that.nickname) && Objects.equals(this.operationIdOriginal, that.operationIdOriginal) && Objects.equals(this.operationIdLowerCase, that.operationIdLowerCase) && Objects.equals(this.operationIdCamelCase, that.operationIdCamelCase) && Objects.equals(this.operationIdSnakeCase, that.operationIdSnakeCase);
    }

    public int hashCode() {
        return Objects.hash(this.responseHeaders, this.hasAuthMethods, this.hasConsumes, this.hasProduces, this.hasParams, this.hasOptionalParams, this.hasRequiredParams, this.returnTypeIsPrimitive, this.returnSimpleType, this.subresourceOperation, this.isMap, this.isArray, this.isMultipart, this.isResponseBinary, this.isResponseFile, this.hasReference, this.isRestfulIndex, this.isRestfulShow, this.isRestfulCreate, this.isRestfulUpdate, this.isRestfulDestroy, this.isRestful, this.isDeprecated, this.isCallbackRequest, this.uniqueItems, this.path, this.operationId, this.returnType, this.httpMethod, this.returnBaseType, this.returnContainer, this.summary, this.unescapedNotes, this.notes, this.baseName, this.defaultResponse, this.discriminator, this.consumes, this.produces, this.prioritizedContentTypes, this.servers, this.bodyParam, this.allParams, this.bodyParams, this.pathParams, this.queryParams, this.headerParams, this.formParams, this.cookieParams, this.requiredParams, this.optionalParams, this.authMethods, this.tags, this.responses, this.callbacks, this.imports, this.examples, this.requestBodyExamples, this.externalDocs, this.vendorExtensions, this.nickname, this.operationIdOriginal, this.operationIdLowerCase, this.operationIdCamelCase, this.operationIdSnakeCase);
    }
}

