/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Schema;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.DefaultCodegen;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.meta.features.ClientModificationFeature;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.meta.features.GlobalFeature;
import org.openapitools.codegen.meta.features.ParameterFeature;
import org.openapitools.codegen.meta.features.SchemaSupportFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.meta.features.WireFormatFeature;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AndroidClientCodegen
extends DefaultCodegen
implements CodegenConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(AndroidClientCodegen.class);
    public static final String USE_ANDROID_MAVEN_GRADLE_PLUGIN = "useAndroidMavenGradlePlugin";
    public static final String ANDROID_GRADLE_VERSION = "androidGradleVersion";
    public static final String ANDROID_SDK_VERSION = "androidSdkVersion";
    public static final String ANDROID_BUILD_TOOLS_VERSION = "androidBuildToolsVersion";
    protected String invokerPackage = "org.openapitools.client";
    protected String groupId = "org.openapitools";
    protected String artifactId = "openapi-android-client";
    protected String artifactVersion = "1.0.0";
    protected String projectFolder = "src/main";
    protected String sourceFolder = this.projectFolder + "/java";
    protected Boolean useAndroidMavenGradlePlugin = true;
    protected String androidGradleVersion;
    protected String androidSdkVersion;
    protected String androidBuildToolsVersion;
    protected Boolean serializableModel = false;
    protected String requestPackage = "org.openapitools.client.request";
    protected String authPackage = "org.openapitools.client.auth";
    protected String gradleWrapperPackage = "gradle.wrapper";
    protected String apiDocPath = "docs/";
    protected String modelDocPath = "docs/";

    public AndroidClientCodegen() {
        this.modifyFeatureSet(features -> features.includeDocumentationFeatures(new DocumentationFeature[]{DocumentationFeature.Readme}).excludeWireFormatFeatures(new WireFormatFeature[]{WireFormatFeature.PROTOBUF}).excludeSecurityFeatures(new SecurityFeature[]{SecurityFeature.OpenIDConnect, SecurityFeature.OAuth2_Password, SecurityFeature.OAuth2_AuthorizationCode, SecurityFeature.OAuth2_ClientCredentials, SecurityFeature.OAuth2_Implicit, SecurityFeature.BearerToken}).excludeGlobalFeatures(new GlobalFeature[]{GlobalFeature.XMLStructureDefinitions, GlobalFeature.Callbacks, GlobalFeature.LinkObjects, GlobalFeature.ParameterStyling}).includeSchemaSupportFeatures(new SchemaSupportFeature[]{SchemaSupportFeature.Polymorphism}).excludeParameterFeatures(new ParameterFeature[]{ParameterFeature.Cookie}).includeClientModificationFeatures(new ClientModificationFeature[]{ClientModificationFeature.BasePath}));
        this.outputFolder = "generated-code/android";
        this.modelTemplateFiles.put("model.mustache", ".java");
        this.apiTemplateFiles.put("api.mustache", ".java");
        this.templateDir = "android";
        this.embeddedTemplateDir = "android";
        this.apiPackage = "org.openapitools.client.api";
        this.modelPackage = "org.openapitools.client.model";
        this.setReservedWordsLowerCase(Arrays.asList("localVarPostBody", "localVarPath", "localVarQueryParams", "localVarHeaderParams", "localVarFormParams", "localVarContentTypes", "localVarContentType", "localVarResponse", "localVarBuilder", "authNames", "basePath", "apiInvoker", "Object", "abstract", "continue", "for", "new", "switch", "assert", "default", "if", "package", "synchronized", "boolean", "do", "goto", "private", "this", "break", "double", "implements", "protected", "throw", "byte", "else", "import", "public", "throws", "case", "enum", "instanceof", "return", "transient", "catch", "extends", "int", "short", "try", "char", "final", "interface", "static", "void", "class", "finally", "long", "strictfp", "volatile", "const", "float", "native", "super", "while", "null"));
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("String", "boolean", "Boolean", "Double", "Integer", "Long", "Float", "byte[]", "Object"));
        this.instantiationTypes.put("array", "ArrayList");
        this.instantiationTypes.put("map", "HashMap");
        this.typeMapping.put("date", "Date");
        this.typeMapping.put("file", "File");
        this.importMapping.put("BigDecimal", "java.math.BigDecimal");
        this.importMapping.put("UUID", "java.util.UUID");
        this.importMapping.put("URI", "java.net.URI");
        this.importMapping.put("File", "java.io.File");
        this.importMapping.put("Date", "java.util.Date");
        this.importMapping.put("Map", "java.util.Map");
        this.importMapping.put("HashMap", "java.util.HashMap");
        this.importMapping.put("Array", "java.util.List");
        this.importMapping.put("ArrayList", "java.util.ArrayList");
        this.importMapping.put("List", "java.util.*");
        this.importMapping.put("Set", "java.util.*");
        this.cliOptions.add(new CliOption("modelPackage", "package for generated models"));
        this.cliOptions.add(new CliOption("apiPackage", "package for generated api classes"));
        this.cliOptions.add(new CliOption("invokerPackage", "root package for generated code"));
        this.cliOptions.add(new CliOption("groupId", "groupId for use in the generated build.gradle and pom.xml"));
        this.cliOptions.add(new CliOption("artifactId", "artifactId for use in the generated build.gradle and pom.xml"));
        this.cliOptions.add(new CliOption("artifactVersion", "artifact version for use in the generated build.gradle and pom.xml"));
        this.cliOptions.add(new CliOption("sourceFolder", "source folder for generated code"));
        this.cliOptions.add(CliOption.newBoolean(USE_ANDROID_MAVEN_GRADLE_PLUGIN, "A flag to toggle android-maven gradle plugin.").defaultValue(Boolean.TRUE.toString()));
        this.cliOptions.add(new CliOption(ANDROID_GRADLE_VERSION, "gradleVersion version for use in the generated build.gradle"));
        this.cliOptions.add(new CliOption(ANDROID_SDK_VERSION, "compileSdkVersion version for use in the generated build.gradle"));
        this.cliOptions.add(new CliOption(ANDROID_BUILD_TOOLS_VERSION, "buildToolsVersion version for use in the generated build.gradle"));
        this.cliOptions.add(CliOption.newBoolean("serializableModel", "boolean - toggle \"implements Serializable\" for generated models"));
        this.supportedLibraries.put("volley", "HTTP client: Volley 1.0.19 (default)");
        this.supportedLibraries.put("httpclient", "HTTP client: Apache HttpClient 4.3.6. JSON processing: Gson 2.3.1. IMPORTANT: Android client using HttpClient is not actively maintained and will be depecreated in the next major release.");
        CliOption library = new CliOption("library", "library template (sub-template) to use");
        library.setEnum(this.supportedLibraries);
        this.cliOptions.add(library);
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "android";
    }

    @Override
    public String getHelp() {
        return "Generates an Android client library.";
    }

    @Override
    public String escapeReservedWord(String name) {
        if (this.reservedWordsMappings().containsKey(name)) {
            return this.reservedWordsMappings().get(name);
        }
        return "_" + name;
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separator + this.sourceFolder + File.separator + this.apiPackage().replace('.', File.separatorChar);
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + File.separator + this.sourceFolder + File.separator + this.modelPackage().replace('.', File.separatorChar);
    }

    @Override
    public String apiDocFileFolder() {
        return this.outputFolder + File.separator + this.apiDocPath.replace('/', File.separatorChar);
    }

    @Override
    public String modelDocFileFolder() {
        return this.outputFolder + File.separator + this.modelDocPath.replace('/', File.separatorChar);
    }

    @Override
    public String toApiDocFilename(String name) {
        return this.toApiName(name);
    }

    @Override
    public String toModelDocFilename(String name) {
        return this.toModelName(name);
    }

    @Override
    public String getTypeDeclaration(Schema p) {
        if (ModelUtils.isArraySchema(p)) {
            ArraySchema ap = (ArraySchema)p;
            Schema inner = ap.getItems();
            return this.getSchemaType(p) + "<" + this.getTypeDeclaration(inner) + ">";
        }
        if (ModelUtils.isMapSchema(p)) {
            Schema inner = this.getAdditionalProperties(p);
            return this.getSchemaType(p) + "<String, " + this.getTypeDeclaration(inner) + ">";
        }
        return super.getTypeDeclaration(p);
    }

    @Override
    public String getSchemaType(Schema p) {
        String openAPIType = super.getSchemaType(p);
        String type = null;
        if (this.typeMapping.containsKey(openAPIType)) {
            type = (String)this.typeMapping.get(openAPIType);
            if (this.languageSpecificPrimitives.contains(type) || type.indexOf(".") >= 0 || type.equals("Map") || type.equals("List") || type.equals("File") || type.equals("Date")) {
                return type;
            }
        } else {
            type = openAPIType;
        }
        return this.toModelName(type);
    }

    @Override
    public String toVarName(String name) {
        name = this.sanitizeName(name);
        if ((name = name.replaceAll("-", "_")).matches("^[A-Z_]*$")) {
            return name;
        }
        if (this.isReservedWord(name = StringUtils.camelize(name, true)) || name.matches("^\\d.*")) {
            name = this.escapeReservedWord(name);
        }
        return name;
    }

    @Override
    public String toParamName(String name) {
        return this.toVarName(name);
    }

    @Override
    public String toModelName(String name) {
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.modelNamePrefix)) {
            name = this.modelNamePrefix + "_" + name;
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.modelNameSuffix)) {
            name = name + "_" + this.modelNameSuffix;
        }
        if (this.isReservedWord(name = StringUtils.camelize(this.sanitizeName(name)))) {
            String modelName = "Model" + name;
            LOGGER.warn(name + " (reserved word) cannot be used as model name. Renamed to " + modelName);
            return modelName;
        }
        if (name.matches("^\\d.*")) {
            String modelName = "Model" + name;
            LOGGER.warn(name + " (model name starts with number) cannot be used as model name. Renamed to " + modelName);
            return modelName;
        }
        return name;
    }

    @Override
    public String toModelFilename(String name) {
        return this.toModelName(name);
    }

    @Override
    public void setParameterExampleValue(CodegenParameter p) {
        if (p.defaultValue != null) {
            p.example = p.defaultValue;
            return;
        }
        String example = p.example;
        String type = p.baseType;
        if (type == null) {
            type = p.dataType;
        }
        if ("String".equals(type)) {
            if (example == null) {
                example = p.paramName + "_example";
            }
            example = "\"" + this.escapeText(example) + "\"";
        } else if ("Integer".equals(type) || "Short".equals(type)) {
            if (example == null) {
                example = "56";
            }
        } else if ("Long".equals(type)) {
            if (example == null) {
                example = "56";
            }
            example = example + "L";
        } else if ("Float".equals(type)) {
            if (example == null) {
                example = "3.4";
            }
            example = example + "F";
        } else if ("Double".equals(type)) {
            example = "3.4";
            example = example + "D";
        } else if ("Boolean".equals(type)) {
            if (example == null) {
                example = "true";
            }
        } else if ("File".equals(type)) {
            if (example == null) {
                example = "/path/to/file";
            }
            example = "new File(\"" + this.escapeText(example) + "\")";
        } else if ("Date".equals(type)) {
            example = "new Date()";
        } else if (!this.languageSpecificPrimitives.contains(type)) {
            example = "new " + type + "()";
        }
        if (example == null) {
            example = "null";
        } else if (Boolean.TRUE.equals(p.isArray)) {
            example = "Arrays.asList(" + example + ")";
        } else if (Boolean.TRUE.equals(p.isMap)) {
            example = "new HashMap()";
        }
        p.example = example;
    }

    @Override
    public String toOperationId(String operationId) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)operationId)) {
            throw new RuntimeException("Empty method name (operationId) not allowed");
        }
        if (this.isReservedWord(operationId = StringUtils.camelize(this.sanitizeName(operationId), true))) {
            String newOperationId = StringUtils.camelize("call_" + operationId, true);
            LOGGER.warn(operationId + " (reserved word) cannot be used as method name. Renamed to " + newOperationId);
            return newOperationId;
        }
        return operationId;
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey("invokerPackage")) {
            this.setInvokerPackage((String)this.additionalProperties.get("invokerPackage"));
            this.setRequestPackage(this.invokerPackage + ".request");
            this.setAuthPackage(this.invokerPackage + ".auth");
        } else {
            this.additionalProperties.put("invokerPackage", this.invokerPackage);
            this.additionalProperties.put("requestPackage", this.requestPackage);
            this.additionalProperties.put("authPackage", this.authPackage);
        }
        if (!this.additionalProperties.containsKey("modelPackage")) {
            this.additionalProperties.put("modelPackage", this.modelPackage);
        }
        if (!this.additionalProperties.containsKey("apiPackage")) {
            this.additionalProperties.put("apiPackage", this.apiPackage);
        }
        if (this.additionalProperties.containsKey("groupId")) {
            this.setGroupId((String)this.additionalProperties.get("groupId"));
        } else {
            this.additionalProperties.put("groupId", this.groupId);
        }
        if (this.additionalProperties.containsKey("artifactId")) {
            this.setArtifactId((String)this.additionalProperties.get("artifactId"));
        } else {
            this.additionalProperties.put("artifactId", this.artifactId);
        }
        if (this.additionalProperties.containsKey("artifactVersion")) {
            this.setArtifactVersion((String)this.additionalProperties.get("artifactVersion"));
        } else {
            this.additionalProperties.put("artifactVersion", this.artifactVersion);
        }
        if (this.additionalProperties.containsKey("sourceFolder")) {
            this.setSourceFolder((String)this.additionalProperties.get("sourceFolder"));
        }
        if (this.additionalProperties.containsKey(USE_ANDROID_MAVEN_GRADLE_PLUGIN)) {
            this.setUseAndroidMavenGradlePlugin(Boolean.valueOf((String)this.additionalProperties.get(USE_ANDROID_MAVEN_GRADLE_PLUGIN)));
        } else {
            this.additionalProperties.put(USE_ANDROID_MAVEN_GRADLE_PLUGIN, this.useAndroidMavenGradlePlugin);
        }
        if (this.additionalProperties.containsKey(ANDROID_GRADLE_VERSION)) {
            this.setAndroidGradleVersion((String)this.additionalProperties.get(ANDROID_GRADLE_VERSION));
        }
        if (this.additionalProperties.containsKey(ANDROID_SDK_VERSION)) {
            this.setAndroidSdkVersion((String)this.additionalProperties.get(ANDROID_SDK_VERSION));
        }
        if (this.additionalProperties.containsKey(ANDROID_BUILD_TOOLS_VERSION)) {
            this.setAndroidBuildToolsVersion((String)this.additionalProperties.get(ANDROID_BUILD_TOOLS_VERSION));
        }
        if (this.additionalProperties.containsKey("library")) {
            this.setLibrary((String)this.additionalProperties.get("library"));
        }
        if (this.additionalProperties.containsKey("serializableModel")) {
            this.setSerializableModel(Boolean.valueOf(this.additionalProperties.get("serializableModel").toString()));
        }
        this.additionalProperties.put("serializableModel", this.serializableModel);
        this.additionalProperties.put("apiDocPath", this.apiDocPath);
        this.additionalProperties.put("modelDocPath", this.modelDocPath);
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.getLibrary())) {
            this.setLibrary("volley");
        }
        if ("volley".equals(this.getLibrary())) {
            this.addSupportingFilesForVolley();
        } else if ("httpclient".equals(this.getLibrary())) {
            this.addSupportingFilesForHttpClient();
        } else {
            throw new IllegalArgumentException("Invalid 'library' option specified: '" + this.getLibrary() + "'. Must be 'httpclient' or 'volley' (default)");
        }
    }

    public Boolean getUseAndroidMavenGradlePlugin() {
        return this.useAndroidMavenGradlePlugin;
    }

    public String getAndroidGradleVersion() {
        return this.androidGradleVersion;
    }

    public String getAndroidSdkVersion() {
        return this.androidSdkVersion;
    }

    public String getAndroidBuildToolsVersion() {
        return this.androidBuildToolsVersion;
    }

    public void setUseAndroidMavenGradlePlugin(Boolean useAndroidMavenGradlePlugin) {
        this.useAndroidMavenGradlePlugin = useAndroidMavenGradlePlugin;
    }

    public void setAndroidGradleVersion(String androidGradleVersion) {
        this.androidGradleVersion = androidGradleVersion;
    }

    public void setAndroidSdkVersion(String androidSdkVersion) {
        this.androidSdkVersion = androidSdkVersion;
    }

    public void setAndroidBuildToolsVersion(String androidBuildToolsVersion) {
        this.androidBuildToolsVersion = androidBuildToolsVersion;
    }

    public String getInvokerPackage() {
        return this.invokerPackage;
    }

    public void setInvokerPackage(String invokerPackage) {
        this.invokerPackage = invokerPackage;
    }

    public void setRequestPackage(String requestPackage) {
        this.requestPackage = requestPackage;
    }

    public void setAuthPackage(String authPackage) {
        this.authPackage = authPackage;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public void setArtifactVersion(String artifactVersion) {
        this.artifactVersion = artifactVersion;
    }

    public void setSourceFolder(String sourceFolder) {
        this.sourceFolder = sourceFolder;
    }

    public void setSerializableModel(Boolean serializableModel) {
        this.serializableModel = serializableModel;
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("\"", "");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("*/", "*_/").replace("/*", "/_*");
    }

    private void addSupportingFilesForVolley() {
        this.modelDocTemplateFiles.put("model_doc.mustache", ".md");
        this.apiDocTemplateFiles.put("api_doc.mustache", ".md");
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        this.supportingFiles.add(new SupportingFile("git_push.sh.mustache", "", "git_push.sh"));
        this.supportingFiles.add(new SupportingFile("gitignore.mustache", "", ".gitignore"));
        this.supportingFiles.add(new SupportingFile("pom.mustache", "", "pom.xml"));
        this.supportingFiles.add(new SupportingFile("build.mustache", "", "build.gradle"));
        this.supportingFiles.add(new SupportingFile("manifest.mustache", this.projectFolder, "AndroidManifest.xml"));
        this.supportingFiles.add(new SupportingFile("apiInvoker.mustache", (this.sourceFolder + File.separator + this.invokerPackage).replace(".", File.separator), "ApiInvoker.java"));
        this.supportingFiles.add(new SupportingFile("jsonUtil.mustache", (this.sourceFolder + File.separator + this.invokerPackage).replace(".", File.separator), "JsonUtil.java"));
        this.supportingFiles.add(new SupportingFile("apiException.mustache", (this.sourceFolder + File.separator + this.invokerPackage).replace(".", File.separator), "ApiException.java"));
        this.supportingFiles.add(new SupportingFile("Pair.mustache", (this.sourceFolder + File.separator + this.invokerPackage).replace(".", File.separator), "Pair.java"));
        this.supportingFiles.add(new SupportingFile("request/getrequest.mustache", (this.sourceFolder + File.separator + this.requestPackage).replace(".", File.separator), "GetRequest.java"));
        this.supportingFiles.add(new SupportingFile("request/postrequest.mustache", (this.sourceFolder + File.separator + this.requestPackage).replace(".", File.separator), "PostRequest.java"));
        this.supportingFiles.add(new SupportingFile("request/putrequest.mustache", (this.sourceFolder + File.separator + this.requestPackage).replace(".", File.separator), "PutRequest.java"));
        this.supportingFiles.add(new SupportingFile("request/deleterequest.mustache", (this.sourceFolder + File.separator + this.requestPackage).replace(".", File.separator), "DeleteRequest.java"));
        this.supportingFiles.add(new SupportingFile("request/patchrequest.mustache", (this.sourceFolder + File.separator + this.requestPackage).replace(".", File.separator), "PatchRequest.java"));
        this.supportingFiles.add(new SupportingFile("auth/apikeyauth.mustache", (this.sourceFolder + File.separator + this.authPackage).replace(".", File.separator), "ApiKeyAuth.java"));
        this.supportingFiles.add(new SupportingFile("auth/httpbasicauth.mustache", (this.sourceFolder + File.separator + this.authPackage).replace(".", File.separator), "HttpBasicAuth.java"));
        this.supportingFiles.add(new SupportingFile("auth/authentication.mustache", (this.sourceFolder + File.separator + this.authPackage).replace(".", File.separator), "Authentication.java"));
        this.supportingFiles.add(new SupportingFile("gradlew.mustache", "", "gradlew"));
        this.supportingFiles.add(new SupportingFile("gradlew.bat.mustache", "", "gradlew.bat"));
        this.supportingFiles.add(new SupportingFile("gradle-wrapper.properties.mustache", this.gradleWrapperPackage.replace(".", File.separator), "gradle-wrapper.properties"));
        this.supportingFiles.add(new SupportingFile("gradle-wrapper.jar", this.gradleWrapperPackage.replace(".", File.separator), "gradle-wrapper.jar"));
    }

    private void addSupportingFilesForHttpClient() {
        this.modelDocTemplateFiles.put("model_doc.mustache", ".md");
        this.apiDocTemplateFiles.put("api_doc.mustache", ".md");
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        this.supportingFiles.add(new SupportingFile("pom.mustache", "", "pom.xml"));
        this.supportingFiles.add(new SupportingFile("settings.gradle.mustache", "", "settings.gradle"));
        this.supportingFiles.add(new SupportingFile("build.mustache", "", "build.gradle"));
        this.supportingFiles.add(new SupportingFile("manifest.mustache", this.projectFolder, "AndroidManifest.xml"));
        this.supportingFiles.add(new SupportingFile("apiInvoker.mustache", (this.sourceFolder + File.separator + this.invokerPackage).replace(".", File.separator), "ApiInvoker.java"));
        this.supportingFiles.add(new SupportingFile("httpPatch.mustache", (this.sourceFolder + File.separator + this.invokerPackage).replace(".", File.separator), "HttpPatch.java"));
        this.supportingFiles.add(new SupportingFile("jsonUtil.mustache", (this.sourceFolder + File.separator + this.invokerPackage).replace(".", File.separator), "JsonUtil.java"));
        this.supportingFiles.add(new SupportingFile("apiException.mustache", (this.sourceFolder + File.separator + this.invokerPackage).replace(".", File.separator), "ApiException.java"));
        this.supportingFiles.add(new SupportingFile("Pair.mustache", (this.sourceFolder + File.separator + this.invokerPackage).replace(".", File.separator), "Pair.java"));
        this.supportingFiles.add(new SupportingFile("git_push.sh.mustache", "", "git_push.sh"));
        this.supportingFiles.add(new SupportingFile("gitignore.mustache", "", ".gitignore"));
        this.supportingFiles.add(new SupportingFile("gradlew.mustache", "", "gradlew"));
        this.supportingFiles.add(new SupportingFile("gradlew.bat.mustache", "", "gradlew.bat"));
        this.supportingFiles.add(new SupportingFile("gradle-wrapper.properties.mustache", this.gradleWrapperPackage.replace(".", File.separator), "gradle-wrapper.properties"));
        this.supportingFiles.add(new SupportingFile("gradle-wrapper.jar", this.gradleWrapperPackage.replace(".", File.separator), "gradle-wrapper.jar"));
    }
}

