/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Pattern;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenResponse;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.examples.ExampleGenerator;
import org.openapitools.codegen.languages.PythonClientCodegen;
import org.openapitools.codegen.meta.GeneratorMetadata;
import org.openapitools.codegen.meta.Stability;
import org.openapitools.codegen.utils.ModelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PythonClientExperimentalCodegen
extends PythonClientCodegen {
    private static final Logger LOGGER = LoggerFactory.getLogger(PythonClientExperimentalCodegen.class);

    public PythonClientExperimentalCodegen() {
        this.apiTemplateFiles.remove("api.mustache");
        this.apiTemplateFiles.put("python-experimental/api.mustache", ".py");
        this.apiDocTemplateFiles.remove("api_doc.mustache");
        this.apiDocTemplateFiles.put("python-experimental/api_doc.mustache", ".md");
        this.modelDocTemplateFiles.remove("model_doc.mustache");
        this.modelDocTemplateFiles.put("python-experimental/model_doc.mustache", ".md");
        this.modelTemplateFiles.remove("model.mustache");
        this.modelTemplateFiles.put("python-experimental/model.mustache", ".py");
        this.generatorMetadata = GeneratorMetadata.newBuilder((GeneratorMetadata)this.generatorMetadata).stability(Stability.EXPERIMENTAL).build();
    }

    @Override
    public void processOpts() {
        super.processOpts();
        this.supportingFiles.remove(new SupportingFile("api_client.mustache", this.packagePath(), "api_client.py"));
        this.supportingFiles.add(new SupportingFile("python-experimental/api_client.mustache", this.packagePath(), "api_client.py"));
        this.supportingFiles.add(new SupportingFile("python-experimental/model_utils.mustache", this.packagePath(), "model_utils.py"));
        ModelUtils.setGenerateAliasAsModel(true);
        LOGGER.info("generateAliasAsModel is hard coded to true in this generator. Alias models will only be generated if they contain validations or enums");
    }

    @Override
    public String getName() {
        return "python-experimental";
    }

    public String dateToString(Schema p, Date date, DateFormat dateFormatter, DateFormat dateTimeFormatter) {
        if (!ModelUtils.isDateSchema(p) && !ModelUtils.isDateTimeSchema(p)) {
            throw new RuntimeException("passed schema must be of type Date or DateTime");
        }
        if (ModelUtils.isDateSchema(p)) {
            return "dateutil_parser('" + dateFormatter.format(date) + "').date()";
        }
        return "dateutil_parser('" + dateTimeFormatter.format(date) + "')";
    }

    @Override
    public String toDefaultValue(Schema p) {
        Object defaultObject = null;
        Boolean enumLengthOne = p.getEnum() != null && p.getEnum().size() == 1;
        if (p.getDefault() != null) {
            defaultObject = p.getDefault();
        } else if (enumLengthOne.booleanValue()) {
            defaultObject = p.getEnum().get(0);
        }
        SimpleDateFormat iso8601Date = new SimpleDateFormat("yyyy-MM-dd", Locale.ROOT);
        SimpleDateFormat iso8601DateTime = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX", Locale.ROOT);
        TimeZone utc = TimeZone.getTimeZone("UTC");
        iso8601Date.setTimeZone(utc);
        iso8601DateTime.setTimeZone(utc);
        if (ModelUtils.isDateSchema(p) || ModelUtils.isDateTimeSchema(p)) {
            Object currentExample;
            List currentEnum = p.getEnum();
            ArrayList<String> fixedEnum = new ArrayList<String>();
            String fixedValue = null;
            Date date = null;
            if (currentEnum != null && !currentEnum.isEmpty()) {
                for (Object enumItem : currentEnum) {
                    date = (Date)enumItem;
                    fixedValue = this.dateToString(p, date, iso8601Date, iso8601DateTime);
                    fixedEnum.add(fixedValue);
                }
                p.setEnum(fixedEnum);
            }
            if ((currentExample = p.getExample()) != null) {
                date = (Date)currentExample;
                fixedValue = this.dateToString(p, date, iso8601Date, iso8601DateTime);
                fixedEnum.add(fixedValue);
                p.setExample((Object)fixedValue);
            }
            if (defaultObject != null) {
                date = (Date)defaultObject;
                fixedValue = this.dateToString(p, date, iso8601Date, iso8601DateTime);
                p.setDefault((Object)fixedValue);
                defaultObject = fixedValue;
            }
        }
        if (defaultObject == null) {
            return null;
        }
        String defaultValue = null;
        if (ModelUtils.isStringSchema(p)) {
            defaultValue = defaultObject.toString();
            if (ModelUtils.isDateSchema(p) || ModelUtils.isDateTimeSchema(p)) {
                return defaultValue;
            }
            if (!(ModelUtils.isByteArraySchema(p) || ModelUtils.isBinarySchema(p) || ModelUtils.isFileSchema(p) || ModelUtils.isUUIDSchema(p) || ModelUtils.isEmailSchema(p) || ModelUtils.isDateTimeSchema(p) || ModelUtils.isDateSchema(p))) {
                defaultValue = Pattern.compile("\r\n|\r|\n").matcher(defaultValue).find() ? "'''" + defaultValue + "'''" : "'" + defaultValue + "'";
            }
            return defaultValue;
        }
        if (ModelUtils.isIntegerSchema(p) || ModelUtils.isNumberSchema(p) || ModelUtils.isBooleanSchema(p)) {
            defaultValue = String.valueOf(defaultObject);
            if (ModelUtils.isBooleanSchema(p)) {
                if (!Boolean.valueOf(defaultValue).booleanValue()) {
                    return "False";
                }
                return "True";
            }
            return defaultValue;
        }
        return defaultObject.toString();
    }

    @Override
    public void postProcessModelProperty(CodegenModel model, CodegenProperty property) {
        this.postProcessPattern(property.pattern, property.vendorExtensions);
    }

    @Override
    public Map<String, Object> postProcessAllModels(Map<String, Object> objs) {
        HashMap<String, Schema> modelSchemasToRemove = new HashMap<String, Schema>();
        for (Map.Entry<String, Object> entry : objs.entrySet()) {
            Map inner = (Map)entry.getValue();
            List models = (List)inner.get("models");
            for (Map mo : models) {
                CodegenModel cm = (CodegenModel)mo.get("model");
                Schema modelSchema = ModelUtils.getSchema(this.openAPI, cm.name);
                CodegenProperty modelProperty = this.fromProperty("value", modelSchema);
                if (cm.isEnum || cm.isAlias) {
                    if (modelProperty.isEnum || modelProperty.hasValidation) continue;
                    modelSchemasToRemove.put(cm.name, modelSchema);
                    continue;
                }
                if (!cm.isArrayModel || modelProperty.isEnum || modelProperty.hasValidation) continue;
                modelSchemasToRemove.put(cm.name, modelSchema);
            }
        }
        for (String modelName : modelSchemasToRemove.keySet()) {
            objs.remove(modelName);
        }
        return objs;
    }

    @Override
    public CodegenProperty fromProperty(String name, Schema p) {
        CodegenProperty result = super.fromProperty(name, p);
        if (result.isEnum) {
            this.updateCodegenPropertyEnum(result);
        }
        return result;
    }

    @Override
    public void updateCodegenPropertyEnum(CodegenProperty var) {
        Map<String, Object> extensions;
        Map<String, Object> allowableValues = var.allowableValues;
        if (var.mostInnerItems != null) {
            allowableValues = var.mostInnerItems.allowableValues;
        }
        if (allowableValues == null) {
            return;
        }
        List values = (List)allowableValues.get("values");
        if (values == null) {
            return;
        }
        String varDataType = var.mostInnerItems != null ? var.mostInnerItems.dataType : var.dataType;
        Optional<Schema> referencedSchema = ModelUtils.getSchemas(this.openAPI).entrySet().stream().filter(entry -> Objects.equals(varDataType, this.toModelName((String)entry.getKey()))).map(Map.Entry::getValue).findFirst();
        String dataType = referencedSchema.isPresent() ? this.getTypeDeclaration(referencedSchema.get()) : varDataType;
        ArrayList<Map<String, Object>> enumVars = new ArrayList<Map<String, Object>>();
        String commonPrefix = this.findCommonPrefixOfVars(values);
        int truncateIdx = commonPrefix.length();
        for (Object value : values) {
            String enumName;
            HashMap<String, Object> enumVar = new HashMap<String, Object>();
            if (truncateIdx == 0) {
                enumName = value.toString();
            } else {
                enumName = value.toString().substring(truncateIdx);
                if ("".equals(enumName)) {
                    enumName = value.toString();
                }
            }
            enumVar.put("name", this.toEnumVarName(enumName, dataType));
            enumVar.put("value", this.toEnumValue(value.toString(), dataType));
            enumVar.put("isString", this.isDataTypeString(dataType));
            enumVars.add(enumVar);
        }
        Map<String, Object> map = extensions = var.mostInnerItems != null ? var.mostInnerItems.getVendorExtensions() : var.getVendorExtensions();
        if (referencedSchema.isPresent()) {
            extensions = referencedSchema.get().getExtensions();
        }
        this.updateEnumVarsWithExtensions(enumVars, extensions);
        allowableValues.put("enumVars", enumVars);
    }

    @Override
    public CodegenParameter fromRequestBody(RequestBody body, Set<String> imports, String bodyParameterName) {
        Set keySet;
        Object[] keyArray;
        CodegenParameter result = super.fromRequestBody(body, imports, bodyParameterName);
        Content content = body.getContent();
        MediaType mediaType = (MediaType)content.get((keyArray = (keySet = content.keySet()).toArray())[0]);
        Schema schema = mediaType.getSchema();
        String ref = schema.get$ref();
        if (ref == null) {
            return result;
        }
        String modelName = ModelUtils.getSimpleRef(ref);
        Schema realSchema = ModelUtils.getSchema(this.openAPI, modelName);
        CodegenProperty modelProp = this.fromProperty("body", realSchema);
        if (modelProp.isPrimitiveType && (modelProp.hasValidation || modelProp.isEnum)) {
            String simpleDataType = result.dataType;
            result.isPrimitiveType = false;
            result.isModel = true;
            result.dataType = modelName;
            imports.add(modelName);
            if (modelProp.isEnum) {
                String value = modelProp._enum.get(0).toString();
                result.example = modelName + "(" + this.toEnumValue(value, simpleDataType) + ")";
            } else {
                result.example = modelName + "(" + result.example + ")";
            }
        }
        return result;
    }

    @Override
    public CodegenResponse fromResponse(String responseCode, ApiResponse response) {
        Schema responseSchema = this.openAPI != null && this.openAPI.getComponents() != null ? ModelUtils.unaliasSchema(this.openAPI, ModelUtils.getSchemaFromResponse(response)) : ModelUtils.getSchemaFromResponse(response);
        String newBaseType = null;
        if (responseSchema != null) {
            CodegenProperty cp = this.fromProperty("response", responseSchema);
            if (cp.complexType != null) {
                Schema modelSchema = ModelUtils.getSchema(this.openAPI, cp.complexType);
                if (modelSchema != null && !"object".equals(modelSchema.getType())) {
                    CodegenProperty modelProp = this.fromProperty("response", modelSchema);
                    if (modelProp.isEnum || modelProp.hasValidation) {
                        newBaseType = cp.complexType;
                    }
                }
            } else if (cp.isEnum || cp.hasValidation) {
                Schema sc = ModelUtils.getSchemaFromResponse(response);
                newBaseType = ModelUtils.getSimpleRef(sc.get$ref());
            }
        }
        CodegenResponse result = super.fromResponse(responseCode, response);
        if (newBaseType != null) {
            result.isModel = true;
            result.baseType = newBaseType;
            result.dataType = newBaseType;
        }
        return result;
    }

    @Override
    public void handleMethodResponse(Operation operation, Map<String, Schema> schemas, CodegenOperation op, ApiResponse methodResponse) {
        CodegenResponse defaultResponse = this.fromResponse("defaultResponse", methodResponse);
        Schema responseSchema = ModelUtils.unaliasSchema(this.openAPI, ModelUtils.getSchemaFromResponse(methodResponse));
        if (responseSchema != null) {
            op.returnBaseType = defaultResponse.baseType;
            String exampleStatusCode = "200";
            for (String key : operation.getResponses().keySet()) {
                if (operation.getResponses().get((Object)key) != methodResponse || key.equals("default")) continue;
                exampleStatusCode = key;
            }
            op.examples = new ExampleGenerator(schemas, this.openAPI).generateFromResponseSchema(exampleStatusCode, responseSchema, PythonClientExperimentalCodegen.getProducesInfo(this.openAPI, operation));
            op.defaultResponse = this.toDefaultValue(responseSchema);
            op.returnType = defaultResponse.dataType;
            op.hasReference = schemas.containsKey(op.returnBaseType);
            Schema schema = schemas.get(op.returnBaseType);
            if (schema != null) {
                CodegenModel cmod = this.fromModel(op.returnBaseType, schema);
                op.discriminator = cmod.discriminator;
            }
            if (defaultResponse.isListContainer) {
                op.isListContainer = true;
            } else if (defaultResponse.isMapContainer) {
                op.isMapContainer = true;
            } else {
                op.returnSimpleType = true;
            }
            if (this.languageSpecificPrimitives().contains(op.returnBaseType) || op.returnBaseType == null) {
                op.returnTypeIsPrimitive = true;
            }
        }
        this.addHeaders(methodResponse, op.responseHeaders);
    }

    @Override
    public String toEnumVarName(String value, String datatype) {
        if (value.length() == 0) {
            return "EMPTY";
        }
        String var = value.replaceAll("\\s+", "_").toUpperCase(Locale.ROOT);
        return var;
    }

    @Override
    public String toEnumValue(String value, String datatype) {
        if (datatype.equals("int") || datatype.equals("float")) {
            return value;
        }
        return "\"" + this.escapeText(value) + "\"";
    }

    @Override
    public void postProcessParameter(CodegenParameter parameter) {
        this.postProcessPattern(parameter.pattern, parameter.vendorExtensions);
    }

    @Override
    public CodegenModel fromModel(String name, Schema schema) {
        HashMap<String, String> propertyToModelName = new HashMap<String, String>();
        Map propertiesMap = schema.getProperties();
        if (propertiesMap != null) {
            for (Map.Entry entry : propertiesMap.entrySet()) {
                Schema refSchema;
                String refType;
                String schemaPropertyName = (String)entry.getKey();
                String string = this.toVarName(schemaPropertyName);
                Schema propertySchema = (Schema)entry.getValue();
                String ref = propertySchema.get$ref();
                if (ref == null || (refType = (refSchema = ModelUtils.getReferencedSchema(this.openAPI, propertySchema)).getType()) == null || refType.equals("object")) continue;
                CodegenProperty modelProperty = this.fromProperty("_fake_name", refSchema);
                if (!modelProperty.isEnum && !modelProperty.hasValidation) continue;
                String modelName = ModelUtils.getSimpleRef(ref);
                propertyToModelName.put(string, modelName);
            }
        }
        CodegenModel result = super.fromModel(name, schema);
        if (result.isAlias || result.isEnum) {
            Schema modelSchema = ModelUtils.getSchema(this.openAPI, result.name);
            CodegenProperty modelProperty = this.fromProperty("value", modelSchema);
            if (modelProperty.isEnum || modelProperty.hasValidation) {
                result.isAlias = true;
                modelProperty.required = true;
                List<CodegenProperty> list = Arrays.asList(modelProperty);
                result.setAllVars(list);
                result.setVars(list);
                result.setRequiredVars(list);
                if (result.vars != null) {
                    for (CodegenProperty prop : result.vars) {
                        this.postProcessModelProperty(result, prop);
                    }
                }
            }
        }
        if (propertyToModelName.isEmpty()) {
            return result;
        }
        ArrayList<List<CodegenProperty>> listOfLists = new ArrayList<List<CodegenProperty>>();
        listOfLists.add(result.vars);
        listOfLists.add(result.allVars);
        listOfLists.add(result.requiredVars);
        listOfLists.add(result.optionalVars);
        listOfLists.add(result.readOnlyVars);
        listOfLists.add(result.readWriteVars);
        for (List list : listOfLists) {
            for (CodegenProperty cp : list) {
                String modelName;
                if (!propertyToModelName.containsKey(cp.name)) continue;
                cp.isPrimitiveType = false;
                cp.complexType = modelName = (String)propertyToModelName.get(cp.name);
                cp.dataType = modelName;
                cp.isEnum = false;
                cp.hasValidation = false;
            }
        }
        return result;
    }
}

