/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import io.swagger.v3.oas.models.media.Schema;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Pattern;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.PythonClientCodegen;
import org.openapitools.codegen.utils.ModelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PythonClientExperimentalCodegen
extends PythonClientCodegen {
    private static final Logger LOGGER = LoggerFactory.getLogger(PythonClientExperimentalCodegen.class);

    public PythonClientExperimentalCodegen() {
        this.supportingFiles.add(new SupportingFile("python-experimental/api_client.mustache", this.packagePath(), "api_client.py"));
        this.apiDocTemplateFiles.put("python-experimental/api_doc.mustache", ".md");
        this.apiTemplateFiles.put("python-experimental/api.mustache", ".py");
        this.modelDocTemplateFiles.put("python-experimental/model_doc.mustache", ".md");
        this.modelTemplateFiles.put("python-experimental/model.mustache", ".py");
    }

    @Override
    public String getName() {
        return "python-experimental";
    }

    public String dateToString(Schema p, Date date, DateFormat dateFormatter, DateFormat dateTimeFormatter) {
        if (!ModelUtils.isDateSchema(p) && !ModelUtils.isDateTimeSchema(p)) {
            throw new RuntimeException("passed schema must be of type Date or DateTime");
        }
        if (ModelUtils.isDateSchema(p)) {
            return "dateutil_parser('" + dateFormatter.format(date) + "').date()";
        }
        return "dateutil_parser('" + dateTimeFormatter.format(date) + "')";
    }

    @Override
    public String toDefaultValue(Schema p) {
        Object defaultObject = null;
        Boolean enumLengthOne = p.getEnum() != null && p.getEnum().size() == 1;
        if (p.getDefault() != null) {
            defaultObject = p.getDefault();
        } else if (enumLengthOne.booleanValue()) {
            defaultObject = p.getEnum().get(0);
        }
        SimpleDateFormat iso8601Date = new SimpleDateFormat("yyyy-MM-dd", Locale.ROOT);
        SimpleDateFormat iso8601DateTime = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX", Locale.ROOT);
        TimeZone utc = TimeZone.getTimeZone("UTC");
        iso8601Date.setTimeZone(utc);
        iso8601DateTime.setTimeZone(utc);
        if (ModelUtils.isDateSchema(p) || ModelUtils.isDateTimeSchema(p)) {
            Object currentExample;
            List currentEnum = p.getEnum();
            ArrayList<String> fixedEnum = new ArrayList<String>();
            String fixedValue = null;
            Date date = null;
            if (currentEnum != null && !currentEnum.isEmpty()) {
                for (Object enumItem : currentEnum) {
                    date = (Date)enumItem;
                    fixedValue = this.dateToString(p, date, iso8601Date, iso8601DateTime);
                    fixedEnum.add(fixedValue);
                }
                p.setEnum(fixedEnum);
            }
            if ((currentExample = p.getExample()) != null) {
                date = (Date)currentExample;
                fixedValue = this.dateToString(p, date, iso8601Date, iso8601DateTime);
                fixedEnum.add(fixedValue);
                p.setExample((Object)fixedValue);
            }
            if (defaultObject != null) {
                date = (Date)defaultObject;
                fixedValue = this.dateToString(p, date, iso8601Date, iso8601DateTime);
                p.setDefault((Object)fixedValue);
                defaultObject = fixedValue;
            }
        }
        if (defaultObject == null) {
            return null;
        }
        String defaultValue = null;
        if (ModelUtils.isStringSchema(p)) {
            defaultValue = defaultObject.toString();
            if (ModelUtils.isDateSchema(p) || ModelUtils.isDateTimeSchema(p)) {
                return defaultValue;
            }
            if (!(ModelUtils.isByteArraySchema(p) || ModelUtils.isBinarySchema(p) || ModelUtils.isFileSchema(p) || ModelUtils.isUUIDSchema(p) || ModelUtils.isEmailSchema(p) || ModelUtils.isDateTimeSchema(p) || ModelUtils.isDateSchema(p))) {
                defaultValue = Pattern.compile("\r\n|\r|\n").matcher(defaultValue).find() ? "'''" + defaultValue + "'''" : "'" + defaultValue + "'";
            }
            return defaultValue;
        }
        if (ModelUtils.isIntegerSchema(p) || ModelUtils.isNumberSchema(p) || ModelUtils.isBooleanSchema(p)) {
            defaultValue = String.valueOf(defaultObject);
            if (ModelUtils.isBooleanSchema(p)) {
                if (!Boolean.valueOf(defaultValue).booleanValue()) {
                    return "False";
                }
                return "True";
            }
            return defaultValue;
        }
        return defaultObject.toString();
    }
}

