/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import io.swagger.v3.oas.models.media.Schema;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.DartClientCodegen;
import org.openapitools.codegen.utils.ModelUtils;

public class DartJaguarClientCodegen
extends DartClientCodegen {
    private static final String NULLABLE_FIELDS = "nullableFields";
    private static Set<String> modelToIgnore = new HashSet<String>();
    private boolean nullableFields = true;

    public DartJaguarClientCodegen() {
        this.browserClient = false;
        this.outputFolder = "generated-code/dart-jaguar";
        this.templateDir = "dart-jaguar";
        this.embeddedTemplateDir = "dart-jaguar";
        this.cliOptions.add(new CliOption(NULLABLE_FIELDS, "Is the null fields should be in the JSON payload"));
    }

    @Override
    public String getName() {
        return "dart-jaguar";
    }

    @Override
    public String getHelp() {
        return "Generates a Dart Jaguar client library.";
    }

    @Override
    public String toDefaultValue(Schema p) {
        if (ModelUtils.isMapSchema(p)) {
            return "const {}";
        }
        if (ModelUtils.isArraySchema(p)) {
            return "const []";
        }
        return super.toDefaultValue(p);
    }

    @Override
    public void processOpts() {
        if (this.additionalProperties.containsKey(NULLABLE_FIELDS)) {
            this.nullableFields = this.convertPropertyToBooleanAndWriteBack(NULLABLE_FIELDS);
        } else {
            this.additionalProperties.put(NULLABLE_FIELDS, this.nullableFields);
        }
        if (this.additionalProperties.containsKey("pubName")) {
            this.setPubName((String)this.additionalProperties.get("pubName"));
        } else {
            this.additionalProperties.put("pubName", this.pubName);
        }
        if (this.additionalProperties.containsKey("pubVersion")) {
            this.setPubVersion((String)this.additionalProperties.get("pubVersion"));
        } else {
            this.additionalProperties.put("pubVersion", this.pubVersion);
        }
        if (this.additionalProperties.containsKey("pubDescription")) {
            this.setPubDescription((String)this.additionalProperties.get("pubDescription"));
        } else {
            this.additionalProperties.put("pubDescription", this.pubDescription);
        }
        if (this.additionalProperties.containsKey("useEnumExtension")) {
            this.setUseEnumExtension(this.convertPropertyToBooleanAndWriteBack("useEnumExtension"));
        } else {
            this.additionalProperties.put("useEnumExtension", this.useEnumExtension);
        }
        if (this.additionalProperties.containsKey("sourceFolder")) {
            this.setSourceFolder((String)this.additionalProperties.get("sourceFolder"));
        }
        this.additionalProperties.put("apiDocPath", this.apiDocPath);
        this.additionalProperties.put("modelDocPath", this.modelDocPath);
        String libFolder = this.sourceFolder + File.separator + "lib";
        this.supportingFiles.add(new SupportingFile("pubspec.mustache", "", "pubspec.yaml"));
        this.supportingFiles.add(new SupportingFile("analysis_options.mustache", "", "analysis_options.yaml"));
        this.supportingFiles.add(new SupportingFile("apilib.mustache", libFolder, "api.dart"));
        this.supportingFiles.add(new SupportingFile("git_push.sh.mustache", "", "git_push.sh"));
        this.supportingFiles.add(new SupportingFile("gitignore.mustache", "", ".gitignore"));
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        String authFolder = this.sourceFolder + File.separator + "lib" + File.separator + "auth";
        this.supportingFiles.add(new SupportingFile("auth/api_key_auth.mustache", authFolder, "api_key_auth.dart"));
        this.supportingFiles.add(new SupportingFile("auth/basic_auth.mustache", authFolder, "basic_auth.dart"));
        this.supportingFiles.add(new SupportingFile("auth/oauth.mustache", authFolder, "oauth.dart"));
        this.supportingFiles.add(new SupportingFile("auth/auth.mustache", authFolder, "auth.dart"));
    }

    @Override
    public Map<String, Object> postProcessModels(Map<String, Object> objs) {
        objs = super.postProcessModels(objs);
        List models = (List)objs.get("models");
        for (Object _mo : models) {
            Map mo = (Map)_mo;
            HashSet<String> modelImports = new HashSet<String>();
            CodegenModel cm = (CodegenModel)mo.get("model");
            for (String modelImport : cm.imports) {
                if (modelToIgnore.contains(modelImport.toLowerCase(Locale.ROOT))) continue;
                modelImports.add(org.openapitools.codegen.utils.StringUtils.underscore(modelImport));
            }
            cm.imports = modelImports;
            cm.vendorExtensions.put("hasVars", cm.vars.size() > 0);
        }
        return objs;
    }

    @Override
    public Map<String, Object> postProcessOperationsWithModels(Map<String, Object> objs, List<Object> allModels) {
        objs = super.postProcessOperationsWithModels(objs, allModels);
        Map operations = (Map)objs.get("operations");
        List operationList = (List)operations.get("operation");
        HashSet<String> modelImports = new HashSet<String>();
        for (CodegenOperation op : operationList) {
            Map<String, String> consume2;
            op.httpMethod = StringUtils.capitalize((String)op.httpMethod.toLowerCase(Locale.ROOT));
            boolean isJson = true;
            boolean isForm = false;
            boolean isMultipart = false;
            if (op.consumes != null) {
                for (Map<String, String> consume2 : op.consumes) {
                    if (!consume2.containsKey("mediaType")) continue;
                    String type = consume2.get("mediaType");
                    isJson = type.equalsIgnoreCase("application/json");
                    isForm = type.equalsIgnoreCase("application/x-www-form-urlencoded");
                    isMultipart = type.equalsIgnoreCase("multipart/form-data");
                    break;
                }
            }
            op.vendorExtensions.put("isJson", isJson);
            op.vendorExtensions.put("isForm", isForm);
            op.vendorExtensions.put("isMultipart", isMultipart);
            HashSet<String> imports = new HashSet<String>();
            consume2 = op.imports.iterator();
            while (consume2.hasNext()) {
                String item = (String)consume2.next();
                if (modelToIgnore.contains(item.toLowerCase(Locale.ROOT))) continue;
                imports.add(org.openapitools.codegen.utils.StringUtils.underscore(item));
            }
            modelImports.addAll(imports);
            op.imports = imports;
            String[] items = op.path.split("/", -1);
            String jaguarPath = "";
            for (int i = 0; i < items.length; ++i) {
                jaguarPath = items[i].matches("^\\{(.*)\\}$") ? jaguarPath + ":" + items[i].replace("{", "").replace("}", "") : jaguarPath + items[i];
                if (i == items.length - 1) continue;
                jaguarPath = jaguarPath + "/";
            }
            op.path = jaguarPath;
        }
        objs.put("modelImports", modelImports);
        return objs;
    }

    static {
        modelToIgnore.add("datetime");
        modelToIgnore.add("map");
        modelToIgnore.add("list");
        modelToIgnore.add("file");
    }
}

