/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import com.google.common.base.Strings;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.MapSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.responses.ApiResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.DefaultCodegen;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractApexCodegen
extends DefaultCodegen
implements CodegenConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractApexCodegen.class);
    protected Boolean serializableModel = false;

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "apex";
    }

    @Override
    public String getHelp() {
        return "Generates an Apex API client library.";
    }

    @Override
    public void processOpts() {
        super.processOpts();
    }

    @Override
    public String escapeReservedWord(String name) {
        if (this.reservedWordsMappings().containsKey(name)) {
            return this.reservedWordsMappings().get(name);
        }
        return "_" + name;
    }

    @Override
    public String sanitizeName(String name) {
        if ((name = super.sanitizeName(name)).contains("__")) {
            name.replaceAll("__", "_");
        }
        if (name.matches("^\\d.*")) {
            name.replaceAll("^\\d.*", "");
        }
        return name;
    }

    @Override
    public String toVarName(String name) {
        if ((name = this.sanitizeName(name)).toLowerCase(Locale.ROOT).matches("^_*class$")) {
            return "propertyClass";
        }
        if ("_".equals(name)) {
            name = "_u";
        }
        if (name.matches("^[A-Z_]*$")) {
            if (this.isReservedWord(name)) {
                name = this.escapeReservedWord(name);
            }
            return name;
        }
        if (this.startsWithTwoUppercaseLetters(name)) {
            name = name.substring(0, 2).toLowerCase(Locale.ROOT) + name.substring(2);
        }
        if (this.isReservedWord(name = StringUtils.camelize(name, true)) || name.matches("^\\d.*")) {
            name = this.escapeReservedWord(name);
        }
        return name;
    }

    private boolean startsWithTwoUppercaseLetters(String name) {
        boolean startsWithTwoUppercaseLetters = false;
        if (name.length() > 1) {
            startsWithTwoUppercaseLetters = name.substring(0, 2).equals(name.substring(0, 2).toUpperCase(Locale.ROOT));
        }
        return startsWithTwoUppercaseLetters;
    }

    @Override
    public String toParamName(String name) {
        if ("callback".equals(name)) {
            return "paramCallback";
        }
        return this.toVarName(name);
    }

    @Override
    public String toModelName(String name) {
        String camelizedName;
        String sanitizedName;
        String nameWithPrefixSuffix = sanitizedName = this.sanitizeName(name);
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.modelNamePrefix)) {
            nameWithPrefixSuffix = this.modelNamePrefix + "_" + nameWithPrefixSuffix;
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.modelNameSuffix)) {
            nameWithPrefixSuffix = nameWithPrefixSuffix + "_" + this.modelNameSuffix;
        }
        if (this.isReservedWord(camelizedName = StringUtils.camelize(nameWithPrefixSuffix))) {
            String modelName = "Model" + camelizedName;
            LOGGER.warn(camelizedName + " (reserved word) cannot be used as model name. Renamed to " + modelName);
            return modelName;
        }
        if (camelizedName.matches("^\\d.*")) {
            String modelName = "Model" + camelizedName;
            LOGGER.warn(name + " (model name starts with number) cannot be used as model name. Renamed to " + modelName);
            return modelName;
        }
        return camelizedName;
    }

    @Override
    public String toModelFilename(String name) {
        return this.toModelName(name);
    }

    @Override
    public String getTypeDeclaration(Schema p) {
        if (ModelUtils.isArraySchema(p)) {
            ArraySchema ap = (ArraySchema)p;
            Schema inner = ap.getItems();
            if (inner == null) {
                LOGGER.warn(ap.getName() + "(array property) does not have a proper inner type defined");
                return null;
            }
            return this.getSchemaType(p) + "<" + this.getTypeDeclaration(inner) + ">";
        }
        if (ModelUtils.isMapSchema(p)) {
            Schema inner = ModelUtils.getAdditionalProperties(p);
            if (inner == null) {
                LOGGER.warn(p.getName() + "(map property) does not have a proper inner type defined");
                return null;
            }
            return this.getSchemaType(p) + "<String, " + this.getTypeDeclaration(inner) + ">";
        }
        return super.getTypeDeclaration(p);
    }

    @Override
    public String getAlias(String name) {
        if (this.typeAliases != null && this.typeAliases.containsKey(name)) {
            return (String)this.typeAliases.get(name);
        }
        return name;
    }

    @Override
    public String toDefaultValue(Schema p) {
        if (ModelUtils.isArraySchema(p)) {
            ArraySchema ap = (ArraySchema)p;
            String pattern = "new ArrayList<%s>()";
            if (ap.getItems() == null) {
                return null;
            }
            return String.format(Locale.ROOT, "new ArrayList<%s>()", this.getTypeDeclaration(ap.getItems()));
        }
        if (ModelUtils.isMapSchema(p)) {
            MapSchema ap = (MapSchema)p;
            String pattern = "new HashMap<%s>()";
            if (ModelUtils.getAdditionalProperties((Schema)ap) == null) {
                return null;
            }
            return String.format(Locale.ROOT, "new HashMap<%s>()", String.format(Locale.ROOT, "String, %s", this.getTypeDeclaration(ModelUtils.getAdditionalProperties((Schema)ap))));
        }
        if (ModelUtils.isLongSchema(p)) {
            if (p.getDefault() != null) {
                return p.getDefault().toString() + "l";
            }
            return "null";
        }
        if (ModelUtils.isIntegerSchema(p)) {
            if (p.getDefault() != null) {
                return p.getDefault().toString();
            }
            return "null";
        }
        if (ModelUtils.isFloatSchema(p)) {
            if (p.getDefault() != null) {
                return p.getDefault().toString() + "f";
            }
            return "null";
        }
        if (ModelUtils.isDoubleSchema(p)) {
            if (p.getDefault() != null) {
                return p.getDefault().toString() + "d";
            }
            return "null";
        }
        if (ModelUtils.isBooleanSchema(p)) {
            if (p.getDefault() != null) {
                return p.getDefault().toString();
            }
            return "null";
        }
        if (ModelUtils.isStringSchema(p)) {
            if (p.getDefault() != null) {
                String _default = (String)p.getDefault();
                if (p.getEnum() == null) {
                    return "\"" + this.escapeText(_default) + "\"";
                }
                return _default;
            }
            return "null";
        }
        return super.toDefaultValue(p);
    }

    @Override
    public void setParameterExampleValue(CodegenParameter p) {
        if (Boolean.TRUE.equals(p.isLong)) {
            p.example = "2147483648L";
        } else if (Boolean.TRUE.equals(p.isFile)) {
            p.example = "Blob.valueOf('Sample text file\\nContents')";
        } else if (Boolean.TRUE.equals(p.isDate)) {
            p.example = "Date.newInstance(1960, 2, 17)";
        } else if (Boolean.TRUE.equals(p.isDateTime)) {
            p.example = "Datetime.newInstanceGmt(2013, 11, 12, 3, 3, 3)";
        } else if (Boolean.TRUE.equals(p.isListContainer)) {
            if (p.items != null && p.items.example != null) {
                p.example = "new " + p.dataType + "{" + p.items.example + "}";
            }
        } else if (Boolean.TRUE.equals(p.isMapContainer)) {
            if (p.items != null && p.items.example != null) {
                p.example = "new " + p.dataType + "{" + p.items.example + "}";
            }
        } else if (Boolean.TRUE.equals(p.isString)) {
            p.example = "'" + p.example + "'";
        } else if ("".equals(p.example) || p.example == null && p.dataType != "Object") {
            if (!this.isReservedWord(p.dataType.toLowerCase(Locale.ROOT))) {
                p.example = p.dataType + ".getExample()";
            }
        } else {
            p.example = "''";
        }
    }

    @Override
    public String toExampleValue(Schema p) {
        String example;
        if (p == null) {
            return "";
        }
        Object obj = p.getExample();
        String string = example = obj == null ? "" : obj.toString();
        if (ModelUtils.isArraySchema(p)) {
            example = "new " + this.getTypeDeclaration(p) + "{" + this.toExampleValue(((ArraySchema)p).getItems()) + "}";
        } else if (ModelUtils.isBooleanSchema(p)) {
            example = String.valueOf(!"false".equals(example));
        } else if (ModelUtils.isByteArraySchema(p)) {
            if (example.isEmpty()) {
                example = "VGhlIHF1aWNrIGJyb3duIGZveCBqdW1wZWQgb3ZlciB0aGUgbGF6eSBkb2cu";
            }
            p.setExample((Object)example);
            example = "EncodingUtil.base64Decode('" + example + "')";
        } else if (ModelUtils.isDateSchema(p)) {
            if (example.matches("^\\d{4}(-\\d{2}){2}")) {
                example = example.substring(0, 10).replaceAll("-0?", ", ");
            } else if (example.isEmpty()) {
                example = "2000, 1, 23";
            } else {
                LOGGER.warn(String.format(Locale.ROOT, "The example provided for property '%s' is not a valid RFC3339 date. Defaulting to '2000-01-23'. [%s]", p.getName(), example));
                example = "2000, 1, 23";
            }
            example = "Date.newInstance(" + example + ")";
        } else if (ModelUtils.isDateTimeSchema(p)) {
            if (example.matches("^\\d{4}([-T:]\\d{2}){5}.+")) {
                example = example.substring(0, 19).replaceAll("[-T:]0?", ", ");
            } else if (example.isEmpty()) {
                example = "2000, 1, 23, 4, 56, 7";
            } else {
                LOGGER.warn(String.format(Locale.ROOT, "The example provided for property '%s' is not a valid RFC3339 datetime. Defaulting to '2000-01-23T04-56-07Z'. [%s]", p.getName(), example));
                example = "2000, 1, 23, 4, 56, 7";
            }
            example = "Datetime.newInstanceGmt(" + example + ")";
        } else if (ModelUtils.isNumberSchema(p)) {
            example = (example = example.replaceAll("[^-0-9.]", "")).isEmpty() ? "1.3579" : example;
        } else if (ModelUtils.isFileSchema(p)) {
            if (example.isEmpty()) {
                example = "VGhlIHF1aWNrIGJyb3duIGZveCBqdW1wZWQgb3ZlciB0aGUgbGF6eSBkb2cu";
                p.setExample((Object)example);
            }
            example = "EncodingUtil.base64Decode(" + example + ")";
        } else if (ModelUtils.isEmailSchema(p)) {
            if (example.isEmpty()) {
                example = "example@example.com";
                p.setExample((Object)example);
            }
            example = "'" + example + "'";
        } else if (ModelUtils.isLongSchema(p)) {
            example = example.isEmpty() ? "123456789L" : example + "L";
        } else if (ModelUtils.isMapSchema(p)) {
            example = "new " + this.getTypeDeclaration(p) + "{'key'=>" + this.toExampleValue(ModelUtils.getAdditionalProperties(p)) + "}";
        } else if (ModelUtils.isPasswordSchema(p)) {
            example = example.isEmpty() ? "password123" : this.escapeText(example);
            p.setExample((Object)example);
            example = "'" + example + "'";
        } else if (ModelUtils.isStringSchema(p)) {
            List enums = p.getEnum();
            if (enums != null && example.isEmpty()) {
                example = (String)enums.get(0);
                p.setExample((Object)example);
            } else if (example.isEmpty()) {
                example = "";
            } else {
                example = this.escapeText(example);
                p.setExample((Object)example);
            }
            example = "'" + example + "'";
        } else {
            example = ModelUtils.isUUIDSchema(p) ? (example.isEmpty() ? "'046b6c7f-0b8a-43b9-b35d-6489e6daee91'" : "'" + this.escapeText(example) + "'") : (ModelUtils.isIntegerSchema(p) ? (example.matches("^-?\\d+$") ? example : "0") : (ModelUtils.isObjectSchema(p) ? (example.isEmpty() ? "null" : example) : this.getTypeDeclaration(p) + ".getExample()"));
        }
        return example;
    }

    @Override
    public String getSchemaType(Schema p) {
        String schemaType = super.getSchemaType(p);
        if (this.typeMapping.containsKey(schemaType = this.getAlias(schemaType))) {
            return (String)this.typeMapping.get(schemaType);
        }
        if (null == schemaType) {
            LOGGER.error("No Type defined for Property " + p);
        }
        return this.toModelName(schemaType);
    }

    @Override
    public String toOperationId(String operationId) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)operationId)) {
            throw new RuntimeException("Empty method/operation name (operationId) not allowed");
        }
        if (this.isReservedWord(operationId = StringUtils.camelize(this.sanitizeName(operationId), true))) {
            String newOperationId = StringUtils.camelize("call_" + operationId, true);
            LOGGER.warn(operationId + " (reserved word) cannot be used as method name. Renamed to " + newOperationId);
            return newOperationId;
        }
        return operationId;
    }

    @Override
    public CodegenModel fromModel(String name, Schema model) {
        CodegenModel cm = super.fromModel(name, model);
        if (cm.interfaces == null) {
            cm.interfaces = new ArrayList<String>();
        }
        Boolean hasDefaultValues = false;
        ArrayList propertyMappings = new ArrayList();
        for (CodegenProperty p : cm.allVars) {
            hasDefaultValues = hasDefaultValues | p.defaultValue != null;
            if (p.baseName.equals(p.name)) continue;
            HashMap<String, String> mapping = new HashMap<String, String>();
            mapping.put("externalName", p.baseName);
            mapping.put("internalName", p.name);
            propertyMappings.add(mapping);
        }
        cm.vendorExtensions.put("hasPropertyMappings", !propertyMappings.isEmpty());
        cm.vendorExtensions.put("hasDefaultValues", hasDefaultValues);
        cm.vendorExtensions.put("propertyMappings", propertyMappings);
        if (!propertyMappings.isEmpty()) {
            cm.interfaces.add("OAS.MappedProperties");
        }
        return cm;
    }

    @Override
    public void postProcessParameter(CodegenParameter parameter) {
        if (parameter.isBodyParam && parameter.isListContainer) {
            parameter.items = parameter.items.items;
            this.setParameterExampleValue(parameter);
        }
    }

    @Override
    public Map<String, Object> postProcessModels(Map<String, Object> objs) {
        return this.postProcessModelsEnum(objs);
    }

    @Override
    protected boolean needToImport(String type) {
        return super.needToImport(type) && type.indexOf(".") < 0;
    }

    @Override
    public String toEnumName(CodegenProperty property) {
        return this.sanitizeName(StringUtils.camelize(property.name)) + "Enum";
    }

    @Override
    public String toEnumVarName(String value, String datatype) {
        if (value.length() == 0) {
            return "EMPTY";
        }
        if (this.getSymbolName(value) != null) {
            return this.getSymbolName(value).toUpperCase(Locale.ROOT);
        }
        if ("Integer".equals(datatype) || "Long".equals(datatype) || "Float".equals(datatype) || "Double".equals(datatype)) {
            String varName = "NUMBER_" + value;
            varName = varName.replaceAll("-", "MINUS_");
            varName = varName.replaceAll("\\+", "PLUS_");
            varName = varName.replaceAll("\\.", "_DOT_");
            return varName;
        }
        String var = value.replaceAll("\\W+", "_").toUpperCase(Locale.ROOT);
        if (var.matches("\\d.*")) {
            return "_" + var;
        }
        return var;
    }

    @Override
    public String toEnumValue(String value, String datatype) {
        if ("Integer".equals(datatype) || "Double".equals(datatype)) {
            return value;
        }
        if ("Long".equals(datatype)) {
            return value + "l";
        }
        if ("Float".equals(datatype)) {
            return value + "f";
        }
        return "\"" + this.escapeText(value) + "\"";
    }

    @Override
    public CodegenOperation fromOperation(String path, String httpMethod, Operation operation) {
        CodegenOperation op = super.fromOperation(path, httpMethod, operation);
        if (op.getHasExamples()) {
            ApiResponse apiResponse = this.findMethodResponse(operation.getResponses());
            Schema responseSchema = ModelUtils.getSchemaFromResponse(apiResponse);
            String deserializedExample = this.toExampleValue(responseSchema);
            for (Map<String, String> example : op.examples) {
                example.put("example", this.escapeText(example.get("example")));
                example.put("deserializedExample", deserializedExample);
            }
        }
        return op;
    }

    private static CodegenModel reconcileInlineEnums(CodegenModel codegenModel, CodegenModel parentCodegenModel) {
        if (!parentCodegenModel.hasEnums) {
            return codegenModel;
        }
        List<CodegenProperty> parentModelCodegenProperties = parentCodegenModel.vars;
        List<CodegenProperty> codegenProperties = codegenModel.vars;
        boolean removedChildEnum = false;
        for (CodegenProperty parentModelCodegenPropery : parentModelCodegenProperties) {
            if (!parentModelCodegenPropery.isEnum) continue;
            Iterator<CodegenProperty> iterator = codegenProperties.iterator();
            while (iterator.hasNext()) {
                CodegenProperty codegenProperty = iterator.next();
                if (!codegenProperty.isEnum || !codegenProperty.equals(parentModelCodegenPropery)) continue;
                iterator.remove();
                removedChildEnum = true;
            }
        }
        if (removedChildEnum) {
            int count = 0;
            int numVars = codegenProperties.size();
            for (CodegenProperty codegenProperty : codegenProperties) {
                codegenProperty.hasMore = ++count < numVars;
            }
            codegenModel.vars = codegenProperties;
        }
        return codegenModel;
    }

    private static String sanitizePackageName(String packageName) {
        packageName = packageName.trim();
        if (Strings.isNullOrEmpty((String)(packageName = packageName.replaceAll("[^a-zA-Z0-9_\\.]", "_")))) {
            return "invalidPackageName";
        }
        return packageName;
    }

    public void setSerializableModel(Boolean serializableModel) {
        this.serializableModel = serializableModel;
    }

    private String sanitizePath(String p) {
        return p.replaceAll("\"", "%22");
    }

    @Override
    public String toRegularExpression(String pattern) {
        return this.escapeText(pattern);
    }

    @Override
    public boolean convertPropertyToBoolean(String propertyKey) {
        boolean booleanValue = false;
        if (this.additionalProperties.containsKey(propertyKey)) {
            booleanValue = Boolean.valueOf(this.additionalProperties.get(propertyKey).toString());
        }
        return booleanValue;
    }

    @Override
    public void writePropertyBack(String propertyKey, boolean value) {
        this.additionalProperties.put(propertyKey, value);
    }

    @Override
    public String sanitizeTag(String tag) {
        return StringUtils.camelize(this.sanitizeName(tag));
    }

    @Override
    public String toModelTestFilename(String name) {
        return this.toModelName(name) + "Test";
    }
}

