/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.config;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import io.swagger.parser.OpenAPIParser;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.parser.core.models.AuthorizationValue;
import io.swagger.v3.parser.core.models.ParseOptions;
import io.swagger.v3.parser.core.models.SwaggerParseResult;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.ClientOptInput;
import org.openapitools.codegen.ClientOpts;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenConfigLoader;
import org.openapitools.codegen.SpecValidationException;
import org.openapitools.codegen.auth.AuthParser;
import org.openapitools.codegen.config.GeneratorProperties;
import org.openapitools.codegen.languages.CSharpNancyFXServerCodegen;
import org.openapitools.codegen.languages.CppQt5ClientCodegen;
import org.openapitools.codegen.languages.CppRestSdkClientCodegen;
import org.openapitools.codegen.languages.CppTizenClientCodegen;
import org.openapitools.codegen.languages.JavaJerseyServerCodegen;
import org.openapitools.codegen.languages.PhpLumenServerCodegen;
import org.openapitools.codegen.languages.PhpSlimServerCodegen;
import org.openapitools.codegen.languages.PhpZendExpressivePathHandlerServerCodegen;
import org.openapitools.codegen.languages.RubySinatraServerCodegen;
import org.openapitools.codegen.languages.ScalaAkkaClientCodegen;
import org.openapitools.codegen.languages.ScalaHttpClientCodegen;
import org.openapitools.codegen.languages.SwiftClientCodegen;
import org.openapitools.codegen.utils.ModelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodegenConfigurator
implements Serializable {
    public static final Logger LOGGER = LoggerFactory.getLogger(CodegenConfigurator.class);
    private static Map<String, String> nameMigrationMap = new HashMap<String, String>();
    private String generatorName;
    private String inputSpec;
    private String outputDir;
    private boolean verbose;
    private boolean skipOverwrite;
    private boolean removeOperationIdPrefix;
    private boolean logToStderr;
    private boolean validateSpec = true;
    private boolean enablePostProcessFile;
    private String templateDir;
    private String auth;
    private String apiPackage;
    private String modelPackage;
    private String invokerPackage;
    private String modelNamePrefix;
    private String modelNameSuffix;
    private String groupId;
    private String artifactId;
    private String artifactVersion;
    private String library;
    private String ignoreFileOverride;
    private Map<String, String> systemProperties = new HashMap<String, String>();
    private Map<String, String> instantiationTypes = new HashMap<String, String>();
    private Map<String, String> typeMappings = new HashMap<String, String>();
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    private Map<String, String> importMappings = new HashMap<String, String>();
    private Set<String> languageSpecificPrimitives = new HashSet<String>();
    private Map<String, String> reservedWordMappings = new HashMap<String, String>();
    private String gitUserId = "GIT_USER_ID";
    private String gitRepoId = "GIT_REPO_ID";
    private String releaseNote = "Minor update";
    private String httpUserAgent;
    private final Map<String, Object> dynamicProperties = new HashMap<String, Object>();

    public CodegenConfigurator() {
        this.setOutputDir(".");
    }

    @Deprecated
    public CodegenConfigurator setLang(String lang) {
        this.setGeneratorName(lang);
        return this;
    }

    public CodegenConfigurator setGeneratorName(String generatorName) {
        if (nameMigrationMap.containsKey(generatorName)) {
            String newValue = nameMigrationMap.get(generatorName);
            LOGGER.warn(String.format(Locale.ROOT, "The name '%s' is a deprecated. Please update to the new name of '%s'.", generatorName, newValue));
            this.generatorName = newValue;
        } else {
            this.generatorName = generatorName;
        }
        return this;
    }

    public CodegenConfigurator setInputSpec(String inputSpec) {
        this.inputSpec = inputSpec;
        return this;
    }

    public String getInputSpec() {
        return this.inputSpec;
    }

    public String getOutputDir() {
        return this.outputDir;
    }

    public CodegenConfigurator setOutputDir(String outputDir) {
        this.outputDir = CodegenConfigurator.toAbsolutePathStr(outputDir);
        return this;
    }

    public String getModelPackage() {
        return this.modelPackage;
    }

    public CodegenConfigurator setModelPackage(String modelPackage) {
        this.modelPackage = modelPackage;
        return this;
    }

    public String getModelNamePrefix() {
        return this.modelNamePrefix;
    }

    public CodegenConfigurator setModelNamePrefix(String prefix) {
        this.modelNamePrefix = prefix;
        return this;
    }

    public boolean getRemoveOperationIdPrefix() {
        return this.removeOperationIdPrefix;
    }

    public CodegenConfigurator setRemoveOperationIdPrefix(boolean removeOperationIdPrefix) {
        this.removeOperationIdPrefix = removeOperationIdPrefix;
        return this;
    }

    public boolean getEnablePostProcessFile() {
        return this.enablePostProcessFile;
    }

    public CodegenConfigurator setEnablePostProcessFile(boolean enablePostProcessFile) {
        this.enablePostProcessFile = enablePostProcessFile;
        return this;
    }

    public boolean getLogToStderr() {
        return this.logToStderr;
    }

    public CodegenConfigurator setLogToStderr(boolean logToStderrte) {
        this.logToStderr = this.logToStderr;
        return this;
    }

    public boolean isGenerateAliasAsModel() {
        return ModelUtils.isGenerateAliasAsModel();
    }

    public CodegenConfigurator setGenerateAliasAsModel(boolean generateAliasAsModel) {
        ModelUtils.setGenerateAliasAsModel(generateAliasAsModel);
        return this;
    }

    public String getModelNameSuffix() {
        return this.modelNameSuffix;
    }

    public CodegenConfigurator setModelNameSuffix(String suffix) {
        this.modelNameSuffix = suffix;
        return this;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public CodegenConfigurator setVerbose(boolean verbose) {
        this.verbose = verbose;
        return this;
    }

    public boolean isValidateSpec() {
        return this.validateSpec;
    }

    public CodegenConfigurator setValidateSpec(boolean validateSpec) {
        this.validateSpec = validateSpec;
        return this;
    }

    public boolean isSkipOverwrite() {
        return this.skipOverwrite;
    }

    public CodegenConfigurator setSkipOverwrite(boolean skipOverwrite) {
        this.skipOverwrite = skipOverwrite;
        return this;
    }

    @Deprecated
    public String getLang() {
        return this.getGeneratorName();
    }

    public String getGeneratorName() {
        return this.generatorName;
    }

    public String getTemplateDir() {
        return this.templateDir;
    }

    public CodegenConfigurator setTemplateDir(String templateDir) {
        File f = new File(templateDir);
        if (!f.exists() || !f.isDirectory()) {
            throw new IllegalArgumentException("Template directory " + templateDir + " does not exist.");
        }
        this.templateDir = f.getAbsolutePath();
        return this;
    }

    public String getAuth() {
        return this.auth;
    }

    public CodegenConfigurator setAuth(String auth) {
        this.auth = auth;
        return this;
    }

    public String getApiPackage() {
        return this.apiPackage;
    }

    public CodegenConfigurator setApiPackage(String apiPackage) {
        this.apiPackage = apiPackage;
        return this;
    }

    public String getInvokerPackage() {
        return this.invokerPackage;
    }

    public CodegenConfigurator setInvokerPackage(String invokerPackage) {
        this.invokerPackage = invokerPackage;
        return this;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public CodegenConfigurator setGroupId(String groupId) {
        this.groupId = groupId;
        return this;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public CodegenConfigurator setArtifactId(String artifactId) {
        this.artifactId = artifactId;
        return this;
    }

    public String getArtifactVersion() {
        return this.artifactVersion;
    }

    public CodegenConfigurator setArtifactVersion(String artifactVersion) {
        this.artifactVersion = artifactVersion;
        return this;
    }

    public Map<String, String> getSystemProperties() {
        return this.systemProperties;
    }

    public CodegenConfigurator setSystemProperties(Map<String, String> systemProperties) {
        this.systemProperties = systemProperties;
        return this;
    }

    public CodegenConfigurator addSystemProperty(String key, String value) {
        this.systemProperties.put(key, value);
        return this;
    }

    public Map<String, String> getInstantiationTypes() {
        return this.instantiationTypes;
    }

    public CodegenConfigurator setInstantiationTypes(Map<String, String> instantiationTypes) {
        this.instantiationTypes = instantiationTypes;
        return this;
    }

    public CodegenConfigurator addInstantiationType(String key, String value) {
        this.instantiationTypes.put(key, value);
        return this;
    }

    public Map<String, String> getTypeMappings() {
        return this.typeMappings;
    }

    public CodegenConfigurator setTypeMappings(Map<String, String> typeMappings) {
        this.typeMappings = typeMappings;
        return this;
    }

    public CodegenConfigurator addTypeMapping(String key, String value) {
        this.typeMappings.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public CodegenConfigurator setAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    public CodegenConfigurator addAdditionalProperty(String key, Object value) {
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, String> getImportMappings() {
        return this.importMappings;
    }

    public CodegenConfigurator setImportMappings(Map<String, String> importMappings) {
        this.importMappings = importMappings;
        return this;
    }

    public CodegenConfigurator addImportMapping(String key, String value) {
        this.importMappings.put(key, value);
        return this;
    }

    public Set<String> getLanguageSpecificPrimitives() {
        return this.languageSpecificPrimitives;
    }

    public CodegenConfigurator setLanguageSpecificPrimitives(Set<String> languageSpecificPrimitives) {
        this.languageSpecificPrimitives = languageSpecificPrimitives;
        return this;
    }

    public CodegenConfigurator addLanguageSpecificPrimitive(String value) {
        this.languageSpecificPrimitives.add(value);
        return this;
    }

    public String getLibrary() {
        return this.library;
    }

    public CodegenConfigurator setLibrary(String library) {
        this.library = library;
        return this;
    }

    public String getGitUserId() {
        return this.gitUserId;
    }

    public CodegenConfigurator setGitUserId(String gitUserId) {
        this.gitUserId = gitUserId;
        return this;
    }

    public String getGitRepoId() {
        return this.gitRepoId;
    }

    public CodegenConfigurator setGitRepoId(String gitRepoId) {
        this.gitRepoId = gitRepoId;
        return this;
    }

    public String getReleaseNote() {
        return this.releaseNote;
    }

    public CodegenConfigurator setReleaseNote(String releaseNote) {
        this.releaseNote = releaseNote;
        return this;
    }

    public String getHttpUserAgent() {
        return this.httpUserAgent;
    }

    public CodegenConfigurator setHttpUserAgent(String httpUserAgent) {
        this.httpUserAgent = httpUserAgent;
        return this;
    }

    public Map<String, String> getReservedWordsMappings() {
        return this.reservedWordMappings;
    }

    public CodegenConfigurator setReservedWordsMappings(Map<String, String> reservedWordsMappings) {
        this.reservedWordMappings = reservedWordsMappings;
        return this;
    }

    public CodegenConfigurator addAdditionalReservedWordMapping(String key, String value) {
        this.reservedWordMappings.put(key, value);
        return this;
    }

    public String getIgnoreFileOverride() {
        return this.ignoreFileOverride;
    }

    public CodegenConfigurator setIgnoreFileOverride(String ignoreFileOverride) {
        this.ignoreFileOverride = ignoreFileOverride;
        return this;
    }

    public ClientOptInput toClientOptInput() {
        Validate.notEmpty((CharSequence)this.generatorName, (String)"language/generatorName must be specified", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)this.inputSpec, (String)"input spec must be specified", (Object[])new Object[0]);
        this.setVerboseFlags();
        this.setSystemProperties();
        CodegenConfig config = CodegenConfigLoader.forName(this.generatorName);
        config.setInputSpec(this.inputSpec);
        config.setOutputDir(this.outputDir);
        config.setSkipOverwrite(this.skipOverwrite);
        config.setIgnoreFilePathOverride(this.ignoreFileOverride);
        config.setRemoveOperationIdPrefix(this.removeOperationIdPrefix);
        config.setEnablePostProcessFile(this.enablePostProcessFile);
        config.instantiationTypes().putAll(this.instantiationTypes);
        config.typeMapping().putAll(this.typeMappings);
        config.importMapping().putAll(this.importMappings);
        config.languageSpecificPrimitives().addAll(this.languageSpecificPrimitives);
        config.reservedWordsMappings().putAll(this.reservedWordMappings);
        this.checkAndSetAdditionalProperty(this.apiPackage, "apiPackage");
        this.checkAndSetAdditionalProperty(this.modelPackage, "modelPackage");
        this.checkAndSetAdditionalProperty(this.invokerPackage, "invokerPackage");
        this.checkAndSetAdditionalProperty(this.groupId, "groupId");
        this.checkAndSetAdditionalProperty(this.artifactId, "artifactId");
        this.checkAndSetAdditionalProperty(this.artifactVersion, "artifactVersion");
        this.checkAndSetAdditionalProperty(this.templateDir, CodegenConfigurator.toAbsolutePathStr(this.templateDir), "templateDir");
        this.checkAndSetAdditionalProperty(this.modelNamePrefix, "modelNamePrefix");
        this.checkAndSetAdditionalProperty(this.modelNameSuffix, "modelNameSuffix");
        this.checkAndSetAdditionalProperty(this.gitUserId, "gitUserId");
        this.checkAndSetAdditionalProperty(this.gitRepoId, "gitRepoId");
        this.checkAndSetAdditionalProperty(this.releaseNote, "releaseNote");
        this.checkAndSetAdditionalProperty(this.httpUserAgent, "httpUserAgent");
        this.handleDynamicProperties(config);
        if (StringUtils.isNotEmpty((CharSequence)this.library)) {
            config.setLibrary(this.library);
        }
        config.additionalProperties().putAll(this.additionalProperties);
        ClientOptInput input = new ClientOptInput().config(config);
        List<AuthorizationValue> authorizationValues = AuthParser.parse(this.auth);
        ParseOptions options = new ParseOptions();
        options.setResolve(true);
        SwaggerParseResult result = new OpenAPIParser().readLocation(this.inputSpec, authorizationValues, options);
        HashSet<String> validationMessages = new HashSet<String>(result.getMessages());
        OpenAPI specification = result.getOpenAPI();
        if (validationMessages.size() > 0) {
            StringBuilder sb;
            List<String> unusedModels;
            HashSet<String> warnings = new HashSet<String>();
            if (specification != null && (unusedModels = ModelUtils.getUnusedSchemas(specification)) != null) {
                unusedModels.forEach(name -> warnings.add("Unused model: " + name));
            }
            if (this.isValidateSpec()) {
                sb = new StringBuilder();
                sb.append("There were issues with the specification. The option can be disabled via validateSpec (Maven/Gradle) or --skip-validate-spec (CLI).");
                sb.append(System.lineSeparator());
                SpecValidationException ex = new SpecValidationException(sb.toString());
                ex.setErrors(validationMessages);
                ex.setWarnings(warnings);
                throw ex;
            }
            sb = new StringBuilder();
            sb.append("There were issues with the specification, but validation has been explicitly disabled.");
            sb.append(System.lineSeparator());
            sb.append("Errors: ").append(System.lineSeparator());
            validationMessages.forEach(msg -> sb.append("\t-").append((String)msg).append(System.lineSeparator()));
            if (!warnings.isEmpty()) {
                sb.append("Warnings: ").append(System.lineSeparator());
                warnings.forEach(msg -> sb.append("\t-").append((String)msg).append(System.lineSeparator()));
            }
            LOGGER.warn(sb.toString());
        }
        input.opts(new ClientOpts()).openAPI(specification);
        return input;
    }

    @JsonAnySetter
    public CodegenConfigurator addDynamicProperty(String name, Object value) {
        this.dynamicProperties.put(name, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getDynamicProperties() {
        return this.dynamicProperties;
    }

    private void handleDynamicProperties(CodegenConfig codegenConfig) {
        for (CliOption langCliOption : codegenConfig.cliOptions()) {
            String opt = langCliOption.getOpt();
            if (this.dynamicProperties.containsKey(opt)) {
                codegenConfig.additionalProperties().put(opt, this.dynamicProperties.get(opt));
                continue;
            }
            if (!this.systemProperties.containsKey(opt)) continue;
            codegenConfig.additionalProperties().put(opt, this.systemProperties.get(opt));
        }
    }

    private void setVerboseFlags() {
        if (!this.verbose) {
            return;
        }
        LOGGER.info("\nVERBOSE MODE: ON. Additional debug options are injected\n - [debugOpenAPI] prints the OpenAPI specification as interpreted by the codegen\n - [debugModels] prints models passed to the template engine\n - [debugOperations] prints operations passed to the template engine\n - [debugSupportingFiles] prints additional data passed to the template engine");
        GeneratorProperties.setProperty("debugOpenAPI", "");
        GeneratorProperties.setProperty("debugModels", "");
        GeneratorProperties.setProperty("debugOperations", "");
        GeneratorProperties.setProperty("debugSupportingFiles", "");
    }

    private void setSystemProperties() {
        for (Map.Entry<String, String> entry : this.systemProperties.entrySet()) {
            GeneratorProperties.setProperty(entry.getKey(), entry.getValue());
        }
    }

    private static String toAbsolutePathStr(String path) {
        if (StringUtils.isNotEmpty((CharSequence)path)) {
            return Paths.get(path, new String[0]).toAbsolutePath().toString();
        }
        return path;
    }

    private void checkAndSetAdditionalProperty(String property, String propertyKey) {
        this.checkAndSetAdditionalProperty(property, property, propertyKey);
    }

    private void checkAndSetAdditionalProperty(String property, String valueToSet, String propertyKey) {
        if (StringUtils.isNotEmpty((CharSequence)property)) {
            this.additionalProperties.put(propertyKey, valueToSet);
        }
    }

    public static CodegenConfigurator fromFile(String configFile) {
        if (StringUtils.isNotEmpty((CharSequence)configFile)) {
            try {
                return (CodegenConfigurator)Json.mapper().readValue(new File(configFile), CodegenConfigurator.class);
            }
            catch (IOException e) {
                LOGGER.error("Unable to deserialize config file: " + configFile, (Throwable)e);
            }
        }
        return null;
    }

    static {
        nameMigrationMap.put("akka-scala", new ScalaAkkaClientCodegen().getName());
        nameMigrationMap.put("scala", new ScalaHttpClientCodegen().getName());
        nameMigrationMap.put("jaxrs", new JavaJerseyServerCodegen().getName());
        nameMigrationMap.put("qt5cpp", new CppQt5ClientCodegen().getName());
        nameMigrationMap.put("cpprest", new CppRestSdkClientCodegen().getName());
        nameMigrationMap.put("tizen", new CppTizenClientCodegen().getName());
        nameMigrationMap.put("sinatra", new RubySinatraServerCodegen().getName());
        nameMigrationMap.put("swift", new SwiftClientCodegen().getName());
        nameMigrationMap.put("lumen", new PhpLumenServerCodegen().getName());
        nameMigrationMap.put("slim", new PhpSlimServerCodegen().getName());
        nameMigrationMap.put("ze-ph", new PhpZendExpressivePathHandlerServerCodegen().getName());
        nameMigrationMap.put("nancyfx", new CSharpNancyFXServerCodegen().getName());
    }
}

