/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import com.samskivert.mustache.Escapers;
import com.samskivert.mustache.Mustache;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Schema;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenResponse;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.DefaultCodegen;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.utils.Markdown;
import org.openapitools.codegen.utils.ModelUtils;

public class StaticHtmlGenerator
extends DefaultCodegen
implements CodegenConfig {
    protected String invokerPackage = "org.openapitools.client";
    protected String groupId = "org.openapitools";
    protected String artifactId = "openapi-client";
    protected String artifactVersion = "1.0.0";
    private Markdown markdownConverter = new Markdown();
    private static final boolean CONVERT_TO_MARKDOWN_VIA_ESCAPE_TEXT = false;

    public StaticHtmlGenerator() {
        this.outputFolder = "docs";
        this.templateDir = "htmlDocs";
        this.embeddedTemplateDir = "htmlDocs";
        this.defaultIncludes = new HashSet();
        this.cliOptions.add(new CliOption("appName", "short name of the application"));
        this.cliOptions.add(new CliOption("appDescription", "description of the application"));
        this.cliOptions.add(new CliOption("infoUrl", "a URL where users can get more information about the application"));
        this.cliOptions.add(new CliOption("infoEmail", "an email address to contact for inquiries about the application"));
        this.cliOptions.add(new CliOption("licenseInfo", "a short description of the license"));
        this.cliOptions.add(new CliOption("licenseUrl", "a URL pointing to the full license"));
        this.cliOptions.add(new CliOption("invokerPackage", "root package for generated code"));
        this.cliOptions.add(new CliOption("groupId", "groupId in generated pom.xml"));
        this.cliOptions.add(new CliOption("artifactId", "artifactId in generated pom.xml"));
        this.cliOptions.add(new CliOption("artifactVersion", "artifact version in generated pom.xml"));
        this.additionalProperties.put("appName", "OpenAPI Sample");
        this.additionalProperties.put("appDescription", "A sample OpenAPI server");
        this.additionalProperties.put("infoUrl", "https://openapi-generator.tech");
        this.additionalProperties.put("infoEmail", "team@openapitools.org");
        this.additionalProperties.put("licenseInfo", "All rights reserved");
        this.additionalProperties.put("licenseUrl", "http://apache.org/licenses/LICENSE-2.0.html");
        this.additionalProperties.put("invokerPackage", this.invokerPackage);
        this.additionalProperties.put("groupId", this.groupId);
        this.additionalProperties.put("artifactId", this.artifactId);
        this.additionalProperties.put("artifactVersion", this.artifactVersion);
        this.supportingFiles.add(new SupportingFile("index.mustache", "", "index.html"));
        this.reservedWords = new HashSet();
        this.languageSpecificPrimitives = new HashSet();
        this.importMapping = new HashMap();
    }

    @Override
    public String escapeText(String input) {
        return this.toHtml(input);
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.DOCUMENTATION;
    }

    @Override
    public String getName() {
        return "html";
    }

    @Override
    public String getHelp() {
        return "Generates a static HTML file.";
    }

    @Override
    public String getTypeDeclaration(Schema p) {
        if (ModelUtils.isArraySchema(p)) {
            ArraySchema ap = (ArraySchema)p;
            Schema inner = ap.getItems();
            return this.getSchemaType(p) + "[" + this.getTypeDeclaration(inner) + "]";
        }
        if (ModelUtils.isMapSchema(p)) {
            Schema inner = ModelUtils.getAdditionalProperties(p);
            return this.getSchemaType(p) + "[String, " + this.getTypeDeclaration(inner) + "]";
        }
        return super.getTypeDeclaration(p);
    }

    @Override
    public Map<String, Object> postProcessOperationsWithModels(Map<String, Object> objs, List<Object> allModels) {
        Map operations = (Map)objs.get("operations");
        List operationList = (List)operations.get("operation");
        for (CodegenOperation op : operationList) {
            op.httpMethod = op.httpMethod.toLowerCase(Locale.ROOT);
            for (CodegenResponse response : op.responses) {
                if (!"0".equals(response.code)) continue;
                response.code = "default";
            }
        }
        return objs;
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input;
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input;
    }

    @Override
    public Mustache.Compiler processCompiler(Mustache.Compiler compiler) {
        return compiler.withEscaper(Escapers.NONE);
    }

    public String toHtml(String input) {
        if (input == null) {
            return "";
        }
        return this.markdownConverter.toHtml(input);
    }

    @Override
    public String toModelName(String name) {
        return name;
    }

    @Override
    public void preprocessOpenAPI(OpenAPI openAPI) {
        Info info = openAPI.getInfo();
        info.setDescription(this.toHtml(info.getDescription()));
        info.setTitle(this.toHtml(info.getTitle()));
        Map models = openAPI.getComponents().getSchemas();
        for (Schema model : models.values()) {
            model.setDescription(this.toHtml(model.getDescription()));
            model.setTitle(this.toHtml(model.getTitle()));
        }
    }

    @Override
    public void postProcessParameter(CodegenParameter parameter) {
        parameter.description = this.toHtml(parameter.description);
        parameter.unescapedDescription = this.toHtml(parameter.unescapedDescription);
    }

    @Override
    public void postProcessModelProperty(CodegenModel model, CodegenProperty property) {
        property.description = this.toHtml(property.description);
        property.unescapedDescription = this.toHtml(property.unescapedDescription);
    }
}

