/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import io.swagger.v3.oas.models.media.Schema;
import java.io.File;
import java.util.Map;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractRubyCodegen;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RubySinatraServerCodegen
extends AbstractRubyCodegen {
    private static final Logger LOGGER = LoggerFactory.getLogger(RubySinatraServerCodegen.class);
    protected String gemName;
    protected String moduleName;
    protected String gemVersion = "1.0.0";
    protected String libFolder = "lib";

    public RubySinatraServerCodegen() {
        this.apiPackage = "lib";
        this.outputFolder = "generated-code" + File.separator + "sinatra";
        this.modelTemplateFiles.clear();
        this.apiTemplateFiles.put("api.mustache", ".rb");
        this.templateDir = "ruby-sinatra-server";
        this.embeddedTemplateDir = "ruby-sinatra-server";
        this.cliOptions.clear();
    }

    @Override
    public void processOpts() {
        super.processOpts();
        this.setApiPackage("api");
        this.supportingFiles.add(new SupportingFile("my_app.mustache", "", "my_app.rb"));
        this.supportingFiles.add(new SupportingFile("OpenAPIing.rb", this.libFolder, "openapiing.rb"));
        this.supportingFiles.add(new SupportingFile("config.ru", "", "config.ru"));
        this.supportingFiles.add(new SupportingFile("Gemfile", "", "Gemfile"));
        this.supportingFiles.add(new SupportingFile("README.md", "", "README.md"));
        this.supportingFiles.add(new SupportingFile("openapi.mustache", "", "openapi.yaml"));
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    @Override
    public String getName() {
        return "ruby-sinatra";
    }

    @Override
    public String getHelp() {
        return "Generates a Ruby Sinatra server library.";
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separator + this.apiPackage.replace("/", File.separator);
    }

    @Override
    public String getSchemaType(Schema p) {
        String openAPIType = super.getSchemaType(p);
        String type = null;
        if (this.typeMapping.containsKey(openAPIType)) {
            type = (String)this.typeMapping.get(openAPIType);
            if (this.languageSpecificPrimitives.contains(type)) {
                return type;
            }
        } else {
            type = openAPIType;
        }
        if (type == null) {
            return null;
        }
        return type;
    }

    @Override
    public String toModelName(String name) {
        if (this.isReservedWord(name)) {
            LOGGER.warn(name + " (reserved word) cannot be used as model filename. Renamed to " + StringUtils.camelize("model_" + name));
            name = "model_" + name;
        }
        return StringUtils.camelize(name);
    }

    @Override
    public String toModelFilename(String name) {
        if (this.isReservedWord(name)) {
            LOGGER.warn(name + " (reserved word) cannot be used as model filename. Renamed to " + StringUtils.underscore("model_" + name));
            name = "model_" + name;
        }
        return StringUtils.underscore(name);
    }

    @Override
    public String toApiFilename(String name) {
        name = name.replaceAll("-", "_");
        return StringUtils.underscore(name) + "_api";
    }

    @Override
    public String toApiName(String name) {
        if (name.length() == 0) {
            return "DefaultApi";
        }
        return StringUtils.camelize(name) + "Api";
    }

    @Override
    public Map<String, Object> postProcessSupportingFileData(Map<String, Object> objs) {
        this.generateYAMLSpecFile(objs);
        return super.postProcessSupportingFileData(objs);
    }
}

