/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Schema;
import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractGraphQLCodegen;
import org.openapitools.codegen.utils.ModelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphQLServerCodegen
extends AbstractGraphQLCodegen
implements CodegenConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphQLServerCodegen.class);

    @Override
    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    @Override
    public String getName() {
        return "graphql-server";
    }

    @Override
    public String getHelp() {
        return "Generates a GraphQL express server including it's types, queries, mutations, (resolvers)";
    }

    public GraphQLServerCodegen() {
        this.packageName = "openapi3graphql-server";
        this.packageVersion = "1.0.0";
        this.outputFolder = "generated-code/graphql-server";
        this.templateDir = "graphql-server";
        this.embeddedTemplateDir = "graphql-server";
        this.hideGenerationTimestamp = Boolean.TRUE;
        this.apiTemplateFiles.put("api.mustache", ".graphql");
        this.apiTemplateFiles.put("resolvers.mustache", "_resolver.js");
        this.apiDocTemplateFiles.put("api_doc.mustache", ".md");
        this.modelTemplateFiles.put("model.mustache", ".graphql");
        this.modelDocTemplateFiles.put("model_doc.mustache", ".md");
        this.cliOptions.clear();
        this.cliOptions.add(new CliOption("packageName", "GraphQL express server package name (convention: lowercase).").defaultValue("openapi3graphql-server"));
        this.cliOptions.add(new CliOption("packageVersion", "GraphQL express server package version.").defaultValue("1.0.0"));
        this.cliOptions.add(new CliOption("hideGenerationTimestamp", "Hides the generation timestamp when files are generated.").defaultValue(Boolean.TRUE.toString()));
    }

    @Override
    public void processOpts() {
        super.processOpts();
        this.modelTestTemplateFiles.clear();
        this.modelPackage = this.packageName;
        this.apiPackage = this.packageName;
        String supportFolder = this.apiPackage().replace('.', File.separatorChar);
        this.supportingFiles.add(new SupportingFile("schema.graphql.mustache", supportFolder, "schema.graphql"));
        this.supportingFiles.add(new SupportingFile(".gitignore", supportFolder, ".gitignore"));
        this.supportingFiles.add(new SupportingFile("README.mustache", supportFolder, "README.md"));
        this.supportingFiles.add(new SupportingFile("package.json.mustache", supportFolder, "package.json"));
        this.supportingFiles.add(new SupportingFile("server.js", supportFolder, "server.js"));
        this.supportingFiles.add(new SupportingFile("start.js", supportFolder, "start.js"));
    }

    @Override
    public String getTypeDeclaration(Schema p) {
        String nullable;
        if (ModelUtils.isArraySchema(p)) {
            ArraySchema ap = (ArraySchema)p;
            Schema inner = ap.getItems();
            return this.getTypeDeclaration(inner);
        }
        if (ModelUtils.isMapSchema(p)) {
            Schema inner = (Schema)p.getAdditionalProperties();
            return this.getTypeDeclaration(inner);
        }
        String schemaType = this.getSchemaType(p);
        String string = nullable = ModelUtils.isNullable(p) ? "" : "!";
        if (this.typeMapping.containsKey(schemaType)) {
            return (String)this.typeMapping.get(schemaType) + nullable;
        }
        if (this.languageSpecificPrimitives.contains(schemaType)) {
            return schemaType + nullable;
        }
        return this.toModelName(schemaType);
    }

    @Override
    public String toEnumName(CodegenProperty property) {
        String enumName = this.toModelName(property.name);
        if ((enumName = enumName.replace("[]", "")).matches("\\d.*")) {
            return StringUtils.capitalize((String)("_" + enumName)) + "Enum";
        }
        return StringUtils.capitalize((String)enumName) + "Enum";
    }
}

