/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Schema;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractCppCodegen;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CppQt5QHttpEngineServerCodegen
extends AbstractCppCodegen
implements CodegenConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(CppQt5QHttpEngineServerCodegen.class);
    public static final String CPP_NAMESPACE = "cppNamespace";
    public static final String CPP_NAMESPACE_DESC = "C++ namespace (convention: name::space::for::api).";
    protected final String PREFIX = "OAI";
    protected final String SRC_DIR = "/src";
    protected final String MODEL_DIR = "/src/models";
    protected final String APIHANDLER_DIR = "/src/handlers";
    protected final String APIREQUEST_DIR = "/src/requests";
    protected Set<String> foundationClasses = new HashSet<String>();
    protected String sourceFolder = "server";
    protected String apiVersion = "1.0.0";
    protected Map<String, String> namespaces = new HashMap<String, String>();
    protected Set<String> systemIncludes = new HashSet<String>();
    protected String cppNamespace = "OpenAPI";
    protected Set<String> nonFrameworkPrimitives = new HashSet<String>();

    public CppQt5QHttpEngineServerCodegen() {
        this.outputFolder = "generated-code/cpp-qt5-qhttpengine-server";
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.modelNamePrefix)) {
            this.modelNamePrefix = "OAI";
        }
        this.modelTemplateFiles.put("model-header.mustache", ".h");
        this.modelTemplateFiles.put("model-body.mustache", ".cpp");
        this.apiTemplateFiles.put("apihandler.h.mustache", ".h");
        this.apiTemplateFiles.put("apihandler.cpp.mustache", ".cpp");
        this.apiTemplateFiles.put("apirequest.h.mustache", ".h");
        this.apiTemplateFiles.put("apirequest.cpp.mustache", ".cpp");
        this.templateDir = "cpp-qt5-qhttpengine-server";
        this.embeddedTemplateDir = "cpp-qt5-qhttpengine-server";
        this.addOption(CPP_NAMESPACE, CPP_NAMESPACE_DESC, this.cppNamespace);
        this.additionalProperties.put("apiVersion", this.apiVersion);
        this.additionalProperties().put("prefix", "OAI");
        this.additionalProperties.put(CPP_NAMESPACE, this.cppNamespace);
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("bool", "qint32", "qint64", "float", "double"));
        this.nonFrameworkPrimitives.addAll(this.languageSpecificPrimitives);
        this.foundationClasses.addAll(Arrays.asList("QString", "QDate", "QDateTime", "QByteArray"));
        this.languageSpecificPrimitives.addAll(this.foundationClasses);
        this.supportingFiles.add(new SupportingFile("helpers-header.mustache", this.sourceFolder + "/src/models", "OAIHelpers.h"));
        this.supportingFiles.add(new SupportingFile("helpers-body.mustache", this.sourceFolder + "/src/models", "OAIHelpers.cpp"));
        this.supportingFiles.add(new SupportingFile("object.mustache", this.sourceFolder + "/src/models", "OAIObject.h"));
        this.supportingFiles.add(new SupportingFile("apirouter.h.mustache", this.sourceFolder + "/src/handlers", "OAIApiRouter.h"));
        this.supportingFiles.add(new SupportingFile("apirouter.cpp.mustache", this.sourceFolder + "/src/handlers", "OAIApiRouter.cpp"));
        this.supportingFiles.add(new SupportingFile("main.cpp.mustache", this.sourceFolder + "/src", "main.cpp"));
        this.supportingFiles.add(new SupportingFile("src-CMakeLists.txt.mustache", this.sourceFolder + "/src", "CMakeLists.txt"));
        this.supportingFiles.add(new SupportingFile("README.md.mustache", this.sourceFolder, "README.MD"));
        this.supportingFiles.add(new SupportingFile("Makefile.mustache", this.sourceFolder, "Makefile"));
        this.supportingFiles.add(new SupportingFile("CMakeLists.txt.mustache", this.sourceFolder, "CMakeLists.txt"));
        this.supportingFiles.add(new SupportingFile("Dockerfile.mustache", this.sourceFolder, "Dockerfile"));
        this.supportingFiles.add(new SupportingFile("LICENSE.txt.mustache", this.sourceFolder, "LICENSE.txt"));
        this.typeMapping = new HashMap();
        this.typeMapping.put("date", "QDate");
        this.typeMapping.put("DateTime", "QDateTime");
        this.typeMapping.put("string", "QString");
        this.typeMapping.put("integer", "qint32");
        this.typeMapping.put("long", "qint64");
        this.typeMapping.put("boolean", "bool");
        this.typeMapping.put("array", "QList");
        this.typeMapping.put("map", "QMap");
        this.typeMapping.put("object", "OAIObject");
        this.typeMapping.put("ByteArray", "QByteArray");
        this.typeMapping.put("UUID", "QString");
        this.typeMapping.put("file", "QIODevice");
        this.typeMapping.put("binary", "QIODevice");
        this.importMapping = new HashMap();
        this.namespaces = new HashMap<String, String>();
        this.systemIncludes.add("QString");
        this.systemIncludes.add("QList");
        this.systemIncludes.add("QMap");
        this.systemIncludes.add("QDate");
        this.systemIncludes.add("QDateTime");
        this.systemIncludes.add("QByteArray");
        this.systemIncludes.add("QIODevice");
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey(CPP_NAMESPACE)) {
            this.cppNamespace = (String)this.additionalProperties.get(CPP_NAMESPACE);
        }
        this.additionalProperties.put("cppNamespaceDeclarations", this.cppNamespace.split("\\::"));
        if (this.additionalProperties.containsKey("modelNamePrefix")) {
            this.supportingFiles.clear();
            this.supportingFiles.add(new SupportingFile("helpers-header.mustache", this.sourceFolder + "/src/models", this.modelNamePrefix + "Helpers.h"));
            this.supportingFiles.add(new SupportingFile("helpers-body.mustache", this.sourceFolder + "/src/models", this.modelNamePrefix + "Helpers.cpp"));
            this.supportingFiles.add(new SupportingFile("object.mustache", this.sourceFolder + "/src/models", this.modelNamePrefix + "Object.h"));
            this.supportingFiles.add(new SupportingFile("apirouter.h.mustache", this.sourceFolder + "/src/handlers", this.modelNamePrefix + "ApiRouter.h"));
            this.supportingFiles.add(new SupportingFile("apirouter.cpp.mustache", this.sourceFolder + "/src/handlers", this.modelNamePrefix + "ApiRouter.cpp"));
            this.supportingFiles.add(new SupportingFile("main.cpp.mustache", this.sourceFolder + "/src", "main.cpp"));
            this.supportingFiles.add(new SupportingFile("src-CMakeLists.txt.mustache", this.sourceFolder + "/src", "CMakeLists.txt"));
            this.supportingFiles.add(new SupportingFile("README.md.mustache", this.sourceFolder, "README.MD"));
            this.supportingFiles.add(new SupportingFile("Makefile.mustache", this.sourceFolder, "Makefile"));
            this.supportingFiles.add(new SupportingFile("CMakeLists.txt.mustache", this.sourceFolder, "CMakeLists.txt"));
            this.supportingFiles.add(new SupportingFile("Dockerfile.mustache", this.sourceFolder, "Dockerfile"));
            this.supportingFiles.add(new SupportingFile("LICENSE.txt.mustache", this.sourceFolder, "LICENSE.txt"));
            this.typeMapping.put("object", this.modelNamePrefix + "Object");
            this.additionalProperties().put("prefix", this.modelNamePrefix);
        }
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    @Override
    public String getName() {
        return "cpp-qt5-qhttpengine-server";
    }

    @Override
    public String getHelp() {
        return "Generates a Qt5 C++ Server using the QHTTPEngine HTTP Library.";
    }

    @Override
    public String toModelImport(String name) {
        if (name.isEmpty()) {
            return null;
        }
        if (this.namespaces.containsKey(name)) {
            return "using " + this.namespaces.get(name) + ";";
        }
        if (this.systemIncludes.contains(name)) {
            return "#include <" + name + ">";
        }
        String folder = this.modelPackage().replace("::", File.separator);
        if (!folder.isEmpty()) {
            folder = folder + File.separator;
        }
        return "#include \"" + folder + name + ".h\"";
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + "/" + this.sourceFolder + "/src/models" + "/" + this.modelPackage().replace("::", File.separator);
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + "/" + this.sourceFolder + "/src/handlers" + "/" + this.apiPackage().replace("::", File.separator);
    }

    private String requestFileFolder() {
        return this.outputFolder + "/" + this.sourceFolder + "/src/requests" + "/" + this.apiPackage().replace("::", File.separator);
    }

    @Override
    public String toModelFilename(String name) {
        return this.modelNamePrefix + this.initialCaps(name);
    }

    @Override
    public String apiFilename(String templateName, String tag) {
        String result = super.apiFilename(templateName, tag);
        if (templateName.contains("apirequest")) {
            result = result.replace("ApiHandler", "ApiRequest");
            result = result.replace(this.apiFileFolder(), this.requestFileFolder());
        }
        return result;
    }

    @Override
    public String toApiFilename(String name) {
        return this.modelNamePrefix + this.initialCaps(name) + "ApiHandler";
    }

    @Override
    public String getTypeDeclaration(Schema p) {
        String openAPIType = this.getSchemaType(p);
        if (ModelUtils.isArraySchema(p)) {
            ArraySchema ap = (ArraySchema)p;
            Schema inner = ap.getItems();
            return this.getSchemaType(p) + "<" + this.getTypeDeclaration(inner) + ">";
        }
        if (ModelUtils.isMapSchema(p)) {
            Schema inner = ModelUtils.getAdditionalProperties(p);
            return this.getSchemaType(p) + "<QString, " + this.getTypeDeclaration(inner) + ">";
        }
        if (ModelUtils.isBinarySchema(p)) {
            return this.getSchemaType(p) + "*";
        }
        if (ModelUtils.isFileSchema(p)) {
            return this.getSchemaType(p) + "*";
        }
        if (this.foundationClasses.contains(openAPIType)) {
            return openAPIType;
        }
        if (this.languageSpecificPrimitives.contains(openAPIType)) {
            return this.toModelName(openAPIType);
        }
        return openAPIType;
    }

    @Override
    public String toDefaultValue(Schema p) {
        if (ModelUtils.isBooleanSchema(p)) {
            return "false";
        }
        if (ModelUtils.isDateSchema(p)) {
            return "NULL";
        }
        if (ModelUtils.isDateTimeSchema(p)) {
            return "NULL";
        }
        if (ModelUtils.isNumberSchema(p)) {
            if ("float".equals(p.getFormat())) {
                return "0.0f";
            }
            return "0.0";
        }
        if (ModelUtils.isIntegerSchema(p)) {
            if ("int64".equals(p.getFormat())) {
                return "0L";
            }
            return "0";
        }
        if (ModelUtils.isMapSchema(p)) {
            Schema inner = ModelUtils.getAdditionalProperties(p);
            return "QMap<QString, " + this.getTypeDeclaration(inner) + ">()";
        }
        if (ModelUtils.isArraySchema(p)) {
            ArraySchema ap = (ArraySchema)p;
            Schema inner = ap.getItems();
            return "QList<" + this.getTypeDeclaration(inner) + ">()";
        }
        if (ModelUtils.isStringSchema(p)) {
            return "QString(\"\")";
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)p.get$ref())) {
            return this.toModelName(ModelUtils.getSimpleRef(p.get$ref())) + "()";
        }
        return "NULL";
    }

    @Override
    public String getSchemaType(Schema p) {
        String openAPIType = super.getSchemaType(p);
        String type = null;
        if (this.typeMapping.containsKey(openAPIType)) {
            type = (String)this.typeMapping.get(openAPIType);
            if (this.languageSpecificPrimitives.contains(type)) {
                return this.toModelName(type);
            }
            if (this.foundationClasses.contains(type)) {
                return type;
            }
        } else {
            type = openAPIType;
        }
        return this.toModelName(type);
    }

    @Override
    public String toVarName(String name) {
        String varName = name;
        varName = this.sanitizeName(name);
        if (varName.matches("^[A-Z_]*$")) {
            varName = varName.toLowerCase(Locale.ROOT);
        }
        if (this.isReservedWord(varName = StringUtils.underscore(varName)) || varName.matches("^\\d.*")) {
            varName = this.escapeReservedWord(varName);
        }
        return varName;
    }

    @Override
    public String toParamName(String name) {
        return this.toVarName(name);
    }

    @Override
    public String getTypeDeclaration(String str) {
        return str;
    }

    @Override
    protected boolean needToImport(String type) {
        return org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)type) && !this.defaultIncludes.contains(type) && !this.nonFrameworkPrimitives.contains(type);
    }

    @Override
    public Map<String, Object> postProcessOperations(Map<String, Object> objs) {
        Map objectMap = (Map)objs.get("operations");
        List operations = (List)objectMap.get("operation");
        List imports = (List)objs.get("imports");
        for (CodegenOperation operation : operations) {
            if (operation.returnBaseType != null && this.needToImport(operation.returnBaseType) && !this.isIncluded(operation.returnBaseType, imports)) {
                imports.add(this.createMapping("import", operation.returnBaseType));
            }
            ArrayList<CodegenParameter> params = new ArrayList<CodegenParameter>();
            if (operation.allParams != null) {
                params.addAll(operation.allParams);
            }
            for (CodegenParameter param : params) {
                if (!param.isPrimitiveType || !this.needToImport(param.baseType) || this.isIncluded(param.baseType, imports)) continue;
                imports.add(this.createMapping("import", param.baseType));
            }
            if (operation.pathParams == null || this.isIncluded("QString", imports)) continue;
            imports.add(this.createMapping("import", "QString"));
        }
        if (this.isIncluded("QMap", imports) && !this.isIncluded("QString", imports)) {
            imports.add(this.createMapping("import", "QString"));
        }
        return objs;
    }

    public Map<String, String> createMapping(String key, String value) {
        HashMap<String, String> customImport = new HashMap<String, String>();
        customImport.put(key, this.toModelImport(value));
        return customImport;
    }

    private boolean isIncluded(String type, List<Map<String, String>> imports) {
        boolean included = false;
        String inclStr = this.toModelImport(type);
        for (Map<String, String> importItem : imports) {
            if (!importItem.containsValue(inclStr)) continue;
            included = true;
            break;
        }
        return included;
    }
}

